<div id="AppModalPagarDolares" v-cloak>
    <form autocomplete="off" id="modal_form_movil" @submit.prevent="pagar">
        <div class="modal fade" id="modal_pagomovil" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Compra o venta de dolares</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body border-top-0">
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <input id="inp_fecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha">
                                    <label for="inp_fecha_desde" class="placeholder">Fecha</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="seleccion" id="inp_descontar" @change="obtenerMetodosSegunDivisa()">
                                        <option value="2">Comprar dolares</option>
                                        <option value="1">Vender dolares</option>
                                    </select>
                                    <label for="inp_pagarcuenta" class="placeholder">Seleccione</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="metodo_pagar" id="inp_pagarmetodo" @click="obtenerCuentasSegunMetodo">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in metodos_de_pagos" :value="row.md_id">{{ row.mp_nombre }}</option>
                                    </select>
                                    <label for="inp_pagarmetodo" class="placeholder">Metodo de pago</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="cuenta_agregar" id="inp_agregar">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in cuentasagregar" :value="row.id">{{ row.alias }} - {{ row.tipo }} - {{ row.codigo }}</option>
                                    </select>
                                    <label for="inp_agregar" class="placeholder">Cuenta Destino</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="cuenta_descontar" id="inp_descontar" @click="obtenerSaldoSegunCuenta">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in cuentasdescontar" :value="row.id">{{ row.alias }} - {{ row.tipo }} - {{ row.codigo }}</option>
                                    </select>
                                    <label for="inp_pagarcuenta" class="placeholder">Cuenta origen</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-floating-label">
                                    <input id="inp_pagarmonto" type="text" class="form-control input-border-bottom" v-money="moneybs" v-model="factor">
                                    <label for="inp_pagarmonto" class="placeholder">Factor</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-12">
                                <div class="form-group form-floating-label">
                                    <input id="inp_pagarmonto" type="text" class="form-control input-border-bottom" v-money="money" v-model="monto">
                                    <label for="inp_pagarmonto" class="placeholder">Monto</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <div class="card card-pricing full-height">
                                        <div class="card-header">
                                            <div class="card-price">
                                                <span class="price text-danger" style="font-size: 20px;">Saldo de la cuenta origen: {{ saldoBS }}</span>
                                                <br><span class="price" style="font-size: 20px;">{{txt}} {{ pagardolares }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                            <i class="loader loader-info"></i>
                        </button>
                        <button type="submit" class="btn btn-primary btn-round btn-block" v-else>Registrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
    new Vue({
        el: '#AppModalPagarDolares',
        data: {
            div_locale: '',
            div_simbolo: '',
            div_decimal: 2,
            divisa_pagar: '',
            metodo_pagar: '',
            cuenta_pagar: '',
            cuenta_agregar: '',
            cuenta_descontar: '',
            descripcion: '',
            seleccion: '',
            fecha: moment().format('YYYY-MM-DD'),
            cuentasdescontar: [],
            cuentasagregar: [],
            metodos_de_pagos: [],
            monto: 0,
            factor: 0,
            saldoBS: 0,
            txt:'',
            money: {
                decimal: '.',
                thousands: ',',
                prefix: '',
                suffix: '',
                precision: 2,
                masked: false /* doesn't work with directive */
            },
            moneybs: {
                decimal: ',',
                thousands: '.',
                prefix: '',
                suffix: '',
                precision: 2,
                masked: false /* doesn't work with directive */
            },
            cargando: false,
            errorForm: [],
        },
        created() {
            this.monto = 0;
            axios.get('ingresosegresos/factorDivisa').then(response => {
                if (response.data.errors == null) {
                    this.factor =monedaDecimal(response.data,'en-US',2);
                }
            }).catch(e => notificacion());
        },
        methods: {
            obtenerMetodosSegunDivisa() {
                this.errorForm = [];
                this.metodo_pagar = '';
                this.metodos_de_pagos = [];
                this.cuenta_pagar = '';
                this.cuentas = [];

                if (!this.seleccion)
                    this.errorForm.push('La divisa es obligatorio.');

                if (this.errorForm.length == 0) {
                    axios.get('ingresosegresos/obtenerMetodosSegunDivisa/' + Number(this.seleccion)).then(response => {
                        if (response.data.errors == null) {
                            this.metodos_de_pagos = response.data;
                        } else {
                            this.divisa_pagar = '';
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            },
            obtenerCuentasSegunMetodo: function(event) {

                this.errorForm = [];
                this.cuenta_pagar = '';
                this.cuentas = [];

                if (this.seleccion == 1) {
                    this.obtenerCuentasIgualUsd();
                    this.txt='Cobrar ';
                } else {
                    this.obtenerCuentasIgualBS();
                    this.txt='Pagar ';
                }

                if (!event.target.value)
                    this.errorForm.push('EL metodo de pago es obligatorio.');

                if (this.errorForm.length == 0) {
                    axios.get('ingresosegresos/obtenerCuentasSegunMetodo/' + Number(event.target.value)).then(response => {
                        if (response.data.errors == null) {
                            this.cuentasagregar = response.data;
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            },
            obtenerCuentasIgualBS() {
                axios.get('ingresosegresos/obtenerCuentasIgualBS').then(response => {
                    if (response.data.errors == null) {
                        this.cuentasdescontar = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());

            },
            obtenerCuentasIgualUsd() {
                axios.get('ingresosegresos/obtenerCuentasIgualUsd').then(response => {
                    if (response.data.errors == null) {
                        this.cuentasdescontar = response.data;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion());

            },
            obtenerSaldoSegunCuenta() {

                this.errorForm = [];

                if (!this.cuenta_descontar)
                    this.errorForm.push('EL cuenta es obligatorio.');

                if (this.errorForm.length == 0) {
                    axios.get('ingresosegresos/obtenerSaldoSegunCuenta/' + Number(this.cuenta_descontar)).then(response => {
                        if (response.data.errors == null) {
                            this.div_locale = response.data.divisa.locale;
                            this.div_simbolo = response.data.divisa.symbol;
                            this.money.decimal = response.data.divisa.decimal;
                            this.money.thousands = response.data.divisa.thousands;
                            this.money.precision = response.data.divisa.precision;
                            this.saldo = response.data.saldo;

                            this.saldoBS = this.moneda(parseFloat(this.saldo), this.div_locale, this.div_simbolo);
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            },
            pagar() {


                this.errorForm = [];

                if (!this.seleccion)
                    this.errorForm.push('Debe sellecionar una opcion');
                if (!this.monto)
                    this.errorForm.push('El monto es obligatorio');
                if (!this.cuenta_agregar)
                    this.errorForm.push('Debe seleccionar una cuenta donde se va agregar el monto');
                if (!this.cuenta_descontar)
                    this.errorForm.push('Debe selleccionar una cuenta para descontar');

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'ingresosegresos/pagarPagoMovil',
                        data: {
                            monto: this.monto,
                            descontar: this.cuenta_descontar,
                            agregar: this.cuenta_agregar,
                            seleccion: this.seleccion,
                            fecha: this.fecha,
                            factor:this.factor
                        },
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == false) {
                                notificacion('fa fa-ban', 'Advertencia', 'Error al pagar', 'warning');
                            } else {
                                this.monto = 0;
                                this.saldo = 0;
                                this.cuenta_descontar = '';
                                this.cuenta_agregar = '';
                                this.errorForm = [];
                                this.seleccion = '';
                                this.cuentas = [];
                                notificacion('fa fa-coins', 'Pago', 'Pago exitosa', 'success');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion()).finally(() => this.cargando = false);
                } else {
                    let total_errores = this.errorForm.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                    }
                }
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                if (this.div_locale) {
                    return monedaMoneda(num, div_locale, div_simbolo, decimal);
                }
            },
            decimal(num, div_locale, decimal = 2) {
                if (this.div_locale) {
                    return monedaDecimal(num, div_locale, decimal);
                }
            },
        },
        computed: {
            balance: function() {
                let total = parseFloat(this.saldo);
                // let monto = convertir_a_float(String(this.monto).toString());
                let balance_ = (total);
                if (balance_ <= 0) {
                    balance_ = 0;
                }
                return this.moneda(balance_, this.div_locale, this.div_simbolo);
            },
            pagardolares: function() {
                let total = parseFloat(this.monto ?? 0);
                let factor = convertir_a_float(String(this.factor).toString());
                let balance_ = (total * factor);
                if (balance_ <= 0) {
                    balance_ = 0;
                }
               
                return this.moneda(balance_, 'de-DE', 'Bs',2);
            }
        }
    });
</script>