<div id="AppModalPagar" v-cloak>
    <form autocomplete="off" id="modal_form_ingreso" @submit.prevent="pagar">
        <div class="modal fade" id="modal_ingreso" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Ingreso</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body border-top-0">
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <input id="inp_fecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha">
                                    <label for="inp_fecha_desde" class="placeholder">Fecha</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="divisa_pagar" id="inp_pagardivisa" @change="obtenerMetodosSegunDivisa">
                                        <option disabled value="">&nbsp;</option>
                                        <?php foreach ($divisas as $row) : ?>
                                            <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <label for="inp_pagardivisa" class="placeholder">Divisa</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="metodo_pagar" id="inp_pagarmetodo" @change="obtenerCuentasSegunMetodo">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in metodos_de_pagos" :value="row.md_id">{{ row.mp_nombre }}</option>
                                    </select>
                                    <label for="inp_pagarmetodo" class="placeholder">Metodo de pago</label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="cuenta_pagar" id="inp_pagarcuenta" @change="obtenerSaldoSegunCuenta">
                                        <option disabled value="">&nbsp;</option>
                                        <option v-for="row in cuentas" :value="row.id">{{ row.alias }} - {{ row.tipo }} - {{ row.codigo }}</option>
                                    </select>
                                    <label for="inp_pagarcuenta" class="placeholder">Cuenta</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group form-floating-label">
                                    <input id="inp_pagarmonto" type="text" class="form-control input-border-bottom" v-money="money" v-model="monto">
                                    <label for="inp_pagarmonto" class="placeholder">Monto</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group form-floating-label">
                                    <select class="form-control input-border-bottom" v-model="categoria" id="inp_cateagoria">
                                        <option disabled value="">Seleccionar una categoria</option>
                                        <?php foreach ($categorias as $row) : ?>
                                            <option value="<?= $row['id'] ?>"><?= $row['categoria'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                    <label for="inp_cateagoria" class="placeholder">Categoria</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-sm-6">
                                <div class="form-group form-floating-label">
                                    <div class="form-group form-group-default">
                                        <label>Descripcion</label>
                                        <textarea class="form-control" v-model="descripcion" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="card card-pricing full-height">
                                        <div class="card-header">
                                            <div class="card-price">
                                                <span class="price" style="font-size: 20px;">{{ balance }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                            <i class="loader loader-info"></i>
                        </button>
                        <button type="submit" class="btn btn-primary btn-round btn-block" v-else>Registrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<script>
    new Vue({
        el: '#AppModalPagar',
        data: {
            div_locale: '',
            div_simbolo: '',
            div_decimal: 2,
            divisa_pagar: '',
            metodo_pagar: '',
            cuenta_pagar: '',
            descripcion: '',
            categoria: '',
            fecha: moment().format('YYYY-MM-DD'),
            cuentas: [],
            metodos_de_pagos: [],
            monto: 0,
            saldo: 0,
            money: {
                decimal: '.',
                thousands: ',',
                prefix: '',
                suffix: '',
                precision: 2,
                masked: false /* doesn't work with directive */
            },
            cargando: false,
            errorForm: [],
        },
        created() {
            this.monto = 0;
        },
        methods: {
            obtenerMetodosSegunDivisa: function(event) {
                this.errorForm = [];
                this.metodo_pagar = '';
                this.metodos_de_pagos = [];
                this.cuenta_pagar = '';
                this.cuentas = [];

                if (!event.target.value)
                    this.errorForm.push('La divisa es obligatorio.');

                if (this.errorForm.length == 0) {
                    axios.get('ingresosegresos/obtenerMetodosSegunDivisa/' + Number(event.target.value)).then(response => {
                        if (response.data.errors == null) {
                            this.metodos_de_pagos = response.data;
                        } else {
                            this.divisa_pagar = '';
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            },
            obtenerCuentasSegunMetodo: function(event) {

                this.errorForm = [];
                this.cuenta_pagar = '';
                this.cuentas = [];

                if (!event.target.value)
                    this.errorForm.push('EL metodo de pago es obligatorio.');

                if (this.errorForm.length == 0) {
                    axios.get('ingresosegresos/obtenerCuentasSegunMetodo/' + Number(event.target.value)).then(response => {
                        if (response.data.errors == null) {
                            this.cuentas = response.data;
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            },
            obtenerSaldoSegunCuenta: function(event) {

                this.errorForm = [];

                if (!event.target.value)
                    this.errorForm.push('EL cuenta es obligatorio.');

                if (this.errorForm.length == 0) {
                    axios.get('ingresosegresos/obtenerSaldoSegunCuenta/' + Number(event.target.value)).then(response => {
                        if (response.data.errors == null) {
                            this.div_locale = response.data.divisa.locale;
                            this.div_simbolo = response.data.divisa.symbol;
                            this.money.decimal = response.data.divisa.decimal;
                            this.money.thousands = response.data.divisa.thousands;
                            this.money.precision = response.data.divisa.precision;
                            this.saldo = response.data.saldo;
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => notificacion());
                }
            },
            pagar() {

                this.errorForm = [];

                if (!this.divisa_pagar)
                    this.errorForm.push('El campo divisa es obligatorio');
                if (!this.metodo_pagar)
                    this.errorForm.push('El campo metodo es obligatorio');
                if (!this.cuenta_pagar)
                    this.errorForm.push('El campo cuenta es obligatorio');
                if (!this.monto)
                    this.errorForm.push('El campo monto es obligatorio');

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'ingresosegresos/pagarPositivo',
                        data: {
                            monto: this.monto,
                            descripcion: this.descripcion,
                            id_divisa: this.divisa_pagar,
                            id_metodo_divisa: this.metodo_pagar,
                            id_cuenta_metodo: this.cuenta_pagar,
                            fecha: this.fecha,
                            categoria: this.categoria
                        },
                        transformRequest: serializar(),
                    }).then(response => {
                        if (response.data.errors == null) {
                            if (response.data == false) {
                                notificacion('fa fa-ban', 'Advertencia', 'Error al guardar el pago', 'warning');
                            } else {
                                this.saldo = 0;
                                this.saldo = response.data;
                                this.monto = 0;
                                this.descripcion = '';
                                this.divisa_pagar = '';
                                this.errorForm = [];
                                this.metodo_pagar = '';
                                this.metodos_de_pagos = [];
                                this.cuenta_pagar = '';
                                this.cuentas = [];
                                this.categoria = '';
                                notificacion('fa fa-coins', 'Ingreso', 'Monto ingresado correctamente', 'success');
                            }
                        } else {
                            let total_errores = response.data.errors.length
                            for (let i = 0; i < total_errores; i++) {
                                notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                            }
                        }
                    }).catch(e => {
                        notificacion();
                    }).finally(() => this.cargando = false);
                } else {
                    let total_errores = this.errorForm.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', this.errorForm[i], 'warning');
                    }
                }
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                if (this.div_locale) {
                    return monedaMoneda(num, div_locale, div_simbolo, decimal);
                }
            },
            decimal(num, div_locale, decimal = 2) {
                if (this.div_locale) {
                    return monedaDecimal(num, div_locale, decimal);
                }
            },
        },
        computed: {
            balance: function() {
                let total = parseFloat(this.saldo);
                let monto = convertir_a_float(String(this.monto).toString());
                let balance_ = (total + monto);
                if (balance_ <= 0) {
                    balance_ = 0;
                }
                return this.moneda(balance_, this.div_locale, this.div_simbolo);
            }
        }
    });
</script>
