<?php

namespace App\Controladores;

use App\Modelos\CarritoVentasModel;
use App\Modelos\Comisiones;
use App\Modelos\Compras;
use App\Modelos\Empleado;
use App\Modelos\EmpleadoAlmacen;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadosComisionesEmplAgente;
use App\Modelos\EmpleadoSucursales;
use App\Modelos\Generico;
use Core\Controller;
use App\Modelos\Ingresosegresos;
use App\Modelos\MetodoPago;
use App\Modelos\MovimientoModel;
use App\Modelos\Notasdeentrega;
use App\Modelos\Ordendeentrega;
use App\Modelos\Pos;
use App\Modelos\Proveedor;
use Core\Helpers\Documento;
use Core\Helpers\Moneda;
use Core\Librerias\CarritoVentasEditar;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\Solicitud;
use Core\Vista;
use DateTime;
use DateTimeZone;
use Exception;
use PhpOffice\PhpSpreadsheet\Calculation\TextData\Replace;

final class IngresosegresosControlador extends Controller
{
    private $ingresosegresos_model;
    private $array_errors = [];
    private $div_master;
    private $timeZone;
    private $module;

    public function __construct()
    {
        parent::__construct();
        $this->module                   = new Module('ingresosegresos');
        $this->ingresosegresos_model    = new Ingresosegresos();
        $this->div_master               = $this->ingresosegresos_model->obtenerDivisaMaster();
        $this->timeZone                 = new DateTimeZone('America/Caracas');
    }

    private function obtenerClientesConDocumentosPendientesPorPagar()
    {
        $array_factura = [];
        $array_notas = [];
        $array_ordenes = [];
        $ventas_pendientes = 0;
        $totales_divisas = [];
        $facturas_divisas = [];
        $facturas_divisas_id = [];
        $notas_divisas = [];
        $notas_divisas_id = [];
        $ordenes_divisas = [];
        $ordenes_divisas_id = [];
        $totales_divisas = [];
        $total_divisa_id = [];

        $facturas = $this->ingresosegresos_model->obtenerFacturasPendientes();
        $notas = $this->ingresosegresos_model->obtenerNotasdeentregaPendiente();
        $ordenes = $this->ingresosegresos_model->obtenerOrdendeentregaPendiente();

        $obtener_agente = new EmpleadoInfo();

        if (is_countable($facturas) && count($facturas)) {

            foreach ($facturas as $row) {

                $acumulado = $this->ingresosegresos_model->obtenerAcumulado($row['fm_id'], 2);
                $acumulado_total = ($acumulado['total']) ?? 0;

                if ($row['fm_empagente'] != NULL) {
                    $agente = $obtener_agente->empleadoInfo($row['fm_empagente']);
                }

                $array_factura[] = [
                    'dni'           => $row['cli_dni'],
                    'nombrecompl'   => $row['cli_razon_social'],
                    'id_cliente'   => $row['cli_id'],
                    'id_grupo'   => $row['grup_id'],
                    'grupo'   => $row['grup_nombre'],
                    'id'            => $row['fm_id'],
                    'correlativo'   => $row['fm_correlativo'],
                    'divisa'        => $row['div_nombre'],
                    'div_locale'    => $row['div_locale'],
                    'div_simbolo'   => $row['div_simbolo'],
                    'total'         => $row['fm_total'],
                    'estatus'       => $row['fm_estatus'],
                    'fecha'         => $row['fecha'],
                    'acumulado'     => $acumulado_total,
                    'sucursal'      => $row['su_nombre'],
                    'tipo'          => 'FACV' . $row['fm_correlativo'],
                    'url'           => 'poseditar/verFactura/' . $row['fm_id'],
                    'agente'        => ($row['fm_empagente'] != NULL) ? $agente['einfo_nombres'] . ' ' . $agente['einfo_apellidos'] : $row['fm_empagente'],
                    'pendiente'     => $row['fm_total'] - $acumulado_total
                ];

                $ventas_pendientes += 1;

                if (!in_array($row['div_id'], $facturas_divisas_id)) {
                    $facturas_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => round(($row['fm_total'] - $acumulado_total), 2),
                    ];
                    $facturas_divisas_id[] = $row['div_id'];
                } else {
                    $facturas_divisas[$row['div_id']]['total'] += $row['fm_total'] - $acumulado_total;
                }
            }
        }

        if (is_countable($notas) && count($notas)) {

            foreach ($notas as $row) {

                $acumulado = $this->ingresosegresos_model->obtenerAcumulado($row['ne_id'], 1);
                $acumulado_total = ($acumulado['total']) ?? 0;

                if ($row['ne_empagente'] != NULL) {
                    $agente = $obtener_agente->empleadoInfo($row['ne_empagente']);
                }

                $array_notas[] = [
                    'dni'           => $row['cli_dni'],
                    'nombrecompl'   => $row['cli_razon_social'],
                    'id_cliente'   => $row['cli_id'],
                    'id_grupo'   => $row['grup_id'],
                    'grupo'   => $row['grup_nombre'],
                    'id'            => $row['ne_id'],
                    'correlativo'   => $row['ne_correlativo'],
                    'tipo'          => 'NEV' . $row['ne_correlativo'],
                    'divisa'        => $row['div_nombre'],
                    'div_locale'    => $row['div_locale'],
                    'div_simbolo'   => $row['div_simbolo'],
                    'total'         => $row['ne_total'],
                    'estatus'       => $row['ne_estatus'],
                    'fecha'         => $row['fecha'],
                    'acumulado'     => $acumulado_total,
                    'sucursal'      => $row['su_nombre'],
                    'agente'        => ($row['ne_empagente'] != NULL) ? $agente['einfo_nombres'] . ' ' . $agente['einfo_apellidos'] : $row['ne_empagente'],
                    'url'           => 'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                    'pendiente'     => $row['ne_total'] - $acumulado_total
                ];

                $ventas_pendientes += 1;

                if (!in_array($row['div_id'], $notas_divisas_id)) {
                    $notas_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['ne_total'] - $acumulado_total
                    ];
                    $notas_divisas_id[] = $row['div_id'];
                } else {
                    $notas_divisas[$row['div_id']]['total'] += $row['ne_total'] - $acumulado_total;
                }
            }
        }

        if (is_countable($ordenes) && count($ordenes)) {

            foreach ($ordenes as $row) {

                $acumulado = $this->ingresosegresos_model->obtenerAcumulado($row['n_id'], 12);
                $acumulado_total = ($acumulado['total']) ?? 0;

                if ($row['n_empagente'] != NULL) {
                    $agente = $obtener_agente->empleadoInfo($row['n_empagente']);
                }

                $array_ordenes[] = [
                    'dni'           => $row['cli_dni'],
                    'nombrecompl'   => $row['cli_razon_social'],
                    'id_cliente'   => $row['cli_id'],
                    'id_grupo'   => $row['grup_id'],
                    'grupo'   => $row['grup_nombre'],
                    'id'            => $row['n_id'],
                    'correlativo'   => $row['n_correlativo'],
                    'divisa'        => $row['div_nombre'],
                    'div_locale'    => $row['div_locale'],
                    'div_simbolo'   => $row['div_simbolo'],
                    'total'         => $row['n_total'],
                    'estatus'       => $row['n_estatus'],
                    'fecha'         => $row['fecha'],
                    'acumulado'     => $acumulado_total,
                    'sucursal'      => $row['su_nombre'],
                    'tipo'          => 'ORDENV' . $row['n_correlativo'],
                    'url'           => 'ordendeentregaeditar/verFactura/' . $row['n_id'],
                    'agente'        => ($row['n_empagente'] != NULL) ? $agente['einfo_nombres'] . ' ' . $agente['einfo_apellidos'] : $row['n_empagente'],
                    'pendiente'     => $row['n_total'] - $acumulado_total
                ];

                $ventas_pendientes += 1;

                if (!in_array($row['div_id'], $ordenes_divisas_id)) {
                    $ordenes_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['n_total'] - $acumulado_total
                    ];
                    $ordenes_divisas_id[] = $row['div_id'];
                } else {
                    $ordenes_divisas[$row['div_id']]['total'] += $row['n_total'] - $acumulado_total;
                }
            }
        }

        if (is_countable($facturas_divisas) && count($facturas_divisas)) {
            foreach ($facturas_divisas as $row) {
                if (!in_array($row['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['total'],
                    ];
                    $total_divisa_id[] = $row['div_id'];
                } else {
                    $totales_divisas[$row['div_id']]['total'] += $row['total'];
                }
            }
        }

        if (is_countable($notas_divisas) && count($notas_divisas)) {
            foreach ($notas_divisas as $row) {
                if (!in_array($row['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['total'],
                    ];
                    $total_divisa_id[] = $row['div_id'];
                } else {
                    $totales_divisas[$row['div_id']]['total'] += $row['total'];
                }
            }
        }

        if (is_countable($ordenes_divisas) && count($ordenes_divisas)) {
            foreach ($ordenes_divisas as $row) {
                if (!in_array($row['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row['div_id']] = [
                        'div_id'        => $row['div_id'],
                        'div_nombre'    => $row['div_nombre'],
                        'div_locale'    => $row['div_locale'],
                        'div_simbolo'   => $row['div_simbolo'],
                        'total'         => $row['total'],
                    ];
                    $total_divisa_id[] = $row['div_id'];
                } else {
                    $totales_divisas[$row['div_id']]['total'] += $row['total'];
                }
            }
        }

        return [
            'facturas_pendiente'    => $array_factura,
            'notas_pendiente'       => $array_notas,
            'ordenes_pendientes'    => $array_ordenes,
            'totales_divisas_ord'   => $ordenes_divisas,
            'totales_divisas_fac'   => $facturas_divisas,
            'totales_divisas_not'   => $notas_divisas,
            'divisas_totales'       => $totales_divisas,
        ];
    }

    //COMPRAS PENDIENTES POR PAGAR
    private function obtenerCMPPP()
    {
        $ventas_pendientes      = 0;
        $facturas_divisas       = [];
        $facturas_divisas_id    = [];
        $notas_divisas          = [];
        $notas_divisas_id       = [];
        $array_notas            = [];
        $array_factura          = [];
        $totales_divisas = [];
        $total_divisa_id = [];

        $notas = $this->ingresosegresos_model->obtenerNotasPendientesCMP();
        $facturas = $this->ingresosegresos_model->obtenerFacturasPendientesCMP();

        if (is_countable($notas) && count($notas)) {

            foreach ($notas as $row_nota) {

                $acumulado = $this->ingresosegresos_model->obtenerAcumulado($row_nota['cmpn_id'], 9);
                $acumulado['total'] = $acumulado['total'] ?? 0;

                $array_notas[] = [
                    'id'            => $row_nota['cmpn_id'],
                    'correlativo'   => $row_nota['cmpn_correlativo'],
                    'total'         => $row_nota['cmpn_total'],
                    'estatus'       => $row_nota['cmpn_estatus'],
                    'fecha'         => $row_nota['fecha'],
                    'divisa'        => $row_nota['div_nombre'],
                    'div_locale'    => $row_nota['div_locale'],
                    'div_simbolo'   => $row_nota['div_simbolo'],
                    'prov_id'       => $row_nota['prov_id'],
                    'prov_nombre'   => $row_nota['prov_razonsocial'],
                    'acumulado'     => $acumulado['total'] * -1,
                    'pendiente'     => $row_nota['cmpn_total'] + $acumulado['total']
                ];

                $ventas_pendientes += 1;

                if (!in_array($row_nota['div_id'], $notas_divisas_id)) {
                    $notas_divisas[$row_nota['div_id']] = [
                        'div_id'        => $row_nota['div_id'],
                        'div_locale'    => $row_nota['div_locale'],
                        'div_simbolo'  => $row_nota['div_simbolo'],
                        'total'         => $row_nota['cmpn_total'] + $acumulado['total']
                    ];
                    $notas_divisas_id[] = $row_nota['div_id'];
                } else {
                    $notas_divisas[$row_nota['div_id']]['total'] += $row_nota['cmpn_total'] + $acumulado['total'];
                }
            }
        }

        if (is_countable($facturas) && count($facturas)) {

            foreach ($facturas as $row_factura) {

                $acumulado = $this->ingresosegresos_model->obtenerAcumulado($row_factura['cmp_id'], 8);
                $acumulado['total'] = $acumulado['total'] ?? 0;

                $array_factura[] = [
                    'id'            => $row_factura['cmp_id'],
                    'correlativo'   => $row_factura['cmp_correlativo'],
                    'total'         => $row_factura['cmp_total'],
                    'estatus'       => $row_factura['cmp_estatus'],
                    'fecha'         => $row_factura['fecha'],
                    'divisa'        => $row_factura['div_nombre'],
                    'div_locale'    => $row_factura['div_locale'],
                    'div_simbolo'   => $row_factura['div_simbolo'],
                    'prov_id'       => $row_factura['prov_id'],
                    'prov_nombre'   => $row_factura['prov_razonsocial'],
                    'acumulado'     => $acumulado['total'] * -1,
                    'pendiente'     => $row_factura['cmp_total'] + $acumulado['total']
                ];

                $ventas_pendientes += 1;

                if (!in_array($row_factura['div_id'], $facturas_divisas_id)) {
                    $facturas_divisas[$row_factura['div_id']] = [
                        'div_id'        => $row_factura['div_id'],
                        'div_locale'    => $row_factura['div_locale'],
                        'div_simbolo'  => $row_factura['div_simbolo'],
                        'total'         => $row_factura['cmp_total'] + $acumulado['total']
                    ];
                    $facturas_divisas_id[] = $row_factura['div_id'];
                } else {
                    $facturas_divisas[$row_factura['div_id']]['total'] += $row_factura['cmp_total'] + $acumulado['total'];
                }
            }
        }

        if (is_countable($facturas_divisas) && count($facturas_divisas)) {
            foreach ($facturas_divisas as $row_fac_div) {
                if (!in_array($row_fac_div['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row_fac_div['div_id']] = [
                        'div_id'        => $row_fac_div['div_id'],
                        'div_locale'    => $row_fac_div['div_locale'],
                        'div_simbolo'  => $row_fac_div['div_simbolo'],
                        'total'         => $row_fac_div['total'],
                    ];
                    $total_divisa_id[] = $row_fac_div['div_id'];
                } else {
                    $totales_divisas[$row_fac_div['div_id']]['total'] += $row_fac_div['total'];
                }
            }
        }

        if (is_countable($notas_divisas) && count($notas_divisas)) {
            foreach ($notas_divisas as $row_n_div) {
                if (!in_array($row_n_div['div_id'], $total_divisa_id)) {
                    $totales_divisas[$row_n_div['div_id']] = [
                        'div_id'        => $row_n_div['div_id'],
                        'div_locale'    => $row_n_div['div_locale'],
                        'div_simbolo'  => $row_n_div['div_simbolo'],
                        'total'         => $row_n_div['total'],
                    ];
                    $total_divisa_id[] = $row_n_div['div_id'];
                } else {
                    $totales_divisas[$row_n_div['div_id']]['total'] += $row_n_div['total'];
                }
            }
        }

        return [
            'facturas_pendiente'    => $array_factura,
            'notas_pendiente'       => $array_notas,
            'totales_divisas_fac'   => $facturas_divisas,
            'totales_divisas_not'   => $notas_divisas,
            'divisas_totales'       => $totales_divisas,
        ];
    }

    public function factorDivisa()
    {
        $factor = $this->ingresosegresos_model->divisaFactor(2, 1);

        Http::json_response($factor['df_factor']);
    }

    public function obtenerProducccion()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {

                    $array_notas            = [];
                    $array_notas_id         = [];
                    $artic_total            = 0;
                    $total                  = 0;
                    $acumulado              = 0;
                    $pendiente              = 0;
                    $total_costo            = 0;
                    $ganancia               = 0;
                    $porcentaje_ganancia    = 0;
                    $porcentaje            = 0;

                    $notas = $this->ingresosegresos_model->obtenerNotasdeentrega($fecha_desde, $fecha_hasta);

                    if (is_countable($notas) && count($notas)) {

                        foreach ($notas as $row) {

                            $cantidad = 0;
                            $costo = 0;

                            $productos = $this->ingresosegresos_model->obtenerArticulosNotasEntrega($row['ne_id']);

                            foreach ($productos as $pro) {
                                $producto = $this->ingresosegresos_model->obtenerProducto($pro['neart_proid']);
                                $cantidad += $pro['neart_procantidad'];
                                $costo += $producto['pro_costo'] * $pro['neart_procantidad'];
                            }

                            //$articulos = $this->ingresosegresos_model->obtenerCantidadTotalDeArticulosNotasEntrega($row['ne_id']);
                            $data_acumulado = $this->ingresosegresos_model->obtenerAcumulado($row['ne_id'], 1);

                            $acumulado_total = ($data_acumulado['total']) ?? 0;

                            if ($row['div_id'] != $this->div_master['div_id']) {

                                $factor = $this->ingresosegresos_model->divisaFactor($row['div_id'], $this->div_master['div_id']);
                                $row['ne_total'] = round($row['ne_total'] * $factor['df_factor'], 2);

                                if ($data_acumulado['total'] > 0) {
                                    $acumulado_total = round($data_acumulado['total'] * $factor['df_factor'], 2);
                                }
                            }

                            if (!in_array($row['cli_id'], $array_notas_id)) {

                                $n_local_porcentaje = 0;

                                if ($row['ne_total'] > 0) {
                                    $n_local_porcentaje = round((($row['ne_total'] - $costo) * 100 / $row['ne_total']), 2);
                                }

                                $array_notas[$row['cli_id']] = [
                                    'documentos'        => 1,
                                    'div_locale'        => $this->div_master['div_locale'],
                                    'div_simbolo'      => $this->div_master['div_simbolo'],
                                    'cli_razon_social'  => $row['cli_razon_social'],
                                    'total'             => $row['ne_total'],
                                    'acumulado'         => $acumulado_total,
                                    'pendiente'         => $row['ne_total'] - $acumulado_total,
                                    'costo'             => $costo,
                                    'art_total'         => $cantidad,
                                    'ganancia'          => $row['ne_total'] - $costo,
                                    'porcentaje'        => $n_local_porcentaje
                                ];
                                $array_notas_id[] = $row['cli_id'];
                            } else {
                                $array_notas[$row['cli_id']]['documentos']  += 1;
                                $array_notas[$row['cli_id']]['total']       += $row['ne_total'];
                                $array_notas[$row['cli_id']]['acumulado']   += $acumulado_total;
                                $array_notas[$row['cli_id']]['pendiente']   += $row['ne_total'] - $acumulado_total;
                                $array_notas[$row['cli_id']]['art_total']   += $cantidad;
                                $array_notas[$row['cli_id']]['costo']       += $costo;
                                $array_notas[$row['cli_id']]['ganancia']    += $row['ne_total'] - $costo;
                                $array_notas[$row['cli_id']]['porcentaje']  += round((($row['ne_total'] - $costo) * 100 / $row['ne_total']), 2);
                            }

                            $artic_total    += $cantidad;
                            $total          += $row['ne_total'];
                            $acumulado      += $acumulado_total;
                            $pendiente      += $row['ne_total'] - $acumulado_total;
                            $total_costo    += $costo;
                        }
                    }

                    $facturas = $this->ingresosegresos_model->obtenerFacturas($fecha_desde, $fecha_hasta);

                    if (is_countable($facturas) && count($facturas)) {

                        foreach ($facturas as $row) {

                            $cantidad = 0;
                            $costo = 0;

                            $productos = $this->ingresosegresos_model->obtenerArticulosFactura($row['fm_id']);

                            foreach ($productos as $pro) {
                                $producto = $this->ingresosegresos_model->obtenerProducto($pro['fa_proid']);
                                $cantidad += $pro['fa_procantidad'];
                                $costo += $producto['pro_costo'] * $pro['fa_procantidad'];
                            }

                            //$articulos = $this->ingresosegresos_model->obtenerCantidadTotalDeArticulosFactura($row['fm_id']);
                            $data_acumulado = $this->ingresosegresos_model->obtenerAcumulado($row['fm_id'], 2);

                            $acumulado_total = ($data_acumulado['total']) ?? 0;

                            if ($row['div_id'] != $this->div_master['div_id']) {

                                $factor = $this->ingresosegresos_model->divisaFactor($row['div_id'], $this->div_master['div_id']);
                                $row['fm_total'] = round($row['fm_total'] * $factor['df_factor'], 2);

                                if ($data_acumulado['total'] > 0) {
                                    $acumulado_total = round($data_acumulado['total'] * $factor['df_factor'], 2);
                                }
                            }

                            if (!in_array($row['cli_id'], $array_notas_id)) {

                                $f_local_porcentaje = 0;

                                if ($row['fm_total'] > 0) {
                                    $f_local_porcentaje = round((($row['fm_total'] - $costo) * 100 / $row['fm_total']), 2);
                                }

                                $array_notas[$row['cli_id']] = [
                                    'documentos'        => 1,
                                    'div_locale'        => $this->div_master['div_locale'],
                                    'div_simbolo'      => $this->div_master['div_simbolo'],
                                    'cli_razon_social'  => $row['cli_razon_social'],
                                    'total'             => $row['fm_total'],
                                    'acumulado'         => $acumulado_total,
                                    'pendiente'         => $row['fm_total'] - $acumulado_total,
                                    'costo'             => $costo,
                                    'art_total'         => $cantidad,
                                    'ganancia'          => $row['fm_total'] - $costo,
                                    'porcentaje'        => $f_local_porcentaje
                                ];
                                $array_notas_id[] = $row['cli_id'];
                            } else {
                                $array_notas[$row['cli_id']]['documentos']  += 1;
                                $array_notas[$row['cli_id']]['total']       += $row['fm_total'];
                                $array_notas[$row['cli_id']]['acumulado']   += $acumulado_total;
                                $array_notas[$row['cli_id']]['pendiente']   += $row['fm_total'] - $acumulado_total;
                                $array_notas[$row['cli_id']]['art_total']   += $cantidad;
                                $array_notas[$row['cli_id']]['costo']       += $costo;
                                $array_notas[$row['cli_id']]['ganancia']    += $row['fm_total'] - $costo;
                                $array_notas[$row['cli_id']]['porcentaje']  += round((($row['fm_total'] - $costo) * 100 / $row['fm_total']), 2);
                            }

                            $artic_total    += $cantidad;
                            $total          += $row['fm_total'];
                            $acumulado      += $acumulado_total;
                            $pendiente      += $row['fm_total'] - $acumulado_total;
                            $total_costo    += $costo;
                        }
                    }

                    if ($total > 0 && $total_costo > 0) {
                        $ganancia += $total - $total_costo;
                        $porcentaje_ganancia  += (($total - $total_costo) * 100 / $total);
                        $porcentaje = $acumulado * 100 /  $total;
                    }

                    Http::json_response([
                        'total'         => Moneda::moneda($total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'acumulado'     => Moneda::moneda($acumulado, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'pendiente'     => Moneda::moneda($pendiente, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'porcentaje'    => round($porcentaje),
                        'tcosto'        => Moneda::moneda($total_costo, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'tganancia'      => Moneda::moneda($ganancia, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'tporcentaje_ganancia' => round($porcentaje_ganancia),
                        'art_total'     => $artic_total,
                        'facturas'      => $array_notas
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function produccionDia()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio   = filter_input(INPUT_GET, 'anio', FILTER_SANITIZE_NUMBER_INT);
            $mes    = filter_input(INPUT_GET, 'mes', FILTER_SANITIZE_NUMBER_INT);
            $div_id = filter_input(INPUT_GET, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_GET, 'sucursal', FILTER_SANITIZE_NUMBER_INT);

            if (empty($anio))
                $anio = date('Y');

            if (empty($mes))
                $mes = date('m');

            if (empty($this->array_errors)) {

                $array_notas        = [];
                $array_notas_id     = [];
                $artic_total        = 0;
                $costo              = 0;
                $venta              = 0;
                $ganancia           = 0;
                $porcentaje         = 0;

                $notas = $this->ingresosegresos_model->obtenerProduccionNEVDia($mes, $anio, $div_id, $sucursal);
                $ordenes = $this->ingresosegresos_model->obtenerProduccionORDENDia($mes, $anio, $div_id, $sucursal);
                $facturas = $this->ingresosegresos_model->obtenerProduccionFACVDia($mes, $anio, $div_id, $sucursal);

                if ($div_id > 0) {
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($div_id);
                } else {
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($this->div_master['div_id']);
                }

                if (is_countable($notas) && count($notas)) {

                    foreach ($notas as $row) {

                        if (!in_array($row['dia'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($this->div_master['div_id'] != $div_id && $div_id > 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                    // $row['total_costo'] *= $div_factor['df_factor'];
                                    // $row['total_venta'] *= $div_factor['df_factor'];
                                }
                                if ($row['ne_divid'] != $this->div_master['div_id'] && $div_id == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['ne_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['dia']] = [
                                'div_locale'    => $divisa['div_locale'],
                                'div_simbolo'   => $divisa['div_simbolo'],
                                'dia'           => $row['dia'],
                                'cantidad'      => $row['cantidad'],
                                'costo'         => $row['total_costo'],
                                'venta'         => $row['total_venta'],
                                'ganancia'      => $row['total_venta'] - $row['total_costo'],
                                'porcentaje'    => $porc,
                                'sucursal'    => $row['su_nombre'],
                            ];
                            $array_notas_id[] = $row['dia'];
                        } else {

                            if ($row['total_venta'] > 0) {

                                if ($this->div_master['div_id'] != $div_id && $div_id > 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                    //  $row['total_costo'] *= $div_factor['df_factor'];
                                    // $row['total_venta'] *= $div_factor['df_factor'];
                                }
                                if ($row['ne_divid'] != $this->div_master['div_id'] && $div_id == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['ne_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['dia']]['cantidad']   += $row['cantidad'];
                            $array_notas[$row['dia']]['costo']      += $row['total_costo'];
                            $array_notas[$row['dia']]['venta']      += $row['total_venta'];
                            $array_notas[$row['dia']]['ganancia']   += $row['total_venta'] - $row['total_costo'];
                            $array_notas[$row['dia']]['porcentaje'] += $porc;
                        }

                        $artic_total    += $row['cantidad'];
                        $costo          += $row['total_costo'];
                        $venta          += $row['total_venta'];
                    }
                }

                if (is_countable($ordenes) && count($ordenes)) {

                    foreach ($ordenes as $row) {

                        if (!in_array($row['dia'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($this->div_master['div_id'] != $div_id && $div_id > 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                    //$row['total_costo'] *= $div_factor['df_factor'];
                                    // $row['total_venta'] *= $div_factor['df_factor'];
                                }
                                if ($row['n_divid'] != $this->div_master['div_id'] && $div_id == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['n_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['dia']] = [
                                'div_locale'    => $divisa['div_locale'],
                                'div_simbolo'   => $divisa['div_simbolo'],
                                'dia'           => $row['dia'],
                                'cantidad'      => $row['cantidad'],
                                'costo'         => $row['total_costo'],
                                'venta'         => $row['total_venta'],
                                'ganancia'      => $row['total_venta'] - $row['total_costo'],
                                'porcentaje'    => $porc,
                                'sucursal'    => $row['su_nombre'],
                            ];
                            $array_notas_id[] = $row['dia'];
                        } else {

                            if ($row['total_venta'] > 0) {
                                if ($this->div_master['div_id'] != $div_id && $div_id > 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                    //$row['total_costo'] *= $div_factor['df_factor'];
                                    // $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                if ($row['n_divid'] != $this->div_master['div_id'] && $div_id == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['n_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['dia']]['cantidad']   += $row['cantidad'];
                            $array_notas[$row['dia']]['costo']      += $row['total_costo'];
                            $array_notas[$row['dia']]['venta']      += $row['total_venta'];
                            $array_notas[$row['dia']]['ganancia']   += $row['total_venta'] - $row['total_costo'];
                            $array_notas[$row['dia']]['porcentaje'] += $porc;
                        }

                        $artic_total    += $row['cantidad'];
                        $costo          += $row['total_costo'];
                        $venta          += $row['total_venta'];
                    }
                }

                if (is_countable($facturas) && count($facturas)) {

                    foreach ($facturas as $row_dos) {

                        if (!in_array($row_dos['dia'], $array_notas_id)) {

                            if ($row_dos['total_venta'] > 0) {

                                if ($this->div_master['div_id'] != $div_id && $div_id > 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                    //$row_dos['total_costo'] *= $div_factor['df_factor'];
                                    // $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                if ($row_dos['fm_divid'] != $this->div_master['div_id'] && $div_id == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row_dos['fm_divid'], $this->div_master['div_id']);
                                    $row_dos['total_costo'] *= $div_factor['df_factor'];
                                    $row_dos['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row_dos['total_venta'] - $row_dos['total_costo']) * 100 / $row_dos['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row_dos['dia']] = [
                                'div_locale'    => $divisa['div_locale'],
                                'div_simbolo'   => $divisa['div_simbolo'],
                                'dia'           => $row_dos['dia'],
                                'cantidad'      => $row_dos['cantidad'],
                                'costo'         => $row_dos['total_costo'],
                                'venta'         => $row_dos['total_venta'],
                                'ganancia'      => $row_dos['total_venta'] - $row_dos['total_costo'],
                                'porcentaje'    => $porc,
                                'sucursal'    => $row_dos['su_nombre'],
                            ];
                            $array_notas_id[] = $row_dos['dia'];
                        } else {

                            if ($row_dos['total_venta'] > 0) {

                                if ($this->div_master['div_id'] != $div_id && $div_id > 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                    //$row_dos['total_costo'] *= $div_factor['df_factor'];
                                    // $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                if ($row_dos['fm_divid'] != $this->div_master['div_id'] && $div_id == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row_dos['fm_divid'], $this->div_master['div_id']);
                                    $row_dos['total_costo'] *= $div_factor['df_factor'];
                                    $row_dos['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row_dos['total_venta'] - $row_dos['total_costo']) * 100 / $row_dos['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row_dos['dia']]['cantidad']   += $row_dos['cantidad'];
                            $array_notas[$row_dos['dia']]['costo']      += $row_dos['total_costo'];
                            $array_notas[$row_dos['dia']]['venta']      += $row_dos['total_venta'];
                            $array_notas[$row_dos['dia']]['ganancia']   += $row_dos['total_venta'] - $row_dos['total_costo'];
                            $array_notas[$row_dos['dia']]['porcentaje'] += $porc;
                        }

                        $artic_total    += $row_dos['cantidad'];
                        $costo          += $row_dos['total_costo'];
                        $venta          += $row_dos['total_venta'];
                    }
                }

                if ($costo > 0 && $venta > 0) {
                    $ganancia = $venta - $costo;
                    $porcentaje = round(($ganancia * 100 / $venta), 2);
                }

                Http::json_response([
                    'costo'         => Moneda::moneda($costo, $divisa['div_locale'], $divisa['div_simbolo']),
                    'venta'         => Moneda::moneda($venta, $divisa['div_locale'], $divisa['div_simbolo']),
                    'ganancia'      => Moneda::moneda($ganancia, $divisa['div_locale'], $divisa['div_simbolo']),
                    'porcentaje'    => round($porcentaje),
                    'art_total'     => $artic_total,
                    'dias'          => $array_notas
                ]);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function produccionAnio()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio   = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
            $divis   = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $sucursal   = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);


            if (empty($this->array_errors)) {

                $array_notas        = [];
                $array_notas_id     = [];
                $artic_total        = 0;
                $costo              = 0;
                $venta              = 0;
                $ganancia           = 0;
                $porcentaje         = 0;

                $notas = $this->ingresosegresos_model->obtenerProduccionNEVAnio($anio, $sucursal, $divis);
                $ordenes = $this->ingresosegresos_model->obtenerProduccionORDENAnio($anio, $sucursal, $divis);
                $facturas = $this->ingresosegresos_model->obtenerProduccionFACVAnio($anio, $sucursal, $divis);

                $compras = new Compras();
                if ($anio == 0) {
                    if ($divis > 0) {
                        $facturasc = $compras->obtenerFacturasAnualest(" cmp.cmp_divid=$divis");
                        $notasc = $compras->obtenerNotasdeEntregaAnualest(" cmp.cmpn_divid=$divis");
                    } else {
                        $facturasc = $compras->obtenerFacturasAnualesTodos();
                        $notasc = $compras->obtenerNotasdeEntregaAnualesTodos();
                    }
                } else {
                    if ($divis > 0) {
                        $facturasc = $compras->obtenerFacturasAnualest("YEAR(cmp.cmp_fecha)=$anio AND cmp.cmp_divid=$divis");
                        $notasc = $compras->obtenerNotasdeEntregaAnualest("YEAR(cmp.cmpn_fecha)=$anio AND cmp.cmpn_divid=$divis");
                    } else {
                        $facturasc = $compras->obtenerFacturasAnualest("YEAR(cmp.cmp_fecha)=$anio");
                        $notasc = $compras->obtenerNotasdeEntregaAnualest("YEAR(cmp.cmpn_fecha)=$anio");
                    }
                }

                if ($divis > 0) {
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($divis);
                } else {
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($this->div_master['div_id']);
                }

                if (is_countable($notas) && count($notas)) {

                    foreach ($notas as $row) {

                        if (!in_array($row['anio'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($row['ne_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['ne_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }


                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['anio']] = [
                                'anio'           => $row['anio'],
                                'venta'         => $row['total_venta'],
                                'porcentaje'    => $porc,
                                'compra' => 0
                            ];
                            $array_notas_id[] = $row['anio'];
                        } else {

                            if ($row['total_venta'] > 0) {


                                if ($row['ne_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['ne_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }
                            $array_notas[$row['anio']]['venta']      += $row['total_venta'];
                            $array_notas[$row['anio']]['porcentaje'] += $porc;
                        }
                    }
                }

                if (is_countable($ordenes) && count($ordenes)) {

                    foreach ($ordenes as $row) {

                        if (!in_array($row['anio'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($row['n_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['n_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['anio']] = [
                                'anio'           => $row['anio'],
                                'venta'         => $row['total_venta'],
                                'porcentaje'    => $porc,
                                'compra' => 0
                            ];
                            $array_notas_id[] = $row['anio'];
                        } else {

                            if ($row['total_venta'] > 0) {


                                if ($row['n_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['n_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['anio']]['venta']      += $row['total_venta'];
                            $array_notas[$row['anio']]['porcentaje'] += $porc;
                        }
                    }
                }

                if (is_countable($facturas) && count($facturas)) {

                    foreach ($facturas as $row) {

                        if (!in_array($row['anio'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($row['fm_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['fm_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['anio']] = [
                                'anio'           => $row['anio'],
                                'venta'         => $row['total_venta'],
                                'porcentaje'    => $porc,
                                'compra' => 0
                            ];
                            $array_notas_id[] = $row['anio'];
                        } else {

                            if ($row['total_venta'] > 0) {


                                if ($row['fm_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['fm_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }
                            $array_notas[$row['anio']]['venta']      += $row['total_venta'];
                            $array_notas[$row['anio']]['porcentaje'] += $porc;
                        }
                    }
                }

                if (is_countable($notasc) && count($notasc)) {

                    foreach ($notasc as $row) {

                        if ($row['divisa'] != $this->div_master['div_id'] && $divis == 0) {
                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                            $row['total'] = round(($row['total'] * $factor['df_factor']), 2);
                        }

                        if (!in_array($row['anio'], $array_notas_id)) {

                            $array_notas[$row['anio']] = [
                                'anio'           => $row['anio'],
                                'venta'         => 0,
                                'porcentaje'    => 0,
                                'compra' => $row['total']
                            ];
                            $array_notas_id[] = $row['anio'];
                        } else {
                            $array_notas[$row['anio']]['compra']      += $row['total'];
                        }
                    }
                }

                if (is_countable($facturasc) && count($facturasc)) {

                    foreach ($facturasc as $row) {

                        if ($row['divisa'] != $this->div_master['div_id'] && $divis == 0) {
                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                            $row['total'] = round(($row['total'] * $factor['df_factor']), 2);
                        }

                        if (!in_array($row['anio'], $array_notas_id)) {

                            $array_notas[$row['anio']] = [
                                'anio'           => $row['anio'],
                                'venta'         => 0,
                                'porcentaje'    => 0,
                                'compra' => $row['total']
                            ];
                            $array_notas_id[] = $row['anio'];
                        } else {
                            $array_notas[$row['anio']]['compra']      += $row['total'];
                        }
                    }
                }

                Http::json_response([
                    'anios'         => $array_notas,
                    'div_locale'    => $divisa['div_locale'],
                    'div_simbolo'  => $divisa['div_simbolo'],
                ]);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function produccionmes()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio   = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
            $divis   = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $sucursal   = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);


            if (empty($this->array_errors)) {

                $array_notas        = [];
                $array_notas_id     = [];
                $artic_total        = 0;
                $costo              = 0;
                $venta              = 0;
                $ganancia           = 0;
                $porcentaje         = 0;

                $notas = $this->ingresosegresos_model->obtenerProduccionNEVMes($anio, $divis, $sucursal);
                $ordenes = $this->ingresosegresos_model->obtenerProduccionORDENMes($anio, $divis, $sucursal);
                $facturas = $this->ingresosegresos_model->obtenerProduccionFACVMes($anio, $divis, $sucursal);

                $compras = new Compras();
                if ($anio == 0) {
                    if ($divis > 0) {
                        $facturasc = $compras->obtenerFacturasAnualesMesIng("AND cmp.cmp_divid=$divis");
                        $notasc = $compras->obtenerNotasdeEntregaAnualesMesIng("AND cmp.cmpn_divid=$divis");
                    } else {
                        $facturasc = $compras->obtenerFacturasAnualesMesIng("");
                        $notasc = $compras->obtenerNotasdeEntregaAnualesMesIng("");
                    }
                } else {
                    if ($divis > 0) {
                        $facturasc = $compras->obtenerFacturasAnualesMesIng("AND YEAR(cmp.cmp_fecha)=$anio AND cmp.cmp_divid=$divis");
                        $notasc = $compras->obtenerNotasdeEntregaAnualesMesIng("AND YEAR(cmp.cmpn_fecha)=$anio AND cmp.cmpn_divid=$divis");
                    } else {
                        $facturasc = $compras->obtenerFacturasAnualesMesIng("AND YEAR(cmp.cmp_fecha)=$anio");
                        $notasc = $compras->obtenerNotasdeEntregaAnualesMesIng("AND YEAR(cmp.cmpn_fecha)=$anio");
                    }
                }

                $data_positivo = $this->ingresosegresos_model->obtenerCierreMesSucursal(0, $anio, 1, $sucursal, $divis);
                $data_negativo = $this->ingresosegresos_model->obtenerCierreMesSucursal(1, $anio, 2, $sucursal, $divis);

                if ($divis > 0) {
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($divis);
                } else {
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($this->div_master['div_id']);
                }

                if (is_countable($data_positivo) && count($data_positivo)) {
                    foreach ($data_positivo as $row) {

                        if ($divis == 0) {
                            $monto = ($this->div_master['div_id'] != $row['div_id']) ? $row['monto'] / $row['fab_factor_master'] : $row['monto'];
                        } else {
                            $monto = $row['monto'];
                        }


                        if (!in_array($row['mes'], $array_notas_id)) {

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => 0,
                                'compra' => 0,
                                'egreso' => 0,
                                'ingreso' => $monto
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {
                            $array_notas[$row['mes']]['ingreso']      += $monto;
                        }
                    }
                }

                if (is_countable($data_negativo) && count($data_negativo)) {
                    foreach ($data_negativo as $row) {

                        if ($divis == 0) {
                            $row['monto'] = $row['monto'] * (-1);
                            $monto = ($this->div_master['div_id'] != $row['div_id']) ? $row['monto'] / $row['fab_factor_master'] : $row['monto'];
                        } else {
                            $monto = $row['monto'] * (-1);
                        }

                        if (!in_array($row['mes'], $array_notas_id)) {

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => 0,
                                'compra' => 0,
                                'egreso' => $monto,
                                'ingreso' => 0
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {
                            $array_notas[$row['mes']]['egreso']      += $monto;
                        }
                    }
                }

                if (is_countable($notasc) && count($notasc)) {

                    foreach ($notasc as $row) {

                        if ($row['divisa'] != $this->div_master['div_id'] && $divis == 0) {
                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                            $row['total'] = round(($row['total'] * $factor['df_factor']), 2);
                        }

                        if (!in_array($row['mes'], $array_notas_id)) {

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => 0,
                                'compra' => $row['total'],
                                'egreso' => 0,
                                'ingreso' => 0
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {
                            $array_notas[$row['mes']]['compra']      += $row['total'];
                        }
                    }
                }

                if (is_countable($facturasc) && count($facturasc)) {

                    foreach ($facturasc as $row) {

                        if ($row['divisa'] != $this->div_master['div_id'] && $divis == 0) {
                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                            $row['total'] = round(($row['total'] * $factor['df_factor']), 2);
                        }

                        if (!in_array($row['mes'], $array_notas_id)) {

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => 0,
                                'compra'        => $row['total'],
                                'egreso' => 0,
                                'ingreso' => 0
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {
                            $array_notas[$row['mes']]['compra']      += $row['total'];
                        }
                    }
                }

                if (is_countable($notas) && count($notas)) {

                    foreach ($notas as $row) {

                        if (!in_array($row['mes'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($row['ne_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['ne_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }


                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => round($row['total_venta'], 2),
                                'compra' =>  0,
                                'egreso' => 0,
                                'ingreso' => 0
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {

                            if ($row['total_venta'] > 0) {


                                if ($row['ne_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['ne_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }
                            $array_notas[$row['mes']]['venta']      += round($row['total_venta'], 2);
                        }
                    }
                }

                if (is_countable($ordenes) && count($ordenes)) {

                    foreach ($ordenes as $row) {

                        if (!in_array($row['mes'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($row['n_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['n_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => round($row['total_venta'], 2),
                                'compra' => 0,
                                'egreso' => 0,
                                'ingreso' => 0
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {

                            if ($row['total_venta'] > 0) {


                                if ($row['n_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['n_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['mes']]['venta']      += round($row['total_venta'], 2);
                        }
                    }
                }

                if (is_countable($facturas) && count($facturas)) {

                    foreach ($facturas as $row) {

                        if (!in_array($row['mes'], $array_notas_id)) {

                            if ($row['total_venta'] > 0) {

                                if ($row['fm_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['fm_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }

                            $array_notas[$row['mes']] = [
                                'mes'           => $row['mes'],
                                'venta'         => round($row['total_venta'], 2),
                                'compra' => 0,
                                'egreso' => 0,
                                'ingreso' => 0
                            ];
                            $array_notas_id[] = $row['mes'];
                        } else {

                            if ($row['total_venta'] > 0) {


                                if ($row['fm_divid'] != $this->div_master['div_id'] && $divis == 0) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($row['fm_divid'], $this->div_master['div_id']);
                                    $row['total_costo'] *= $div_factor['df_factor'];
                                    $row['total_venta'] *= $div_factor['df_factor'];
                                }

                                $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                            } else {
                                $porc = 0;
                            }
                            $array_notas[$row['mes']]['venta']      += round($row['total_venta'], 2);
                        }
                    }
                }

                Http::json_response([
                    'meses'         => $array_notas,
                    'div_locale'    => $divisa['div_locale'],
                    'div_simbolo'  => $divisa['div_simbolo'],
                ]);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $empleado_almacen_model = new EmpleadoAlmacen();

            $list_cat = [];
            $t_list_cat = [];
            $total_por_divisas_id = [];
            $total_por_divisas = [];
            $list_bancos = [];

            $data_bancos = $this->ingresosegresos_model->totalIngresosSegunCuentas();
            $categorias = $empleado_almacen_model->consultar("SELECT * FROM app_categorias_ingreso_egreso WHERE cie_id != 1 AND cie_id != 2")->all();
            $t_categorias = $empleado_almacen_model->consultar("SELECT * FROM app_categorias_ingreso_egreso")->all();

            if (is_countable($data_bancos) && count($data_bancos)) {

                foreach ($data_bancos as $banco) {

                    $list_bancos[] = [
                        'banco' => $banco['ban_descripcion'],
                        'cuenta' => $banco['bc_cuenta']  . ' ' . $banco['bc_alias'],
                        'tipo' => $banco['bc_tipo'],
                        'divisa' => $banco['div_nombre'],
                        'total' => Moneda::moneda($banco['total'] ?? 0, $banco['div_locale'], $banco['div_simbolo'])
                    ];

                    if (!in_array($banco['div_id'], $total_por_divisas_id)) {
                        $total_por_divisas[$banco['div_id']] = [
                            'divisa'    => Moneda::obtenerDivisa($banco['div_id']),
                            'total'     => $banco['total'] ?? 0
                        ];
                        $total_por_divisas_id[] = $banco['div_id'];
                    } else {
                        $total_por_divisas[$banco['div_id']]['total'] += $banco['total'];
                    }
                }
            }

            if (is_countable($categorias) && count($categorias)) {
                foreach ($categorias as $row) {
                    $list_cat[] = [
                        'id' => $row['cie_id'],
                        'categoria' => $row['cie_descripcion']
                    ];
                }
            }

            if (is_countable($t_categorias) && count($t_categorias)) {
                foreach ($t_categorias as $row) {
                    $t_list_cat[] = [
                        'id' => $row['cie_id'],
                        'categoria' => $row['cie_descripcion']
                    ];
                }
            }

            $obtener_agente = new EmpleadoInfo();
            $obtener_comisiones = new Comisiones();

            $empleado_sucursales = new EmpleadoSucursales();
            $suc = $empleado_sucursales->obtenerSucursales($_SESSION['user_data']['emp_id']);


            return Vista::view('ingresosegresos/index', [
                'almacenes'             => $empleado_almacen_model->obtenerAlmacenes($_SESSION['user_data']['emp_id']),
                'divisas'               => $this->ingresosegresos_model->obtenerDivisas(),
                'monedas'               => $total_por_divisas,
                'sucursales'            => $suc,
                'bancos'                => $list_bancos,
                'cli_pendiente'         => $this->obtenerClientesConDocumentosPendientesPorPagar(),
                'cmppp'                 => $this->obtenerCMPPP(),
                'categorias'            => $list_cat,
                't_categorias'          => $t_list_cat,
                'agentes'               => $obtener_agente->agentesventa(),
                'comisiones'            => $obtener_comisiones->todos(),
                'todosucursales' =>  $this->module->has_module_action_permission('facturacion', 'todosucursales', $_SESSION['user_data']['emp_id']),
                'productos_vendidos_simples' => $this->module->has_module_action_permission('ingresosegresos', 'productos_vendidos_simples', $_SESSION['user_data']['emp_id']),
                'facturas_compras' => $this->module->has_module_action_permission('ingresosegresos', 'facturas_compras', $_SESSION['user_data']['emp_id']),
                'impresoras'            => $this->ingresosegresos_model->consultar("SELECT imp_id id, imp_descripcion impresora, imp_tipo tipo FROM app_impresoras WHERE imp_tipo = 2 AND imp_estatus = 1")->all(),
                'imp_ticket'            => $this->ingresosegresos_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all(),
                'registrar_ingresos'    => $this->module->has_module_action_permission('ingresosegresos', 'registrar_ingresos', $_SESSION['user_data']['emp_id']),
                'registrar_egresos'     => $this->module->has_module_action_permission('ingresosegresos', 'registrar_egresos', $_SESSION['user_data']['emp_id']),
                'pagar_comisiones'    => $this->module->has_module_action_permission('ingresosegresos', 'pagar_comisiones', $_SESSION['user_data']['emp_id']),
                'registrar_transferencias' => $this->module->has_module_action_permission('ingresosegresos', 'registrar_transferencias', $_SESSION['user_data']['emp_id']),
                'cliente_cobrar' => $this->module->has_module_action_permission('ingresosegresos', 'cliente_cobrar', $_SESSION['user_data']['emp_id']),
                'venta_dias' => $this->module->has_module_action_permission('ingresosegresos', 'venta_dias', $_SESSION['user_data']['emp_id']),
                'precio_productos_vendidos' => $this->module->has_module_action_permission('ingresosegresos', 'precio_productos_vendidos', $_SESSION['user_data']['emp_id']),
                'ventas_meses' => $this->module->has_module_action_permission('ingresosegresos', 'ventas_meses', $_SESSION['user_data']['emp_id']),
                'cuentas_pagar' => $this->module->has_module_action_permission('ingresosegresos', 'cuentas_pagar', $_SESSION['user_data']['emp_id']),
                'cierre_dia' => $this->module->has_module_action_permission('ingresosegresos', 'cierre_dia', $_SESSION['user_data']['emp_id']),
                'venta_dia' => $this->module->has_module_action_permission('ingresosegresos', 'venta_dia', $_SESSION['user_data']['emp_id']),
                'consolidado' => $this->module->has_module_action_permission('ingresosegresos', 'consolidado', $_SESSION['user_data']['emp_id']),
                'inversion' => $this->module->has_module_action_permission('ingresosegresos', 'inversion', $_SESSION['user_data']['emp_id']),
                'balance_movimiento' => $this->module->has_module_action_permission('ingresosegresos', 'balance_movimiento', $_SESSION['user_data']['emp_id']),
                'balance_movimiento_documento' => $this->module->has_module_action_permission('ingresosegresos', 'balance_movimiento_documento', $_SESSION['user_data']['emp_id']),
                'productos_vendidos' => $this->module->has_module_action_permission('ingresosegresos', 'productos_vendidos', $_SESSION['user_data']['emp_id']),
                'productos_vendidos_documentos' => $this->module->has_module_action_permission('ingresosegresos', 'productos_vendidos_documentos', $_SESSION['user_data']['emp_id']),
                'reporte_proveedor' => $this->module->has_module_action_permission('ingresosegresos', 'reporte_proveedor', $_SESSION['user_data']['emp_id']),
                'reporte_general' => $this->module->has_module_action_permission('ingresosegresos', 'reporte_general', $_SESSION['user_data']['emp_id']),
            ]);
        }
    }

    public function inversion()
    {

        $list_cat = [];
        $t_list_cat = [];
        $dolar = [];
        $bolivar = [];
        $list_bancos = [];
        $tbolivar = 0;
        $tDolar = 0;

        // $divisas=$this->ingresosegresos_model->obtenerDivisas();

        $data_bancosd = $this->ingresosegresos_model->totalIngresosSegunCuentasDivisa(1);
        $data_sumaDolar = $this->ingresosegresos_model->totalIngresosSegunCuentasDivisaMonto(2);
        $data_sumaBolivar = $this->ingresosegresos_model->totalIngresosSegunCuentasDivisaMonto(1);

        foreach ($data_sumaDolar as $row) {
            $tDolar += $row['total'];
        }

        foreach ($data_sumaBolivar as $row) {
            $tbolivar = $row['total'];
        }

        if (is_countable($data_bancosd) && count($data_bancosd)) {
            foreach ($data_bancosd as $banco) {

                $porcentaje = round(($banco['total'] * 100) / $tbolivar, 2);

                $bolivar[] = [
                    'banco' => $banco['ban_descripcion'],
                    'cuenta' => $banco['bc_alias'],
                    'tipo' => $banco['bc_tipo'],
                    'divisa' => $banco['div_nombre'],
                    'total_numero' => $porcentaje,
                    'totaln' => $tbolivar,
                    'total' => Moneda::moneda($banco['total'] ?? 0, $banco['div_locale'], $banco['div_simbolo'])
                ];
            }
        }

        $data_bancosb = $this->ingresosegresos_model->totalIngresosSegunCuentasDivisa(2);

        if (is_countable($data_bancosb) && count($data_bancosb)) {
            foreach ($data_bancosb as $banco) {
                $porcentaje = round(($banco['total'] * 100) / $tDolar, 2);
                $dolar[] = [
                    'banco' => $banco['ban_descripcion'],
                    'cuenta' => $banco['bc_alias'],
                    'tipo' => $banco['bc_tipo'],
                    'divisa' => $banco['div_nombre'],
                    'total_numero' => $porcentaje,
                    'total' => Moneda::moneda($banco['total'] ?? 0, $banco['div_locale'], $banco['div_simbolo'])
                ];
            }
        }


        http::json_response([
            'dolar' => $dolar,
            'bolivar' => $bolivar
        ]);
    }
    public function obtenerSeriesAlmacenesEmpleado(int $sucursales)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sucursales = filter_var($sucursales, FILTER_SANITIZE_NUMBER_INT);

            $almacenes = $this->carritoVentas->obtenerAlmacenesEmpleadoSucursales($sucursales);

            $idalm = '';
            foreach ($almacenes as $row) {
                if ($row['empalm_predeterminado'] == 1) {
                    $idalm = $row['empalm_almid'];
                }
            }

            if ($idalm == "" && count($almacenes) > 0) {
                $idalm = $almacenes[0]['empalm_almid'];
            }

            Http::json_response([
                'almacenes' => $almacenes,
                'id_alm' => $idalm
            ]);
        }
    }

    public function obtenerInversion(int $id_almacen)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $array_productos = [];
            $cantidad = $tcosto = $tventa = $porcentaje = $ganancia = 0;

            $productos = $this->ingresosegresos_model->obtenerProductosConStock($id_almacen);

            if (is_countable($productos) &&  count($productos)) {

                foreach ($productos as $row) {

                    $porcentaje_pro = 0;
                    $ganancia_pro = 0;
                    $ganancia_pro = ($row['pro_precio'] * $row['cantidad']) - ($row['pro_costo'] * $row['cantidad']);

                    if ($ganancia_pro > 0 && $row['pro_costo'] > 0) {
                        $porcentaje_pro = ($ganancia_pro * 100 / ($row['pro_costo'] * $row['cantidad']));
                    }

                    $array_productos[] = [
                        'id'            => $row['pro_id'],
                        'descripcion'   => $row['pro_descripcion'],
                        'costo'         => Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'cantidad'      => $row['cantidad'],
                        'almacen'       => $row['alm_nombre'],
                        'ganancia'      => Moneda::moneda($ganancia_pro, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'porcentaje'    => round($porcentaje_pro)
                    ];

                    $tcosto     += $row['pro_costo'] * $row['cantidad'];
                    $tventa     += $row['pro_precio'] * $row['cantidad'];
                    $cantidad   += $row['cantidad'];
                    $ganancia   = $tventa - $tcosto;
                    $porcentaje = ($tcosto > 0) ?  $ganancia * 100 / $tcosto : 0;
                }
            }

            Http::json_response([
                'productos'     => $array_productos,
                'tcosto'        => Moneda::moneda($tcosto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                'tventa'        => Moneda::moneda($tventa, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                'cantidad'      => Moneda::decimal($cantidad, $this->div_master['div_locale']),
                'ganancia'      => Moneda::moneda($ganancia, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                'porcentaje'    => Moneda::decimal($porcentaje, $this->div_master['div_locale'])
            ]);
        }
    }

    //OBTIENE LOS PRODUCTOS DE DOCUEMENTOS GENERADOS VENIDOS
    public function obtenerProductosVendidos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $id_divisa      = filter_input(INPUT_GET, 'divisa');
            $sucursal      = filter_input(INPUT_GET, 'sucursal');

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {

                    if (!empty($id_divisa)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                    }

                    $artic_total        = 0;
                    $costo_total        = 0;
                    $venta_total        = 0;
                    $totales_productos  = [];
                    $total_productos_id = [];

                    $productos =  $this->ingresosegresos_model->obtenerProductos();

                    if (is_countable($productos) && count($productos)) {

                        foreach ($productos as $pro) {

                            if (empty($id_divisa)) {
                                $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta);
                                $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrd($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta);
                                $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta);
                            } else {
                                $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa);
                                $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrd($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa);
                                $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa);
                            }


                            if (is_countable($total_notas) && count($total_notas)) {

                                foreach ($total_notas as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa)) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            //$row['costo'] = round(($row['costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    } else {

                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($row['costo'] * $row['cantidad']);
                                        $ga = ($ganancia * 100);
                                        $ganc = ($row['costo'] * $row['cantidad']);
                                        if ($ga > 0 && $ganc > 0) {
                                            $ganancia_porct =  $ga / $ganc;
                                        } else {
                                            $ganancia_porct = 0;
                                        }
                                    }

                                    if (!in_array($pro['pro_id'], $total_productos_id)) {
                                        $totales_productos[$pro['pro_id']] = [
                                            'div_locale'        => $this->div_master['div_locale'],
                                            'div_simbolo'       => $this->div_master['div_simbolo'],
                                            'div_nombre'        => $this->div_master['div_nombre'],
                                            'pro_id'            => $pro['pro_id'],
                                            'pro_descripcion'   => $pro['pro_descripcion'],
                                            'pro_costo'         =>  $row['costo'],
                                            'cantidad'          => $row['cantidad'],
                                            'costo_total'       =>  $row['costo'] * $row['cantidad'],
                                            'total'             => $row['total'],
                                            'ganancia'          => $ganancia,
                                            'ganancia_porct'    => $ganancia_porct,
                                            'sucursal'          => $row['su_nombre'],
                                            'uri'               => 'notasdeentregaeditar/verFactura/' . $row['id'],
                                            'documento'         => 'NEV' . $row['correlativo'],
                                            'fecha'             => $row['fecha'],
                                            'empleado'          => $row['nombre'] . ' ' . $row['apellido'],
                                        ];
                                        $total_productos_id[] = $pro['pro_id'];
                                    } else {
                                        $totales_productos[$pro['pro_id']]['costo_total']       +=  $row['costo'] * $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['cantidad']          += $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['pro_id']]['ganancia']          += $ganancia;
                                        $totales_productos[$pro['pro_id']]['ganancia_porct']    += $ganancia_porct;
                                    }

                                    $artic_total += $row['cantidad'];
                                    $costo_total +=  $row['costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }

                            if (is_countable($total_facv) && count($total_facv)) {

                                foreach ($total_facv as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa)) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            //$row['costo'] = round(($row['costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    } else {
                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($row['costo'] * $row['cantidad']);
                                        $ga = ($ganancia * 100);
                                        $ganc = ($row['costo'] * $row['cantidad']);
                                        if ($ga > 0 && $ganc > 0) {
                                            $ganancia_porct =  $ga / $ganc;
                                        } else {
                                            $ganancia_porct = 0;
                                        }
                                    }

                                    if (!in_array($pro['pro_id'], $total_productos_id)) {
                                        $totales_productos[$pro['pro_id']] = [
                                            'div_locale'        => $this->div_master['div_locale'],
                                            'div_simbolo'       => $this->div_master['div_simbolo'],
                                            'div_nombre'        => $this->div_master['div_nombre'],
                                            'pro_id'            => $pro['pro_id'],
                                            'pro_descripcion'   => $pro['pro_descripcion'],
                                            'pro_costo'         =>  $row['costo'],
                                            'cantidad'          => $row['cantidad'],
                                            'costo_total'       =>  $row['costo'] * $row['cantidad'],
                                            'total'             => $row['total'],
                                            'ganancia'          => $ganancia,
                                            'ganancia_porct'    => $ganancia_porct,
                                            'sucursal'          => $row['su_nombre'],
                                            'uri'               => 'poseditar/verFactura/' . $row['id'],
                                            'documento'         => 'FACV' . $row['correlativo'],
                                            'fecha'             => $row['fecha'],
                                            'empleado'          => $row['nombre'] . ' ' . $row['apellido'],
                                        ];
                                        $total_productos_id[] = $pro['pro_id'];
                                    } else {
                                        $totales_productos[$pro['pro_id']]['costo_total']       +=  $row['costo'] * $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['cantidad']          += $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['pro_id']]['ganancia']          += $ganancia;
                                        $totales_productos[$pro['pro_id']]['ganancia_porct']    += $ganancia_porct;
                                    }

                                    $artic_total += $row['cantidad'];
                                    $costo_total +=  $row['costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }

                            if (is_countable($total_ordenes) && count($total_ordenes)) {

                                foreach ($total_ordenes as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa)) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            // $row['costo'] = round(($row['costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /*$this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $id_divisa);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    } else {
                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($row['costo'] * $row['cantidad']);
                                        $ga = ($ganancia * 100);
                                        $ganc = ($row['costo'] * $row['cantidad']);
                                        if ($ga > 0 && $ganc > 0) {
                                            $ganancia_porct =  $ga / $ganc;
                                        } else {
                                            $ganancia_porct = 0;
                                        }
                                    }

                                    if (!in_array($pro['pro_id'], $total_productos_id)) {
                                        $totales_productos[$pro['pro_id']] = [
                                            'div_locale'        => $this->div_master['div_locale'],
                                            'div_simbolo'       => $this->div_master['div_simbolo'],
                                            'div_nombre'        => $this->div_master['div_nombre'],
                                            'pro_id'            => $pro['pro_id'],
                                            'pro_descripcion'   => $pro['pro_descripcion'],
                                            'pro_costo'         =>  $row['costo'],
                                            'cantidad'          => $row['cantidad'],
                                            'costo_total'       =>  $row['costo'] * $row['cantidad'],
                                            'total'             => $row['total'],
                                            'ganancia'          => $ganancia,
                                            'ganancia_porct'    => $ganancia_porct,
                                            'sucursal'          => $row['su_nombre'],
                                            'uri'               => 'ordendeentregaeditar/verFactura/' . $row['id'],
                                            'documento'         => 'ORDENV' . $row['correlativo'],
                                            'fecha'             => $row['fecha'],
                                            'empleado'          => $row['nombre'] . ' ' . $row['apellido'],
                                        ];
                                        $total_productos_id[] = $pro['pro_id'];
                                    } else {
                                        $totales_productos[$pro['pro_id']]['costo_total']       +=  $row['costo'] * $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['cantidad']          += $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['pro_id']]['ganancia']          += $ganancia;
                                        $totales_productos[$pro['pro_id']]['ganancia_porct']    += $ganancia_porct;
                                    }

                                    $artic_total += $row['cantidad'];
                                    $costo_total +=  $row['costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }
                        }
                    }

                    $ganancia = 0;
                    $ganancia_porct = 0;

                    if ($venta_total > 0 && $costo_total > 0) {
                        $ganancia = $venta_total - $costo_total;
                        $ganancia_porct   = ($costo_total * 100) / $venta_total;
                    }

                    Http::json_response([
                        'venta_total'   => Moneda::moneda($venta_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'costo_total'   => Moneda::moneda($costo_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'artic_total'   => $artic_total,
                        'ganancia'      => Moneda::moneda($ganancia, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'ganancia_porc' => round($ganancia_porct),
                        'productos'     => $totales_productos,
                        'cantidad_articulos' =>  count($totales_productos)
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerProductosVendidosdocumentos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $id_divisa      = filter_input(INPUT_GET, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $sucursal      = filter_input(INPUT_GET, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $estatus      = filter_input(INPUT_GET, 'estatus', FILTER_SANITIZE_NUMBER_INT);
            $agente_emplead      = filter_input(INPUT_GET, 'agente', FILTER_SANITIZE_NUMBER_INT);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            // if (empty($sucursal))
            //  $this->array_errors[] = 'Seleccione una sucursal.';

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {

                    if (!empty($id_divisa)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                    }

                    $artic_total        = 0;
                    $costo_total        = 0;
                    $venta_total        = 0;
                    $totales_productos  = [];

                    $productos =  $this->ingresosegresos_model->obtenerProductos();
                    $obtener_agente = new EmpleadoInfo();


                    if (is_countable($productos) && count($productos)) {

                        foreach ($productos as $pro) {

                            if (empty($id_divisa)) {
                                $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEVL($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, null, $estatus, $agente_emplead);
                                $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrdL($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, null, $estatus, $agente_emplead);
                                $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACVL($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, null, $estatus, $agente_emplead);
                            } else {

                                $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEVL($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa, $estatus, $agente_emplead);
                                $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrdL($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa, $estatus, $agente_emplead);
                                $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACVL($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa, $estatus, $agente_emplead);
                            }

                            if (is_countable($total_notas) && count($total_notas)) {

                                foreach ($total_notas as $row) {

                                    if ($row['agente'] != NULL) {
                                        $agente = $obtener_agente->empleadoInfo($row['agente']);
                                    }

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa) && $id_divisa > 0) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            //$row['costo'] = round(($row['costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    } else {

                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($row['costo'] * $row['cantidad']);
                                        $ga = ($ganancia * 100);
                                        $ganc = ($row['costo'] * $row['cantidad']);
                                        if ($ga > 0 && $ganc > 0) {
                                            $ganancia_porct =  $ga / $ganc;
                                        } else {
                                            $ganancia_porct = 0;
                                        }
                                    }

                                    $totales_productos[] = [
                                        'div_locale'        => $this->div_master['div_locale'],
                                        'div_simbolo'       => $this->div_master['div_simbolo'],
                                        'div_nombre'        => $this->div_master['div_nombre'],
                                        'pro_id'            => $pro['pro_id'],
                                        'pro_descripcion'   => $pro['pro_descripcion'],
                                        'pro_costo'         =>  $row['costo'],
                                        'cantidad'          => $row['cantidad'],
                                        'costo_total'       =>  $row['costo'] * $row['cantidad'],
                                        'total'             => $row['total'],
                                        'estatus'           => ($row['estatus'] == 1) ? 'Pagado' : 'Pendiente',
                                        'ganancia'          => $ganancia,
                                        'ganancia_porct'    => $ganancia_porct,
                                        'sucursal'          => $row['su_nombre'],
                                        'uri'               => 'notasdeentregaeditar/verFactura/' . $row['id'],
                                        'documento'         => 'NEV' . $row['correlativo'],
                                        'fecha'             => $row['fecha'],
                                        'empleado'          => $row['nombre'] . ' ' . $row['apellido'],
                                        'agente'            => ($row['agente'] != NULL) ? $agente['einfo_nombres'] . ' ' . $agente['einfo_apellidos'] : $row['agente'],
                                        'cliente'           => $row['cli_razon_social'],
                                        'cliente_id'        => $row['cli_id'],
                                        'grupo'             => $row['grup_nombre'],
                                        'grupo_id'           => $row['grup_codigo']
                                    ];


                                    $artic_total += $row['cantidad'];
                                    $costo_total +=  $row['costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }

                            if (is_countable($total_facv) && count($total_facv)) {

                                foreach ($total_facv as $row) {

                                    if ($row['agente'] != NULL) {
                                        $agente = $obtener_agente->empleadoInfo($row['agente']);
                                    }
                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa) && $id_divisa > 0) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            //$row['costo'] = round(($row['costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    } else {
                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($row['costo'] * $row['cantidad']);
                                        $ga = ($ganancia * 100);
                                        $ganc = ($row['costo'] * $row['cantidad']);
                                        if ($ga > 0 && $ganc > 0) {
                                            $ganancia_porct =  $ga / $ganc;
                                        } else {
                                            $ganancia_porct = 0;
                                        }
                                    }
                                    $totales_productos[] = [
                                        'div_locale'        => $this->div_master['div_locale'],
                                        'div_simbolo'       => $this->div_master['div_simbolo'],
                                        'div_nombre'        => $this->div_master['div_nombre'],
                                        'pro_id'            => $pro['pro_id'],
                                        'pro_descripcion'   => $pro['pro_descripcion'],
                                        'pro_costo'         =>  $row['costo'],
                                        'cantidad'          => $row['cantidad'],
                                        'costo_total'       =>  $row['costo'] * $row['cantidad'],
                                        'total'             => $row['total'],
                                        'estatus'           => ($row['estatus'] == 1) ? 'Pagado' : 'Pendiente',
                                        'ganancia'          => $ganancia,
                                        'ganancia_porct'    => $ganancia_porct,
                                        'sucursal'          => $row['su_nombre'],
                                        'uri'               => 'poseditar/verFactura/' . $row['id'],
                                        'documento'         => 'FACV' . $row['correlativo'],
                                        'fecha'             => $row['fecha'],
                                        'empleado'          => $row['nombre'] . ' ' . $row['apellido'],
                                        'agente'            => ($row['agente'] != NULL) ? $agente['einfo_nombres'] . ' ' . $agente['einfo_apellidos'] : $row['agente'],
                                        'cliente'           => $row['cli_razon_social'],
                                        'cliente_id'        => $row['cli_id'],
                                        'grupo'             => $row['grup_nombre'],
                                        'grupo_id'           => $row['grup_codigo']
                                    ];

                                    $artic_total += $row['cantidad'];
                                    $costo_total +=  $row['costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }

                            if (is_countable($total_ordenes) && count($total_ordenes)) {

                                foreach ($total_ordenes as $row) {

                                    if ($row['agente'] != NULL) {
                                        $agente = $obtener_agente->empleadoInfo($row['agente']);
                                    }

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa) && $id_divisa > 0) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            //$row['costo'] = round(($row['costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /*$this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $id_divisa);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    } else {
                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                            $row['costo'] = round(($row['costo'] * $factor['df_factor']), 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($row['costo'] * $row['cantidad']);
                                        $ga = ($ganancia * 100);
                                        $ganc = ($row['costo'] * $row['cantidad']);
                                        if ($ga > 0 && $ganc > 0) {
                                            $ganancia_porct =  $ga / $ganc;
                                        } else {
                                            $ganancia_porct = 0;
                                        }
                                    }
                                    $totales_productos[] = [
                                        'div_locale'        => $this->div_master['div_locale'],
                                        'div_simbolo'       => $this->div_master['div_simbolo'],
                                        'div_nombre'        => $this->div_master['div_nombre'],
                                        'pro_id'            => $pro['pro_id'],
                                        'pro_descripcion'   => $pro['pro_descripcion'],
                                        'pro_costo'         =>  $row['costo'],
                                        'cantidad'          => $row['cantidad'],
                                        'costo_total'       =>  $row['costo'] * $row['cantidad'],
                                        'total'             => $row['total'],
                                        'estatus'           => ($row['estatus'] == 1) ? 'Pagado' : 'Pendiente',
                                        'ganancia'          => $ganancia,
                                        'ganancia_porct'    => $ganancia_porct,
                                        'sucursal'          => $row['su_nombre'],
                                        'uri'               => 'ordendeentregaeditar/verFactura/' . $row['id'],
                                        'documento'         => 'ORDENV' . $row['correlativo'],
                                        'fecha'             => $row['fecha'],
                                        'empleado'          => $row['nombre'] . ' ' . $row['apellido'],
                                        'agente'            => ($row['agente'] != NULL) ? $agente['einfo_nombres'] . ' ' . $agente['einfo_apellidos'] : $row['agente'],
                                        'cliente'           => $row['cli_razon_social'],
                                        'cliente_id'        => $row['cli_id'],
                                        'grupo'             => $row['grup_nombre'],
                                        'grupo_id'           => $row['grup_codigo']
                                    ];


                                    $artic_total += $row['cantidad'];
                                    $costo_total +=  $row['costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }
                        }
                    }

                    $ganancia = 0;
                    $ganancia_porct = 0;

                    if ($venta_total > 0 && $costo_total > 0) {
                        $ganancia = $venta_total - $costo_total;
                        $ganancia_porct   = ($costo_total * 100) / $venta_total;
                    }

                    Http::json_response([
                        'venta_total'   => Moneda::moneda($venta_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'costo_total'   => Moneda::moneda($costo_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'artic_total'   => $artic_total,
                        'ganancia'      => Moneda::moneda($ganancia, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'ganancia_porc' => round($ganancia_porct),
                        'productos'     => $totales_productos,
                        'cantidad_articulos' =>  count($totales_productos)
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerServiciosVendidos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $id_divisa      = filter_input(INPUT_GET, 'divisa');
            $sucursal      = filter_input(INPUT_GET, 'sucursal');

            if (empty($sucursal))
                $this->array_errors[] = 'Seleccione una sucursal.';

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {

                    if (!empty($id_divisa)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                    }

                    $artic_total        = 0;
                    $costo_total        = 0;
                    $venta_total        = 0;
                    $totales_productos  = [];
                    $total_productos_id = [];

                    $productos =  $this->ingresosegresos_model->obtenerProductos();

                    if (is_countable($productos) && count($productos)) {

                        foreach ($productos as $pro) {

                            if (empty($id_divisa)) {
                                $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta);
                                $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrd($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta);
                                $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta);
                            } else {
                                $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa);
                                $total_ordenes = $this->ingresosegresos_model->obtenerArticulosDeOrd($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa);
                                $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACV($pro['pro_id'], $sucursal, $fecha_desde, $fecha_hasta, $id_divisa);
                            }

                            if (is_countable($total_notas) && count($total_notas)) {

                                foreach ($total_notas as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa)) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            $pro['pro_costo'] = round(($pro['pro_costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                        }
                                    } else {

                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($pro['pro_costo'] * $row['cantidad']);
                                        $ganancia_porct = ($ganancia * 100) / ($pro['pro_costo'] * $row['cantidad']);
                                    }

                                    if (!in_array($pro['pro_id'], $total_productos_id)) {
                                        $totales_productos[$pro['pro_id']] = [
                                            'div_locale'        => $this->div_master['div_locale'],
                                            'div_simbolo'       => $this->div_master['div_simbolo'],
                                            'div_nombre'        => $this->div_master['div_nombre'],
                                            'pro_id'            => $pro['pro_id'],
                                            'pro_descripcion'   => $pro['pro_descripcion'],
                                            'pro_costo'         => $pro['pro_costo'],
                                            'cantidad'          => $row['cantidad'],
                                            'costo_total'       => $pro['pro_costo'] * $row['cantidad'],
                                            'total'             => $row['total'],
                                            'ganancia'          => $ganancia,
                                            'ganancia_porct'    => $ganancia_porct,
                                        ];
                                        $total_productos_id[] = $pro['pro_id'];
                                    } else {
                                        $totales_productos[$pro['pro_id']]['costo_total']       += $pro['pro_costo'] * $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['cantidad']          += $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['pro_id']]['ganancia']          += $ganancia;
                                        $totales_productos[$pro['pro_id']]['ganancia_porct']    += $ganancia_porct;
                                    }

                                    $artic_total += $row['cantidad'];
                                    $costo_total += $pro['pro_costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }

                            if (is_countable($total_facv) && count($total_facv)) {

                                foreach ($total_facv as $row_dos) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa)) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            $pro['pro_costo'] = round(($pro['pro_costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row_dos['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row_dos['divisa'], $this->div_master['div_id']);
                                            $row_dos['total'] = round($row_dos['total'] * $factor['df_factor'], 2);
                                        }
                                    } else {
                                        if ($row_dos['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row_dos['divisa'], $this->div_master['div_id']);
                                            $row_dos['total'] = round($row_dos['total'] * $factor['df_factor'], 2);
                                        }
                                    }

                                    if ($row_dos['total'] > 1) {
                                        $ganancia = $row_dos['total'] - ($pro['pro_costo'] * $row_dos['cantidad']);
                                        $ganancia_porct   = ($ganancia * 100) / ($pro['pro_costo'] * $row_dos['cantidad']);
                                    }

                                    if (!in_array($pro['pro_id'], $total_productos_id)) {
                                        $totales_productos[$pro['pro_id']] = [
                                            'div_locale'        => $this->div_master['div_locale'],
                                            'div_simbolo'       => $this->div_master['div_simbolo'],
                                            'div_nombre'        => $this->div_master['div_nombre'],
                                            'pro_id'            => $pro['pro_id'],
                                            'pro_descripcion'   => $pro['pro_descripcion'],
                                            'pro_costo'         => $pro['pro_costo'],
                                            'cantidad'          => $row_dos['cantidad'],
                                            'costo_total'       => $pro['pro_costo'] * $row_dos['cantidad'],
                                            'total'             => $row_dos['total'],
                                            'ganancia'          => $ganancia,
                                            'ganancia_porct'    => $ganancia_porct,
                                        ];
                                        $total_productos_id[] = $pro['pro_id'];
                                    } else {
                                        $totales_productos[$pro['pro_id']]['costo_total']       += $pro['pro_costo'] * $row_dos['cantidad'];
                                        $totales_productos[$pro['pro_id']]['cantidad']          += $row_dos['cantidad'];
                                        $totales_productos[$pro['pro_id']]['total']             += $row_dos['total'];
                                        $totales_productos[$pro['pro_id']]['ganancia']          += $ganancia;
                                        $totales_productos[$pro['pro_id']]['ganancia_porct']    += $ganancia_porct;
                                    }

                                    $artic_total += $row_dos['cantidad'];
                                    $costo_total += $pro['pro_costo'] * $row_dos['cantidad'];
                                    $venta_total += $row_dos['total'];
                                }
                            }

                            if (is_countable($total_ordenes) && count($total_ordenes)) {

                                foreach ($total_ordenes as $row) {

                                    $ganancia = 0;
                                    $ganancia_porct = 0;

                                    if (!empty($id_divisa)) {

                                        if ($this->div_master['div_id'] != $id_divisa) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                            $pro['pro_costo'] = round(($pro['pro_costo'] * $div_factor['df_factor']), 2);
                                        }

                                        if ($row['divisa'] != $id_divisa /*$this->div_master['div_id']*/) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $id_divisa);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                        }
                                    } else {
                                        if ($row['divisa'] != $this->div_master['div_id']) {
                                            $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                            $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                        }
                                    }

                                    if ($row['total'] > 1) {
                                        $ganancia = $row['total'] - ($pro['pro_costo'] * $row['cantidad']);
                                        $ganancia_porct = ($ganancia * 100) / ($pro['pro_costo'] * $row['cantidad']);
                                    }

                                    if (!in_array($pro['pro_id'], $total_productos_id)) {
                                        $totales_productos[$pro['pro_id']] = [
                                            'div_locale'        => $this->div_master['div_locale'],
                                            'div_simbolo'       => $this->div_master['div_simbolo'],
                                            'div_nombre'        => $this->div_master['div_nombre'],
                                            'pro_id'            => $pro['pro_id'],
                                            'pro_descripcion'   => $pro['pro_descripcion'],
                                            'pro_costo'         => $pro['pro_costo'],
                                            'cantidad'          => $row['cantidad'],
                                            'costo_total'       => $pro['pro_costo'] * $row['cantidad'],
                                            'total'             => $row['total'],
                                            'ganancia'          => $ganancia,
                                            'ganancia_porct'    => $ganancia_porct,
                                        ];
                                        $total_productos_id[] = $pro['pro_id'];
                                    } else {
                                        $totales_productos[$pro['pro_id']]['costo_total']       += $pro['pro_costo'] * $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['cantidad']          += $row['cantidad'];
                                        $totales_productos[$pro['pro_id']]['total']             += $row['total'];
                                        $totales_productos[$pro['pro_id']]['ganancia']          += $ganancia;
                                        $totales_productos[$pro['pro_id']]['ganancia_porct']    += $ganancia_porct;
                                    }

                                    $artic_total += $row['cantidad'];
                                    $costo_total += $pro['pro_costo'] * $row['cantidad'];
                                    $venta_total += $row['total'];
                                }
                            }
                        }
                    }

                    $ganancia = 0;
                    $ganancia_porct = 0;

                    if ($venta_total > 0 && $costo_total > 0) {
                        $ganancia = $venta_total - $costo_total;
                        $ganancia_porct   = ($costo_total * 100) / $venta_total;
                    }

                    Http::json_response([
                        'venta_total'   => Moneda::moneda($venta_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'costo_total'   => Moneda::moneda($costo_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'artic_total'   => $artic_total,
                        'ganancia'      => Moneda::moneda($ganancia, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'ganancia_porc' => round($ganancia_porct),
                        'productos'     => $totales_productos
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }
    public function obtenerPrecioProductoVendidos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $id_divisa      = filter_input(INPUT_GET, 'divisa');
            $sucursal      = filter_input(INPUT_GET, 'sucursal');
            $filtro         = filter_input(INPUT_GET, 'filtro');

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {

                    if (!empty($id_divisa)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                    }

                    $totales_productos  = [];

                    $total_notas = $this->ingresosegresos_model->obtenerArticulosDeNEVPREC($fecha_desde, $fecha_hasta, $id_divisa, $sucursal);
                    $total_facv = $this->ingresosegresos_model->obtenerArticulosDeFACVPREC($fecha_desde, $fecha_hasta, $id_divisa, $sucursal);

                    if (is_countable($total_notas) && count($total_notas)) {
                        foreach ($total_notas as $row) {

                            $pro =  $this->ingresosegresos_model->obtenerProductosid($row['proid']);

                            $ganancia = 0;
                            $ganancia_porct = 0;

                            if ($this->div_master['div_id'] != $id_divisa && $id_divisa > 0) {
                                $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                $pro['pro_costo'] = round(($pro['pro_costo'] * $div_factor['df_factor']), 2);
                                $pro['pro_precio'] = round(($pro['pro_precio'] * $div_factor['df_factor']), 2);
                            }

                            if ($row['divisa'] != $id_divisa && $id_divisa > 0 /* $this->div_master['div_id']*/) {
                                $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                $row['precio'] = round(($row['precio'] * $div_factor['df_factor']), 2);
                            }

                            if ($row['divisa'] != $this->div_master['div_id'] && $id_divisa == 0 /* $this->div_master['div_id']*/) {
                                $factor = $this->ingresosegresos_model->divisaFactor($row['divisa'], $this->div_master['div_id']);
                                $row['total'] = round($row['total'] * $factor['df_factor'], 2);
                                $row['precio'] = round(($row['precio'] * $factor['df_factor']), 2);
                            }

                            $descuento = ($row['precio'] * $row['descuento']) / 100;

                            if ($filtro == 1 && ($row['descuento'] == 0 && ($row['precio'] > $pro['pro_precio']))) {
                                $totales_productos[] = [
                                    'div_locale'        => $this->div_master['div_locale'],
                                    'div_simbolo'       => $this->div_master['div_simbolo'],
                                    'div_nombre'        => $this->div_master['div_nombre'],
                                    'pro_id'            => $pro['pro_id'],
                                    'pro_descripcion'   => $pro['pro_descripcion'],
                                    'pro_costo'         => $pro['pro_costo'],
                                    'precio_venta'      => $pro['pro_precio'],
                                    'precio_factura'    => $row['precio'],
                                    'precio_desc'       => $descuento,
                                    'descuento'         => $row['descuento'],
                                    'cantidad'          => $row['cantidad'],
                                    'costo_total'       => $pro['pro_costo'] * $row['cantidad'],
                                    'total'             => $row['total'],
                                    'id'                => $row['id'],
                                    'tipo'              => 'NEV',
                                    'url'               => 'notasdeentregaeditar/verFactura/' . $row['id'],
                                    'ganancia'          => $ganancia,
                                    'ganancia_porct'    => $ganancia_porct,
                                ];
                            }
                            if ($filtro == 2 && (($row['descuento'] == 0 && ($row['precio'] < $pro['pro_precio'])) || ($row['descuento'] > 0 && ($descuento < $pro['pro_precio'])))) {
                                $totales_productos[] = [
                                    'div_locale'        => $this->div_master['div_locale'],
                                    'div_simbolo'       => $this->div_master['div_simbolo'],
                                    'div_nombre'        => $this->div_master['div_nombre'],
                                    'pro_id'            => $pro['pro_id'],
                                    'pro_descripcion'   => $pro['pro_descripcion'],
                                    'pro_costo'         => $pro['pro_costo'],
                                    'precio_venta'      => $pro['pro_precio'],
                                    'precio_factura'    => $row['precio'],
                                    'precio_desc'       => $descuento,
                                    'descuento'         => $row['descuento'],
                                    'cantidad'          => $row['cantidad'],
                                    'costo_total'       => $pro['pro_costo'] * $row['cantidad'],
                                    'total'             => $row['total'],
                                    'id'                => $row['id'],
                                    'tipo'              => 'NEV',
                                    'url'               => 'notasdeentregaeditar/verFactura/' . $row['id'],
                                    'ganancia'          => $ganancia,
                                    'ganancia_porct'    => $ganancia_porct,
                                ];
                            }
                        }
                    }

                    if (is_countable($total_facv) && count($total_facv)) {

                        foreach ($total_facv as $row_dos) {

                            $pro =  $this->ingresosegresos_model->obtenerProductosid($row_dos['proid']);

                            $ganancia = 0;
                            $ganancia_porct = 0;

                            if (!empty($id_divisa) && $id_divisa > 0) {

                                if ($this->div_master['div_id'] != $id_divisa) {
                                    $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                                    $pro['pro_costo'] = round(($pro['pro_costo'] * $div_factor['df_factor']), 2);
                                    $pro['pro_precio'] = round(($pro['pro_precio'] * $div_factor['df_factor']), 2);
                                }

                                if ($row_dos['divisa'] != $id_divisa /* $this->div_master['div_id']*/) {
                                    $factor = $this->ingresosegresos_model->divisaFactor($row_dos['divisa'], $this->div_master['div_id']);
                                    $row_dos['total'] = round($row_dos['total'] * $factor['df_factor'], 2);
                                    $row_dos['precio'] = round(($row_dos['precio'] * $div_factor['df_factor']), 2);
                                }
                            } else {
                                if ($row_dos['divisa'] != $this->div_master['div_id']) {
                                    $factor = $this->ingresosegresos_model->divisaFactor($row_dos['divisa'], $this->div_master['div_id']);
                                    $row_dos['total'] = round($row_dos['total'] * $factor['df_factor'], 2);
                                    $row_dos['precio'] = round(($row_dos['precio'] * $factor['df_factor']), 2);
                                }
                            }
                            $descuento = ($row_dos['precio'] * $row_dos['descuento']) / 100;

                            if ($filtro == 1 && ($row_dos['descuento'] == 0 && ($row_dos['precio'] > $pro['pro_precio']))) {
                                $totales_productos[] = [
                                    'div_locale'        => $this->div_master['div_locale'],
                                    'div_simbolo'       => $this->div_master['div_simbolo'],
                                    'div_nombre'        => $this->div_master['div_nombre'],
                                    'pro_id'            => $pro['pro_id'],
                                    'pro_descripcion'   => $pro['pro_descripcion'],
                                    'pro_costo'         => $pro['pro_costo'],
                                    'precio_venta'      => $pro['pro_precio'],
                                    'precio_factura'    => $row_dos['precio'],
                                    'precio_desc'       => $descuento,
                                    'descuento'         => $row_dos['descuento'],
                                    'cantidad'          => $row_dos['cantidad'],
                                    'costo_total'       => $pro['pro_costo'] * $row_dos['cantidad'],
                                    'total'             => $row_dos['total'],
                                    'id'                => $row_dos['id'],
                                    'tipo'              => 'FACV',
                                    'url'               => 'poseditar/verFactura/' . $row_dos['id'],
                                    'ganancia'          => $ganancia,
                                    'ganancia_porct'    => $ganancia_porct,
                                ];
                            }
                            if ($filtro == 2 && ($row_dos['descuento'] == 0 && ($row_dos['precio'] < $pro['pro_precio'])) || ($row_dos['descuento'] > 0 && ($descuento < $pro['pro_precio']))) {
                                $totales_productos[] = [
                                    'div_locale'        => $this->div_master['div_locale'],
                                    'div_simbolo'       => $this->div_master['div_simbolo'],
                                    'div_nombre'        => $this->div_master['div_nombre'],
                                    'pro_id'            => $pro['pro_id'],
                                    'pro_descripcion'   => $pro['pro_descripcion'],
                                    'pro_costo'         => $pro['pro_costo'],
                                    'precio_venta'      => $pro['pro_precio'],
                                    'precio_factura'    => $row_dos['precio'],
                                    'precio_desc'       => $descuento,
                                    'descuento'         => $row_dos['descuento'],
                                    'cantidad'          => $row_dos['cantidad'],
                                    'costo_total'       => $pro['pro_costo'] * $row_dos['cantidad'],
                                    'total'             => $row_dos['total'],
                                    'id'                => $row_dos['id'],
                                    'tipo'              => 'FACV',
                                    'url'               => 'poseditar/verFactura/' . $row_dos['id'],
                                    'ganancia'          => $ganancia,
                                    'ganancia_porct'    => $ganancia_porct,
                                ];
                            }
                        }
                    }



                    Http::json_response([
                        'productos'     => $totales_productos
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerMetodosSegunDivisa(int $id_divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id_divisa, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->ingresosegresos_model->obtenerMetodosSegunDivisa($id));
        }
    }

    public function obtenerMetodosSegunDivisaYCuentas(int $id_divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id_divisa, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response([
                'metodos' => $this->ingresosegresos_model->obtenerMetodosSegunDivisa($id),
                'cuentas' => $this->ingresosegresos_model->obtenerCuentasSegunDivisa($id)
            ]);
        }
    }

    public function obtenerCuentasSegunMetodo(int $id_metodo_divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id_metodo_divisa, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->ingresosegresos_model->obtenerCuentasSegunMetodo($id));
        }
    }

    public function obtenerCuentasIgualBS()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->ingresosegresos_model->obtenerCuentasIgualBS());
        }
    }

    public function obtenerCuentasIgualUsd()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->ingresosegresos_model->obtenerCuentasIgualUsd());
        }
    }

    public function obtenerSaldoSegunCuenta(int $id_cuenta)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id_cuenta, FILTER_SANITIZE_NUMBER_INT);
            $divisa_cuenta = $this->ingresosegresos_model->obtenerDivisaSegunCuenta($id);
            $cuenta_origen = $this->ingresosegresos_model->consultar("SELECT cmp_cueid, cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id = $id")->row();
            $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta_origen['cmp_cueid']}")->row();
            Http::json_response([
                'cuenta_destino' => $this->ingresosegresos_model->obtenerCuentasSegunMetodoDestino($cuenta_origen['cmp_cueid'], $cuenta_origen['cmp_mdid']),
                'divisa' => Moneda::obtenerDivisa($divisa_cuenta['div_id']),
                'saldo' => $saldo['bc_saldo'] ?? 0,
            ]);
        }
    }

    public function obtenerSaldoSegunCuentaTransferencia(int $id_cuenta)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id_cuenta, FILTER_SANITIZE_NUMBER_INT);
            $divisa_cuenta = $this->ingresosegresos_model->obtenerDivisaSegunCuenta($id);
            $cuenta_origen = $this->ingresosegresos_model->consultar("SELECT cmp_cueid, cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id = $id")->row();
            $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta_origen['cmp_cueid']}")->row();
            Http::json_response([
                'cuenta_destino' => $this->ingresosegresos_model->obtenerCuentasSegunMetodoDestinoTrans($cuenta_origen['cmp_cueid'], $divisa_cuenta['div_id']),
                'divisa' => Moneda::obtenerDivisa($divisa_cuenta['div_id']),
                'saldo' => $saldo['bc_saldo'] ?? 0,
            ]);
        }
    }

    public function pagarPositivo()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('ingresosegresos', 'registrar_ingresos', $_SESSION['user_data']['emp_id'])) {

                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
                $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
                $descripcion        = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
                $fecha              = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
                $categoria          = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);

                if (empty($id_divisa))
                    $this->array_errors[] = 'El campo Divisa es obligatorio.';
                if (empty($id_metodo_divisa))
                    $this->array_errors[] = 'El campo Metodo es obligatorio.';
                if (empty($id_cuenta_metodo))
                    $this->array_errors[] = 'El campo Cuenta es obligatorio.';
                if (empty($monto))
                    $this->array_errors[] = 'El campo Monto es obligatorio.';
                if (empty($categoria))
                    $this->array_errors[] = 'El campo Categoria es obligatorio.';
                if (empty($descripcion))
                    $this->array_errors[] = 'El campo Descripición es obligatorio.';
                if (!validateDate($fecha, 'Y-m-d')) {
                    $this->array_errors[] = 'El formato del campo fecha es incorrecto.';
                }

                if (empty($this->array_errors)) {

                    $factor = 1;
                    $cuenta = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta_metodo")->row();
                    $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                    $monto  = convertir_a_float($monto);
                    $total  = $saldo['bc_saldo'] + $monto;
                    $tcm = $cuenta['cmp_saldo'] + $monto;

                    if ($monto <= 0)
                        $this->array_errors[] = 'EL monto debe ser mayor que cero.';

                    if ($this->div_master['div_id'] != $divisa['div_id']) {
                        $data_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                        if (!$data_factor) {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa' . $divisa['div_nombre'] . ' y la divisa predeterminada ' . $this->div_master['div_nombre'];
                        } else {
                            $factor = $data_factor['df_factor'];
                        }
                    }

                    $conversion = round($monto / $factor, 2);

                    if (empty($this->array_errors)) {

                        $movimiento = new MovimientoModel();

                        try {

                            $movimiento->transactionBegin();

                            $movimiento->guardar([
                                'fab_divisa'            => $id_divisa,
                                'fab_metodo'            => $id_metodo_divisa,
                                'fab_cmpid'             => $id_cuenta_metodo,
                                'fab_monto'             => $monto,
                                'fab_factor'            => $factor,
                                'fab_conversion'        => $conversion,
                                'fab_divid_conversion'  => $this->div_master['div_id'],
                                'fab_factor_master'     => $factor,
                                'fab_empid'                => $_SESSION['user_data']['emp_id'],
                                'fab_modulo'            => 'ingreso',
                                'fab_descripcion'       => $descripcion,
                                'fab_observacion'       => 'Ingreso por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo INGRESO.',
                                'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                                'fab_categoria'         => $categoria,
                                'fab_saldo_anterior'    => $saldo['bc_saldo']
                            ]);

                            $movimiento->pagarCuenta($cuenta['cmp_cueid'], $total);
                            $movimiento->pagarCuentaMetodo($id_cuenta_metodo, $tcm);

                            $movimiento->transactionCommit();
                        } catch (\Throwable $th) {
                            $movimiento->transactionRollBack();
                            $this->array_errors[] = 'Error en transacción';
                        }

                        if (empty($this->array_errors)) {
                            Http::json_response($total);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para registrar ingresos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagarNegativo()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('ingresosegresos', 'registrar_egresos', $_SESSION['user_data']['emp_id'])) {

                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
                $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
                $descripcion        = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
                $fecha              = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
                $categoria          = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);

                if (empty($id_divisa))
                    $this->array_errors[] = 'El campo Divisa es obligatorio.';
                if (empty($id_metodo_divisa))
                    $this->array_errors[] = 'El campo Metodo es obligatorio.';
                if (empty($id_cuenta_metodo))
                    $this->array_errors[] = 'El campo Cuenta es obligatorio.';
                if (empty($monto))
                    $this->array_errors[] = 'El campo Monto es obligatorio.';
                if (empty($descripcion))
                    $this->array_errors[] = 'El campo Descrpición es obligatorio.';
                if (empty($categoria))
                    $this->array_errors[] = 'El campo Categoria es obligatorio.';
                if (!validateDate($fecha, 'Y-m-d')) {
                    $this->array_errors[] = 'El formato del campo fecha es incorrecto.';
                }

                if (empty($this->array_errors)) {

                    $monto  = convertir_a_float($monto);

                    if ($monto <= 0)
                        $this->array_errors[] = 'EL monto debe ser mayor que cero.';

                    $factor = 1;
                    $cuenta = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta_metodo")->row();
                    $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                    $total  = $saldo['bc_saldo'] - $monto;
                    $tcm = $cuenta['cmp_saldo'] - $monto;

                    if ($monto > round($saldo['bc_saldo'], 2))
                        $this->array_errors[] = 'Saldo insuficiente.';

                    if ($this->div_master['div_id'] != $divisa['div_id']) {
                        $data_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                        if (!$data_factor) {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa' . $divisa['div_nombre'] . ' y la divisa predeterminada ' . $this->div_master['div_nombre'];
                        } else {
                            $factor = $data_factor['df_factor'];
                        }
                    }

                    $conversion = round($monto / $factor, 2);

                    if (empty($this->array_errors)) {

                        $movimiento = new MovimientoModel();

                        try {

                            $movimiento->transactionBegin();

                            $movimiento->guardar([
                                'fab_divisa'            => $id_divisa,
                                'fab_metodo'            => $id_metodo_divisa,
                                'fab_cmpid'             => $id_cuenta_metodo,
                                'fab_monto'             => $monto * -1,
                                'fab_factor'            => $factor,
                                'fab_conversion'        => $conversion * -1,
                                'fab_divid_conversion'  => $this->div_master['div_id'],
                                'fab_factor_master'     => $factor,
                                'fab_retiro'            => 1,
                                'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                'fab_modulo'            => 'egreso',
                                'fab_descripcion'       => $descripcion,
                                'fab_observacion'       => 'Egreso por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo EGRESO.',
                                'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                                'fab_categoria'         => $categoria,
                                'fab_saldo_anterior'    => $saldo['bc_saldo']
                            ]);

                            $movimiento->pagarCuenta($cuenta['cmp_cueid'], $total);
                            $movimiento->pagarCuentaMetodo($id_cuenta_metodo, $tcm);

                            $movimiento->transactionCommit();
                        } catch (\Throwable $th) {
                            $movimiento->transactionRollBack();
                            $this->array_errors[] = 'Error en transacción';
                        }

                        if (empty($this->array_errors)) {
                            Http::json_response($total);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para registrar egresos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function transferirEntreCuentas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('ingresosegresos', 'registrar_transferencias', $_SESSION['user_data']['emp_id'])) {

                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta_metodo_destino = filter_input(INPUT_POST, 'id_cuenta_metodo_destino', FILTER_SANITIZE_NUMBER_INT);
                $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
                $descripcion        = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
                $fecha              = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
                $categoria          = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);

                if (empty($id_divisa))
                    $this->array_errors[] = 'El campo Divisa es obligatorio.';
                if (empty($id_metodo_divisa))
                    $this->array_errors[] = 'El campo Metodo es obligatorio.';
                if (empty($id_cuenta_metodo))
                    $this->array_errors[] = 'El campo Cuenta es obligatorio.';
                if (empty($id_cuenta_metodo_destino))
                    $this->array_errors[] = 'El campo Cuenta destino es obligatorio.';
                if (empty($monto))
                    $this->array_errors[] = 'El campo Monto es obligatorio.';
                if (empty($descripcion))
                    $this->array_errors[] = 'El campo Descrpición es obligatorio.';
                if (empty($categoria))
                    $this->array_errors[] = 'El campo Categoria es obligatorio.';
                if (!validateDate($fecha, 'Y-m-d')) {
                    $this->array_errors[] = 'El formato del campo fecha es incorrecto.';
                }

                if (empty($this->array_errors)) {

                    $monto = convertir_a_float($monto);

                    if ($monto <= 0)
                        $this->array_errors[] = 'EL monto debe ser mayor que cero.';

                    $factor = 1;
                    $cuenta = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta_metodo")->row();
                    $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                    $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                    $total = $saldo['bc_saldo'] - $monto;
                    $tcm = $cuenta['cmp_saldo'] - $monto;

                    $cuenta_destino = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta_metodo_destino")->row();
                    $saldo_destino = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta_destino['cmp_cueid']}")->row();
                    $total_destino = $saldo_destino['bc_saldo'] + $monto;
                    $tcm_destino = $cuenta_destino['cmp_saldo'] + $monto;
                    $permiso_cuenta = $this->ingresosegresos_model->consultar("SELECT * FROM app_empleados_cuentas WHERE ec_empid = {$_SESSION['user_data']['emp_id']} AND ec_bcid={$cuenta_destino['cmp_cueid']}")->row();

                    $verificar_disponibilidad = $this->ingresosegresos_model->consultar("SELECT * FROM app_movimientos WHERE fab_retiro = 4 AND fab_cmpid= $id_cuenta_metodo")->all();
                    $disponibilidad = 0;
                    $monto_disponible = round($saldo['bc_saldo'], 2);
                    if (is_countable($verificar_disponibilidad) && count($verificar_disponibilidad)) {
                        foreach ($verificar_disponibilidad as $row) {
                            $disponibilidad += convertir_a_float($row['fab_monto']);
                        }
                    }
                    $monto_disponible = ($disponibilidad > 0) ? $monto_disponible - $disponibilidad : round($saldo['bc_saldo'], 2);

                    if($monto_disponible>0){
                        if ($monto >  $monto_disponible){
                            $this->array_errors[] = 'Lo siento pero no ha disponibilidad, hay transferencias en espera de la cuenta origen.';
                        }
                    }else{
                        if ($monto >  $monto_disponible){
                            $this->array_errors[] = 'Saldo insuficiente.';
                        }
                    }
                   // Http::json_response($monto_disponible);

                    if ($this->div_master['div_id'] != $divisa['div_id']) {
                        $data_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $id_divisa);
                        if (!$data_factor) {
                            $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa' . $divisa['div_nombre'] . ' y la divisa predeterminada ' . $this->div_master['div_nombre'];
                        } else {
                            $factor = $data_factor['df_factor'];
                        }
                    }

                    $conversion = round($monto / $factor, 2);

                     if (empty($this->array_errors)) {

                        $movimiento = new MovimientoModel();

                        try {

                            $movimiento->transactionBegin();

                            if ($permiso_cuenta) {

                                $movimiento->guardar([
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo_divisa,
                                    'fab_cmpid'             => $id_cuenta_metodo,
                                    'fab_monto'             => $monto * -1,
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $conversion * -1,
                                    'fab_divid_conversion'  => $this->div_master['div_id'],
                                    'fab_factor_master'     => $factor,
                                    'fab_retiro'            => 1,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'transferencia',
                                    'fab_descripcion'       => $descripcion,
                                    'fab_observacion'       => 'Egreso por transferencia por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo TRANSFERENCIA. a la cuenta destino ' . $saldo_destino['bc_alias'],
                                    'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                                    'fab_categoria'         => $categoria,
                                    'fab_saldo_anterior'    => $saldo['bc_saldo']
                                ]);

                                $movimiento->pagarCuenta($cuenta['cmp_cueid'], $total);
                                $movimiento->pagarCuentaMetodo($id_cuenta_metodo, $tcm);

                                $movimiento->guardar([
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo_divisa,
                                    'fab_cmpid'             => $id_cuenta_metodo_destino,
                                    'fab_monto'             => $monto,
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $conversion,
                                    'fab_divid_conversion'  => $this->div_master['div_id'],
                                    'fab_factor_master'     => $factor,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'transferencia',
                                    'fab_descripcion'       => $descripcion,
                                    'fab_observacion'       => 'Ingreso por transferencia por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo TRANSFERECIA. desde la cuenta origen ' . $saldo['bc_alias'],
                                    'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                                    'fab_categoria'         => $categoria,
                                    'fab_saldo_anterior'    => $saldo_destino['bc_saldo']
                                ]);

                                $movimiento->pagarCuenta($cuenta_destino['cmp_cueid'], $total_destino);
                                $movimiento->pagarCuentaMetodo($id_cuenta_metodo_destino, $tcm_destino);
                            } else {
                                $movimiento->guardar([
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo_divisa,
                                    'fab_cmpid'             => $id_cuenta_metodo,
                                    'fab_monto'             => $monto * -1,
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $conversion * -1,
                                    'fab_divid_conversion'  => $this->div_master['div_id'],
                                    'fab_factor_master'     => $factor,
                                    'fab_idretiro'          => $id_cuenta_metodo_destino,
                                    'fab_retiro'            => 4,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'transferencia',
                                    'fab_descripcion'       => $descripcion,
                                    'fab_observacion'       => 'Egreso por transferencia por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo TRANSFERENCIA. a la cuenta destino ' . $saldo_destino['bc_alias'],
                                    'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                                    'fab_categoria'         => $categoria,
                                    'fab_saldo_anterior'    => $saldo['bc_saldo']
                                ]);
                            }

                            $movimiento->transactionCommit();
                        } catch (\Throwable $th) {
                            $movimiento->transactionRollBack();
                            $this->array_errors[] = 'Error en transacción';
                        }

                        if (empty($this->array_errors)) {
                            Http::json_response(true);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para registrar egresos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function Validar_transferencia($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $movimiento = $this->ingresosegresos_model->consultar("SELECT * 
                FROM app_movimientos m
                JOIN app_empleados e ON e.emp_id = m.fab_empid
                JOIN app_cuentas_metodopago cm ON cm.cmp_id = m.fab_cmpid 
                JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid 
                JOIN app_bancos b ON b.ban_id = bc.bc_banid 
                LEFT JOIN app_sucursales s ON s.su_id=m.fab_sucursal 
                LEFT JOIN app_categorias_ingreso_egreso cie ON cie.cie_id = m.fab_categoria
                WHERE m.fab_id = $id")->row();

            $monto = convertir_a_float($movimiento['fab_monto']);

            $factor = 1;
            $cuenta = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = {$movimiento['fab_cmpid']}")->row();
            $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
            $divisa = $this->ingresosegresos_model->obtenerDivisa($movimiento['fab_divisa']);
            $total = $saldo['bc_saldo'] - $monto;
            $tcm = $cuenta['cmp_saldo'] - $monto;

            $cuenta_destino = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = {$movimiento['fab_idretiro']}")->row();
            $saldo_destino = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta_destino['cmp_cueid']}")->row();
            $total_destino = $saldo_destino['bc_saldo'] + $monto;
            $tcm_destino = $cuenta_destino['cmp_saldo'] + $monto;
            $permiso_cuenta = $this->ingresosegresos_model->consultar("SELECT * FROM app_empleados_cuentas WHERE ec_empid = {$_SESSION['user_data']['emp_id']} AND ec_bcid={$cuenta_destino['cmp_cueid']}")->row();


            if ($this->div_master['div_id'] != $divisa['div_id']) {
                $data_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $movimiento['fab_divisa']);
                if (!$data_factor) {
                    $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa' . $divisa['div_nombre'] . ' y la divisa predeterminada ' . $this->div_master['div_nombre'];
                } else {
                    $factor = $data_factor['df_factor'];
                }
            }

            $conversion = round($monto / $factor, 2);

            $movimientot = new MovimientoModel();

            try {

                $movimientot->transactionBegin();

                if ($permiso_cuenta) {

                    $movimientot->pagarCuenta($cuenta['cmp_cueid'], $total);
                    $movimientot->pagarCuentaMetodo($movimiento['fab_cmpid'], $tcm);

                    $movimientot->guardar([
                        'fab_divisa'            => $movimiento['fab_divisa'],
                        'fab_metodo'            => $movimiento['fab_metodo'],
                        'fab_cmpid'             => $movimiento['fab_idretiro'],
                        'fab_monto'             => $monto,
                        'fab_factor'            => $factor,
                        'fab_conversion'        => $conversion,
                        'fab_divid_conversion'  => $this->div_master['div_id'],
                        'fab_factor_master'     => $factor,
                        'fab_empid'             => $_SESSION['user_data']['emp_id'],
                        'fab_modulo'            => 'transferencia',
                        'fab_descripcion'       => $movimiento['fab_descripcion'],
                        'fab_observacion'       => 'Ingreso por transferencia por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo TRANSFERECIA. desde la cuenta origen ' . $saldo['bc_alias'],
                        'fab_fecha'             => $movimiento['fab_fecha'],
                        'fab_categoria'         => $movimiento['fab_categoria'],
                        'fab_saldo_anterior'    => $saldo_destino['bc_saldo']
                    ]);

                    $movimientot->pagarCuenta($cuenta_destino['cmp_cueid'], $total_destino);
                    $movimientot->pagarCuentaMetodo($movimiento['fab_idretiro'], $tcm_destino);
                    $movimientot->consultar("UPDATE app_movimientos SET fab_idretiro = NULL,fab_retiro=1 WHERE fab_id = $id")->run();
                } else {
                    $this->array_errors[] = 'No tiene permiso para procesar esta transferencia, a la cuenta destino.';
                }

                $movimientot->transactionCommit();
            } catch (\Throwable $th) {
                $movimientot->transactionRollBack();
                $this->array_errors[] = 'Error en transacción';
            }

            if (empty($this->array_errors)) {
                Http::json_response(true);
            } else {
                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function eliminar_transferenciaEnEspera($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            $movimientot = new MovimientoModel();
            $movimiento = $this->ingresosegresos_model->consultar("SELECT * FROM app_movimientos WHERE fab_id = $id")->row();

            if ($movimientot->existe('fab_id', $id)) {
                Http::json_response($movimientot->eliminar($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerBalanceDelMes()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');
            $fecha_hasta = date('Y-m-d');
            $total_credito = 0;
            $disponible = 0;
            $array_balances = [];
            $array_balances_creditos = [];
            $balances = $this->ingresosegresos_model->obtenerBalanceDelMes($fecha_desde, $fecha_hasta, 3);
            $balances_creditos = $this->ingresosegresos_model->obtenerBalanceDelMesCredito($fecha_desde, $fecha_hasta, 3);

            if (is_countable($balances) && count($balances)) {
                foreach ($balances as $row) {
                    $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                    $disponible += $monto;
                    $array_balances[] = [
                        'fecha'         => $row['fecha'],
                        'empleado'      => $row['emp_username'],
                        'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                        'cuenta'        => $row['bc_alias'],
                        'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'divisa'        => $this->div_master['div_nombre'],
                        'categoria'     => $row['cie_descripcion'],
                        'sucursal'     => $row['su_nombre']
                    ];
                }
            }

            if (is_countable($balances_creditos) && count($balances_creditos)) {
                foreach ($balances_creditos as $row) {
                    $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                    $total_credito += $monto;
                    $array_balances_creditos[] = [
                        'fecha'         => $row['fecha'],
                        'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                        'divisa'        => $this->div_master['div_nombre'],
                        'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                    ];
                }
            }

            Http::json_response([
                'balance'   => $array_balances,
                'total'     => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                'balance_creditos' => $array_balances_creditos,
                'total_credito' => Moneda::moneda($total_credito, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
            ]);
        }
    }

    public function obtenerBalanceDelMesPorDocumento()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');
            $fecha_hasta = date('Y-m-d');
            $total_credito = 0;
            $disponible = 0;
            $array_balances = [];
            $array_balances_creditos = [];
            $balances = $this->ingresosegresos_model->obtenerBalanceDelMes($fecha_desde, $fecha_hasta, 3);
            $balances_creditos = $this->ingresosegresos_model->obtenerBalanceDelMesCredito($fecha_desde, $fecha_hasta, 3);

            if (is_countable($balances) && count($balances)) {
                foreach ($balances as $row) {
                    $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                    $disponible += $monto;

                    $divisabs = $this->ingresosegresos_model->obtenerDivisa($row['fab_divid_conversion']);

                    if ($row['fab_doc'] == 1) {
                        $factura = $this->ingresosegresos_model->consultar("SELECT * 
                        FROM app_notas_de_entrega n  
                        LEFT JOIN app_clientes c ON c.cli_id=n.ne_cliid 
                        WHERE ne_id={$row['fab_idgenerico']}")->row();

                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre'],
                            'cliente'       => $factura['cli_razon_social'],
                            'tasa'          => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                            'correlativo' => 'NEV' . $factura['ne_correlativo'],
                            'url' => 'notasdeentregaeditar/verFactura/' . $factura['ne_id']
                        ];
                    } elseif ($row['fab_doc'] == 2) {
                        $factura = $this->ingresosegresos_model->consultar("SELECT * 
                        FROM app_factura_master fm 
                        LEFT JOIN app_clientes c ON c.cli_id=fm.fm_cliid 
                        WHERE fm_id={$row['fab_idgenerico']}")->row();

                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre'],
                            'cliente'       => $factura['cli_razon_social'],
                            'tasa'          => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                            'correlativo' => 'FACV' . $factura['fm_correlativo'],
                            'url' => 'poseditar/verFactura/' . $factura['fm_id']
                        ];
                    } elseif ($row['fab_doc'] == 8) {
                        $factura = $this->ingresosegresos_model->consultar("SELECT * 
                        FROM app_compras cn 
                        LEFT JOIN app_clientes c ON c.cli_id=cn.cmp_cliid 
                        WHERE cmp_id={$row['fab_idgenerico']}")->row();
                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'      => $row['su_nombre'],
                            'cliente'       => $factura['cli_razon_social'],
                            'tasa'           => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                            'correlativo' => 'FACC' . $factura['cmp_correlativo'],
                            'url' => 'cmpfacturaeditar/verFactura/' . $factura['cmp_id']
                        ];
                    } elseif ($row['fab_doc'] == 9) {
                        $factura = $this->ingresosegresos_model->consultar("SELECT * 
                        FROM app_compras_notas nc  
                        LEFT JOIN app_clientes c ON c.cli_id=nc.cmpn_cliid 
                        WHERE cmpn_id={$row['fab_idgenerico']}")->row();
                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre'],
                            'cliente'       => $factura['cli_razon_social'],
                            'tasa'           => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                            'correlativo' => 'NEC' . $factura['cmpn_correlativo'],
                            'url' => 'cmpnotaseditar/verFactura/' . $factura['cmpn_id']
                        ];
                    } elseif ($row['fab_doc'] == 12) {
                        $factura = $this->ingresosegresos_model->consultar("SELECT * 
                        FROM app_orden_de_entrega n 
                        LEFT JOIN app_clientes c ON c.cli_id=n.n_cliid 
                        WHERE n_id={$row['fab_idgenerico']}")->row();

                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre'],
                            'cliente'       => $factura['cli_razon_social'],
                            'tasa'          => $row['fab_factor'],
                            'correlativo' => 'ORDENV' . $factura['n_correlativo'],
                            'url' => 'ordendeentregaeditar/verFactura/' . $factura['n_id']
                        ];
                    } elseif ($row['fab_doc'] == 13) {
                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre'],
                            'cliente'     => '',
                            'tasa' => '',
                            'correlativo' => 'Comision',
                            'url' => ''
                        ];
                    } else {
                        $array_balances[] = [
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre'],
                            'cliente'       => '',
                            'tasa'          => $row['fab_factor'],
                            'correlativo' => '',
                            'url' => ''
                        ];
                    }
                }
            }

            if (is_countable($balances_creditos) && count($balances_creditos)) {
                foreach ($balances_creditos as $row) {
                    $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                    $total_credito += $monto;
                    $array_balances_creditos[] = [
                        'fecha'         => $row['fecha'],
                        'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                        'divisa'        => $this->div_master['div_nombre'],
                        'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                    ];
                }
            }

            Http::json_response([
                'balance'   => $array_balances,
                'total'     => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                'balance_creditos' => $array_balances_creditos,
                'total_credito' => Moneda::moneda($total_credito, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
            ]);
        }
    }

    public function buscarBalance()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
            $fecha_desde        = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta        = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
            $categoria          = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');
            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d')) {
                    $this->array_errors[] = 'El formato del campo fecha desde es incorrecto.';
                }

                if (empty($this->array_errors)) {

                    if (empty($tipo)) {
                        $tipo = 3;
                    } else {
                        if ($tipo == 1) {
                            $tipo = 0;
                        } elseif ($tipo == 2) {
                            $tipo = 1;
                        } else {
                            $tipo = 3;
                        }
                    }

                    $balances = [];
                    $disponible = 0;
                    $array_balances = [];
                    $total_credito = 0;
                    $array_balances_creditos = [];
                    $balances_creditos = $this->ingresosegresos_model->obtenerBalanceDelMesCreditoDivisa($fecha_desde, $fecha_hasta, $tipo, $id_divisa);

                    if (!empty($fecha_desde) && empty($id_divisa) && empty($id_metodo_divisa) && empty($id_cuenta_metodo)) {
                        $balances = $this->ingresosegresos_model->obtenerBalanceDelMes($fecha_desde, $fecha_hasta, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && empty($id_metodo_divisa) && empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalancePorDivisa($fecha_desde, $fecha_hasta, $id_divisa, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && !empty($id_metodo_divisa) && empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalancePorDivisaYTipodeMetodo($fecha_desde, $fecha_hasta, $id_divisa, $id_metodo_divisa, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && !empty($id_metodo_divisa) && !empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalancePorCuenta($fecha_desde, $fecha_hasta, $id_cuenta_metodo, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && !empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalanceSoloPorCuenta($fecha_desde, $fecha_hasta, $id_cuenta_metodo, $tipo, $categoria);
                    }

                    if (is_countable($balances_creditos) && count($balances_creditos)) {
                        foreach ($balances_creditos as $row) {
                            $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                            $total_credito += $monto;
                            $array_balances_creditos[] = [
                                'fecha'         => $row['fecha'],
                                'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                'divisa'        => $this->div_master['div_nombre'],
                                'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            ];
                        }
                    }

                    if (is_countable($balances) && count($balances)) {
                        foreach ($balances as $row) {
                            $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                            $disponible += $monto;
                            $array_balances[] = [
                                'fecha'         => $row['fecha'],
                                'empleado'      => $row['emp_username'],
                                'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                'cuenta'        => $row['bc_alias'],
                                'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                'divisa'        => $this->div_master['div_nombre'],
                                'categoria'     => $row['cie_descripcion']
                            ];
                        }
                    }

                    Http::json_response([
                        'balance'   => $array_balances,
                        'total'     => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'balance_creditos' => $array_balances_creditos,
                        'total_credito' => Moneda::moneda($total_credito, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                    ]);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function buscarBalanceGrafica()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio        = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
            $mes        = filter_input(INPUT_POST, 'mes', FILTER_SANITIZE_NUMBER_INT);
            $tipo        = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
            $sucursal        = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $divis        = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);

            $balances = [];
            $array_balances = [];
            $array_balances_creditos = [];
            $array_notas_id = [];
            $balances_creditos = $this->ingresosegresos_model->obtenerBalanceDelMesCreditoGrafica($anio);

            $balances = $this->ingresosegresos_model->obtenerBalanceDelMesGrafica($anio, $mes, $tipo, $sucursal, $divis);

            if ($divis > 0) {
                $divisa = $this->ingresosegresos_model->obtenerDivisa($divis);
            } else {
                $divisa = $this->ingresosegresos_model->obtenerDivisa($this->div_master['div_id']);
            }

            if (is_countable($balances) && count($balances)) {
                foreach ($balances as $row) {

                    if ($tipo == 0) {
                        $monto = ($divisa['div_id'] != $row['fab_divisa'] && $divis == 0) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                    } else {
                        $monto = ($divisa['div_id'] != $row['fab_divisa'] && $divis == 0) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                        $monto = $monto * (-1);
                    }
                    if (!in_array($row['fab_categoria'], $array_notas_id)) {

                        $array_balances[$row['fab_categoria']] = [
                            'id'           => $row['fab_categoria'],
                            'categoria'     => $row['cie_descripcion'],
                            'monto'  => $monto
                        ];
                        $array_notas_id[] = $row['fab_categoria'];
                    } else {
                        $array_balances[$row['fab_categoria']]['monto']      += $monto;
                    }
                }
            }

            Http::json_response([
                'balance'   => $array_balances,
                'balance_creditos' => $array_balances_creditos,
                'div_locale'    => $divisa['div_locale'],
                'div_simbolo'  => $divisa['div_simbolo'],
            ]);

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function buscarBalanceDocumento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
            $fecha_desde        = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta        = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
            $categoria          = filter_input(INPUT_POST, 'categoria', FILTER_SANITIZE_NUMBER_INT);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');
            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d')) {
                    $this->array_errors[] = 'El formato del campo fecha desde es incorrecto.';
                }

                if (empty($this->array_errors)) {

                    if (empty($tipo)) {
                        $tipo = 3;
                    } else {
                        if ($tipo == 1) {
                            $tipo = 0;
                        } elseif ($tipo == 2) {
                            $tipo = 1;
                        } else {
                            $tipo = 3;
                        }
                    }

                    $balances = [];
                    $disponible = 0;
                    $array_balances = [];
                    $total_credito = 0;
                    $array_balances_creditos = [];
                    $balances_creditos = $this->ingresosegresos_model->obtenerBalanceDelMesCreditoDivisa($fecha_desde, $fecha_hasta, $tipo, $id_divisa);

                    if (!empty($fecha_desde) && empty($id_divisa) && empty($id_metodo_divisa) && empty($id_cuenta_metodo)) {
                        $balances = $this->ingresosegresos_model->obtenerBalanceDelMes($fecha_desde, $fecha_hasta, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && empty($id_metodo_divisa) && empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalancePorDivisa($fecha_desde, $fecha_hasta, $id_divisa, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && !empty($id_metodo_divisa) && empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalancePorDivisaYTipodeMetodo($fecha_desde, $fecha_hasta, $id_divisa, $id_metodo_divisa, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && !empty($id_metodo_divisa) && !empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalancePorCuenta($fecha_desde, $fecha_hasta, $id_cuenta_metodo, $tipo, $categoria);
                    } elseif (!empty($fecha_desde) && !empty($id_divisa) && !empty($id_cuenta_metodo)) {
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($id_divisa);
                        $this->div_master['div_id'] = $id_divisa;
                        $this->div_master['div_locale'] = $divisa['div_locale'];
                        $this->div_master['div_simbolo'] = $divisa['div_simbolo'];
                        $this->div_master['div_nombre'] = $divisa['div_nombre'];
                        $balances = $this->ingresosegresos_model->obtenerBalanceSoloPorCuenta($fecha_desde, $fecha_hasta, $id_cuenta_metodo, $tipo, $categoria);
                    }

                    if (is_countable($balances_creditos) && count($balances_creditos)) {
                        foreach ($balances_creditos as $row) {
                            $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                            $total_credito += $monto;
                            $array_balances_creditos[] = [
                                'fecha'         => $row['fecha'],
                                'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                'divisa'        => $this->div_master['div_nombre'],
                                'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            ];
                        }
                    }

                    if (is_countable($balances) && count($balances)) {
                        foreach ($balances as $row) {
                            $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                            $disponible += $monto;

                            $divisabs = $this->ingresosegresos_model->obtenerDivisa($row['fab_divid_conversion']);

                            if ($row['fab_doc'] == 1) {
                                $factura = $this->ingresosegresos_model->consultar("SELECT * 
                                FROM app_notas_de_entrega n  
                                LEFT JOIN app_clientes c ON c.cli_id=n.ne_cliid 
                                WHERE ne_id={$row['fab_idgenerico']}")->row();

                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'     => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'       => $factura['cli_razon_social'],
                                    'tasa'          => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                                    'correlativo' => 'NEV' . $factura['ne_correlativo'],
                                    'url' => 'notasdeentregaeditar/verFactura/' . $factura['ne_id']
                                ];
                            } elseif ($row['fab_doc'] == 2) {
                                $factura = $this->ingresosegresos_model->consultar("SELECT * 
                                FROM app_factura_master fm 
                                LEFT JOIN app_clientes c ON c.cli_id=fm.fm_cliid 
                                WHERE fm_id={$row['fab_idgenerico']}")->row();

                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'     => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'       => $factura['cli_razon_social'],
                                    'tasa'          => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                                    'correlativo' => 'FACV' . $factura['fm_correlativo'],
                                    'url' => 'poseditar/verFactura/' . $factura['fm_id']
                                ];
                            } elseif ($row['fab_doc'] == 8) {
                                $factura = $this->ingresosegresos_model->consultar("SELECT * 
                                FROM app_compras cn 
                                LEFT JOIN app_clientes c ON c.cli_id=cn.cmp_cliid 
                                WHERE cmp_id={$row['fab_idgenerico']}")->row();
                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'      => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'       => $factura['cli_razon_social'],
                                    'tasa'           => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                                    'correlativo' => 'FACC' . $factura['cmp_correlativo'],
                                    'url' => 'cmpfacturaeditar/verFactura/' . $factura['cmp_id']
                                ];
                            } elseif ($row['fab_doc'] == 9) {
                                $factura = $this->ingresosegresos_model->consultar("SELECT * 
                                FROM app_compras_notas nc  
                                LEFT JOIN app_clientes c ON c.cli_id=nc.cmpn_cliid 
                                WHERE cmpn_id={$row['fab_idgenerico']}")->row();
                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'     => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'       => $factura['cli_razon_social'],
                                    'tasa'           => ($row['fab_factor'] != 1 ?  Moneda::moneda($row['fab_factor'], $divisabs['div_locale'], $divisabs['div_simbolo']) : $row['fab_factor']),
                                    'correlativo' => 'NEC' . $factura['cmpn_correlativo'],
                                    'url' => 'cmpnotaseditar/verFactura/' . $factura['cmpn_id']
                                ];
                            } elseif ($row['fab_doc'] == 12) {
                                $factura = $this->ingresosegresos_model->consultar("SELECT * 
                                FROM app_orden_de_entrega n 
                                LEFT JOIN app_clientes c ON c.cli_id=n.n_cliid 
                                WHERE n_id={$row['fab_idgenerico']}")->row();

                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'     => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'       => $factura['cli_razon_social'],
                                    'tasa'          => $row['fab_factor'],
                                    'correlativo' => 'ORDENV' . $factura['n_correlativo'],
                                    'url' => 'ordendeentregaeditar/verFactura/' . $factura['n_id']
                                ];
                            } elseif ($row['fab_doc'] == 13) {
                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'     => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'     => '',
                                    'tasa' => '',
                                    'correlativo' => 'Comision',
                                    'url' => ''
                                ];
                            } else {
                                $array_balances[] = [
                                    'fecha'         => $row['fecha'],
                                    'empleado'      => $row['emp_username'],
                                    'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                                    'cuenta'        => $row['bc_alias'],
                                    'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'disponible'    => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                                    'divisa'        => $this->div_master['div_nombre'],
                                    'categoria'     => $row['cie_descripcion'],
                                    'sucursal'     => (isset($row['su_nombre'])) ? $row['su_nombre'] : '',
                                    'cliente'       => '',
                                    'tasa'          => $row['fab_factor'],
                                    'correlativo' => '',
                                    'url' => ''
                                ];
                            }
                        }
                    }

                    Http::json_response([
                        'balance'   => $array_balances,
                        'total'     => Moneda::moneda($disponible, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'balance_creditos' => $array_balances_creditos,
                        'total_credito' => Moneda::moneda($total_credito, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                    ]);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerSucursalesEmpleado()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $empleado_sucursales = new EmpleadoSucursales();
            $suc = $empleado_sucursales->obtenerSucursales($_SESSION['user_data']['emp_id']);

            $ID = '';
            foreach ($suc as $row) {
                if ($row['sucursal_predeterminado'] == 1) {
                    $ID = $row['sucursal_id'];
                }
            }

            Http::json_response([
                'sucursales' => $suc,
                'id' => ($_SESSION['sucursal']['id'] != 0) ? $_SESSION['sucursal']['id'] : $ID,
                'desactivar' => ($_SESSION['sucursal']['id'] != 0) ? true : false
            ]);
        }
    }

    public function obtenerCierreDelDia()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $sucursal = filter_input(INPUT_GET, 'sucursal', FILTER_SANITIZE_NUMBER_INT);

            //if (empty($_GET['sucursal'])) {
            //    $this->array_errors[]  = 'EL campo sucursal es obligatorio.';
            // }
            if (empty($_GET['fecha'])) {
                $this->array_errors[]  = 'EL campo fecha es obligatorio.';
            } else {
                if (!validateDate($_GET['fecha'], 'Y-m-d')) {
                    $this->array_errors[] = 'EL campo no es valido.';
                }
            }

            if (empty($this->array_errors)) {

                $list_cierre_de_dia_p = [];
                $list_cierre_de_dia_n = [];
                $total_id_p = [];
                $totales_divisas_p = [];
                $total_id_n = [];
                $totales_divisas_n = [];

                $data_positivo = $this->ingresosegresos_model->obtenerCierreDelDia(0, $_GET['fecha'], $sucursal);
                $data_negativo = $this->ingresosegresos_model->obtenerCierreDelDia(1, $_GET['fecha'], $sucursal);

                if (is_countable($data_positivo) && count($data_positivo)) {
                    foreach ($data_positivo as $row) {
                        $list_cierre_de_dia_p[] = [
                            'empleado' => [
                                'nombres' => $row['einfo_nombres'],
                                'apellidos' => $row['einfo_apellidos']
                            ],
                            'metodo' => $row['fab_metodo'],
                            'divisa' => $row['div_nombre'],
                            'monto' => Moneda::moneda($row['monto'], $row['div_locale'], $row['div_simbolo']),
                            'banco' => [
                                'codigo' => $row['ban_codigo'],
                                'descripcion' => $row['ban_descripcion'],
                                'cuenta' => $row['bc_cuenta'],
                                'alias' => $row['bc_alias'],
                                'tipo' => $row['bc_tipo'],
                                'metodo' => $row['mp_nombre']
                            ]
                        ];

                        if (!in_array($row['div_id'], $total_id_p)) {
                            $totales_divisas_p[$row['div_id']] = [
                                'divisa' => Moneda::obtenerDivisa($row['div_id']),
                                'total' => $row['monto'],
                            ];
                            $total_id_p[] = $row['div_id'];
                        } else {
                            $totales_divisas_p[$row['div_id']]['total'] += $row['monto'];
                        }
                    }
                }

                if (is_countable($data_negativo) && count($data_negativo)) {
                    foreach ($data_negativo as $row) {
                        $list_cierre_de_dia_n[] = [
                            'empleado' => [
                                'nombres' => $row['einfo_nombres'],
                                'apellidos' => $row['einfo_apellidos']
                            ],
                            'metodo' => $row['fab_metodo'],
                            'divisa' => $row['div_nombre'],
                            'monto' => Moneda::moneda($row['monto'], $row['div_locale'], $row['div_simbolo']),
                            'banco' => [
                                'codigo' => $row['ban_codigo'],
                                'descripcion' => $row['ban_descripcion'],
                                'cuenta' => $row['bc_cuenta'],
                                'alias' => $row['bc_alias'],
                                'tipo' => $row['bc_tipo'],
                                'metodo' => $row['mp_nombre']
                            ]
                        ];

                        if (!in_array($row['div_id'], $total_id_n)) {
                            $totales_divisas_n[$row['div_id']] = [
                                'divisa' => Moneda::obtenerDivisa($row['div_id']),
                                'total' => $row['monto'],
                            ];
                            $total_id_n[] = $row['div_id'];
                        } else {
                            $totales_divisas_n[$row['div_id']]['total'] += $row['monto'];
                        }
                    }
                }

                Http::json_response([
                    'cierre_positivo' => $list_cierre_de_dia_p,
                    'cierre_negativo' =>  $list_cierre_de_dia_n,
                    'total_divisas_p' => $totales_divisas_p,
                    'total_divisas_n' => $totales_divisas_n,
                ]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function imprimir()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['fecha']) && !empty($_GET['id'])) {

                $fecha     = $this->solicitud->sanitize($_GET['fecha'], FILTER_SANITIZE_STRING);
                $estatus   = $this->solicitud->sanitize($_GET['estatus'], FILTER_SANITIZE_STRING);
                $id   = $this->solicitud->sanitize($_GET['id'], FILTER_VALIDATE_INT);
                $sucursal = $this->solicitud->sanitize($_GET['sucursal'], FILTER_SANITIZE_NUMBER_INT);

                $data = [];
                $list_cierre = [];

                if ($id && $estatus) {
                    if ($estatus == 'positivo') {
                        $data = $this->ingresosegresos_model->obtenerCierreDelDia(0, $fecha, $sucursal);

                        if (is_countable($data) && count($data)) {
                            foreach ($data as $row) {
                                $list_cierre[] = [
                                    'empleado' => [
                                        'nombres' => $row['einfo_nombres'],
                                        'apellidos' => $row['einfo_apellidos']
                                    ],
                                    'metodo' => $row['fab_metodo'],
                                    'divisa' => $row['div_nombre'],
                                    'monto' => Moneda::moneda($row['monto'], $row['div_locale'], $row['div_simbolo']),
                                    'banco' => [
                                        'codigo' => $row['ban_codigo'],
                                        'descripcion' => $row['ban_descripcion'],
                                        'cuenta' => $row['bc_cuenta'],
                                        'alias' => $row['bc_alias'],
                                        'tipo' => $row['bc_tipo'],
                                        'metodo' => $row['mp_nombre']
                                    ]
                                ];
                            }
                        }
                    }
                    if ($estatus == 'negativo') {
                        $data = $this->ingresosegresos_model->obtenerCierreDelDia(1, $fecha, $sucursal);

                        if (is_countable($data) && count($data)) {
                            foreach ($data as $row) {
                                $list_cierre[] = [
                                    'empleado' => [
                                        'nombres' => $row['einfo_nombres'],
                                        'apellidos' => $row['einfo_apellidos']
                                    ],
                                    'metodo' => $row['fab_metodo'],
                                    'divisa' => $row['div_nombre'],
                                    'monto' => Moneda::moneda($row['monto'], $row['div_locale'], $row['div_simbolo']),
                                    'banco' => [
                                        'codigo' => $row['ban_codigo'],
                                        'descripcion' => $row['ban_descripcion'],
                                        'cuenta' => $row['bc_cuenta'],
                                        'alias' => $row['bc_alias'],
                                        'tipo' => $row['bc_tipo'],
                                        'metodo' => $row['mp_nombre']
                                    ]
                                ];
                            }
                        }
                    }
                    if ($estatus == 'completo') {

                        $abonos = [];
                        $pagos = [];
                        $dataNto = $this->ingresosegresos_model->obtenerCierreMovimientocompletoNot($fecha, $sucursal);
                        $dataFact = $this->ingresosegresos_model->obtenerCierreMovimientocompletoFact($fecha, $sucursal);
                        $dataOrd = $this->ingresosegresos_model->obtenerCierreMovimientocompletoOrd($fecha, $sucursal);
                        $positivo = 0;

                        $generico = new Generico();

                        if (is_countable($dataNto) && count($dataNto)) {
                            foreach ($dataNto as $row) {

                                $total_pagos = $generico->totalPagos($row['ne_id'], 1, 1);

                                if ($row['fab_divisa'] != $this->div_master['div_id']) {
                                    $factor = $this->ingresosegresos_model->divisaFactor($row['div_id'], $this->div_master['div_id']);
                                    $row['fab_monto'] *= $factor['df_factor'];
                                }

                                $positivo += $row['fab_monto'];

                                if ((round($total_pagos['total'] ?? 0, 2) >= round($row['ne_total'], 2)) && $total_pagos['total'] == 1) {
                                    $pagos[] = [
                                        'pago' => $row['fab_observacion'],
                                    ];
                                } else {
                                    if ((round($total_pagos['total'] ?? 0, 2) >= round($row['ne_total'], 2))) {
                                        $observacion = str_replace('Pago', 'Abono/ pago completo ', $row['fab_observacion']);
                                        $abonos[] = [
                                            'pago' => $observacion,
                                        ];
                                    } else {
                                        $observacion = str_replace('Pago', 'Abono', $row['fab_observacion']);
                                        $abonos[] = [
                                            'pago' => $observacion,
                                        ];
                                    }
                                }
                            }
                        }

                        if (is_countable($dataFact) && count($dataFact)) {
                            foreach ($dataFact as $row) {

                                $total_pagos = $generico->totalPagos($row['fm_id'], 2, 1);

                                if ($row['fab_divisa'] != $this->div_master['div_id']) {
                                    $factor = $this->ingresosegresos_model->divisaFactor($row['div_id'], $this->div_master['div_id']);
                                    $row['fab_monto'] *= $factor['df_factor'];
                                }

                                $positivo += $row['fab_monto'];

                                if ((round($total_pagos['total'] ?? 0, 2) >= round($row['fm_total'], 2)) && $total_pagos['total'] == 1) {
                                    $pagos[] = [
                                        'pago' => $row['fab_observacion'],
                                    ];
                                } else {
                                    if ((round($total_pagos['total'] ?? 0, 2) >= round($row['fm_total'], 2))) {
                                        $observacion = str_replace('Pago', 'Abono/ pago completo ', $row['fab_observacion']);
                                        $abonos[] = [
                                            'pago' => $observacion,
                                        ];
                                    } else {
                                        $observacion = str_replace('Pago', 'Abono', $row['fab_observacion']);
                                        $abonos[] = [
                                            'pago' => $observacion,
                                        ];
                                    }
                                }
                            }
                        }


                        if (is_countable($dataOrd) && count($dataOrd)) {
                            foreach ($dataOrd as $row) {

                                $total_pagos = $generico->totalPagos($row['n_id'], 12, 1);
                                $planilla = $generico->obtenerPlanillas($row['n_id']);

                                if ($row['fab_divisa'] != $this->div_master['div_id']) {
                                    $factor = $this->ingresosegresos_model->divisaFactor($row['div_id'], $this->div_master['div_id']);
                                    $row['fab_monto'] *= $factor['df_factor'];
                                }

                                $positivo += $row['fab_monto'];

                                if ((round($total_pagos['total'] ?? 0, 2) >= round($row['n_total'], 2)) && $total_pagos['total'] == 1) {
                                    $observacion = str_replace('Pago', 'Pago ' . $planilla['pre_correlativo'] ?? '', $row['fab_observacion']);
                                    $pagos[] = [
                                        'pago' => $observacion,
                                    ];
                                } else {
                                    if ((round($total_pagos['total'] ?? 0, 2) >= round($row['n_total'], 2))) {
                                        $observacion = str_replace('Pago', 'Abono/ pago completo ' . $planilla['pre_correlativo'] ?? '', $row['fab_observacion']);
                                        $abonos[] = [
                                            'pago' => $observacion,
                                        ];
                                    } else {
                                        $observacion = str_replace('Pago', 'Abono ' . $planilla['pre_correlativo'] ?? '', $row['fab_observacion']);
                                        $abonos[] = [
                                            'pago' => $observacion,
                                        ];
                                    }
                                }
                            }
                        }

                        $credito = $this->ingresosegresos_model->consultar("SELECT n_total as total, n_divid as divisa FROM app_orden_de_entrega WHERE n_estatus=4 AND (DATE(n_fecha) BETWEEN '$fecha' AND '$fecha')")->all();
                        $credito_total = 0;
                        if (is_countable($credito) && count($credito)) {
                            foreach ($credito as $row) {
                                if ($row['divisa'] != $this->div_master['div_id']) {
                                    $factor = $this->ingresosegresos_model->divisaFactor($row['div_id'], $this->div_master['div_id']);
                                    $row['total'] *= $factor['df_factor'];
                                }
                                $credito_total += $row['total'];
                            }
                        }

                        $list_cierre[] = [
                            'ingreso' => Moneda::moneda($positivo, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'abonos' => $abonos,
                            'pagos' => $pagos,
                            'credito' => Moneda::moneda($credito_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        ];
                    }
                    $this->carritoVentas = new CarritoVentasEditar();
                    Http::json_response($this->carritoVentas->imprimirIngreso($estatus, $list_cierre, $id));
                } else {
                    $this->array_errors[] = 'Acción prohibidssa';
                }
            } else {
                $this->array_errors[] = 'Acción prohibidaaa';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerComisionesEmpAgentePendiente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_comempl = new EmpleadosComisionesEmplAgente();

            if (!empty($_POST['fecha_desde']) && !empty($_POST['fecha_hasta'])) {
                $id_comision = filter_input(INPUT_POST, 'tipo_comision', FILTER_SANITIZE_NUMBER_INT);
                $id_divisa   = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $agente      = filter_input(INPUT_POST, 'agente', FILTER_SANITIZE_NUMBER_INT);
                $fecha_desde = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
                $fecha_hasta = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);
                $documento      = filter_input(INPUT_POST, 'documento', FILTER_SANITIZE_NUMBER_INT);

                if (empty($fecha_desde))
                    $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

                if (empty($fecha_hasta))
                    $fecha_hasta = date('Y-m-d');


                $facturas = $this->ingresosegresos_model->obtenerComisionesFacturasPendientes($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $agente, $documento);
                $notas = $this->ingresosegresos_model->obtenerComisionesNotasPendientes($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $agente, $documento);
                $ordenes = $this->ingresosegresos_model->obtenerComisionesOrdenPendientes($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $agente, $documento);


                $pendiente = [];
                $total_pagar = 0;

                if (empty($this->array_errors)) {

                    if (!validateDate($fecha_desde, 'Y-m-d'))
                        $this->array_errors[] = 'La Fecha desde es incorrecta.';
                    if (!validateDate($fecha_hasta, 'Y-m-d'))
                        $this->array_errors[] = 'La Fecha hasta es incorrecta.';


                    if (is_countable($notas) && count($notas)) {

                        $documento = Documento::obtener(1);

                        foreach ($notas as $row) {

                            $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);

                            $pendiente[] = [
                                'id'                => $row['comagentefn_id'],
                                'com_descripcion'   => $row['com_descripcion'],
                                'uri'               => ruta_base() .  'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                                'idnf'              => $documento['prefijo'] . $row['ne_correlativo'],
                                'fecha_reg'         => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                                'total'             => $row['comagentefn_fntotal'],
                                'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                                'cliente'           => $row['cli_razon_social'],
                                'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                                'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                                'estatusfn'         => $row['ne_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                                'monto'             => $row['comagentefn_monto'],
                                'agente'            => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                                'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                                'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                                'checked'           => false
                            ];
                            $total_pagar += $row['comagentefn_monto'];
                        }
                    }

                    if (is_countable($ordenes) && count($ordenes)) {

                        $documento = Documento::obtener(12);

                        foreach ($ordenes as $row) {

                            $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);

                            $planilla = '';
                            if ($row['comagentefn_planilla'] > 0) {
                                $plan = $this->ingresosegresos_model->consultar("SELECT * FROM app_preorden_master WHERE pre_id={$row['comagentefn_planilla']}")->row();
                                $planilla = $plan['pre_correlativo'];
                            }

                            $pendiente[] = [
                                'id'                => $row['comagentefn_id'],
                                'com_descripcion'   => $row['com_descripcion'],
                                'uri'               => ($row['comagentefn_planilla'] > 0) ? ruta_base() . 'planilla/orden/' . $row['comagentefn_planilla'] : ruta_base() .  'ordendeentregaeditar/verFactura/' . $row['n_id'],
                                'idnf'              => ($row['comagentefn_planilla'] > 0) ? '#' . $planilla : $documento['prefijo'] . $row['n_correlativo'],
                                'fecha_reg'         => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                                'total'             => $row['comagentefn_fntotal'],
                                'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                                'cliente'           => $row['cli_razon_social'],
                                'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                                'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                                'estatusfn'         => $row['n_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                                'monto'             => $row['comagentefn_monto'],
                                'agente'            => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                                'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                                'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                                'checked'           => false
                            ];
                            $total_pagar += $row['comagentefn_monto'];
                        }
                    }

                    if (is_countable($facturas) && count($facturas)) {

                        $documento = Documento::obtener(2);

                        foreach ($facturas as $row) {

                            $divisa_pagada = Moneda::obtenerDivisa($row['comagentefn_divid']);

                            $pendiente[] = [
                                'id'                => $row['comagentefn_id'],
                                'uri'               => ruta_base() .  'poseditar/verFactura/' . $row['fm_id'],
                                'com_descripcion'   => $row['com_descripcion'],
                                'idnf'              => $documento['prefijo'] . $row['fm_correlativo'],
                                'fecha_reg'         => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                                'total'             => $row['comagentefn_fntotal'],
                                'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                                'cliente'           => $row['cli_razon_social'],
                                'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                                'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                                'estatusfn'         => $row['fm_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                                'monto'             => $row['comagentefn_monto'],
                                'agente'            => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                                'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa_pagada['locale'], $divisa_pagada['symbol']),
                                'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d-m-Y h:i A', strtotime($row['comagentefn_fechapago'])) : '',
                                'checked'           => false
                            ];
                            $total_pagar += $row['comagentefn_monto'];
                        }
                    }

                    $divisa_pagada = Moneda::obtenerDivisa($id_divisa);

                    Http::json_response([
                        'pendientes' => $pendiente,
                        'total_pagar' => Moneda::moneda($total_pagar, $divisa_pagada['locale'], $divisa_pagada['symbol'])
                    ]);
                }
            } else {
                $this->array_errors[] = 'Acciion prohibidaaa';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerTransferenciasespera()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_POST['fecha_desde']) && !empty($_POST['fecha_hasta'])) {
                $id_divisa   = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $fecha_desde = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
                $fecha_hasta = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);

                if (empty($fecha_desde))
                    $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

                if (empty($fecha_hasta))
                    $fecha_hasta = date('Y-m-d');

                $array_balances = [];

                $balances = $this->ingresosegresos_model->consultar("SELECT e.emp_username,m.fab_id, m.fab_doc,m.fab_idgenerico,m.fab_factor,m.fab_divid_conversion,m.fab_divisa, m.fab_monto, m.fab_factor_master, m.fab_descripcion, m.fab_observacion, bc_alias, cie_descripcion, DATE_FORMAT(fab_fecha, '%d/%m/%Y') as fecha, s.* 
                FROM app_movimientos m
                JOIN app_empleados e ON e.emp_id = m.fab_empid
                JOIN app_cuentas_metodopago cm ON cm.cmp_id = m.fab_cmpid 
                JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid 
                JOIN app_bancos b ON b.ban_id = bc.bc_banid 
                LEFT JOIN app_sucursales s ON s.su_id=m.fab_sucursal 
                LEFT JOIN app_categorias_ingreso_egreso cie ON cie.cie_id = m.fab_categoria
                WHERE m.fab_credito = 0 AND (DATE(m.fab_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND m.fab_retiro =4 AND m.fab_divisa = $id_divisa ORDER BY m.fab_id ASC")->all();

                if (is_countable($balances) && count($balances)) {
                    foreach ($balances as $row) {
                        $monto = ($this->div_master['div_id'] != $row['fab_divisa']) ? $row['fab_monto'] / $row['fab_factor_master'] : $row['fab_monto'];
                        ///$disponible += $monto;
                        $array_balances[] = [
                            'id' => $row['fab_id'],
                            'fecha'         => $row['fecha'],
                            'empleado'      => $row['emp_username'],
                            'descripcion'   => $row['fab_descripcion'] . ' ' . $row['fab_observacion'],
                            'cuenta'        => $row['bc_alias'],
                            'monto'         => Moneda::moneda($monto, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'disponible'    => 0,
                            'divisa'        => $this->div_master['div_nombre'],
                            'categoria'     => $row['cie_descripcion'],
                            'sucursal'     => $row['su_nombre']
                        ];
                    }
                }

                Http::json_response($array_balances);
            }
        }
    }

    public function imprimir_comisiones()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['fecha_desde']) && !empty($_GET['fecha_hasta'])) {


                $fecha_desde    = $this->solicitud->sanitize($_GET['fecha_desde'], FILTER_SANITIZE_STRING);
                $fecha_hasta    = $this->solicitud->sanitize($_GET['fecha_hasta'], FILTER_SANITIZE_STRING);
                $agente         = $this->solicitud->sanitize($_GET['agente'], FILTER_VALIDATE_INT);
                $estatus        = $this->solicitud->sanitize($_GET['estatus'], FILTER_VALIDATE_INT);
                $id_comision    = $this->solicitud->sanitize($_GET['tipo_comision'], FILTER_VALIDATE_INT);
                $id_divisa      = $this->solicitud->sanitize($_GET['divisa'], FILTER_VALIDATE_INT);
                $id_impresora   = $this->solicitud->sanitize($_GET['id_impresora'], FILTER_VALIDATE_INT);

                if (empty($id_divisa))
                    Http::json_response(['errors' => ['La divisa es obligatoria']]);

                if (empty($fecha_desde))
                    $fecha_desde = (new DateTime())->modify('first day of this month')->format('Y-m-d');

                if (empty($fecha_hasta))
                    $fecha_hasta = date('Y-m-d');

                if (empty($this->array_errors)) {

                    if (!validateDate($fecha_desde, 'Y-m-d'))
                        $this->array_errors[] = 'La Fecha desde es incorrecta.';
                    if (!validateDate($fecha_hasta, 'Y-m-d'))
                        $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                    $data = $this->obtenerComisionesTotales($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, $estatus, '', $agente);
                    $this->carritoVentas = new CarritoVentasEditar();

                    Http::json_response($this->carritoVentas->imprimirComisiones($fecha_desde, $fecha_hasta, $data, $id_impresora, $estatus));
                } else {
                    Http::json_response(['errors' => $this->array_errors]);
                }
            } else {
                $this->array_errors[] = 'Acciion prohibidaaa';
            }
        }
    }

    public function obtenerMetodoPagoComisiones(int $divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $divisa = filter_var($divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($divisa))
                $this->array_errors[] = 'Debe una divisa';

            if (empty($this->array_errors)) {
                $metodopago = new MetodoPago();
                $data = $metodopago->obtenerMetodoPagoComisiones($divisa);
                if ($data) {
                    Http::json_response($data);
                } else {
                    $this->array_errors[] = 'Lo siento no hay metodos relacionados a esta divisa';
                }

                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function obtenerCuentasSegunMetod(int $id_metodo_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_metodo_divisa = filter_var($id_metodo_divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_metodo_divisa))
                $this->array_errors[] = 'Debe seleccionar un metodo';

            if (empty($this->array_errors)) {
                $empleado         = new Empleado();
                $data = $empleado->obtenerCuentasSegunMetodo($id_metodo_divisa);
                if ($data) {
                    Http::json_response($data);
                } else {
                    $this->array_errors[] = 'Lo siento no hay cuentas registradas para este metoto de pago';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerPagoDivisa()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_divisa']) || empty($_GET['id_comision']))
                Http::json_response(['errors' => ['Acci\A8\AEn prohibida']]);

            $id_divisa  = filter_input(INPUT_GET, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_com_age = filter_input(INPUT_GET, 'id_comision', FILTER_SANITIZE_NUMBER_INT);

            $newEmpCom  = new EmpleadosComisionesEmplAgente();

            $data_comision  = $newEmpCom->obtener($id_com_age);
            $div_original   = Moneda::obtenerDivisa($data_comision['comagentefn_divid']);
            $div_deseada    = Moneda::obtenerDivisa($id_divisa);

            $total_sin_conversion = $data_comision['comagentefn_monto'];

            if ($data_comision['comagentefn_divid'] == $id_divisa) {
                $total = $data_comision['comagentefn_monto'];
            } else {
                $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                if ($div_fact) {
                    $total = $data_comision['comagentefn_monto'] * $div_fact['df_factor'];
                } else {
                    $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registr\A8\AE la comision.';
                }
            }

            if (empty($this->array_errors)) {
                Http::json_response([
                    'total_sin_conversion' => Moneda::moneda($total_sin_conversion, $div_original['locale'], $div_original['symbol'], $div_original['precision']),
                    'total_con_conversion' => Moneda::moneda($total, $div_deseada['locale'], $div_deseada['symbol'], $div_deseada['precision'])
                ]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerMontoApagarDeComisionesSeleccionadas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_divisa']))
                Http::json_response(['errors' => ['Debe seleccionar la divisa y alguna comision']]);

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_comisiones = json_decode($_POST['id_comisiones'], true);

            if (is_countable($id_comisiones) && count($id_comisiones)) {

                $newEmpCom  = new EmpleadosComisionesEmplAgente();

                $data_comision_referencia = $newEmpCom->obtener($id_comisiones[0]);
                $divisa_original = Moneda::obtenerDivisa($data_comision_referencia['comagentefn_divid']);
                $div_deseada = Moneda::obtenerDivisa($id_divisa);
                $total_con_conversion = 0;
                $total_sin_conversion = 0;

                foreach ($id_comisiones as $row) {

                    $data_comision  = $newEmpCom->obtener($row);

                    $total_sin_conversion += $data_comision['comagentefn_monto'];

                    if ($data_comision['comagentefn_divid'] == $id_divisa) {
                        $total_con_conversion += $data_comision['comagentefn_monto'];
                    } else {
                        $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                        if ($div_fact) {
                            $total_con_conversion += $data_comision['comagentefn_monto'] * $div_fact['df_factor'];
                        } else {
                            $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registr\A8\AE la comision.';
                        }
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response([
                        'total_sin_conversion' => Moneda::moneda($total_sin_conversion, $divisa_original['locale'], $divisa_original['symbol'], $divisa_original['precision']),
                        'total_con_conversion' => Moneda::moneda($total_con_conversion, $div_deseada['locale'], $div_deseada['symbol'], $div_deseada['precision'])
                    ]);
                }
            } else {
                $this->array_errors[]  = 'Accion prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagarComision()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo  = filter_input(INPUT_POST, 'id_metodo', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta  = filter_input(INPUT_POST, 'id_cuenta', FILTER_SANITIZE_NUMBER_INT);
            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa el obligatorio.';
            if (empty($id_metodo))
                $this->array_errors[] = 'El campo Metodo el obligatorio.';
            if (empty($id_cuenta))
                $this->array_errors[] = 'El campo Cuenta el obligatorio.';

            if ($id && empty($this->array_errors)) {

                $movimiento_model   = new MovimientoModel();
                $new_comempl        = new EmpleadosComisionesEmplAgente();
                $newFACV            = new Pos();
                $newNEV             = new Notasdeentrega();
                $newOrden           = new Ordendeentrega();
                $divisa_master      = Moneda::Predeterminada();

                $factor_master = $factor = 1;
                $total = 0;

                if ($id) {

                    $data_comision = $new_comempl->obtener($id);
                    $div_format = Moneda::obtenerDivisa($id_divisa);

                    if ($data_comision['comagentefn_divid'] == $id_divisa) {
                        $factor = 1;
                        $total = $data_comision['comagentefn_monto'];
                    } else {
                        $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                        if ($div_fact) {
                            $factor = $div_fact['df_factor'];
                            $total = $data_comision['comagentefn_monto'] * $factor;
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registr\A8\AE la comision.';
                        }
                    }

                    if ($divisa_master['id'] != $id_divisa) {
                        $data_factor = Moneda::obtenerFactor($divisa_master['id'], $id_divisa);
                        if ($data_factor) {
                            $factor_master = $data_factor['df_factor'];
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa a pagar';
                        }
                    }

                    $cuenta = $movimiento_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta")->row();
                    $saldo = $movimiento_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();

                    if ($saldo['bc_saldo'] < $total) {
                        $this->array_errors[] = 'Saldo insuficiente';
                    }

                    if (empty($this->array_errors)) {

                        $fecha_de_pago = date('Y-m-d H:i:s');

                        if ($data_comision['comagentefn_fntipo'] == 1) {

                            $nota = $newNEV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(1);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$nota['ne_correlativo']} {$nota['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = $th;
                            }
                        } elseif ($data_comision['comagentefn_fntipo'] == 2) {

                            $factura = $newFACV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(2);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $factura['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $factura['fm_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$factura['fm_correlativo']} {$factura['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = $th;
                            }
                        } elseif ($data_comision['comagentefn_fntipo'] == 12) {

                            $orden = $newOrden->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(12);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$orden['n_correlativo']} {$orden['n_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = $th;
                            }
                        }
                    }

                    if (empty($this->array_errors)) {
                        Http::json_response(true);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagarComisiones()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_metodo  = filter_input(INPUT_POST, 'id_metodo', FILTER_SANITIZE_NUMBER_INT);
            $id_cuenta  = filter_input(INPUT_POST, 'id_cuenta', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa el obligatorio.';
            if (empty($id_metodo))
                $this->array_errors[] = 'El campo Metodo el obligatorio.';
            if (empty($id_cuenta))
                $this->array_errors[] = 'El campo Cuenta el obligatorio.';

            $id_comisiones = json_decode($_POST['id_comisiones'], true);

            if (is_countable($id_comisiones) && count($id_comisiones)) {

                foreach ($id_comisiones as $id_comision) {
                    $movimiento_model   = new MovimientoModel();
                    $new_comempl        = new EmpleadosComisionesEmplAgente();
                    $newFACV            = new Pos();
                    $newNEV             = new Notasdeentrega();
                    $newOrden           = new Ordendeentrega();
                    $divisa_master      = Moneda::Predeterminada();

                    $factor_master = $factor = 1;
                    $total = 0;

                    $data_comision = $new_comempl->obtener($id_comision);
                    $div_format = Moneda::obtenerDivisa($id_divisa);

                    if ($data_comision['comagentefn_divid'] == $id_divisa) {
                        $factor = 1;
                        $total = $data_comision['comagentefn_monto'];
                    } else {
                        $div_fact = Moneda::obtenerFactor($data_comision['comagentefn_divid'], $id_divisa);
                        if ($div_fact) {
                            $factor = $div_fact['df_factor'];
                            $total = $data_comision['comagentefn_monto'] * $factor;
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa en que se registr\A8\AE la comision.';
                        }
                    }

                    if ($divisa_master['id'] != $id_divisa) {
                        $data_factor = Moneda::obtenerFactor($divisa_master['id'], $id_divisa);
                        if ($data_factor) {
                            $factor_master = $data_factor['df_factor'];
                        } else {
                            $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa a pagar';
                        }
                    }

                    $cuenta = $movimiento_model->consultar("SELECT cmp_saldo, cmp_cueid FROM app_cuentas_metodopago WHERE cmp_id = $id_cuenta")->row();
                    $saldo = $movimiento_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();

                    if ($saldo['bc_saldo'] < $total) {
                        $this->array_errors[] = 'Saldo insuficiente';
                    }

                    if (empty($this->array_errors)) {

                        $fecha_de_pago = date('Y-m-d H:i:s');

                        if ($data_comision['comagentefn_fntipo'] == 1) {

                            $nota = $newNEV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(1);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$nota['ne_correlativo']} {$nota['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transaccion' . $th;
                            }
                        } elseif ($data_comision['comagentefn_fntipo'] == 2) {

                            $factura = $newFACV->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(2);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $factura['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $factura['fm_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$factura['fm_correlativo']} {$factura['ne_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transaccion' . $th;
                            }
                        } else if ($data_comision['comagentefn_fntipo'] == 12) {

                            $orden = $newOrden->obtener($data_comision['comagentefn_fnid']);
                            $doc_ = Documento::obtener(12);

                            try {

                                $movimiento_model->transactionBegin();

                                $movimiento_model->guardar([
                                    'fab_idgenerico'        => $data_comision['comagentefn_id'],
                                    'fab_doc'               => 13,
                                    'fab_divisa'            => $id_divisa,
                                    'fab_metodo'            => $id_metodo,
                                    'fab_cmpid'             => $id_cuenta,
                                    'fab_monto'             => $total * (-1),
                                    'fab_factor'            => $factor,
                                    'fab_conversion'        => $data_comision['comagentefn_monto'] * (-1),
                                    'fab_divid_conversion'  => $data_comision['comagentefn_divid'],
                                    'fab_factor_master'     => $factor_master,
                                    'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                    'fab_modulo'            => 'comision',
                                    'fab_retiro'            => 1,
                                    'fab_descripcion'       => 'Pago Comision',
                                    'fab_observacion'       => "Pago Comision {$doc_['prefijo']} # {$orden['n_correlativo']} {$orden['n_env_nombres']} Monto: " . Moneda::moneda($total, $div_format['locale'], $div_format['symbol']),
                                    'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                    'fab_categoria'         => 3
                                ]);

                                $movimiento_model->pagarCuenta($cuenta['cmp_cueid'], ($saldo['bc_saldo'] - $total));
                                $movimiento_model->pagarCuentaMetodo($id_cuenta, ($cuenta['cmp_saldo'] - $total));
                                $movimiento_model->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1, comagentefn_fechapago = '$fecha_de_pago' WHERE comagentefn_id= {$data_comision['comagentefn_id']}")->run();

                                $movimiento_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $movimiento_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transaccion' . $th;
                            }
                        }
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response(true);
                }
            } else {
                Http::json_response(['errors' => ['Debe seleccionar alguna comision']]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function editarpendiente()
    {
        $new_comempl = new EmpleadosComisionesEmplAgente();

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $porcentaje  = filter_input(INPUT_POST, 'porcentaje', FILTER_SANITIZE_STRING ?? 0);
            $monto  = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING ?? 0);

            $monto = convertir_a_float($monto);
            $porcentaje = convertir_a_float($porcentaje);

            if ($monto <= 0) {
                $this->array_errors[] = 'EL monto no puede ser 0';
            } else {
                if ($new_comempl->existe('comagentefn_id', $id)) {
                    if (empty($this->array_errors)) {
                        if ($new_comempl->editar($id, [
                            'comagentefn_monto' => $monto,
                            'comagentefn_porcentaje'  => $porcentaje,
                        ], true)) {
                            Http::json_response(true);
                        } else {
                            Http::json_response(false);
                        }
                    }
                } else {
                    $this->array_errors[] = "Error, No se pudo modificar.";
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarComisionPendiente(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_comis = new EmpleadosComisionesEmplAgente();

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($new_comis->existe('comagentefn_id', $id)) {
                Http::json_response($new_comis->eliminar($id));
            } else {
                Http::json_response(false);
            }
        }
    }

    public function obtenerComisionesId()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_POST, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_POST, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $agente         = filter_input(INPUT_POST, 'agente', FILTER_SANITIZE_NUMBER_INT);

            $id_comision    = filter_input(INPUT_POST, 'comision', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa      = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_divisa))
                Http::json_response(['errors' => ['La divisa es obligatoria']]);

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime())->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                Http::json_response($this->obtenerComisionesIndividuales($fecha_desde, $fecha_hasta, $id_divisa, $id_comision, 1, '', $agente));
            } else {
                Http::json_response(['errors' => $this->array_errors]);
            }
        } else {
            Http::json_response('Error');
        }
    }

    public function obtenerComisionesIndividuales(string $fecha_desde, string $fecha_hasta, int $id_divisa, int $id_comision, int $estatus, String $select_doc, int $agente)
    {
        $newCom = new EmpleadosComisionesEmplAgente();
        $divisa = Moneda::obtenerDivisa($id_divisa);

        $array_total = [];
        $total_pagada = 0;
        $total_pendiente = 0;
        $n_agente = '';

        if ($estatus == 2) {
            $estatusText = 'todas';
        } else {
            $estatusText = $estatus == 1 ? 'pagadas' : 'pendientes';
        }

        if (!empty($id_comision)) {

            $data_comision = $newCom->consultar("SELECT * FROM app_comision WHERE com_id = $id_comision")->row();
            $tipo_comision = $data_comision['com_descripcion'];

            if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
            }

            $facturas = $newCom->obtenerComisionesFacturasId($where_f);
            $notas = $newCom->obtenerComisionesNotasId($where_n);
            $ordenes = $newCom->obtenerComisionesOrdenesId($where_o);
        } else {

            $tipo_comision = 'Todas';

            if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
            }

            $facturas = $newCom->obtenerComisionesFacturasId($where_f);
            $notas = $newCom->obtenerComisionesNotasId($where_n);
            $ordenes = $newCom->obtenerComisionesOrdenesId($where_o);
        }



        if (is_countable($notas) && count($notas)) {

            $documento = $newCom->obtenerDocumento(1);

            foreach ($notas as $row) {

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'uri'             => ruta_base() .  'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['ne_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['ne_total'],
                    'total_factura_moneda' => Moneda::moneda($row['ne_total'], $row['div_locale'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'           => $row['comagentefn_fntotal'],
                    'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'         => $row['cli_razon_social'],
                    'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'       => $row['ne_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'           => $row['comagentefn_monto'],
                    'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'  => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => '',
                    'planilla'          => '',
                    'observacion'       => ''
                ];
                $n_agente = ($agente != 0) ? $row['einfo_nombres'] . " " . $row['einfo_apellidos'] : '';
            }
        }

        if (is_countable($ordenes) && count($ordenes)) {

            $documento = $newCom->obtenerDocumento(12);

            foreach ($ordenes as $row) {

                $planilla = $newCom->consultar("SELECT pre_id, pre_correlativo 
                        FROM app_planilla_orden_de_entrega 
                        JOIN app_preorden_master ON po_preid = pre_id 
                        WHERE po_nid = {$row['n_id']}")->row();

                $uri_planilla = '';
                $serv = 'GLOBAL';
                $planilla_id = '';

                if ($planilla) {
                    $planilla_id = $planilla['pre_correlativo'];
                    $uri_planilla = ruta_base() . 'planilla/orden/' . $planilla['pre_id'];
                    if ($row['comagentefn_planilla_servid']) {
                        $data_serv = $newCom->consultar("SELECT pro_descripcion FROM app_productos WHERE pro_id = {$row['comagentefn_planilla_servid']}")->row();
                        $serv = $data_serv['pro_descripcion'];
                    }
                }

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'uri'             => ruta_base() .  'ordendeentregaeditar/verFactura/' . $row['n_id'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['n_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['n_total'],
                    'total_factura_moneda' => Moneda::moneda($row['n_total'], $row['div_locale'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'           => $row['comagentefn_fntotal'],
                    'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'         => $row['cli_razon_social'],
                    'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'       => $row['n_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'           => $row['comagentefn_monto'],
                    'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'  => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => $uri_planilla,
                    'planilla'          => $planilla_id,
                    'observacion'       => $serv
                ];
                $n_agente = ($agente != 0) ? $row['einfo_nombres'] . " " . $row['einfo_apellidos'] : '';
            }
        }

        if (is_countable($facturas) && count($facturas)) {

            $documento = $newCom->obtenerDocumento(2);

            foreach ($facturas as $row) {

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'uri'             => ruta_base() .  'poseditar/verFactura/' . $row['fm_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['fm_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['fm_total'],
                    'total_factura_moneda' => Moneda::moneda($row['fm_total'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'             => $row['comagentefn_fntotal'],
                    'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'           => $row['cli_razon_social'],
                    'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'         => $row['fm_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'             => $row['comagentefn_monto'],
                    'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'    => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => '',
                    'planilla'          => '',
                    'observacion'       => ''
                ];

                $n_agente = ($agente != 0) ? $row['einfo_nombres'] . " " . $row['einfo_apellidos'] : '';
            }
        }

        return [
            'total_pendiente'   => Moneda::moneda($total_pendiente, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'total_pagado'      => Moneda::moneda($total_pagada, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'total'             => Moneda::moneda($total_pendiente + $total_pagada, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'comisiones'        => $array_total,
            'fecha_desde'       => $fecha_desde,
            'fecha_hasta'       => $fecha_hasta,
            'select_doc'        => $select_doc,
            'agente'            => $agente,
            'n_agente'          => $n_agente,
            'divisa'            => $divisa['id'],
            'comision'          => $id_comision,
            'estatus'           => $estatus,
            'estatusText'       => $estatusText,
            'tipo_comision'     => $tipo_comision
        ];
    }

    public function obtenerComisionesTotales(string $fecha_desde, string $fecha_hasta, int $id_divisa, int $id_comision, int $estatus, String $select_doc, int $agente)
    {
        $newCom = new EmpleadosComisionesEmplAgente();
        $divisa = Moneda::obtenerDivisa($id_divisa);

        $array_total = [];
        $total_pagada = 0;
        $total_pendiente = 0;
        $n_agente = '';

        if ($estatus == 2) {
            $estatusText = 'todas';
        } else {
            $estatusText = $estatus == 1 ? 'pagadas' : 'pendientes';
        }

        if (!empty($id_comision)) {

            $data_comision = $newCom->consultar("SELECT * FROM app_comision WHERE com_id = $id_comision")->row();
            $tipo_comision = $data_comision['com_descripcion'];

            if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_n =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_o =  "fn.comagentefn_com =$id_comision AND fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
            }

            $facturas = $newCom->obtenerComisionesFacturasId($where_f);
            $notas = $newCom->obtenerComisionesNotasId($where_n);
            $ordenes = $newCom->obtenerComisionesOrdenesId($where_o);
        } else {

            $tipo_comision = 'Todas';

            if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND comagentefn_divid = $id_divisa";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc' AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($select_doc) && !empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND empc.empagent_captado='$select_doc'";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($agente)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_fnempagente=$agente";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && !empty($id_divisa)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND comagentefn_divid = $id_divisa";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta) && $estatus != 2) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') AND fn.comagentefn_estatus=$estatus";
            } else if (!empty($fecha_desde) && !empty($fecha_hasta)) {

                $where_f =  "fn.comagentefn_fntipo=2 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_n =  "fn.comagentefn_fntipo=1 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
                $where_o =  "fn.comagentefn_fntipo=12 AND (DATE(comagentefn_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')";
            }

            $facturas = $newCom->obtenerComisionesFacturasId($where_f);
            $notas = $newCom->obtenerComisionesNotasId($where_n);
            $ordenes = $newCom->obtenerComisionesOrdenesId($where_o);
        }



        if (is_countable($notas) && count($notas)) {

            $documento = $newCom->obtenerDocumento(1);

            foreach ($notas as $row) {

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'uri'             => ruta_base() .  'notasdeentregaeditar/verFactura/' . $row['ne_id'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['ne_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['ne_total'],
                    'total_factura_moneda' => Moneda::moneda($row['ne_total'], $row['div_locale'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'           => $row['comagentefn_fntotal'],
                    'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'         => $row['cli_razon_social'],
                    'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'       => $row['ne_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'           => $row['comagentefn_monto'],
                    'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'  => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => '',
                    'planilla'          => '',
                    'observacion'       => ''
                ];
                $n_agente = ($agente != 0) ? $row['einfo_nombres'] . " " . $row['einfo_apellidos'] : '';
            }
        }

        if (is_countable($ordenes) && count($ordenes)) {

            $documento = $newCom->obtenerDocumento(12);

            foreach ($ordenes as $row) {

                $planilla = $newCom->consultar("SELECT pre_id, pre_correlativo 
                        FROM app_planilla_orden_de_entrega 
                        JOIN app_preorden_master ON po_preid = pre_id 
                        WHERE po_nid = {$row['n_id']}")->row();

                $uri_planilla = '';
                $serv = 'GLOBAL';
                $planilla_id = '';

                if ($planilla) {
                    $planilla_id = $planilla['pre_correlativo'];
                    $uri_planilla = ruta_base() . 'planilla/orden/' . $planilla['pre_id'];
                    if ($row['comagentefn_planilla_servid']) {
                        $data_serv = $newCom->consultar("SELECT pro_descripcion FROM app_productos WHERE pro_id = {$row['comagentefn_planilla_servid']}")->row();
                        $serv = $data_serv['pro_descripcion'];
                    }
                }

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'uri'             => ruta_base() .  'ordendeentregaeditar/verFactura/' . $row['n_id'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['n_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['n_total'],
                    'total_factura_moneda' => Moneda::moneda($row['n_total'], $row['div_locale'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'           => $row['comagentefn_fntotal'],
                    'total_moneda'    => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'         => $row['cli_razon_social'],
                    'porcentaje'      => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'      => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'       => $row['n_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'           => $row['comagentefn_monto'],
                    'monto_moneda'    => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'  => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'      => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => $uri_planilla,
                    'planilla'          => $planilla_id,
                    'observacion'       => $serv
                ];
                $n_agente = ($agente != 0) ? $row['einfo_nombres'] . " " . $row['einfo_apellidos'] : '';
            }
        }

        if (is_countable($facturas) && count($facturas)) {

            $documento = $newCom->obtenerDocumento(2);

            foreach ($facturas as $row) {

                if ($row['comagentefn_estatus'] == 0) {
                    $total_pendiente += $row['comagentefn_monto'];
                } else {
                    $total_pagada += $row['comagentefn_monto'];
                }

                $array_total[] = [
                    'id'              => $row['comagentefn_id'],
                    'uri'             => ruta_base() .  'poseditar/verFactura/' . $row['fm_id'],
                    'com_descripcion' => $row['com_descripcion'],
                    'agente'          => $row['einfo_nombres'] . " " . $row['einfo_apellidos'],
                    'idnf'            => $documento['doc_prefijo'] . $row['fm_correlativo'],
                    'fecha_reg'       => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'divisa_factura'  => $row['div_nombre'],
                    'total_factura'   => $row['fm_total'],
                    'total_factura_moneda' => Moneda::moneda($row['fm_total'], $row['div_simbolo'], $row['div_decimal'], $divisa['precision']),
                    'total'             => $row['comagentefn_fntotal'],
                    'total_moneda'      => Moneda::moneda($row['comagentefn_fntotal'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'cliente'           => $row['cli_razon_social'],
                    'porcentaje'        => round($row['comagentefn_porcentaje'], 2),
                    'estatuscom'        => $row['comagentefn_estatus'] == 0 ? 'Pendiente' : 'Pagado',
                    'estatusfn'         => $row['fm_estatus'] == 1 ? 'Finalizado' : 'Pendiente',
                    'monto'             => $row['comagentefn_monto'],
                    'monto_moneda'      => Moneda::moneda($row['comagentefn_monto'], $divisa['locale'], $divisa['symbol'], $divisa['precision']),
                    'fecha_creacion'    => date('d/m/Y', strtotime($row['comagentefn_fecha'])),
                    'fecha_pago'        => $row['comagentefn_fechapago'] ? date('d/m/Y', strtotime($row['comagentefn_fechapago'])) : '',
                    'uri_planilla'      => '',
                    'planilla'          => '',
                    'observacion'       => ''
                ];

                $n_agente = ($agente != 0) ? $row['einfo_nombres'] . " " . $row['einfo_apellidos'] : '';
            }
        }

        return [
            'total_pendiente'   => Moneda::moneda($total_pendiente, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'total_pagado'      => Moneda::moneda($total_pagada, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'total'             => Moneda::moneda($total_pendiente + $total_pagada, $divisa['locale'], $divisa['symbol'], $divisa['precision']),
            'fecha_desde'       => $fecha_desde,
            'fecha_hasta'       => $fecha_hasta,
            'select_doc'        => $select_doc,
            'agente'            => $agente,
            'n_agente'          => $n_agente,
            'divisa'            => $divisa['id'],
            'comision'          => $id_comision,
            'estatus'           => $estatus,
            'estatusText'       => $estatusText,
            'tipo_comision'     => $tipo_comision
        ];
    }

    public function pagarPagoMovil()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $fecha    = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $seleccion    = filter_input(INPUT_POST, 'seleccion', FILTER_SANITIZE_STRING);
            $monto    = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
            $descontar    = filter_input(INPUT_POST, 'descontar', FILTER_SANITIZE_STRING);
            $agregar    = filter_input(INPUT_POST, 'agregar', FILTER_SANITIZE_STRING);
            $factorbs    = filter_input(INPUT_POST, 'factor', FILTER_SANITIZE_STRING);

            if ($seleccion == 1) {

                $monto = convertir_a_float($monto);

                if ($monto <= 0)
                    $this->array_errors[] = 'EL monto debe ser mayor que cero.';

                $factor = 1;
                $cuenta = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid,cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id = $descontar")->row();
                $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                $divisa = $this->ingresosegresos_model->obtenerDivisa(2);
                $divisab = $this->ingresosegresos_model->obtenerDivisa(1);

                $total = $saldo['bc_saldo'] - $monto;
                $tcm = $cuenta['cmp_saldo'] - $monto;

                $cuenta_destino = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid,cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id = $agregar")->row();
                $saldo_destino = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta_destino['cmp_cueid']}")->row();

                if ($monto > round($saldo['bc_saldo'], 2))
                    $this->array_errors[] = 'Saldo insuficiente.';

                if ($this->div_master['div_id'] != $divisa['div_id']) {
                    $data_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], 2);
                    if (!$data_factor) {
                        $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa' . $divisa['div_nombre'] . ' y la divisa predeterminada ' . $this->div_master['div_nombre'];
                    } else {
                        $factor = $data_factor['df_factor'];
                    }
                }

                $conversion = round($monto / $factor, 2);

                if (empty($this->array_errors)) {

                    $movimiento = new MovimientoModel();

                    try {

                        $movimiento->transactionBegin();

                        $movimiento->guardar([
                            'fab_divisa'            => 2,
                            'fab_metodo'            => $cuenta['cmp_mdid'],
                            'fab_cmpid'             => $descontar,
                            'fab_monto'             => $monto * -1,
                            'fab_factor'            => $factor,
                            'fab_conversion'        => $conversion * -1,
                            'fab_divid_conversion'  => 2,
                            'fab_factor_master'     => $factor,
                            'fab_empid'             => $_SESSION['user_data']['emp_id'],
                            'fab_modulo'            => 'venta',
                            'fab_descripcion'       => "Venta de dolares",
                            'fab_observacion'       => 'Egreso por venta de dolares por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo VENTA DE DOLARES. a la cuenta destino ' . $saldo_destino['bc_alias'],
                            'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                            'fab_categoria'         => 24,
                            'fab_saldo_anterior'    => $saldo['bc_saldo']
                        ]);

                        $movimiento->pagarCuenta($cuenta['cmp_cueid'], $total);
                        $movimiento->pagarCuentaMetodo($cuenta['cmp_mdid'], $tcm);

                        $data_factorcp = $this->ingresosegresos_model->divisaFactor(2, 1);
                        //$factorcp = $data_factorcp['df_factor'];
                        $factorcp = $factorbs;
                        $montob = convertir_a_float($monto * $factorcp);

                        $conversioncp = round($montob / $factorcp);
                        $total_destino = $saldo_destino['bc_saldo'] + $montob;
                        $tcm_destino = $cuenta_destino['cmp_saldo'] + $montob;


                        $movimiento->guardar([
                            'fab_divisa'            => 1,
                            'fab_metodo'            => $cuenta_destino['cmp_mdid'],
                            'fab_cmpid'             => $agregar,
                            'fab_monto'             => $montob,
                            'fab_factor'            => $factorcp,
                            'fab_conversion'        => $conversioncp,
                            'fab_divid_conversion'  => 2,
                            'fab_factor_master'     => $factorcp,
                            'fab_empid'             => $_SESSION['user_data']['emp_id'],
                            'fab_modulo'            => 'venta',
                            'fab_descripcion'       => "Venta de dolares",
                            'fab_observacion'       => 'Ingreso por venta de dolares por el monto en $' . $monto . '= ' . Moneda::moneda($montob, $divisab['div_locale'], $divisab['div_simbolo'])  . ' del modulo VENTA DE DOLARES. desde la cuenta origen ' . $saldo['bc_alias'],
                            'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                            'fab_categoria'         => 24,
                            'fab_saldo_anterior'    => $saldo_destino['bc_saldo']
                        ]);

                        $movimiento->pagarCuenta($cuenta_destino['cmp_cueid'], $total_destino);
                        $movimiento->pagarCuentaMetodo($cuenta_destino['cmp_mdid'], $tcm_destino);

                        $movimiento->transactionCommit();
                    } catch (\Throwable $th) {
                        $movimiento->transactionRollBack();
                        $this->array_errors[] = 'Error en transacción';
                    }

                    if (empty($this->array_errors)) {
                        Http::json_response(true);
                    }
                }
                Http::json_response(['errors' => $this->array_errors]);
            } else {
                $monto = convertir_a_float($monto);

                if ($monto <= 0)
                    $this->array_errors[] = 'EL monto debe ser mayor que cero.';

                $factor = 1;
                $cuenta = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid,cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id = $descontar")->row();
                $saldo = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                $divisa = $this->ingresosegresos_model->obtenerDivisa(2);
                $divisab = $this->ingresosegresos_model->obtenerDivisa(1);


                $cuenta_destino = $this->ingresosegresos_model->consultar("SELECT cmp_saldo, cmp_cueid,cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id = $agregar")->row();
                $saldo_destino = $this->ingresosegresos_model->consultar("SELECT bc_saldo, bc_alias FROM app_bancos_cuentas WHERE bc_id = {$cuenta_destino['cmp_cueid']}")->row();

                if ($monto > round($saldo['bc_saldo'], 2))
                    $this->array_errors[] = 'Saldo insuficiente.';

                if ($this->div_master['div_id'] != $divisa['div_id']) {
                    $data_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], 2);
                    if (!$data_factor) {
                        $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa' . $divisa['div_nombre'] . ' y la divisa predeterminada ' . $this->div_master['div_nombre'];
                    } else {
                        $factor = $data_factor['df_factor'];
                    }
                }

                $conversion = round($monto / $factor, 2);

                if (empty($this->array_errors)) {

                    $movimiento = new MovimientoModel();

                    try {

                        $movimiento->transactionBegin();

                        $data_factorcp = $this->ingresosegresos_model->divisaFactor(2, 1);
                        // $factorcp = $data_factorcp['df_factor'];
                        $factorcp = $factorbs;
                        $montob = convertir_a_float($monto * $factorcp);
                        $total = $saldo['bc_saldo'] - $montob;
                        $tcm = $cuenta['cmp_saldo'] - $montob;

                        $conversioncp = round($montob / $factorcp);


                        $movimiento->guardar([
                            'fab_divisa'            => 1,
                            'fab_metodo'            => $cuenta['cmp_mdid'],
                            'fab_cmpid'             => $descontar,
                            'fab_monto'             => $montob * -1,
                            'fab_factor'            => $factorcp,
                            'fab_conversion'        => $conversioncp * -1,
                            'fab_divid_conversion'  => 2,
                            'fab_factor_master'     => $factorcp,
                            'fab_empid'             => $_SESSION['user_data']['emp_id'],
                            'fab_modulo'            => 'venta',
                            'fab_descripcion'       => "Compra de dolares",
                            'fab_observacion'       => 'Egreso por compra de dolares por el monto en $' . $monto . ' =' . Moneda::moneda($montob, $divisab['div_locale'], $divisab['div_simbolo'])  . ' del modulo COMPRA DE DOLARES. a la cuenta destino ' . $saldo_destino['bc_alias'],
                            'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                            'fab_categoria'         => 10,
                            'fab_saldo_anterior'    => $saldo['bc_saldo']
                        ]);

                        $movimiento->pagarCuenta($cuenta['cmp_cueid'], $total);
                        $movimiento->pagarCuentaMetodo($cuenta['cmp_mdid'], $tcm);

                        $total_destino = $saldo_destino['bc_saldo'] + $monto;
                        $tcm_destino = $cuenta_destino['cmp_saldo'] + $monto;


                        $movimiento->guardar([
                            'fab_divisa'            => 2,
                            'fab_metodo'            => $cuenta_destino['cmp_mdid'],
                            'fab_cmpid'             => $agregar,
                            'fab_monto'             => $monto,
                            'fab_factor'            => $factor,
                            'fab_conversion'        => $monto,
                            'fab_divid_conversion'  => 2,
                            'fab_factor_master'     => $factor,
                            'fab_empid'             => $_SESSION['user_data']['emp_id'],
                            'fab_modulo'            => 'venta',
                            'fab_descripcion'       => "Compra de dolares",
                            'fab_observacion'       => 'Ingreso por Compra de dolares por el monto de ' . Moneda::moneda($monto, $divisa['div_locale'], $divisa['div_simbolo'])  . ' del modulo VENTA DE DOLARES. desde la cuenta origen ' . $saldo['bc_alias'],
                            'fab_fecha'             => $fecha . ' ' . date('H:i:s'),
                            'fab_categoria'         => 10,
                            'fab_saldo_anterior'    => $saldo_destino['bc_saldo']
                        ]);

                        $movimiento->pagarCuenta($cuenta_destino['cmp_cueid'], $total_destino);
                        $movimiento->pagarCuentaMetodo($cuenta_destino['cmp_mdid'], $tcm_destino);

                        $movimiento->transactionCommit();
                    } catch (\Throwable $th) {
                        $movimiento->transactionRollBack();
                        $this->array_errors[] = 'Error en transacción';
                    }

                    if (empty($this->array_errors)) {
                        Http::json_response(true);
                    }
                }
                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function searc($valor, $array)
    {
        foreach ($array as $key => $val) {
            if ($val['id'] === $valor) {
                return $key;
            }
        }
        return 'vacio';
    }

    public function productosVendidosComprasMes()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio   = filter_input(INPUT_GET, 'anio', FILTER_SANITIZE_NUMBER_INT);
            $div_id = filter_input(INPUT_GET, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_GET, 'sucursal', FILTER_SANITIZE_NUMBER_INT);

            if (empty($anio))
                $anio = date('Y');

            if (empty($this->array_errors)) {

                $array_notas        = [];
                $array_notas_id     = [];
                $artic_total        = 0;
                $costo              = 0;
                $venta              = 0;
                $ganancia           = 0;
                $porcentaje         = 0;
                $array_notas_proid  = [];
                $array_compras_proidNo = [];
                $array_compra_proidDisp  = [];

                $productos =  $this->ingresosegresos_model->obtenerProductos();

                if (is_countable($productos) && count($productos)) {

                    foreach ($productos as $pro) {
                        $array_compra_proidmes = [];

                        $notas = $this->ingresosegresos_model->obtenerProduccionNEVMesCompras($anio, $div_id, $sucursal, $pro['pro_id']);
                        $ordenes = $this->ingresosegresos_model->obtenerProduccionORDENMesCompras($anio, $div_id, $sucursal, $pro['pro_id']);
                        $facturas = $this->ingresosegresos_model->obtenerProduccionFACVMesCompras($anio, $div_id, $sucursal, $pro['pro_id']);
                        $divisa = $this->ingresosegresos_model->obtenerDivisa($div_id);
                        $compras = $this->ingresosegresos_model->obtenerFacturasCompras($pro['pro_id'], $anio);

                        if (is_countable($facturas) && count($facturas)) {

                            foreach ($facturas as $row) {

                                if ((!in_array($row['mes'], $array_notas_id))) {

                                    if ($row['total_venta'] > 0) {

                                        if ($this->div_master['div_id'] != $div_id) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                            $row['total_costo'] *= $div_factor['df_factor'];
                                        }

                                        $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                                    } else {
                                        $porc = 0;
                                    }

                                    foreach ($compras as $row1) {

                                        if (($this->searc(strval($row1['codigo'] . $row['producto']), $array_compra_proidDisp) === 'vacio') && ($this->searc(strval($row1['codigo'] . $row['producto']), $array_compras_proidNo) === 'vacio')) {
                                            $cant = convertir_a_float($row1['cmpart_procantidad']);

                                            if ($cant > 0) {
                                                if ($cant == convertir_a_float($row['cantidad'])) {
                                                    $array_compras_proidNo[] = [
                                                        'id'       => $row1['codigo'] . $row['producto'],
                                                        'activo'   => 'inactivo',
                                                        'cantidad' => $cant,
                                                        'correlativo' => $row1['cmp_correlativo'],
                                                        'codigo' => $row1['codigo'],
                                                    ];
                                                    $array_compra_proidmes[$row['mes'] . $row['producto']] = [
                                                        'correlativo' => $row1['cmp_correlativo'],
                                                        'uri'         => ruta_base() . 'cmpfacturaeditar/verFactura/' .  $row1['codigo'],
                                                        'codigo' => $row1['codigo'],
                                                    ];

                                                    $array_compra_proidDisp[] = [
                                                        'cantidad' => 0,
                                                        'id' => $row1['codigo'] . $row['producto'],
                                                    ];
                                                } else {
                                                    $r = ($cant - convertir_a_float($row['cantidad']) > 0) ? ($cant - convertir_a_float($row['cantidad'])) : 0;
                                                    if ($r > 0) {
                                                        $array_compras_proidNo[] = [
                                                            'id' => $row1['codigo'] . $row['producto'],
                                                            'activo' => 'activo',
                                                            'cantidad' => $r,
                                                            'correlativo' => $row1['cmp_correlativo'],
                                                            'codigo' => $row1['codigo'],
                                                        ];
                                                    } else {
                                                        $array_compras_proidNo[] = [
                                                            'id' => $row1['codigo'] . $row['producto'],
                                                            'activo' => 'inactivo',
                                                            'cantidad' => $r,
                                                            'correlativo' => $row1['cmp_correlativo'],
                                                            'codigo' => $row1['codigo'],
                                                        ];
                                                    }

                                                    $array_compra_proidmes[$row['mes'] . $row['producto']] = [
                                                        'correlativo' => $row1['cmp_correlativo'],
                                                        'uri'         => ruta_base() . 'cmpfacturaeditar/verFactura/' .  $row1['codigo'],
                                                        'codigo' => $row1['codigo'],
                                                    ];

                                                    $array_compra_proidDisp[] = [
                                                        'cantidad' => $r,
                                                        'id' => $row1['codigo'] . $row['producto'],
                                                    ];
                                                }
                                            }
                                        } else {
                                            if (($this->searc(strval($row1['codigo'] . $row['producto']), $array_compra_proidDisp) >= 0)) {
                                                $key = $this->searc(strval($row1['codigo'] . $row['producto']), $array_compra_proidDisp);
                                                $cant = convertir_a_float($array_compra_proidDisp[$key]['cantidad']);

                                                if ($cant > 0) {
                                                    $key2 = $this->searc(strval($row1['codigo'] . $row['producto']), $array_compras_proidNo);
                                                    $act = $array_compras_proidNo[$key2]['activo'];
                                                    $r = ($cant - convertir_a_float($row['cantidad']) > 0) ? ($cant - convertir_a_float($row['cantidad'])) : 0;
                                                    if (($r > 0) && ($act === 'activo')) {
                                                        $array_compra_proidDisp[$key]['cantidad'] = $r;
                                                        $array_compras_proidNo[$key2]['activo'] = 'activo';
                                                    } else {
                                                        $array_compra_proidDisp[$key]['cantidad'] = $r;
                                                        $array_compras_proidNo[$key2]['activo'] = 'inactivo';
                                                    }
                                                } else {
                                                    $array_compra_proidmes = [];
                                                }
                                            }
                                        }
                                    }

                                    $dta = [];
                                    $dta[$row['producto']] = [
                                        'cantidad'      => $row['cantidad'],
                                        'div_locale'    => $divisa['div_locale'],
                                        'div_simbolo'   => $divisa['div_simbolo'],
                                        'mes'           => $row['mes'],
                                        'costo'         => $row['total_costo'],
                                        'venta'         => $row['total_venta'],
                                        'ganancia'      => $row['total_venta'] - $row['total_costo'],
                                        'porcentaje'    => $porc,
                                        'id'            => $pro['pro_id'],
                                        'producto'      => $pro['pro_descripcion'] . '-' . $pro['pro_nombrecorto'],
                                        'sucursal'      => $row['su_nombre'],
                                        'facturas'      => $array_compra_proidmes
                                    ];

                                    // $data[$row['producto']] = $dta;

                                    //if ((!in_array($row['mes'] . $row['producto'], $array_notas_proid))) {
                                    $array_notas[$row['mes']] = [
                                        'productos'     => $dta,
                                        'mes'           => $row['mes'],
                                    ];

                                    $array_notas_id[] = $row['mes'];
                                    $array_notas_proid[] = $row['mes'] . $row['producto'];
                                    //}
                                } else {

                                    if ($row['total_venta'] > 0) {

                                        if ($this->div_master['div_id'] != $div_id) {
                                            $div_factor = $this->ingresosegresos_model->divisaFactor($this->div_master['div_id'], $div_id);
                                            $row['total_costo'] *= $div_factor['df_factor'];
                                        }

                                        $porc = round((($row['total_venta'] - $row['total_costo']) * 100 / $row['total_venta']), 2);
                                    } else {
                                        $porc = 0;
                                    }

                                    foreach ($compras as $row1) {

                                        if (($this->searc(strval($row1['codigo'] . $row['producto']), $array_compra_proidDisp) === 'vacio') && ($this->searc(strval($row1['codigo'] . $row['producto']), $array_compras_proidNo) === 'vacio')) {
                                            $cant = convertir_a_float($row1['cmpart_procantidad']);

                                            if ($cant > 0) {
                                                if ($cant == convertir_a_float($row['cantidad'])) {
                                                    $array_compras_proidNo[] = [
                                                        'id'       => $row1['codigo'] . $row['producto'],
                                                        'activo'   => 'inactivo',
                                                        'cantidad' => $cant,
                                                        'correlativo' => $row1['cmp_correlativo'],
                                                        'codigo' => $row1['codigo'],
                                                    ];
                                                    $array_compra_proidmes[$row['mes'] . $row['producto']] = [
                                                        'correlativo' => $row1['cmp_correlativo'],
                                                        'uri'         => ruta_base() . 'cmpfacturaeditar/verFactura/' .  $row1['codigo'],
                                                        'codigo' => $row1['codigo'],
                                                    ];

                                                    $array_compra_proidDisp[] = [
                                                        'cantidad' => 0,
                                                        'id' => $row1['codigo'] . $row['producto'],
                                                    ];
                                                } else {
                                                    $r = ($cant - convertir_a_float($row['cantidad']) > 0) ? ($cant - convertir_a_float($row['cantidad'])) : 0;
                                                    if ($r > 0) {
                                                        $array_compras_proidNo[] = [
                                                            'id' => $row1['codigo'] . $row['producto'],
                                                            'activo' => 'activo',
                                                            'cantidad' => $r,
                                                            'correlativo' => $row1['cmp_correlativo'],
                                                            'codigo' => $row1['codigo'],
                                                        ];
                                                    } else {
                                                        $array_compras_proidNo[] = [
                                                            'id' => $row1['codigo'] . $row['producto'],
                                                            'activo' => 'inactivo',
                                                            'cantidad' => $r,
                                                            'correlativo' => $row1['cmp_correlativo'],
                                                            'codigo' => $row1['codigo'],
                                                        ];
                                                    }

                                                    $array_compra_proidmes[$row['mes'] . $row['producto']] = [
                                                        'correlativo' => $row1['cmp_correlativo'],
                                                        'uri'         => ruta_base() . 'cmpfacturaeditar/verFactura/' .  $row1['codigo'],
                                                        'codigo' => $row1['codigo'],
                                                    ];

                                                    $array_compra_proidDisp[] = [
                                                        'cantidad' => $r,
                                                        'id' => $row1['codigo'] . $row['producto'],
                                                    ];
                                                }
                                            }
                                        } else {
                                            if (($this->searc(strval($row1['codigo'] . $row['producto']), $array_compra_proidDisp) >= 0)) {
                                                $key = $this->searc(strval($row1['codigo'] . $row['producto']), $array_compra_proidDisp);
                                                $cant = convertir_a_float($array_compra_proidDisp[$key]['cantidad']);

                                                if ($cant > 0) {
                                                    $key2 = $this->searc(strval($row1['codigo'] . $row['producto']), $array_compras_proidNo);
                                                    $act = $array_compras_proidNo[$key2]['activo'];
                                                    $r = ($cant - convertir_a_float($row['cantidad']) > 0) ? ($cant - convertir_a_float($row['cantidad'])) : 0;
                                                    if (($r > 0) && ($act === 'activo')) {
                                                        $array_compra_proidDisp[$key]['cantidad'] = $r;
                                                        $array_compras_proidNo[$key2]['activo'] = 'activo';
                                                    } else {
                                                        $array_compra_proidDisp[$key]['cantidad'] = $r;
                                                        $array_compras_proidNo[$key2]['activo'] = 'inactivo';
                                                    }
                                                } else {
                                                    $array_compra_proidmes = [];
                                                }
                                            }
                                        }
                                    }

                                    if ((!in_array($row['mes'] . $row['producto'], $array_notas_proid))) {


                                        $array_notas[$row['mes']]['productos'][$row['producto']] =
                                            [
                                                'cantidad'      => $row['cantidad'],
                                                'div_locale'    => $divisa['div_locale'],
                                                'div_simbolo'   => $divisa['div_simbolo'],
                                                'mes'           => $row['mes'],
                                                'costo'         => $row['total_costo'],
                                                'venta'         => $row['total_venta'],
                                                'ganancia'      => $row['total_venta'] - $row['total_costo'],
                                                'porcentaje'    => $porc,
                                                'producto'      => $pro['pro_descripcion'] . '-' . $pro['pro_nombrecorto'],
                                                'id'            => $pro['pro_id'],
                                                'sucursal'      => $row['su_nombre'],
                                                'facturas'      => $array_compra_proidmes
                                            ];

                                        $array_notas_proid[] = $row['mes'] . $row['producto'];
                                    } else {


                                        if ((in_array($row['mes'] . $row['producto'], $array_notas_proid))) {
                                            $array_notas[$row['mes']]['productos'][$row['producto']]['cantidad'] += $row['cantidad'];
                                            $array_notas[$row['mes']]['productos'][$row['producto']]['costo']      += $row['total_costo'];
                                            $array_notas[$row['mes']]['productos'][$row['producto']]['venta']      += $row['total_venta'];
                                            $array_notas[$row['mes']]['productos'][$row['producto']]['ganancia']   += $row['total_venta'] - $row['total_costo'];
                                            $array_notas[$row['mes']]['productos'][$row['producto']]['porcentaje'] += $porc;
                                            $array_notas[$row['mes']]['productos'][$row['producto']]['facturas'] = $array_compra_proidmes;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                if ($costo > 0 && $venta > 0) {
                    $ganancia = $venta - $costo;
                    $porcentaje = round((($ganancia) * 100 / $venta), 2);
                }

                Http::json_response([
                    'costo'         => Moneda::moneda($costo, $divisa['div_locale'], $divisa['div_simbolo']),
                    'venta'         => Moneda::moneda($venta, $divisa['div_locale'], $divisa['div_simbolo']),
                    'ganancia'      => Moneda::moneda($ganancia, $divisa['div_locale'], $divisa['div_simbolo']),
                    'porcentaje'    => round($porcentaje),
                    'art_total'     => $artic_total,
                    'meses'         => $array_notas,
                    'ddd'           => $array_compra_proidDisp
                ]);
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }
}
