<div class="card" id="appImpuestos" v-cloak>
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Listado de Impuestos</div>
            <div class="card-tools">
                <a href="#" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" @click.prevent="modalImpuesto">
                    <span class="btn-label">
                        <i class="fa fa-plus"></i>
                    </span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm" id="tabla_impuestos">
                <thead>
                    <tr class="border-0">
                        <th>Código</th>
                        <th>Descripción</th>
                        <th>Valor</th>
                        <th class="text-center">Retención</th>
                        <th class="text-center">Estatus</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in impuestos">
                        <td>{{ row.imp_codigo }}</td>
                        <td>{{ row.imp_descripcion }}</td>
                        <td class="text-right">{{ row.imp_valor }} %</td>
                        <td class="text-center ">
                            <span v-if="row.imp_retencion == 1">SI</span>
                            <span v-else>NO</span>
                        </td>
                        <td class="text-center">
                            <a href="#" title="Modificar estatus" @click.prevent="modificarEstatus(row.imp_id, 'estatus'+row.imp_id)">
                                <i :class="row.imp_estatus == 1 ? 'fa fa-check text-success' : 'fa fa-times text-danger'" :id="'estatus'+row.imp_id"></i>
                            </a>
                        </td>
                        <td class="text-center">
                            <div class="form-button-action">
                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row.imp_id, row.imp_codigo, row.imp_descripcion, row.imp_valor, row.imp_retencion)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminar(row.imp_id, row.imp_codigo)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php include 'modaleditarguardar.php'; ?>
</div>
<script src="<?= ruta_base()  ?>public/assetsvuejs/impuestos/impuestos.js"></script>
