<?php

namespace App\Controladores;

use App\Modelos\Impuesto;
use Core\Controller;
use Core\Librerias\Http;
use Core\Vista;

final class ImpuestosControlador extends Controller
{
    private $impuesto;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->impuesto = new Impuesto();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            return Vista::viewAJAX('impuestos/index');
        }
    }

    public function obtenerImpuesto(int $id_impuesto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id_impuesto, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->impuesto->obtenerImpuesto($id));
        }
    }

    public function getImpuestos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->impuesto->where(['imp_id!=' => 2]));
        }
    }

    public function obtenerImpuestos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->impuesto->obtenerImpuestos());
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $imp_codigo         = $this->solicitud->sanitize($_POST['ci'], FILTER_SANITIZE_STRING);
                $imp_valor          = filter_input(INPUT_POST, 'vi', FILTER_SANITIZE_STRING) ?? 0;
                $imp_descripcion    = $this->solicitud->sanitize($_POST['di'], FILTER_SANITIZE_STRING);
                $imp_retencion      = filter_input(INPUT_POST, 'ri', FILTER_SANITIZE_NUMBER_INT) ?? 0;

                if (empty($imp_codigo))
                    $this->array_errors[] = 'El campo Codigo es requerido';
                if (empty($imp_descripcion))
                    $this->array_errors[] = 'El campo Descripcion es requerido';

                if (empty($this->array_errors)) {

                    if (empty($_POST['id'])) {
                        if ($this->impuesto->where(['imp_codigo' => $imp_codigo], true))
                            $this->array_errors[] = 'El código ya se encuentra en uso';
                        if ($this->impuesto->where(['imp_valor' => $imp_valor], true))
                            $this->array_errors[] = 'El valor ya se encuentra en uso';

                        if (empty($this->array_errors)) {
                            Http::json_response($this->impuesto->guardar([
                                'imp_codigo' => $imp_codigo,
                                'imp_valor' => convertir_a_float($imp_valor),
                                'imp_descripcion' => $imp_descripcion,
                                'imp_retencion' => $imp_retencion
                            ], true));
                        }
                    } else {
                        $imp_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                        if ($this->impuesto->where(['imp_id!=' => $imp_id, 'imp_codigo' => $imp_codigo], true))
                            $this->array_errors[] = 'El código ya se encuentra en uso';
                        if ($this->impuesto->where(['imp_id!=' => $imp_id, 'imp_valor' => $imp_valor], true))
                            $this->array_errors[] = 'El código ya se encuentra en uso';

                        if (empty($this->array_errors)) {
                            Http::json_response($this->impuesto->editar($imp_id, [
                                'imp_codigo' => $imp_codigo,
                                'imp_valor' => convertir_a_float($imp_valor),
                                'imp_descripcion' => $imp_descripcion,
                                'imp_retencion' => $imp_retencion
                            ]));
                        }
                    }
                }

                Http::json_response(['errors' => $this->array_errors]);
            } else {
                Http::json_response(['errors' => ['Usted no es administrador']]);
            }
        }
    }

    public function modificarEstatus(int $imp_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $imp_id  = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            if ($this->impuesto->existe('imp_id', $imp_id)) {
                $estatus = $this->impuesto->obtener($imp_id);
                if ($estatus['imp_estatus']) {
                    try {
                        $this->impuesto->transactionBegin();
                        $this->impuesto->editar($imp_id, ['imp_estatus' => 0]);
                        $this->impuesto->actualizarEstatusTodos($imp_id, 0);
                        $this->impuesto->transactionCommit();
                    } catch (\Throwable $th) {
                        $this->impuesto->transactionRollBack();
                        $this->array_errors[] = 'Error al actualizar estatus';
                    }
                } else {
                    try {
                        $this->impuesto->transactionBegin();
                        $this->impuesto->editar($imp_id, ['imp_estatus' => 1]);
                        $this->impuesto->actualizarEstatusTodos($imp_id, 0);
                        $this->impuesto->transactionCommit();
                    } catch (\Throwable $th) {
                        $this->impuesto->transactionRollBack();
                        $this->array_errors[] = 'Error al actualizar estatus';
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response(true);
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminar(int $id_impuesto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id  = filter_var($id_impuesto, FILTER_SANITIZE_NUMBER_INT);

            if ($this->impuesto->existe('imp_id', $id) && $id != 2) {
                if ($this->impuesto->comprobarImpuesto($id)) {
                    $this->array_errors[] = 'Lo siento el impuesto no se puede eliminar ya esta siendo usado';
                } else {
                    Http::json_response($this->impuesto->eliminar($id));
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
