<form action="#" autocomplete="off" @submit.prevent="guardarEditar" id="modal_form_impresoras">
    <div class="modal fade" id="modal-impresora" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h5 class="modal-title">{{ titulo }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="impr-codigo">Código</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-hashtag"></i>
                                </span>
                            </div>
                            <input type="text" id="impr-codigo" class="form-control" v-model="dataForm.codigo" v-mask="'XXXXXXXXXXXXXXXXXXXX'" @keyup="dataForm.codigo=dataForm.codigo.toUpperCase()">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="impr-descripcion">Descripción:</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-pencil-alt"></i>
                                </span>
                            </div>
                            <input type="text" id="impr-descripcion" class="form-control" v-model="dataForm.descripcion" @keyup="dataForm.descripcion=dataForm.descripcion.toUpperCase()">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="impr-descripcion">IP:</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-wifi"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="impr-ip" class="form-control" v-model="dataForm.ip">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="impr-descripcion">Puerto:</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-wifi"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="impr-puerto" class="form-control" v-model="dataForm.puerto" v-mask="'####'">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="impresoras">Tipo</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-question-circle"></i>
                                        </span>
                                    </div>
                                    <select id="impr-series" class="form-control custom-select" v-model="dataForm.tipo">
                                        <option value="" disabled selected>Seleccionar un elemento</option>
                                        <option :value="1">Fiscal</option>
                                        <option :value="2">Ticket</option>
                                        <option :value="3">Punto</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="impresoras">Series</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-sort-alpha-down"></i>
                                        </span>
                                    </div>
                                    <select id="impr-series" class="form-control custom-select" v-model="dataForm.serie">
                                        <option value="" disabled>Seleccionar un Serie</option>
                                        <option v-for="row in series" :value="row.ser_id">{{ row.ser_descripcion }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group" v-if="dataForm.tipo==1">
                        <label for="impresoras">Limite</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-stop-circle"></i>
                                </span>
                            </div>
                            <input type="number" class="form-control" v-model="dataForm.limite">
                        </div>
                    </div>
                    <div class="form-check" v-if="dataForm.tipo==1">
                        <label class="form-check-label">
                            <input type="checkbox" v-model="dataForm.quitardecimal" id="pro_publico" class="form-check-input">
                            <span class="form-check-sign">Redondear</span>
                        </label>
                    </div>
                    <div class="form-check" v-if="dataForm.tipo==2">
                        <label class="form-check-label">
                            <input type="checkbox" v-model="dataForm.usdticket" id="pro_publico" class="form-check-input">
                            <span class="form-check-sign">Imprimir USD</span>
                        </label>
                    </div>
                    <div class="form-row" v-if="dataForm.tipo==2">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="impresoras">Mensaje footer</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-question-circle"></i>
                                        </span>
                                    </div>
                                    <textarea id="impr-footer" class="form-control" v-model="dataForm.footer"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary  btn-sm">{{ accion }}</button>
                </div>
            </div>
        </div>
    </div>
</form>