<div class="card" id="appImpresoras">
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Listado de impresoras</div>
            <div class="card-tools">
                <a href="#" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" @click.prevent="modalImpresora"><span class="btn-label"><i class="fa fa-plus"></i></span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Codigo</th>
                        <th>Impresora</th>
                        <th>IP</th>
                        <th>Puerto</th>
                        <th>Serie</th>
                        <th>Tipo</th>
                        <th class="text-center">Estatus</th>
                        <th class="text-center">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in impresoras">
                        <td>{{ row.codigo }}</td>
                        <td>{{ row.descripcion }}</td>
                        <td>{{ row.ip }}</td>
                        <td>{{ row.puerto }}</td>
                        <td>{{ row.serie_descripcion }}</td>
                        <td>{{ row.tipo_nombre }}</td>
                        <td class="text-center">
                            <button class="btn btn-icon btn-link" data-toggle="tooltip" title="Cambiar estatus" data-original-title="Cambiar estatus" @click="cambiarEstatus(row)">
                                <i class="fa" :class="[row.estatus == 1 ?  'fa-check text-success' : 'fa-ban text-danger']"></i>
                            </button>
                        </td>
                        <td class="text-center">
                            <div class="form-button-action">
                            <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminar(row)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php include 'modal_editar_guardar.php'; ?>
</div>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assetsvuejs/impresoras/impresoras.js'); ?>"></script>
