<?php

namespace App\Controladores;

use App\Modelos\Impresoras;
use Core\Controller;
use Core\Librerias\Http;
use Core\Vista;

final class ImpresorasControlador extends Controller
{
    private $newImpresoras;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->newImpresoras = new Impresoras();
    }

    public function index()
    {
        Vista::viewAJAX('impresoras/index');
    }

    public function obtenerImpresoras()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_impresoras = [];
            $impresoras = $this->newImpresoras->obtenerImpresoras();

            if (is_countable($impresoras) && count($impresoras)) {

                foreach ($impresoras as $row) {

                    switch ($row['imp_tipo']) {
                        case 1:
                            $tipo = 'Fiscal';
                            break;
                        case 2:
                            $tipo = 'Ticket';
                            break;
                        default:
                            $tipo = 'Punto';
                            break;
                    }

                    $list_impresoras[] = [
                        'id' => $row['imp_id'],
                        'codigo' => $row['imp_codigo'],
                        'descripcion' => $row['imp_descripcion'],
                        'ip' => $row['imp_ip'],
                        'puerto' => $row['imp_puerto'],
                        'serie_id' => $row['imp_serid'],
                        'serie_descripcion' => $row['ser_descripcion'],
                        'tipo' => $row['imp_tipo'],
                        'tipo_nombre' => $tipo,
                        'estatus' => $row['imp_estatus'] ? true : false,
                        'limite'  =>  $row['imp_limite'],
                        'redondear' => $row['imp_redondear']==1?true:false,
                        'usdticket'=> $row['imp_usd']==1?true:false,
                        'footer'=>$row['imp_descripcion_final']
                    ];
                }
            }

            Http::json_response($list_impresoras);
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                if (empty($_POST['codigo']))
                    $this->array_errors[] = "El campo Código es obligatorio.";
                if (empty($_POST['descripcion']))
                    $this->array_errors[] = "El campo Descripción es obligatorio.";
                if (empty($_POST['ip']))
                    $this->array_errors[] = "El campo IP es obligatorio.";
                if (empty($_POST['puerto']))
                    $this->array_errors[] = "El campo Puerto es obligatorio.";
                if (empty($_POST['serie']))
                    $this->array_errors[] = "El campo Serie es obligatorio.";
                if (empty($_POST['tipo']))
                    $this->array_errors[] = "El campo Tipo es obligatorio.";

                if (empty($this->array_errors)) {

                    $imp_codigo = $this->solicitud->sanitize($_POST['codigo'], FILTER_SANITIZE_STRING);
                    $imp_descripcion = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);
                    $imp_serid = $this->solicitud->sanitize($_POST['serie'], FILTER_SANITIZE_NUMBER_INT);
                    $imp_ip = $this->solicitud->sanitize($_POST['ip']);
                    $imp_puerto = $this->solicitud->sanitize($_POST['puerto'], FILTER_SANITIZE_NUMBER_INT);

                    $imp_tipo = $this->solicitud->sanitize($_POST['tipo'], FILTER_VALIDATE_INT, array("options" => array("min_range" => 1, "max_range" => 2)));
                    $imp_limite = $this->solicitud->sanitize($_POST['limite'], FILTER_VALIDATE_INT);
                    $quitardecimal = ('true' == filter_input(INPUT_POST, 'quitardecimal')) ? 1 : 0;
                    $usdticket = ('true' == filter_input(INPUT_POST, 'usdticket')) ? 1 : 0;
                    $footer = $this->solicitud->sanitize($_POST['footer'], FILTER_SANITIZE_STRING);
                    
                    if ($imp_tipo == false) {
                        $this->array_errors[] = 'El campo tipo es incorrecto';
                    }

                    if (empty($this->array_errors)) {

                        $data_form = [
                            'imp_codigo' => $imp_codigo,
                            'imp_descripcion' => $imp_descripcion,
                            'imp_ip' => $imp_ip,
                            'imp_puerto' => $imp_puerto,
                            'imp_serid' => $imp_serid,
                            'imp_tipo' => $imp_tipo,
                            'imp_empid' => $_SESSION['user_data']['emp_id'],
                            'imp_limite' =>  $imp_limite,
                            'imp_redondear'=> $quitardecimal,
                            'imp_usd'=> $usdticket,
                            'imp_descripcion_final'=>$footer
                        ];

                        if (empty($_POST['id'])) {

                            $existe = $this->newImpresoras->consultar("SELECT imp_id FROM app_impresoras WHERE imp_codigo = '$imp_codigo'")->row();

                            if ($existe) {
                                $this->array_errors[] = "El codigo $imp_codigo ya se encuentra en uso";
                            } else {

                                if ($this->newImpresoras->guardar($data_form, true)) {
                                    Http::json_response(true);
                                } else {
                                    Http::json_response(false);
                                }
                            }
                        } else {

                            $imp_id = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);

                            if ($this->newImpresoras->existe('imp_id', $imp_id)) {

                                $repite_codigo = $this->newImpresoras->consultar("SELECT imp_id FROM app_impresoras WHERE imp_codigo = '$imp_codigo' AND imp_id != $imp_id")->row();

                                if ($repite_codigo) {
                                    $this->array_errors[] = "El codigo $imp_codigo ya se encuentra en uso";
                                } else {
                                    if ($this->newImpresoras->editar($imp_id, $data_form)) {
                                        Http::json_response(true);
                                    } else {
                                        Http::json_response(false);
                                    }
                                }
                            } else {
                                Http::json_response(false);
                            }
                        }
                    }
                }

                Http::json_response(['errors' => $this->array_errors]);
            } else {
                Http::json_response(['errors' => 'Usted no es administrador']);
            }
        }
    }

    public function cambiarEstatus(int $imp_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $imp_id = $this->solicitud->sanitize($imp_id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->newImpresoras->existe('imp_id', $imp_id)) {

                $data_impresora = $this->newImpresoras->obtener($imp_id);

                $res = $this->newImpresoras->editar($imp_id, [
                    'imp_estatus' => $data_impresora['imp_estatus'] ? 0 : 1
                ]);

                if ($res) {
                    Http::json_response(true);
                } else {
                    Http::json_response(false);
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    public function eliminar(int $imp_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $imp_id = $this->solicitud->sanitize($imp_id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->newImpresoras->existe('imp_id', $imp_id)) {

                $existe_foraneo = $this->newImpresoras->consultar("SELECT caj_id FROM app_cajas WHERE caj_impresora = $imp_id")->row();

                if ($existe_foraneo) {
                    $this->array_errors[] = 'Lo siento no puede eliminar la impresora ya que esta asociada a un caja';
                } else {
                    Http::json_response($this->newImpresoras->eliminar($imp_id));
                }
            } else {
                Http::json_response(false);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
