<?php

namespace App\Modelos;

use Core\Database;

class Grupos extends Database
{
    protected $table    = 'app_clientes_grupos';
    protected $id       = 'grup_id';

    public function grupoDiferente($condicion)
    {
        return $this->consultar("SELECT * FROM app_clientes_grupos WHERE $condicion")->all();
    }

    public function estatus($id)
    {
        return $this->consultar("SELECT * FROM app_clientes_grupos WHERE grup_id=$id")->row();
    }

    public function modificarEstatus($id, $estatus)
    {
        return $this->consultar("UPDATE app_clientes_grupos SET grup_estatus=$estatus WHERE grup_id=$id")->run();
    }

    public function chequearForaneo($id_grupo)
    {
        return $this->consultar("SELECT * FROM app_clientes WHERE cli_grupid=$id_grupo")->row();
    }

    public function listaCliente($id_grupo)
    {
        return $this->consultar("SELECT * FROM app_clientes WHERE cli_grupid=$id_grupo")->all();
    }

    public function obtenerDatosEmpresa()
    {
        return $this->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();
    }
}
