<?php

namespace App\Controladores;

use Core\Librerias\Solicitud;
use Core\ManejadorSession;
use Core\Vista;
use App\Modelos\Generico;
use Core\Librerias\GoogleAuthenticator;

final class GoogleControlador
{
    public function index()
    {
        if (!isset($_SESSION['user_data']['emp_id'])) {
            header('Location: ' . ruta_base());
        }

        exit(Vista::viewAJAX('google/googleauth', []));
    }

    public function acceso()
    {
        $solicitud = new Solicitud();
        $code = $solicitud->sanitize($_POST['code'], FILTER_VALIDATE_INT);

        return ManejadorSession::seleccionargoogleauth($code);
    }

    public function salir()
    {
        return ManejadorSession::destruirSession();
    }
}
