<style>
    .table td,
    .table th {
        padding: 0 30px !important;
        height: 30px;
    }

    .scroll {
        max-height: 400px;
        width: 100%;
        padding: 0px 5px 0 5px;
        margin: 0;
        overflow-y: scroll;
        overflow-x: hidden;
        scrollbar-color: rgba(103, 110, 117, 0.15) rgba(122, 128, 134, 0.05);
        scrollbar-width: thin;
    }

    .scroll::-webkit-scrollbar {
        -webkit-appearance: none;
    }

    .scroll::-webkit-scrollbar:vertical {
        width: 6px;
    }

    .scroll::-webkit-scrollbar-thumb {
        background: #ccc;
    }
</style>
<div class="container" id="appCarritoVer" v-cloak>
    <input type="hidden" value="<?= $cliente['cli_id'] ?>" id="id_cliente_fac">
    <input type="hidden" value="<?= $factura['fm_id'] ?>" id="id_fac">
    <div class="page-inner">
        <div class="row">
            <div class="col">
                <div class="d-flex justify-content-between">
                    <div class="col-5 pl-0 mr-3 row-card-no-pd" style="margin-bottom: 0; padding-top: 0; padding-bottom: 0">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread">
                                <div class="list-group-item-figure">
                                    <div class="avatar">
                                        <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($cliente['cli_razon_social'][0]) ?></span>
                                    </div>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h4 class="list-group-item-title">
                                                <span id="cabecera_cliente"><?= $cliente['cli_razon_social'] ?> <?= $cliente['cli_dni'] ?></span>
                                            </h4>
                                        </div>
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title text-warning">
                                                VENTAS - FACTURA <span class="text-danger">ANULADA</span>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-7 p-0">
                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" id="fecha" class="form-control" value="<?= date('Y-m-d', strtotime($factura['fm_fecha'])) ?>" disabled>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="almacen">Almacén</label>
                                    <select id="almacen" ref="almacen_predeterminado" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <?php foreach ($almacenes as $row) : ?>
                                            <option value="<?= $row['alm_id'] ?>" <?= ($factura['fm_almid'] == $row['alm_id']) ? 'selected' : '' ?>><?= $row['alm_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="divisa">Divisa</label>
                                    <select id="divisa" class="form-control" disabled>
                                        <option value="div_nombre_master">{{ div_nombre_master }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="serie">Serie</label>
                                    <select id="serie" v-model="serie_predeterminada" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <?php foreach ($series as $row) : ?>
                                            <option value="<?= $row['ser_id'] ?>"><?= $row['ser_descripcion'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="form-group">
                    <label>DESCRIPCIÓN DE ANULACIÓN</label>
                    <textarea class="form-control" rows="1" disabled><?= $factura['fm_observaciones'] ?></textarea>
                </div>
            </div>
            <div class="col-12 mt-3">
                <nav>
                    <div class="nav nav-tabs" role="tablist">
                        <a class="nav-item nav-link active" data-toggle="tab" href="#nav-lista" role="tab" aria-controls="nav-home" aria-selected="true">Productos <span class="badge badge-info ml-2"> #<?= $factura['fm_correlativo'] ?></span></a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-pagos" role="tab" aria-controls="nav-pagos" aria-selected="false"><i class="fas fa-file-invoice-dollar"></i> Pagos</a>
                    </div>
                </nav>
                <div class="tab-content mt-2">
                    <div class="tab-pane fade show active" id="nav-lista" role="tabpanel" aria-labelledby="nav-home-tab">
                        <div class="row row-card-no-pd">
                            <div class="col-12 mt-2">
                                <div class="col-12 mt-2 mb-2">
                                    <div class="d-flex justify-content-end">
                                        <div class="dropdown d-inline mr-3 mr-md-2">
                                            <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="<?= url('ventascaja') ?>" target="_blank" style="max-height: 2rem;"><i class="fas fa-reply"></i> Ventas</a>
                                            <button class="btn btn-info btn-round btn-sm dropdown-toggle" style="max-height: 2rem;" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Imprimir
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdf/<?= $factura['fm_id'] ?>" target="_blank">PDF completo</a>
                                                <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdfMP/<?= $factura['fm_id'] ?>" target="_blank">PDF media pagina</a>
                                                <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdfFMP/<?= $factura['fm_id'] ?>" target="_blank">PDF pagos</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="scroll" style="height: 300px;width: 100%;padding: 0;margin: 0;overflow-y: scroll;overflow-x: hidden;">
                                    <div class="table-responsive">
                                        <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="1" width="100%" tabindex="2">
                                            <thead>
                                                <tr class="text-center">
                                                    <th>Código</th>
                                                    <th>Artículo</th>
                                                    <th>Precio</th>
                                                    <th>Cantidad</th>
                                                    <th>% Dcto.</th>
                                                    <th>Neto</th>
                                                    <th>IVA</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="(row, index) in carrito" class="text-right">
                                                    <td class="text-center">{{ row.codigo }}</td>
                                                    <td class="text-left">{{ row.nombre }}</td>
                                                    <td width="8%"><input type="text" class="form-control text-right border-dark" v-model="row.precio" disabled></td>
                                                    <td width="8%"><input type="text" class="form-control text-right border-dark" v-model.number="row.cantidad" disabled></td>
                                                    <td width="8%"><input type="text" class="form-control text-right border-dark" v-model.number="row.descuento" disabled></td>
                                                    <td width="8%">{{ row.neto }}</td>
                                                    <td width="8%">
                                                        <select id="impuestos" class="form-control text-center input-border-bottom" v-model="row.id_iva" disabled>
                                                            <?php foreach ($impuestos as $row) : ?>
                                                                <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td width="10%" class="text-right">{{ row.total }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row row-card-no-pd">
                            <div class="col-12" style="padding-left: 30%;">
                                <div class="table-responsive ">
                                    <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="2" width="100%" tabindex="2">
                                        <thead>
                                            <tr class="text-right">
                                                <th>Subtotal</th>
                                                <th>Dto. %</th>
                                                <th>Neto</th>
                                                <th>IVA</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="text-right">
                                                <td width="20%">{{ subtotal }}</td>
                                                <td width="20%"><input type="text" class="form-control text-right border-dark" v-model.number="descuento" disabled></td>
                                                <td width="20%">{{ neto }}</td>
                                                <td width="20%">{{ iva }}</td>
                                                <td width="20%">{{ total }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-pagos" role="tabpanel" aria-labelledby="nav-pagos-tab">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-bordered-bd-black mt-3">
                                                <thead>
                                                    <tr>
                                                        <th>Fecha</th>
                                                        <th>Divisa</th>
                                                        <th>Total</th>
                                                        <th>Restante</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>{{ factura.fecha }}</td>
                                                        <td>{{ div_nombre_master }}</td>
                                                        <td>{{ moneda(total, div_locale, div_simbolo) }}</td>
                                                        <td>{{ moneda(restante_original, div_locale, div_simbolo) }}</td>
                                                        <td class="text-center"><a href="#">Pagar</a></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-bordered-bd-black mt-3">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Fecha</th>
                                                <th>Cuenta</th>
                                                <th>Metodo</th>
                                                <th>Monto</th>
                                                <th>factor</th>
                                                <th>Conversion</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in abonos" :class="[(row.fab_retiro==1) ? 'bg-danger': '']">
                                                <td class="text-center">
                                                    <a v-if="row.fab_retiro==0" href="#">
                                                        <i class="fa fa-trash text-danger"></i>
                                                    </a>
                                                </td>
                                                <td>{{ row.fab_fecha }}</td>
                                                <td>{{ row.bc_alias }} {{ row.bc_tipo }}</td>
                                                <td>{{ row.mp_nombre }}</td>
                                                <td>{{ row.fab_monto }}</td>
                                                <td>{{ row.fab_factor }}</td>
                                                <td>{{ row.fab_conversion }}</td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th class="text-right">Total</th>
                                                <th>{{ total_pagado }}</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalcorreo.php'; ?>
</div>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assets/vue-select.js') ?>"></script>
<script src="<?= ruta_base() ?>public/assets/underscore-min.js"></script>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assets/v-money.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/facturacioncaja/anulado.js"></script>
