<div class="container" id="appCarrito" v-cloak>
    <input type="hidden" value="<?= $cliente['cli_id'] ?>" id="id_cliente_fac">
    <input type="hidden" id="ruta_documento" value="facturacioncaja">
    <div class="page-inner">
        <div class="row">
            <div class="col">
                <div class="d-flex justify-content-between">
                    <div class="col-5 pl-0 row-card-no-pd" style="margin-bottom: 0; padding-top: 0; padding-bottom: 0">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread">
                                <div class="list-group-item-figure">
                                    <div class="avatar">
                                        <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($cliente['cli_razon_social'][0]) ?></span>
                                    </div>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h4 class="list-group-item-title">
                                                <span id="cabecera_cliente"><?= $cliente['cli_razon_social'] ?> <?= $cliente['cli_dni'] ?></span>
                                                <a href="#" data-toggle="modal" data-target="#modal_buscar_cliente_generico"><span class="fa fa-edit"></span></a>
                                            </h4>
                                        </div>
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title text-warning">
                                                VENTAS - NUEVA FACTURA
                                                <div class="<?= ($doc_pendientes > 1) ? 'text-danger' : 'text-dark' ?>">
                                                    <small>Pendientes: <?= $doc_pendientes ?></small>
                                                    <?php if ($cliente['grup_id']) : ?>
                                                        <small> Venta Al <?= $cliente['grup_nombre'] ?> <?= $cliente['grup_descuento'] ?>%</small>
                                                    <?php endif; ?>
                                                </div>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-7 p-0">
                        <div class="row">
                            <div class="col">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" id="fecha" class="form-control" value="<?= date('Y-m-d') ?>">
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="almacen">Almacén</label>
                                    <select id="almacen" ref="almacen_predeterminado" class="form-control" @change="cambiarAlmacen">
                                        <?php foreach ($almacenes as $row) : ?>
                                            <option value="<?= $row['alm_id'] ?>" <?= ($row['alm_master']) ? 'selected' : '' ?>><?= $row['alm_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="divisa">Divisa</label>
                                    <select id="divisa" ref="divisa_predeterminada" @change="predeterminarDivisa" class="form-control">
                                        <?php foreach ($divisas as $row) : ?>
                                            <option value="<?= $row['div_id'] ?>" <?= ($row['div_facturar'] == 1) ? 'selected' : '' ?>><?= $row['div_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col">
                                <div class="form-group">
                                    <label for="serie">Serie</label>
                                    <select id="serie" ref="serie_predeterminada" class="form-control">
                                        <option disabled value="">Seleccione un elemento</option>
                                        <?php foreach ($series as $row) : ?>
                                            <option value="<?= $row['ser_id'] ?>"><?= $row['ser_descripcion'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-3">
                <nav>
                    <div class="nav nav-tabs" role="tablist">
                        <a class="nav-item nav-link active" data-toggle="tab" href="#nav-lista" role="tab" aria-controls="nav-home" aria-selected="true">Productos <span class="badge badge-info ml-2">{{ articulosTotal }}</span></a>
                    </div>
                </nav>
                <div class="tab-content mt-2">
                    <div class="tab-pane fade show active" id="nav-lista" role="tabpanel" aria-labelledby="nav-home-tab">
                        <div class="row row-card-no-pd">
                            <div class="col-12 mt-2">
                                <div class="col-12 mt-2 mb-2" style="padding-left: 0px;">
                                    <div class="d-flex justify-content-between">
                                        <div class="suiche">
                                            <label for="" class="etiqueta icon-preview"><i class="fas fa-barcode"></i></label>
                                            <input type="checkbox" v-model="toggleBarcode" id="switch" @change="focusBuuscar">
                                            <label for="switch" class="lbl"></label>
                                        </div>
                                        <div class="col pl-0">
                                            <div class="input-icon">
                                                <span class="input-icon-addon" data-toggle="modal" data-target="#modal-precio-global">
                                                    <i :class="'fa fa-search'"></i>
                                                </span>
                                                <input type="text" id="buscador" class="form-control" placeholder="buscar productos" @input="buscarProducto" @keydown="seleccionarProducto">
                                            </div>
                                        </div>
                                        <button type="button" class="btn btn-primary btn-round" disabled v-if="cargando">
                                            <i class="loader loader-info"></i>
                                        </button>
                                        <button type="button" class="btn btn-info btn-sm btn-round" v-else @click="guardarFactura" style="max-height: 2rem;">Guardar</button>
                                    </div>
                                </div>
                                <div class="scroll" style="height: 300px;width: 100%;padding: 0;margin: 0;overflow-y: scroll;overflow-x: hidden;">
                                    <div class="table-responsive">
                                        <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="1" width="100%" tabindex="2">
                                            <thead>
                                                <tr class="text-center">
                                                    <th></th>
                                                    <th>Código</th>
                                                    <th>Artículo</th>
                                                    <th>Precio Unit.</th>
                                                    <th>Cantidad</th>
                                                    <th>% Dcto.</th>
                                                    <th>Neto</th>
                                                    <th>IVA</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in carrito" class="text-right">
                                                    <td class="text-center">
                                                        <a href="#" @click.prevent="eliminarProducto(row.unique)">
                                                            <i class="fa fa-trash text-danger"></i>
                                                        </a>
                                                    </td>
                                                    <td class="text-center">{{ row.codigo }}</td>
                                                    <td>{{ row.nombre }}</td>
                                                    <td width="13%">{{ moneda(row.precio, money.locale, money.prefix, money.precision) }}</td>
                                                    <td width="7%"><input type="text" class="form-control text-right" style="border-color: #bbb; background-color:#fff;" v-model="row.cantidad" @keyup.prevent="actualizarCantidad(row.id, $event)"></td>
                                                    <td width="7%" @click="modalDescuento(row.unique, row.descuento)">{{ row.descuento }}</td>
                                                    <td width="12%">{{ moneda(row.neto, money.locale, money.prefix, money.precision) }}</td>
                                                    <td width="7%">
                                                        <select id="impuestos" class="form-control text-center input-border-bottom" v-model="row.id_iva" disabled>
                                                            <?php foreach ($impuestos as $row) : ?>
                                                                <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td width="12%" class="text-right">{{ moneda(row.total, money.locale, money.prefix, money.precision) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row row-card-no-pd">
                            <div class="col-12" style="padding-left: 30%;">
                                <div class="table-responsive ">
                                    <table class="bg-white table-bordered-bd-black" cellspacing="1" cellpadding="2" width="100%" tabindex="2">
                                        <thead>
                                            <tr class="text-center">
                                                <th>Subtotal</th>
                                                <th>% Dcto.</th>
                                                <th>Neto</th>
                                                <th>IVA</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="text-right">
                                                <td width="20%">{{ moneda(subtotal, money.locale, money.prefix, money.precision) }}</td>
                                                <td class="text-center" width="20%">{{ descuento }}</td>
                                                <td width="20%">{{ moneda(neto, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%">{{ iva }}</td>
                                                <td width="20%">{{ moneda(total, money.locale, money.prefix, money.precision) }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3 row-card-no-pd">
                            <div class="col">
                                <div class="form-group form-group-default">
                                    <label>Observaciones</label>
                                    <textarea class="form-control" v-model="observaciones" rows="3"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app/notasdeentregacajaeditar/vista/modal_descuento.php' ?>
</div>
<link rel="stylesheet" href="<?= asset('assets/buscadorProductos.css') ?>">
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/facturacioncaja/crear.js') ?>"></script>
<?php include 'app/notasdeentrega/vista/guardar_cambiar_cliente.php' ?>
