<div class="row">
    <div class="col-lg-4">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscarVentaDia($event)" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group form-floating-label">
                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="pvfecha_desde" class="placeholder">Fecha (Dia)</label>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group input-group form-floating-label">
                                <select id="vddocumentodia" class="form-control input-border-bottom" v-model="documento">
                                    <option value="0">Todas</option>
                                    <option value="2">Facturas</option>
                                    <option value="1">Notas de Entrega</option>
                                    <option value="12">Orden de Entrega</option>
                                </select>
                                <label for="vddocumento" class="placeholder">Documento</label>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisasdia" class="form-control input-border-bottom" v-model="divisa">
                                    <option value="0">Todas</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pvdivisas" class="placeholder">Divisa</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="row" style="align-items: center;">
            <div class="col-lg-8">
                <div class="row">
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6 col-sm-4 col-lg-6">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="h1 m-0"> <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else> {{ cantidad_artdia }} </span>
                                        </div>
                                        <div class="text-muted mb-3">Articulos</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-sm-4 col-lg-6">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="h1 m-0">
                                            <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else> {{ artic_totaldia }}</span>
                                        </div>
                                        <div class="text-muted mb-3">Articulos vendidos</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="row">
                            <div class="col-6 col-sm-4 col-lg-6">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="h1 m-0">
                                            <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else>{{ acumuladodia }}</span>
                                        </div>
                                        <div class="text-muted mb-3">Total acumulado</div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 col-sm-4 col-lg-6">
                                <div class="card">
                                    <div class="card-body p-3 text-center">
                                        <div class="h1 m-0">
                                            <i class="loader loader-success" v-if="cargando"></i>
                                            <span v-else>{{ pendientedia }}</span>
                                        </div>
                                        <div class="text-muted mb-3">Total pendiente</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="col-lg-12 col-sm-9 col-lg-12">
                    <div class="card">
                        <div class="card-body p-3 text-center">
                            <div class="icon-big text-center" style="font-size: 25px;">
                                <i class="flaticon-coins text-success"></i>
                            </div>
                            <div class="h1 m-0">
                                <i class="loader loader-success" v-if="cargando"></i>
                                <span v-else>{{ totaldia }}</span>
                            </div>
                            <div class="text-muted mb-3">Total</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_venta_dia">
                        <thead>
                            <tr class="text-center">
                                <th style="width: 10%;">Código</th>
                                <th style="width: 20%;">Cliente</th>
                                <th>Acumulado</th>
                                <th>Pendiente</th>
                                <th>Total</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productosVendidoDia">
                                <td class="text-center"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                <td class="text-left">{{ row.cliente }}</td>
                                <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ fechaNormal(row.fecha) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>