<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscarVentapordia($event)" id="form_dia_busqueda">
                    <div class="form-row">
                        <div class="col-sm-3">
                            <div class="form-group form-floating-label">
                                <input id="dia_anio" type="text" class="form-control input-border-bottom" v-model.number="anio">
                                <label for="dia_anio" class="placeholder">Año</label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group input-group form-floating-label">
                                <select id="dia_meses" class="form-control input-border-bottom" v-model="mes">
                                    <option value="01">Enero</option>
                                    <option value="02">Febrero</option>
                                    <option value="03">Marzo</option>
                                    <option value="04">Abril</option>
                                    <option value="05">Mayo</option>
                                    <option value="06">Junio</option>
                                    <option value="07">Julio</option>
                                    <option value="08">Agosto</option>
                                    <option value="09">Septiembre</option>
                                    <option value="10">Octubre</option>
                                    <option value="11">Noviembre</option>
                                    <option value="12">Diciembre</option>
                                </select>
                                <label for="dia_meses" class="placeholder">Mes</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="dia_divisas" class="form-control input-border-bottom" v-model="divisa">
                                    <option value="0">Todas</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="dia_divisas" class="placeholder">Divisa</label>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <div class="form-group">
                                    <button type="submit" class="btn btn-border btn-info btn-sm mr-2">Buscar</button>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :cargando="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_dias">
                        <thead>
                            <tr>
                                <th class="text-center">Día</th>
                                <th class="text-center">Cant. Art</th>
                                <th class="text-center">Costo</th>
                                <th class="text-center">Venta</th>
                                <th class="text-center">Ganancia</th>
                                <th class="text-center">% Ganancia</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in dias_ventas">
                                <td class="text-center">{{ row.dia }}</td>
                                <td class="text-center">{{ row.cantidad }}</td>
                                <td class="text-right">{{ moneda(row.costo, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.venta, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ decimal(row.porcentaje, row.div_locale) }}%</td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="text-center">Total</th>
                                <th class="text-center">{{ art_total_D }}</th>
                                <th class="text-right">{{ costo_D }}</th>
                                <th class="text-right">{{ venta_D }}</th>
                                <th class="text-right">{{ ganancia_D }}</th>
                                <th class="text-right">{{ porcentaje_D }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>