<div class="row">
    <div class="col-lg-6">
        <div class="row">
            <div class="col-lg-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <div class="card-head-row">
                            <div class="card-title">
                                Cierre de día Ingresos</div>
                                <div class="card-tools">
                                    <input type="date" class="form-control" v-model="fecha_desde" @change="buscarCierreDelDia">
                                    <button @click="modalImprimirCierre('positivo')" class="btn-light btn btn-sm mt-2" style="Float:right; max-height: 2rem;">Imprimir</button>
                                    <button @click="modalImprimirCierre('completo')" class="btn-light btn btn-sm mt-2" style="Float:right; max-height: 2rem;">Imprimir cierre completo</button>
                                </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="row row-card-no-pd">
                    <div class="col-sm-6 col-md-4" v-for="row in total_divisas_p">
                        <div class="card card-stats card-round">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-3">
                                        <div class="icon-big text-center">
                                            <i class="flaticon-coins text-success"></i>
                                        </div>
                                    </div>
                                    <div class="col-9 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">{{ row.divisa.divisa }}</p>
                                            <h4 class="card-title">
                                                {{ moneda(row.total, row.divisa.locale, row.divisa.symbol)  }}
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-head-bg-primary table-bordered-bd-primary" id="tabla_cierre_dia_ingreso">
                                <thead>
                                    <tr>
                                        <th>CUENTA</th>
                                        <th>METODO/DIVISA</th>
                                        <th>TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in cierres_del_dia.positivo">
                                        <td><small class="text-primary">CAJERO: {{ row.empleado.nombres + ' ' + row.empleado.apellidos }}</small> {{ row.banco.cuenta }} | {{ row.banco.alias }} </td>
                                        <td>{{ row.banco.metodo }} / {{ row.divisa }}</td>
                                        <td>{{ row.monto }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="row">
            <div class="col-lg-12">
                <div class="card card-warning">
                    <div class="card-header">
                        <div class="card-head-row">
                            <div class="card-title">
                                Cierre de día Egresos
                            </div>
                            <div class="card-tools">
                            <input type="date" class="form-control" v-model="fecha_desde" @change="buscarCierreDelDia">
                            <button @click="modalImprimirCierre('negativo')" class="btn-light btn btn-sm mt-2" style="Float:right; max-height: 2rem;">Imprimir</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="row row-card-no-pd">
                    <div class="col-sm-6 col-md-4" v-for="row in total_divisas_n">
                        <div class="card card-stats card-round">
                            <div class="card-body ">
                                <div class="row">
                                    <div class="col-3">
                                        <div class="icon-big text-center">
                                            <i class="flaticon-coins text-success"></i>
                                        </div>
                                    </div>
                                    <div class="col-9 col-stats">
                                        <div class="numbers">
                                            <p class="card-category">{{ row.divisa.divisa }}</p>
                                            <h4 class="card-title">
                                                {{ moneda(row.total, row.divisa.locale, row.divisa.symbol)  }}
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover table-head-bg-primary table-bordered-bd-primary" id="tabla_cierre_dia_egreso">
                                <thead>
                                    <tr>
                                        <th>CUENTA</th>
                                        <th>METODO/DIVISA</th>
                                        <th>TOTAL</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in cierres_del_dia.negativo">
                                        <td><small class="text-primary">CAJERO: {{ row.empleado.nombres + ' ' + row.empleado.apellidos }}</small> {{ row.banco.codigo }} | {{ row.banco.cuenta }} | {{ row.banco.alias }} </td>
                                        <td>{{ row.banco.metodo }} / {{ row.divisa }}</td>
                                        <td>{{ row.monto }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>