<form autocomplete="off" @submit.prevent="pagar">
    <div class="modal fade" id="modal_crear_credito" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header border-top-0 border-bottom-0">
                    Nuevo Credito
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body border-top-0">
                    <div class="form-row">
                        <div class="col-12 mb-3">
                            <div class="form-group">
                                <small class="form-text text-muted">Nº DOCUMENTO / RAZÓN SOCIAL</small>
                                <v-select id="buscar_cliente_credito" v-model="selected_cli" label="cliente" :filterable="false" :options="clientes" @search="onSearch">
                                    <template slot="no-options">
                                        Escribe para buscar el cliente
                                    </template>
                                    <template slot="option" slot-scope="option">
                                        <div class="d-flex ml-0 pl-0">
                                            <div class="avatar ml-0 pl-0">
                                                <span class="avatar-title rounded-circle border border-white bg-info ml-0 pl-0" style="width: 40px; height: 40px;">{{ option.cliente.charAt() }}</span>
                                            </div>
                                            <div class="flex-1 pt-1 ml-2">
                                                <h6 class="fw-bold mb-1">{{ option.cliente.toUpperCase() }}</h6>
                                            </div>
                                        </div>
                                    </template>
                                    <template slot="selected-option" slot-scope="option" alt="avatar">
                                        <div class="avatar">
                                            <span class="avatar-title rounded-circle border border-white bg-info" style="width: 40px; height: 40px;">{{ option.cliente.charAt() }}</span>
                                        </div>
                                        {{ option.cliente.toUpperCase() }}
                                    </template>
                                </v-select>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="serie" id="pagarserie">
                                    <option disabled value="">&nbsp;</option>
                                    <?php foreach ($series as $row) : ?>
                                        <option value="<?= $row['ser_id'] ?>"><?= $row['ser_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pagarserie" class="placeholder">Serie</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="divisa_pagar" id="pagardivisa" @change="obtenerMetodosSegunDivisa">
                                    <option disabled value="">&nbsp;</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pagardivisa" class="placeholder">Divisa</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="metodo_pagar" id="pagarmetodo" @change="obtenerCuentasSegunMetodo">
                                    <option disabled value="">&nbsp;</option>
                                    <option v-for="row in metodos_de_pagos" :value="row.id">{{ row.metodo }}</option>
                                </select>
                                <label for="pagarmetodo" class="placeholder">Metodo de pago</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="cuenta_pagar" id="pagarcuenta">
                                    <option disabled value="">&nbsp;</option>
                                    <option v-for="row in cuentas" :value="row.id">{{ row.cuenta }}</option>
                                </select>
                                <label for="pagarcuenta" class="placeholder">Cuenta</label>
                            </div>
                            <div class="form-group">
                                <label for="pagarmonto" class="placeholder">Monto</label>
                                <input id="pagarmonto" type="text" class="form-control input-border-bottom" v-money="money" v-model="monto">
                            </div>
                            <div class="form-group">
                                <label for="pagardescripcion" class="placeholder">Descripción</label>
                                <textarea id="pagardescripcion" class="form-control" v-model="pagardescripcion"></textarea>
                            </div>
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                            <div class="col mt-3">
                                <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                                    <i class="loader loader-info"></i>
                                </button>
                                <button type="submit" id="btn_pagar" class="btn btn-primary btn-round btn-block" v-else>pagar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
