<style>
    .table>tbody>tr>td {
        font-size: 11px;
    }
</style>
<div class="container" v-cloak id="appFactura">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Ventas</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('facturacion') ?>">Ventas</a>
                </li>
            </ul>
            <div class="ml-md-auto">
                <?php if ($opbuscarenfacturas) : ?>
                    <a href="#" class="btn btn-info btn-round btn-sm mr-2" @click.prevent="modalLineas"> <span class="flaticon-search-2"></span> Buscar en Facturas</a>
                <?php endif; ?>
                <a href="#" class="btn btn-secondary btn-round btn-sm mr-2" data-toggle="modal" data-target="#modal-precio-global"> <span class="fas fa-question-circle"></span> Consultar Precio</a>
                <?php if ($opfactor) : ?>
                    <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="#" style="max-height: 2rem;" data-target="#modal-divisas" data-toggle="modal"><i class="fa fa-balance-scale"></i> Factor</a>
                <?php endif; ?>
                <div class="dropdown d-inline mr-3 mr-md-2">
                    <button class="btn btn-info btn-sm btn-border btn-round dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Acciones
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <?php if ($opfabricantes) : ?>
                            <a class="dropdown-item" href="<?= url('fabricantes') ?>">Fabricantes</a>
                        <?php endif; ?>
                        <?php if ($opproveedores) : ?>
                            <a class="dropdown-item" href="<?= url('proveedores') ?>">Proveedores</a>
                        <?php endif; ?>
                        <?php if ($opcategorias) : ?>
                            <a class="dropdown-item" href="<?= url('categorias') ?>">Categorías</a>
                        <?php endif; ?>
                        <?php if ($optarifas) : ?>
                            <a class="dropdown-item" href="<?= url('tarifas') ?>">Tarifas</a>
                        <?php endif; ?>
                        <?php if ($opalmacenes) : ?>
                            <a class="dropdown-item" href="<?= url('almacenes') ?>">Almacenes</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 mt-2">
                <div class="d-flex align-items-left flex-column">
                    <div class="nav-scroller d-flex">
                        <div class="nav nav-line d-flex align-items-center justify-contents-center">
                            <a class="nav-link active" data-toggle="pill" href="#ventas_documentos" role="tab" aria-controls="ventas_documentos" aria-selected="true" style="padding: 0px 0px 20px 0 !important;">Documentos</a>
                            <a class="nav-link " data-toggle="pill" href="#reportes_venta" role="tab" aria-controls="reportes_venta" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="buscarVentaDia()">Reportes</a>
                        </div>
                        <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                            <select id="sucursal" class="form-control custom-select" v-model="sucursal_predeterminada" @change="actualizarDatos()" :disabled="disabled" onchange="obtenerIngresosDiarios()">
                                <option disabled value="">Seleccione un elemento</option>
                                <?php if ($todosucursales) : ?>
                                    <option value="0">Sucursal (Todas)</option>
                                <?php endif; ?>
                                <option v-for="row in sucursales_empleado" :value="row.su_id">Sucursal ({{row.su_nombre}})</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="tab-content mt-4">
                    <div class="tab-pane fade show active" id="ventas_documentos">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="row">
                                    <div class="col-lg-6 form-group">
                                        <select name="mes" class="form-control custom-select" v-model="mes" @change="actualizarDatos()">
                                            <option value="0"> Mes (Todos)</option>
                                            <option value="01">Mes (Enero)</option>
                                            <option value="02">Mes (Febrero)</option>
                                            <option value="03">Mes (Marzo)</option>
                                            <option value="04">Mes (Abril)</option>
                                            <option value="05">Mes (Mayo)</option>
                                            <option value="06">Mes (Junio)</option>
                                            <option value="07">Mes (Julio)</option>
                                            <option value="08">Mes (Agosto)</option>
                                            <option value="09">Mes (Septiembre)</option>
                                            <option value="10">Mes (Octubre)</option>
                                            <option value="11">Mes (Noviembre)</option>
                                            <option value="12">Mes (Diciembre)</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-6 form-group">
                                        <select name="anio" class="form-control custom-select" v-model="anio" @change="actualizarDatos()">
                                            <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                if ($m == date('o')) {
                                                    echo '<option value="' . $m . '" selected>Año ' . $m . '</option>';
                                                } else {
                                                    echo '<option value="' . $m . '">Año ' . $m . '</option>';
                                                }
                                            }
                                            ?>
                                        </select>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="row row-card-no-pd">
                                            <div class="col-sm-6 col-md-6">
                                                <div class="card card-stats card-round">
                                                    <div class="card-body ">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <div class="icon-big text-center">
                                                                    <i class="fas fa-file-invoice-dollar text-secondary"></i>
                                                                </div>
                                                            </div>
                                                            <div class="col-8 col-stats" style="padding-left: 0px;padding-right: 10px;">
                                                                <div class="numbers">
                                                                    <p class="card-category">Facturas pendientes</p>
                                                                    <h4 class="card title" style="font-size: 2.2em;">
                                                                        {{ facturasNoPagas }}
                                                                    </h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="card card-stats card-round">
                                                    <div class="card-body ">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <div class="icon-big text-center">
                                                                    <i class="fas fa-file-invoice text-secondary"></i>
                                                                </div>
                                                            </div>
                                                            <div class="col-8 col-stats" style="padding-left: 0px;padding-right: 10px;">
                                                                <div class="numbers">
                                                                    <p class="card-category" style="font-size: 13px;">Notas de Entrega pendientes</p>
                                                                    <h4 class="card title" style="font-size: 2.2em;">
                                                                        {{ notasdeentregaNoPagas }}
                                                                    </h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="card card-stats card-round">
                                                    <div class="card-body ">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <div class="icon-big text-center">
                                                                    <i class="fas fa-file-signature text-secondary"></i>
                                                                </div>
                                                            </div>
                                                            <div class="col-8 col-stats" style="padding-left: 0px;padding-right: 10px;">
                                                                <div class="numbers">
                                                                    <p class="card-category">Presupuestos pendientes</p>
                                                                    <h4 class="card title" style="font-size: 2.2em;">
                                                                        {{ presupuestosNoPagas }}
                                                                    </h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6 col-md-6">
                                                <div class="card card-stats card-round">
                                                    <div class="card-body ">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <div class="icon-big text-center">
                                                                    <i class="fas fa-file-import text-secondary"></i>

                                                                </div>
                                                            </div>
                                                            <div class="col-8 col-stats" style="padding-left: 0px;padding-right: 10px;">
                                                                <div class="numbers">
                                                                    <p class="card-category">Pedidos pendientes</p>
                                                                    <h4 class="card title" style="font-size: 2.2em;">
                                                                        {{ pedidosNoPagas }}
                                                                    </h4>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="card full-height">
                                    <div class="card-body">
                                        <canvas id="ventasSemanales" height="230"></canvas>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="row row-card-no-pd">
                                    <div class="col-12 col-md-2">
                                        <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" id="v-pills-tab-with-icon" role="tablist" aria-orientation="vertical">
                                            <?php if ($opnotasentrgas) : ?>
                                                <a class="nav-link active" data-toggle="pill" href="#Notasentrega" role="tab" aria-controls="Notasentrega" aria-selected="true" @click.prevent="obtenerNotasdeEntrega()">
                                                    Notas de Entrega
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($opfacturas) : ?>
                                                <a class="nav-link" data-toggle="pill" href="#Facturas" role="tab" aria-controls="Facturas" aria-selected="false" @click.prevent="obtenerFacturasTodas()">
                                                    Facturas
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($oppresupuestos) : ?>
                                                <a class="nav-link" data-toggle="pill" href="#Presupuestos" role="tab" aria-controls="Presupuestos" aria-selected="false" @click.prevent="obtenerPresupuestoTodas()">
                                                    Presupuestos
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($oppedidos) : ?>
                                                <a class="nav-link" data-toggle="pill" href="#Pedidos" role="tab" aria-controls="Pedidos" aria-selected="false" @click.prevent="obtenerPedidosTodas()">
                                                    Pedidos
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($opnotascreditos) : ?>
                                                <a class="nav-link" data-toggle="pill" href="#NotasCredito" role="tab" aria-controls="NotasCredito" aria-selected="false" @click.prevent="obtenerCreditosTodas()">
                                                    Notas de Crédito
                                                </a>
                                            <?php endif; ?>
                                            <?php if ($opordendeentrega) : ?>
                                                <a class="nav-link" data-toggle="pill" href="#OrdendeEntrega" role="tab" aria-controls="OrdendeEntrega" aria-selected="false" @click.prevent="obtenerOrdendeEntrega()">
                                                    <?= $doc_generico['doc_descripcion'] ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-10">
                                        <div class="tab-content">
                                            <?php if ($opfacturas) : ?>
                                                <div class="tab-pane fade" id="Facturas">
                                                    <div class="card" :class="cargando_tabla">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#fac_pendientes" role="tab" aria-controls="fac_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;" @click="obtenerFacturasPendientes()">Pendientes ({{ facturasNoPagas }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#fac_pagas" role="tab" aria-controls="fac_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerFacturasPagadas()">Pagas ({{ facturasPagas }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#fac_anuladas" role="tab" aria-controls="fac_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerFacturasAnuladas()">Anuladas ({{ facturasAnuladas }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-round btn-sm" @click.prevent="modal_buscar_cliente('pos')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva Factura</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade" id="fac_pagas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_facturas_pagadas">
                                                                            <thead>
                                                                                <tr>
                                                                                    <th class="text-left buscar" style="width: 10%;">Código</th>
                                                                                    <th class="text-left buscar" style="width: 30%;">Nombre del Cliente</th>
                                                                                    <th class="buscar" style="width: 20%;">Total</th>
                                                                                    <th class="buscar">Fecha</th>
                                                                                    <th style="width: 15%;">Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade show active" id="fac_pendientes">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_facturas_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th style="width: 10%;">Código</th>
                                                                                    <th style="width: 30%;">Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right" style="font-size: 12px;"></th>
                                                                                    <th class="text-right" style="font-size: 12px;"></th>
                                                                                    <th class="text-right" style="font-size: 12px;"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="fac_anuladas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_facturas_anuladas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th class="text-left" style="width: 10%;">Código</th>
                                                                                    <th class="text-left" style="width: 30%;">Nombre del Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($opnotasentrgas) : ?>
                                                <div class="tab-pane fade show active" id="Notasentrega">
                                                    <div class="card" :class="cargando_tabla">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#notas_pendientes" role="tab" aria-controls="notas_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;" @click="obtenerNotasdeEntregaPendientes()">Pendientes ({{ notasdeentregaNoPagas }})</a>
                                                                        <a class="nav-link " data-toggle="pill" href="#notas_pagas" role="tab" aria-controls="notas_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerNotasdeEntregaPagadas()">Pagas ({{ notasdeentregaPagas }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#notas_anuladas" role="tab" aria-controls="notas_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerNotasdeEntregaAnuladas()">Anuladas ({{ notasdeentregaAnuladas }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-sm btn-round" @click.prevent="modal_buscar_cliente('notasdeentrega')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva Nota de Entrega</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade" id="notas_pagas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_notasdeentrega_pagadas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Nombre del Cliente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-left"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade show active" id="notas_pendientes">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_notasdeentrega_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th style="width: 35%;">Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th style="width: 6%;">Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="notas_anuladas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_notasdeentrega_anuladas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($oppedidos) : ?>
                                                <div class="tab-pane fade" id="Pedidos">
                                                    <div class="card" :class="cargando_tabla">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#pedidos_pendientes" role="tab" aria-controls="pedidos_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;" @click="obtenerPedidosPendientes()">Pendientes ({{ pedidosNoPagas }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#pedidos_pagas" role="tab" aria-controls="pedidos_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerPedidosPagadas()">Pagos ({{ pedidosPagas }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-sm btn-round" @click.prevent="modal_buscar_cliente('pedidos')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nuevo Pedido</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade" id="pedidos_pagas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_pedidos_pagadas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>

                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade show active" id="pedidos_pendientes">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_pedidos_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($oppresupuestos) : ?>
                                                <div class="tab-pane fade" id="Presupuestos">
                                                    <div class="card" :class="cargando_tabla">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#presupuesto_pendientes" role="tab" aria-controls="presupuesto_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;" @click="obtenerPresupuestoPendientes()">Pendientes ({{ presupuestosNoPagas }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#presupuesto_pagas" role="tab" aria-controls="presupuesto_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerPresupuestoPagadas()">Pagos ({{ presupuestosPagas }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-sm btn-round" @click.prevent="modal_buscar_cliente('presupuesto')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nuevo Presupuesto</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade" id="presupuesto_pagas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_presupuesto_pagadas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th style="width: 10%;">Código</th>
                                                                                    <th style="width: 60%;">Cliente</th>
                                                                                    <th style="width: 20%;">Total</th>
                                                                                    <th style="width: 10%;">Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade show active" id="presupuesto_pendientes">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_presupuesto_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($opnotascreditos) : ?>
                                                <div class="tab-pane fade" id="NotasCredito">
                                                    <div class="card" :class="cargando_tabla">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#creditos_activos" role="tab" aria-controls="creditos_activos" aria-selected="true" style="padding: 0px 0px 20px 0 !important;" @click="obtenerCredito_activos()">Activas ({{ creditosActivos }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#creditos_inactivos" role="tab" aria-controls="creditos_inactivos" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerCredito_inactivos()">Inactivas ({{ creditosInactivos }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <button class="btn btn-info btn-border btn-sm btn-round" @click="modalCrearCredito"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nuevo Crédito</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade show active" id="creditos_activos">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_creditos_activos">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Documento</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Restante</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Descripción</th>
                                                                                    <th>Acciones</th>
                                                                                </tr>
                                                                            </thead>

                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="creditos_inactivos">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_creditos_inactivos">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th>Documento</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Restante</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Descripción</th>
                                                                                    <th>Acción</th>
                                                                                </tr>
                                                                            </thead>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($opordendeentrega) : ?>
                                                <div class="tab-pane fade" id="OrdendeEntrega">
                                                    <div class="card" :class="cargando_tabla">
                                                        <div class="card-body">
                                                            <div class="d-flex align-items-left flex-column">
                                                                <div class="nav-scroller d-flex">
                                                                    <div class="nav nav-line d-flex align-items-center justify-contents-center">
                                                                        <a class="nav-link active" data-toggle="pill" href="#ordenes_pendientes" role="tab" aria-controls="ordenes_pendientes" aria-selected="true" style="padding: 0px 0px 20px 0 !important;" @click="obtenerOrdendeEntregaPendientes()">Pendientes ({{ ordenesPendientes }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#ordenes_creditos" role="tab" aria-controls="ordenes_creditos" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerOrdendeEntregaCreditos()">Creditos ({{ ordenesCreditos }})</a>
                                                                        <a class="nav-link " data-toggle="pill" href="#ordenes_pagas" role="tab" aria-controls="ordenes_pagas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerOrdendeEntregaPagadas()">Pagas ({{ ordenesPagas }})</a>
                                                                        <a class="nav-link" data-toggle="pill" href="#ordenes_anuladas" role="tab" aria-controls="ordenes_anuladas" aria-selected="false" style="padding: 0px 0px 20px 0 !important;" @click="obtenerOrdendeEntregaAnuladas()">Anuladas ({{ ordenesAnuladas }})</a>
                                                                    </div>
                                                                    <div class="d-flex d-md-inline ml-md-auto py-2 py-md-0">
                                                                        <a href="#" class="btn btn-info btn-border btn-sm btn-round" @click.prevent="modal_buscar_cliente('ordendeentrega')"> <span class="btn-label"> <i class="fa fa-plus"></i></span> Nueva <?= $doc_generico['doc_descripcion'] ?></a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-content mt-4">
                                                                <div class="tab-pane fade" id="ordenes_pagas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_ordenes_pagadas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th style="width: 10%;">Código</th>
                                                                                    <th style="width: 60%;">Planilla</th>
                                                                                    <th style="width: 50%;">Nombre del Cliente</th>
                                                                                    <th style="width: 20%;">Total</th>
                                                                                    <th style="width: 10%;">Fecha</th>
                                                                                    <th style="width: 10%;">Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade show active" id="ordenes_pendientes">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_ordenes_pendientes">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th style="width: 60%;">Planilla</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="ordenes_creditos">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_ordenes_creditos">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th style="width: 60%;">Planilla</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                    <th>Cambiar Estado</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                                <div class="tab-pane fade" id="ordenes_anuladas">
                                                                    <div class="table-responsive">
                                                                        <table class="display  table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table_ordenes_anuladas">
                                                                            <thead>
                                                                                <tr class="text-center">
                                                                                    <th>Código</th>
                                                                                    <th style="width: 60%;">Planilla</th>
                                                                                    <th>Cliente</th>
                                                                                    <th>Acumulado</th>
                                                                                    <th>Pendiente</th>
                                                                                    <th>Total</th>
                                                                                    <th>Fecha</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tfoot>
                                                                                <tr>
                                                                                    <th>Total:</th>
                                                                                    <th></th>
                                                                                    <th></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th class="text-right"></th>
                                                                                    <th></th>
                                                                                </tr>
                                                                            </tfoot>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="reportes_venta">

                        <div class="nav nav-pills nav-secondary d-flex align-items-center justify-contents-center mb-3">
                            <a class="nav-link active" data-toggle="pill" href="#ventadia" role="tab" aria-controls="ventadia" aria-selected="false">Ventas del día</a>
                            <?php if ($cierre_dia) : ?>
                                <a class="nav-link" data-toggle="pill" href="#cierredeldia" role="tab" aria-controls="cierredeldia" aria-selected="true" @click.prevent="buscarCierreDelDia()">Cierre del día</a>
                            <?php endif; ?>
                            <?php if ($reporte_proveedor) : ?>
                                <a class="nav-link" data-toggle="pill" href="#reporteproveedor" role="tab" aria-controls="reporteproveedor" aria-selected="false">Proveedores de los productos mas vendidos</a>
                            <?php endif; ?>
                            <?php if ($productos_vendidos) : ?>
                                <a class="nav-link" data-toggle="pill" href="#productos_vendidos" role="tab" aria-controls="productos_vendidos" aria-selected="false">Productos vendidos</a>
                            <?php endif; ?>
                            <?php if ($productos_vendidos_documentos) : ?>
                                <a class="nav-link" data-toggle="pill" href="#productos_vendidos_documentos" role="tab" aria-controls="productos_vendidos_documentos" aria-selected="false">Productos vendidos por documentos</a>
                            <?php endif; ?>
                            <?php if ($productos_vendidos_simples) : ?>
                                <a class="nav-link" data-toggle="pill" href="#productos_vendidos_simples" role="tab" aria-controls="productos_vendidos_simples" aria-selected="false">Productos vendidos simples</a>
                            <?php endif; ?>
                            <?php if ($venta_dias) : ?>
                                <a class="nav-link" data-toggle="pill" href="#dia" role="tab" aria-controls="dia" aria-selected="false">Total por ventas por días</a>
                            <?php endif; ?>
                            <?php if ($ventas_meses) : ?>
                                <a class="nav-link" data-toggle="pill" href="#mes" role="tab" aria-controls="mes" aria-selected="false">Total por ventas por meses</a>
                            <?php endif; ?>
                            <?php if ($cliente_cobrar) : ?>
                                <a class="nav-link" data-toggle="pill" href="#clipp" role="tab" aria-controls="clipp" aria-selected="false" @click.prevent="obtener_clpp()">Cli. Pendientes por cobrar</a>
                            <?php endif; ?>
                            <?php if ($precio_productos_vendidos) : ?>
                                <a class="nav-link" data-toggle="pill" href="#precioventa" role="tab" aria-controls="precioventa" aria-selected="false">Precios de productos vendidos</a>
                            <?php endif; ?>
                            <?php if ($hora_productos_vendidos) : ?>
                                <a class="nav-link" data-toggle="pill" href="#horaventa" role="tab" aria-controls="horaventa" aria-selected="false">Ventas por horas</a>
                            <?php endif; ?>
                        </div>
                        <div class="tab-content">
                            <div class="tab-pane fade  show active" id="ventadia" role="tabpanel">
                                <?php include 'tab_venta_dia.php' ?>
                            </div>
                            <?php if ($cierre_dia) : ?>
                                <div class="tab-pane fade" id="cierredeldia" role="tabpanel">
                                    <?php include 'tab_cierre_del_dia.php' ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($reporte_proveedor) : ?>
                                <div class="tab-pane fade" id="reporteproveedor" role="tabpanel">
                                    <?php include 'tab_reporteprov.php' ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($productos_vendidos) : ?>
                                <div class="tab-pane fade" id="productos_vendidos" role="tabpanel">
                                    <?php include 'tab_productos_vendidos.php' ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($productos_vendidos_documentos) : ?>
                                <div class="tab-pane fade" id="productos_vendidos_documentos" role="tabpanel">
                                    <?php include 'tab_productos_vendidos_documentos.php' ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($productos_vendidos_simples) : ?>
                                <div class="tab-pane fade" id="productos_vendidos_simples" role="tabpanel">
                                    <?php include 'tab_productos_vendidos_simples.php' ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($venta_dias) : ?>
                                <div class="tab-pane fade" id="dia" role="tabpanel">
                                    <?php include 'tab_dia.php' ?>
                                </div>
                            <?php endif; ?>
                            <div class="tab-pane fade" id="mes" role="tabpanel">
                                <?php include 'tab_mes.php' ?>
                            </div>
                            <?php if ($cliente_cobrar) : ?>
                                <div class="tab-pane fade" id="clipp" role="tabpanel">
                                    <?php include 'tab_clipp.php' ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($precio_productos_vendidos) : ?>
                                <div class="tab-pane fade" id="precioventa" role="tabpanel">
                                    <?php include 'tab_precioventa.php' ?>
                                </div>
                            <?php endif; ?>
                            <div class="tab-pane fade" id="horaventa" role="tabpanel">
                                <?php include 'diaHora.php' ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalbuscarcliente.php'; ?>
    <?php if ($opbuscarenfacturas) : ?>
        <?php include 'modallineas.php'; ?>
    <?php endif; ?>
    <?php if ($opnotascreditos) : ?>
        <?php include 'modal_detalle_credito.php'; ?>
        <?php include 'modal_nuevo_credito.php'; ?>
    <?php endif; ?>
    <?php if ($opfactor) : ?>
        <?php include 'modal_divisas.php' ?>
        <?php include 'app/divisas/vista/modalfactor.php' ?>
    <?php endif; ?>
    <?php include 'modal_imprimir.php' ?>
    <?php if ($reporte_proveedor) : ?>
        <?php include 'app/ingresosegresos/vista/modal_prodProv.php' ?>
    <?php endif; ?>
    <?php if ($cierre_dia) : ?>
        <?php include 'modal_imprimir_cierre.php' ?>
    <?php endif; ?>
</div>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assets/vue-select.js') ?>"></script>
<script src="<?= asset('assets/v-money.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<script src="<?= asset('assets/js/plugin/chart.js/Chart.min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/facturacion/index.js') ?>"></script>