<?php

namespace App\Controladores;

use App\Modelos\Empresa;
use Core\Controller;
use Core\Librerias\Http;
use Exception;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;

final class EmpresaControlador extends Controller
{
    private $empresa;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->empresa = new Empresa();
    }

    public function obtenerDatosEmpresa()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->empresa->obtenerDatosEmpresa());
        }
    }

    public function ver()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->empresa->obtenerDatosEmpresa());
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $emp_id             = filter_input(INPUT_POST, 'ide', FILTER_SANITIZE_NUMBER_INT);
                $emp_rif            = filter_input(INPUT_POST, 're', FILTER_SANITIZE_STRING);
                $emp_rif_dni        = filter_input(INPUT_POST, 'rde', FILTER_SANITIZE_STRING);
                $emp_nombrecorto    = filter_input(INPUT_POST, 'nce', FILTER_SANITIZE_STRING);
                $emp_nombre         = filter_input(INPUT_POST, 'ne', FILTER_SANITIZE_STRING);
                $emp_paisid         = filter_input(INPUT_POST, 'pide', FILTER_SANITIZE_NUMBER_INT);
                $emp_codpostal      = filter_input(INPUT_POST, 'cpe', FILTER_SANITIZE_NUMBER_INT);
                $emp_direccion      = filter_input(INPUT_POST, 'de', FILTER_SANITIZE_STRING);
                $emp_email          = filter_input(INPUT_POST, 'coe', FILTER_SANITIZE_EMAIL);
                $emp_fax            = filter_input(INPUT_POST, 'fae', FILTER_SANITIZE_STRING);
                $emp_observaciones  = filter_input(INPUT_POST, 'oe', FILTER_SANITIZE_STRING);
                $emp_estado         = filter_input(INPUT_POST, 'ee', FILTER_SANITIZE_STRING);
                $emp_ciudad         = filter_input(INPUT_POST, 'ce', FILTER_SANITIZE_STRING);
                $emp_telefono_1     = filter_input(INPUT_POST, 't1e', FILTER_SANITIZE_STRING);
                $emp_telefono_2     = filter_input(INPUT_POST, 't2e', FILTER_SANITIZE_STRING);
                $emp_email_password = filter_input(INPUT_POST, 'passwd', FILTER_SANITIZE_STRING);
                $emp_host_correo    = filter_input(INPUT_POST, 'hce', FILTER_SANITIZE_STRING);
                $emp_port_correo    = filter_input(INPUT_POST, 'ptce', FILTER_SANITIZE_STRING);
                $emp_cantidad       = filter_input(INPUT_POST, 'cantidad', FILTER_SANITIZE_STRING) ?? 0;

                if (empty($emp_rif))
                    $this->array_errors[] = "El campo RIF es requerido.";
                if (empty($emp_rif_dni))
                    $this->array_errors[] = "El campo DNI es requerido.";
                if (empty($emp_nombrecorto))
                    $this->array_errors[] = "El campo Nombre corto es requerido.";
                if (empty($emp_nombre))
                    $this->array_errors[] = "El campo Nombre es requerido.";
                if (empty($emp_paisid))
                    $this->array_errors[] = "El campo País es requerido.";
                if (empty($emp_codpostal))
                    $this->array_errors[] = "El campo Código postal es requerido.";
                if (empty($emp_direccion))
                    $this->array_errors[] = "El campo Dirección es requerido.";
                if (empty($emp_email))
                    $this->array_errors[] = "El campo Correo es requerido.";
                if (empty($emp_telefono_1))
                    $this->array_errors[] = "El campo Teléfono uno es requerido.";
                if (empty($emp_estado))
                    $this->array_errors[] = "El campo Estado uno es requerido.";
                if (empty($emp_ciudad))
                    $this->array_errors[] = "El campo Ciudad uno es requerido.";
                if (empty($emp_email_password))
                    $this->array_errors[] = "El campo Contraseña correo es requerido.";
                if (empty($emp_host_correo))
                    $this->array_errors[] = "El campo Host correo es requerido.";
                if (empty($emp_port_correo))
                    $this->array_errors[] = "El campo Puerto correo es requerido.";

                //if (valida_email($emp_email) == false)
                //array_push($this->array_errors, "El correo $emp_email no es correcto");
                if (empty($this->array_errors) && empty($this->array_errors)) {
                    $data_form = [
                        'emp_rif'               => $emp_rif,
                        'emp_rif_dni'           => $emp_rif_dni,
                        'emp_nombrecorto'       => $emp_nombrecorto,
                        'emp_nombre'            => $emp_nombre,
                        'emp_paisid'            => $emp_paisid,
                        'emp_codpostal'         => $emp_codpostal,
                        'emp_direccion'         => $emp_direccion,
                        'emp_email'             => $emp_email,
                        'emp_fax'               => $emp_fax,
                        'emp_observaciones'     => $emp_observaciones,
                        'emp_estado'            => $emp_estado,
                        'emp_ciudad'            => $emp_ciudad,
                        'emp_regimeniva'        => '',
                        'emp_telefono_1'        => $emp_telefono_1,
                        'emp_telefono_2'        => $emp_telefono_2,
                        'emp_email_password'    => $emp_email_password,
                        'emp_host_correo'       => $emp_host_correo,
                        'emp_port_correo'       => $emp_port_correo,
                        'emp_cantidad'          => $emp_cantidad
                    ];
                    $resultado = $this->empresa->editar(1, $data_form);
                    Http::json_response($resultado);
                }

                Http::json_response([
                    'errors' => $this->array_errors
                ]);
            } else {
                Http::json_response(['errors' => ['Usted no es administrador']]);
            }
        }
    }

    public function probarCorreo()
    {
        $data_empresa = $this->empresa->obtenerDatosEmpresa();

        if (empty($data_empresa['emp_host_correo']))
            $this->array_errors[] = "EL campo Host de correo debe ser configurado";
        if (empty($data_empresa['emp_port_correo']))
            $this->array_errors[] = "El campo Puerto correo debe ser configurado.";
        if (empty($data_empresa['emp_email_password']))
            $this->array_errors[] = "El campo Contraseña correo debe ser configurado.";
        if (empty($data_empresa['emp_email']))
            $this->array_errors[] = "El campo Correo debe ser configurado.";

        if (empty($this->array_errors)) {

            $mail = new PHPMailer(true);

            $mail->setLanguage('es');

            $smtp = new SMTP();

            $smtp->do_debug = SMTP::DEBUG_OFF;

            try {

                if (!$smtp->connect("{$data_empresa['emp_host_correo']}", $data_empresa['emp_port_correo'])) {
                    $this->array_errors[] = "Conexión fallida";
                }

                if (empty($this->array_errors)) {
                    $mail->isSMTP();
                    $mail->Host       = "{$data_empresa['emp_host_correo']}";
                    $mail->SMTPAuth   = true;
                    $mail->Username   = "{$data_empresa['emp_email']}";
                    $mail->Password   = "{$data_empresa['emp_email_password']}";
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;         // Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged
                    $mail->Port       = $data_empresa['emp_port_correo'];                                    // TCP port to connect to, use 465 for `PHPMailer::ENCRYPTION_SMTPS` above

                    $mail->setFrom("{$data_empresa['emp_email']}");
                    $mail->addReplyTo("{$data_empresa['emp_email']}", 'Empresa');
                    $mail->addAddress("{$data_empresa['emp_email']}");

                    $mail->isHTML(true);
                    $mail->Subject = 'PRUEBA DE CORREO EMPPRESA';
                    $mail->Body    = 'Correo configurado exitosamente';
                    $mail->AltBody = 'Prueba de correo';

                    $mail->send();
                    Http::json_response(true);
                }
            } catch (Exception $e) {
                $this->array_errors[] = "{$mail->ErrorInfo}.";
            }
        }

        Http::json_response(['errors' => $this->array_errors]);
    }

    public function habilitarDeshabilitarFiguraAgente()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $data_empresa = $this->empresa->obtener(1);

                Http::json_response($this->empresa->editar(1, [
                    'emp_figura_agente' => $data_empresa['emp_figura_agente'] == 1 ? 0 : 1
                ]));
            }
        }
    }
    public function habilitarDeshabilitarIva()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $data_empresa = $this->empresa->obtener(1);

                Http::json_response($this->empresa->editar(1, [
                    'emp_iva' => $data_empresa['emp_iva'] == 1 ? 0 : 1
                ]));
            }
        }
    }
}
