<div class="container" id="appEmpleadoVer" v-cloak>
    <input type="hidden" value="<?= $emp_id ?>" id="empleado" />
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Empleado</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('empleados') ?>">Empleados</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('empleados/ver' . $emp_id) ?>">Perfil de {{ dataForm.nombres }} {{ dataForm.apellidos }}</a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <ul class="nav nav-pills nav-secondary" id="pills-tab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="pill" href="#home" role="tab" aria-controls="home" aria-selected="true">Datos</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Usuario</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#settings" role="tab" aria-controls="settings" aria-selected="false">Configuración</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_almacenes" role="tab" aria-controls="tab_almacenes" aria-selected="false">Almacenes</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_sucursales" role="tab" aria-controls="tab_sucursales" aria-selected="false">Sucursales</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_series" role="tab" aria-controls="tab_series" aria-selected="false">Series</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_cuentas" role="tab" aria-controls="tab_cuentas" aria-selected="false">Cuentas</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_divisas" role="tab" aria-controls="tab_divisas" aria-selected="false">Divisas</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_imagen" role="tab" aria-controls="tab_imagen" aria-selected="false">Imagen</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_comisiones" role="tab" aria-controls="tab_comisiones" aria-selected="false">Comisiones</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="pill" href="#tab_clients" role="tab" aria-controls="tab_clients" aria-selected="false">Clientes</a>
                            </li>
                        </ul>
                        <div class="tab-content mt-3">
                            <div class="tab-pane active show mb-3" id="home">
                                <div class="row">
                                    <div class="col-12">
                                        <form @submit.prevent="editarInfo" autocomplete="off">
                                            <div class="form-row">
                                                <div class="col-3">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_nombres">Nombres:</label>
                                                        <input type="text" id="einfo_nombres" class="form-control" v-model="dataForm.nombres">
                                                    </div>
                                                </div>
                                                <div class="col-3">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_apellidos">Apellidos:</label>
                                                        <input type="text" id="einfo_apellidos" class="form-control" v-model="dataForm.apellidos">
                                                    </div>
                                                </div>
                                                <div class="col-2">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_telefono_movil">Teléfono:</label>
                                                        <input type="tel" id="einfo_telefono_movil" class="form-control" v-model="dataForm.telefono" v-mask="'(####) ###-####'">
                                                    </div>
                                                </div>
                                                <div class="col-4">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_email">Correo Electrónico:</label>
                                                        <input type="email" id="einfo_email" class="form-control" v-model="dataForm.correo">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-default">
                                                <label for="einfo_direccion_1">Dirección:</label>
                                                <input type="text" id="einfo_direccion_1" class="form-control" v-model="dataForm.direccion_uno">
                                            </div>

                                            <div class="form-row">
                                                <div class="col-6">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_direccion_2">Referencia:</label>
                                                        <input type="text" id="einfo_direccion_2" class="form-control" v-model="dataForm.direccion_dos">
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_ciudad">Ciudad:</label>
                                                        <input type="text" id="einfo_ciudad" class="form-control" v-model="dataForm.ciudad">
                                                    </div>
                                                </div>
                                                <div class="col">
                                                    <div class="form-group form-group-default">
                                                        <label for="einfo_estado">Estado:</label>
                                                        <input type="text" id="einfo_estado" class="form-control" v-model="dataForm.estado">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <?php if (constant('EMP_FIGURA_AGENTE') == true) : ?>
                                                    <div class="col-11">
                                                        <div class="form-check">
                                                            <label class="form-check-label">
                                                                <input class="form-check-input" type="checkbox" v-model="dataForm.agente_de_venta">
                                                                <span class="form-check-sign">Es agente de venta (SI/NO)</span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="col text-right">
                                                    <button type="submit" class="btn btn-primary  btn-sm"><i class="fas fa-save"></i> Actualizar</button>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                                        {{ row }}
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane mb-3" id="profile">
                                <div class="row">
                                    <div class="col-6">
                                        <form autocomplete="off" @submit.prevent="editarGuardarUser">
                                            <div class="form-group form-group-default">
                                                <label for="username">Usuario</label>
                                                <div class="col-md-8">
                                                    <input id='emp_username' class='form-control form-inps' v-model="dataFormUser.nombre">
                                                </div>
                                            </div>
                                            <div class="form-group form-group-default">
                                                <label for="emp_password">Contraseña</label>
                                                <div class="col-md-8">
                                                    <input type="password" id='emp_password' class='form-control form-inps' v-model="dataFormUser.password">
                                                </div>
                                            </div>
                                            <div class="form-group form-group-default">
                                                <label for="repeat_password">Re-contraseña</label>
                                                <div class="col-md-8">
                                                    <input type="password" id='repeat_password' class='form-control form-inps' v-model="dataFormUser.repassword">
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <div class="col-11">
                                                    <div class="form-check">
                                                        <label class="form-check-label">
                                                            <input class="form-check-input" type="checkbox" v-model="dataFormUser.obrero">
                                                            <span class="form-check-sign">Es obrero (SI/NO)</span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                                        {{ row }}
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-row">
                                                <div class="col">
                                                    <button type="submit" class="btn btn-primary  btn-sm"> Actualizar</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane mb-3" id="settings">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group form-group-default">
                                            <label for="pagina-de-inicio">Página de inicio</label>
                                            <select id="pagina-de-inicio" v-model="selectedPagina" class="form-control" @change="establecerPaginaDeInicio($event)">
                                                <option value="invalida" disabled>Seleccione un pagina de inicio</option>
                                                <option value="">Inicio</option>
                                                <option v-for="row in permisosDeInicio" :value="row.id">{{ row.descripcion }}</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group form-group-default">
                                            <label for="pagina-de-inicio">Permisos en modulos</label>
                                            <br>
                                            <div class="row">
                                                <div class="col-3" v-for="module in all_modules">
                                                    <div id="accordion" class="accordion-secondary">
                                                        <div class="card">
                                                            <div class="card-header collapsed" data-toggle="collapse" :data-target="'#'+module.nombre" aria-expanded="true">
                                                                <div class="card-head-row">
                                                                    <div class="span-icon">
                                                                        <i :class="'fa fa-'+ module.icon"></i>
                                                                        {{ module.nombre }}
                                                                    </div>
                                                                    <div class="card-tools">
                                                                        <div class="span-mode">
                                                                            <input type="checkbox" v-model="module.permiso" @click="permitirModulo(module.id, $event)">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div :id="module.nombre" class="collapse">
                                                                <div class="card-body">
                                                                    <ul class="list-group">
                                                                        <li class="list-group-item d-flex justify-content-between align-items-center" v-for="(action, index) in module.acciones" :key="index">
                                                                            {{ action.nombre }}
                                                                            <span>
                                                                                <input type="checkbox" v-model="action.permiso" @click="permitirModuloAcciones(module.id, action.id, $event)">
                                                                            </span>
                                                                        </li>
                                                                    </ul>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane mb-3" id="tab_almacenes">
                                <form>
                                    <div class="form-group">
                                        <label for="almacenes">Almacen</label>
                                        <select id="almacenes" class="form-control" v-model="almacen" @change="guardarAlmacen()">
                                            <option value="" disabled>SELECCIONAR UN ALMACEN</option>
                                            <?php foreach ($almacenes as $row) : ?>
                                                <option value="<?= $row['alm_id'] ?>"><?= $row['alm_nombre'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </form>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Almacen</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in almacenes_empleado">
                                            <td>{{ row.alm_nombre }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminarAlmacen(row.empalm_id, row.alm_nombre)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-button-action">
                                                    <input class="form-check-input" type="checkbox" :checked="row.empalm_predeterminado==1 ? true : false" id="predeterminado" @click="predeterminadoAlmacen(row.empalm_almid,row.empalm_empid)">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="tab-pane mb-3" id="tab_sucursales">
                                <form>
                                    <div class="form-group">
                                        <label for="sucursales">Sucursales</label>
                                        <select id="sucursales" class="form-control" v-model="sucursales" @change="guardarSucursal()">
                                            <option value="" disabled>SELECCIONAR UNA SUCURSAL</option>
                                            <?php foreach ($sucursales as $row) : ?>
                                                <option value="<?= $row['su_id'] ?>"><?= $row['su_nombre'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </form>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Dirección</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in sucursales_empleado">
                                            <td>{{ row.su_nombre }}</td>
                                            <td>{{ row.su_direccion }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminarSucursales(row.empsuc_id, row.su_nombre)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-button-action">
                                                    <input class="form-check-input" type="checkbox" :checked="row.sucursal_predeterminado==1 ? true : false" id="predeterminado" @click="predeterminadoSucursal(row.sucursal_id,row.empleado_id)">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="tab-pane mb-3" id="tab_series">
                                <form>
                                    <div class="form-group">
                                        <label for="series">Serie</label>
                                        <select id="series" class="form-control" v-model="serie" @change="guardarSerie()">
                                            <option value="" disabled>SELECCIONAR UNA SERIE</option>
                                            <?php foreach ($series as $row) : ?>
                                                <option value="<?= $row['ser_id'] ?>"><?= $row['ser_descripcion'] . ' Sucursal ' . $row['su_nombre'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </form>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Serie</th>
                                            <th>Sucursal</th>
                                            <th></th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in series_empleado">
                                            <td>{{ row.ser_descripcion }}</td>
                                            <td>{{ row.su_nombre }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminarSerie(row.empser_id, row.ser_descripcion)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-button-action">
                                                    <input class="form-check-input" type="checkbox" :checked="row.empser_predeterminado==1 ? true : false" id="predeterminado" @click="predeterminadoSerie(row.empser_serid,row.empser_empid)">
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="tab-pane mb-3" id="tab_cuentas">
                                <form>
                                    <div class="form-group">
                                        <label for="series">Cuenta</label>
                                        <select id="series" class="form-control" v-model="cuenta" @change="guardarCuenta()">
                                            <option value="" disabled>SELECCIONAR UNA CUENTA</option>
                                            <?php foreach ($cuentas as $row) : ?>
                                                <option value="<?= $row['id'] ?>"><?= $row['cuenta'] ?> <?= $row['alias'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </form>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Cuenta</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in empleadoCuentas">
                                            <td>{{ row.cuenta }} {{ row.alias }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminarCuenta(row)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="tab-pane mb-3" id="tab_divisas">
                                <div class="form-group form-group-default">
                                    <label for="selectedDivisa">Divisa para facturar</label>
                                    <select id="selectedDivisa" v-model="selectedDivisa" class="form-control" @change="establecerDivisa($event)">
                                        <option value="" disabled>Seleccione una divisa</option>
                                        <option v-for="row in divisas" :value="row.id">{{ row.nombre }}</option>
                                    </select>
                                </div>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Divisa</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in empleadoDivisas">
                                            <td>{{ row.nombre }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminarDivisa(row)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="tab-pane mb-3" id="tab_imagen">
                                <h2 class="text-center">Imagen de perfil</h2>
                                <div class="row">
                                    <div class="col-md-12 d-flex justify-content-center">
                                        <div class="input-file input-file-image" :class="upload_imagen">
                                            <img class="img-upload-preview img-circle" :src="ruta_imagen" width="150" height="150">
                                            <input type="file" class="form-control form-control-file" id="uploadImg2" name="uploadImg2" accept="image/*" required="" ref="file" v-on:change="handleFileUpload()">
                                            <label for="uploadImg2" class="label-input-file btn btn-black btn-round">
                                                <span class="btn-label">
                                                    <i class="fa fa-file-image"></i>
                                                </span>
                                                Subir Imagen
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <div class=" alert alert-warning" role="alert" v-for="row in errorImage">
                                            {{ row }}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane mb-3" id="tab_clients">
                                <div class="row">
                                    <div class="col-12 table-responsive">
                                        <table class="table" id="tabla_clientes">
                                            <thead>
                                                <tr>
                                                    <th>Fecha</th>
                                                    <th>Nº de documento</th>
                                                    <th>Razón social</th>
                                                    <th>Telefono</th>
                                                    <th>Email</th>
                                                    <th>Dirección</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="row in clientes">
                                                    <td>{{ row.empagent_fecha_registro }}</td>
                                                    <td>{{ row.cli_dni }}</td>
                                                    <td>{{ row.cli_razon_social }}</td>
                                                    <td>{{ row.cli_email }}</td>
                                                    <td>{{ row.cli_telefono }}</td>
                                                    <td>{{ row.cli_direccion }}-{{ row.pa_nombre }} / {{ row.cli_estado }} / {{ row.cli_ciudad }}</td>
                                                    <td>
                                                        <div class="form-button-action">
                                                            <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminarCliente(row.cli_id,row.cli_razon_social)">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane mb-3" id="tab_comisiones">
                                <div class="form-group form-groud-default">
                                    <div class="row">
                                        <div class="col-12">
                                            <ul class="nav nav-pills nav-secondary" role="tablist">
                                                <li>
                                                    <a class="nav-link active" data-toggle="pill" href="#Configurar" role="tab" aria-selected="index">Configuración</a>
                                                </li>
                                                <li>
                                                    <a class="nav-link" data-toggle="pill" href="#Comisionespagada" role="tab" aria-selected="false" @click="obtenerComisionesEmpAgentePagadas()">Comisiones Pagadas</a>
                                                </li>
                                                <li>
                                                    <a class="nav-link" data-toggle="pill" href="#Comisionespendiente" role="tab" aria-selected="false" @click="obtenerComisionesEmpAgentePendiente()">Comisiones Pendientes</a>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="col-12 mb-3">
                                            <div class="tab-content">
                                                <div class="tab-pane fade show active" id="Configurar">
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <strong><a href="" @click.prevent="modalComision" class="boton-info-b  btn btn-round btn-sm pull-right"><i class="fas fa-plus"></i> Agregar Nueva Comisión</a></strong>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <table class="table table-striped nowrap">
                                                                <thead>
                                                                    <tr>
                                                                        <th>Comisiones</th>
                                                                        <th>Porcentajes</th>
                                                                        <th>Estatus</th>
                                                                        <th>Documentos</th>
                                                                        <th></th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr v-for="row in comisionesAgente">
                                                                        <td>{{ row.comision }}</td>
                                                                        <td>
                                                                            <span v-show="spanPorcentaje" style="cursor: pointer;" class="" @click="cambiarPorcentajeComisionAgente(row)">{{ row.porcentaje }} %</span>
                                                                            <form v-show="inputPorcentaje" @submit.prevent="editarPorcentajeComisionAgente(row)">
                                                                                <input type="text" :id="'porcentaje'+row.id" :value="row.porcentaje">
                                                                                <button type="submit" class="btn"><i class="fa fa-save"></i></button>
                                                                            </form>
                                                                        </td>
                                                                        <td>
                                                                            <i :class="row.estatus == 1 ? 'btn fa fa-check' : 'btn fa fa-times'" @click="cambiarEstatusAgenteComision(row)"></i>
                                                                        </td>
                                                                        <td class="text-center" style="height: inherit; width: 20%">
                                                                            <div class="form-button-action">
                                                                                <button type="button" title="Documentos" class="btn btn-link btn-dark-r" @click="modalDocumentos(row)">
                                                                                    <i class="fa fa-file text-info"></i>
                                                                                </button>
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="form-button-action">
                                                                                <button type="button" title="eliminar" class="btn btn-link btn-dark-r" @click="eliminarSeleccion(row.id)">
                                                                                    <i class="fa fa-trash text-danger"></i>
                                                                                </button>
                                                                            </div>
                                                                        </td>
                                                                    </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Comisionespagada">
                                                    <div class="table-responsive">
                                                        <table class="display nowrap table table-striped table-hover dataTable" id="table_comisiones_pagadas">
                                                            <thead>
                                                                <tr>
                                                                    <th>Fecha</th>
                                                                    <th>Cliente</th>
                                                                    <th>Comision</th>
                                                                    <th>Porcentaje</th>
                                                                    <th>Monto</th>
                                                                    <th>Fecha de pago</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr v-for="pagadas in comisionesAgentepagadas">
                                                                    <td>{{pagadas.fecha_reg}}</td>
                                                                    <td>{{pagadas.cliente}}</td>
                                                                    <td>{{pagadas.com_descripcion}}</td>
                                                                    <td>{{pagadas.porcentaje}} %</td>
                                                                    <td>{{pagadas.monto_moneda}}</td>
                                                                    <td>{{pagadas.fecha_pago}}</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="Comisionespendiente">
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <ul class="nav nav-pills nav-secondary" role="tablist">
                                                                <li class="nav-item" v-for="(row, index) in comisionesAgentependientes">
                                                                    <a class="nav-link" :class="index == 1 ? 'active' : ''" data-toggle="pill" :href="'#nav-pendiente'+index" role="tab" aria-controls="home" :aria-selected="index == 1 ? true : false">{{ row.divisa }}</a>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                    <div class="tab-content mt-3">
                                                        <div class="tab-pane mb-3 fade" :class="index == 1 ? 'active show' : ''" v-for="(row, index) in comisionesAgentependientes" :id="'nav-pendiente'+index">
                                                            <div class="table-responsive">
                                                                <table class="display nowrap table table-striped table-hover dataTable">
                                                                    <thead>
                                                                        <tr>
                                                                            <th class="text-center">
                                                                                <label for="checkbox-todos" class="form-check-label">
                                                                                    <input class="form-check-input" type="checkbox" class="checkbox-todos" @change="checktodos(index, $event)">
                                                                                    <span class="form-check-sign"></span>
                                                                                </label>
                                                                            </th>
                                                                            <th>Fecha</th>
                                                                            <th>Documento</th>
                                                                            <th>Total</th>
                                                                            <th>Estatus</th>
                                                                            <th>Cliente</th>
                                                                            <th>Comision</th>
                                                                            <th>Porcentaje</th>
                                                                            <th>Monto</th>
                                                                            <th></th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <tr v-for="row in row.pendientes" :key="row.id">
                                                                            <td class="text-center">
                                                                                <label :for="'check'+row.id" class="form-check-label">
                                                                                    <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'part'+row.id">
                                                                                    <span class="form-check-sign"></span>
                                                                                </label>
                                                                            </td>
                                                                            <td>{{row.fecha_reg}}</td>
                                                                            <td class="text-center">
                                                                                <a :href="row.uri" title="Ver documento" target="_blank">
                                                                                    {{ row.idnf }}
                                                                                </a>
                                                                            </td>
                                                                            <td>{{row.total_moneda}}</td>
                                                                            <th>{{row.estatusfn}}</th>
                                                                            <td>{{row.cliente}}</td>
                                                                            <td>{{row.com_descripcion}}</td>
                                                                            <td>{{row.porcentaje}} %</td>
                                                                            <td>{{row.monto_moneda}}</td>
                                                                            <td>
                                                                                <div class="form-button-action">
                                                                                    <button type="button" title="Pagar" @click="modalPagoPendienteId(row)" class="btn btn-link">
                                                                                        <i class="fa fa-coins text-warning"></i>
                                                                                    </button>
                                                                                    <button type="button" title="Editar" @click="modalPendienteeditar(row.porcentaje,row.monto,row.total,row.divisa,row.id)" class="btn btn-link btn-primary">
                                                                                        <i class="fa fa-edit"></i>
                                                                                    </button>
                                                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click.prevent="eliminarComisionPendiente(row.id)">
                                                                                        <i class="fa fa-trash"></i>
                                                                                    </button>
                                                                                </div>
                                                                            </td>
                                                                        </tr>
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                            <div class="row d-flex justify-content-end">
                                                                <a href="#" class="btn btn-info btn-sm btn-round mr-3" @click.prevent="modalPagarTodo(index)">Pagar comisiones seleccionadas</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app/notasdeentregaeditar/vista/modal_editar_con_agente.php' ?>
    <?php include 'modal_pago_pendiente.php' ?>
    <?php include 'modal_agregar_comision.php' ?>
    <?php include 'modal_pagar_pendientes.php' ?>
    <?php include 'modal_documentos.php' ?>
</div>
<script src="<?= ruta_base() ?>public/assets/v-money.js"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assetsvuejs/empleados/empleado_ver.js') ?>"></script>