<form action="#" autocomplete="off" @submit.prevent="guardar" id="modal_form_empleado">
    <div class="modal fade" id="modal_empleado" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ titulo }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="empnombres">Nombres</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-id-badge"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="empnombres" class="form-control" v-model="dataForm.nombres">
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="empapellidos">Apellidos</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-id-card-alt"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="empapellidos" class="form-control" v-model="dataForm.apellidos">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="emptelefono">Teléfono</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-phone fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="tel" id="emptelefono" class="form-control" v-model="dataForm.telefono" v-mask="'(####) ###-####'">
                                </div>
                                <small class="form-text text-muted" style="font-size:10px; padding-left:45px;">(0000) 000-0000</small>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="empcorreo">Correo Electrónico:</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-envelope fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="email" id="empcorreo" class="form-control" v-model="dataForm.correo">
                                </div>
                                <small class="form-text text-muted" style="font-size:10px; padding-left:45px;">usuario@ejemplo.com</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="empdireccion">Dirección:</label>
                        <input type="text" id="empdireccion" class="form-control" v-model="dataForm.direccion_uno">
                    </div>
                    <div class="form-group">
                        <label for="empdirecciondos">Referencia:</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-crosshairs fa-fw"></i>
                                </span>
                            </div>
                            <input type="text" id="empdirecciondos" class="form-control" v-model="dataForm.direccion_dos">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="empestado">Estado:</label>
                                <input type="text" id="empestado" class="form-control" v-model="dataForm.estado">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label for="empciudad">Ciudad:</label>
                                <input type="text" id="empciudad" class="form-control" v-model="dataForm.ciudad">
                            </div>
                        </div>
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" v-model="dataForm.agente_de_venta">
                            <span class="form-check-sign">Es agente de venta (SI/NO)</span>
                        </label>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                        <i class="loader loader-info"></i>
                    </button>
                    <button v-else class="btn btn-sm btn-primary" type="submit">
                        <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                        <span class="d-none d-sm-inline-block">{{ accion }}</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>