<?php

namespace App\Modelos;

use Core\Database;

class EmpleadosComisionesEmplAgente extends Database
{
    protected $table = 'app_comisiones_agente_fn';
    protected $id = 'comagentefn_id';

    public function obtenerDocumento(int $id)
    {
        return $this->consultar("SELECT * FROM app_documentos WHERE doc_id=$id")->row();
    }

    public function obtenerComisionesAgenteFacturasPagadas(int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn 
        JOIN app_factura_master fm ON fn.comagentefn_fnid=fm.fm_id 
        JOIN app_clientes cli ON fm.fm_cliid=cli.cli_id
        JOIN app_divisas dv ON fm.fm_divid=dv.div_id
        JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_fnempagente=$id AND fn.comagentefn_fntipo=2 AND fn.comagentefn_estatus=1
        ORDER BY DATE(comagentefn_fechapago) DESC")->all();
    }

    public function obtenerComisionesAgenteFacturasPendientes(int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn
        JOIN app_factura_master fm ON fn.comagentefn_fnid=fm.fm_id
        JOIN app_clientes cli ON fm.fm_cliid=cli.cli_id
        JOIN app_divisas dv ON fm.fm_divid=dv.div_id
        JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_fnempagente=$id AND fn.comagentefn_fntipo=2 AND fn.comagentefn_estatus=0
        ORDER BY DATE(comagentefn_fecha) DESC")->all();
    }

    public function obtenerComisionesAgenteNotasPagadas(int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn
        JOIN app_notas_de_entrega nt ON fn.comagentefn_fnid=nt.ne_id 
        JOIN app_clientes cli ON nt.ne_cliid=cli.cli_id
        JOIN app_divisas dv ON nt.ne_divid=dv.div_id
        JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_fnempagente=$id AND fn.comagentefn_fntipo=1 AND fn.comagentefn_estatus=1
        ORDER BY DATE(comagentefn_fechapago) DESC")->all();
    }

    public function obtenerComisionesAgenteNotasPendientes(int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn
        JOIN app_notas_de_entrega nt ON fn.comagentefn_fnid=nt.ne_id 
        JOIN app_clientes cli ON nt.ne_cliid=cli.cli_id
        JOIN app_divisas dv ON nt.ne_divid=dv.div_id
        JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_fnempagente=$id AND fn.comagentefn_fntipo=1 AND fn.comagentefn_estatus=0
        ORDER BY DATE(comagentefn_fecha) DESC")->all();
    }

    public function obtenerComisionesAgenteOrdenPendientes(int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn
        JOIN app_orden_de_entrega nt ON fn.comagentefn_fnid=nt.n_id 
        JOIN app_clientes cli ON nt.n_cliid=cli.cli_id
        JOIN app_divisas dv ON nt.n_divid=dv.div_id
        JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_fnempagente=$id AND fn.comagentefn_fntipo=12 AND fn.comagentefn_estatus=0
        ORDER BY DATE(comagentefn_fecha) DESC")->all();
    }

    public function obtenerComisionesAgenteOrdenPagadas(int $id)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn
        JOIN app_orden_de_entrega nt ON fn.comagentefn_fnid=nt.n_id 
        JOIN app_clientes cli ON nt.n_cliid=cli.cli_id
        JOIN app_divisas dv ON nt.n_divid=dv.div_id
        JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_fnempagente=$id AND fn.comagentefn_fntipo=12 AND fn.comagentefn_estatus=1
        ORDER BY DATE(comagentefn_fechapago) DESC")->all();
    }

    public function editarEstatusFactNotaPendiente($id)
    {
        return $this->consultar("UPDATE app_comisiones_agente_fn SET comagentefn_estatus=1 WHERE comagentefn_id= $id")->run();
    }

    public function obtenerComisionFactNotaPendiente($id_fn, $id_tipofn)
    {
        return $this->consultar("SELECT * 
        FROM app_comisiones_agente_fn fn
        LEFT JOIN app_comision c ON fn.comagentefn_com=c.com_id
        LEFT JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
        LEFT JOIN app_productos pr ON fn.comagentefn_planilla_servid=pr.pro_id
        WHERE comagentefn_fnid =$id_fn AND comagentefn_fntipo=$id_tipofn")->all();
    }

    public function obtenerComisionAgentefnPendiente($id_fn, $id_tipofn, $id_agente, $tipocomision)
    {
        return $this->consultar("SELECT * FROM app_comisiones_agente_fn WHERE comagentefn_fnempagente=$id_agente AND comagentefn_com =$tipocomision AND comagentefn_fnid=$id_fn AND comagentefn_fntipo=$id_tipofn")->all();
    }

    public function obtenerComisionesAgenteNotasPendientesIdfn($id)
    {
        return $this->consultar("SELECT * FROM app_comisiones_agente_fn fn
        LEFT JOIN app_notas_de_entrega nt ON fn.comagentefn_fnid=nt.ne_id 
        LEFT JOIN app_clientes cli ON nt.ne_cliid=cli.cli_id
        LEFT JOIN app_divisas dv ON nt.ne_divid=dv.div_id
        LEFT JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_id =$id AND fn.comagentefn_fntipo=1 AND fn.comagentefn_estatus=0")->row();
    }

    public function obtenerMovimientosPendientesFactIdfn($id)
    {
        return $this->consultar("SELECT * FROM app_comisiones_agente_fn fn
        LEFT JOIN app_factura_master fm ON fn.comagentefn_fnid=fm.fm_id
        LEFT JOIN app_clientes cli ON fm.fm_cliid=cli.cli_id
        LEFT JOIN app_divisas dv ON fm.fm_divid=dv.div_id
        LEFT JOIN app_comision c ON fn.comagentefn_com=c.com_id
        WHERE fn.comagentefn_id=$id AND fn.comagentefn_fntipo=2 AND fn.comagentefn_estatus=0")->row();
    }

    public function eliminarNotaFactId($id, int $tipo_documento)
    {
        return $this->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_fnid = $id AND comagentefn_fntipo = $tipo_documento")->run();
    }

    public function obtenerComisionesNotasId($where)
    {
        return $this->consultar("SELECT * FROM app_comisiones_agente_fn fn
            JOIN app_notas_de_entrega nt ON fn.comagentefn_fnid=nt.ne_id 
            JOIN app_clientes cli ON nt.ne_cliid=cli.cli_id
            JOIN app_divisas dv ON nt.ne_divid=dv.div_id
            JOIN app_comision c ON fn.comagentefn_com=c.com_id
            JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
            WHERE $where ORDER BY fn.comagentefn_fecha DESC")->all();
    }

    public function obtenerComisionesOrdenesId($where)
    {
        return $this->consultar("SELECT * FROM app_comisiones_agente_fn fn
            JOIN app_orden_de_entrega nt ON fn.comagentefn_fnid=nt.n_id 
            JOIN app_clientes cli ON nt.n_cliid=cli.cli_id
            JOIN app_divisas dv ON nt.n_divid=dv.div_id
            JOIN app_comision c ON fn.comagentefn_com=c.com_id
            JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
            WHERE $where ORDER BY fn.comagentefn_fecha DESC")->all();
    }

    public function obtenerComisionesFacturasId($where)
    {
        return $this->consultar("SELECT * FROM app_comisiones_agente_fn fn
            JOIN app_factura_master fm ON fn.comagentefn_fnid=fm.fm_id
            JOIN app_clientes cli ON fm.fm_cliid=cli.cli_id
            JOIN app_divisas dv ON fm.fm_divid=dv.div_id
            JOIN app_comision c ON fn.comagentefn_com=c.com_id
            JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
            WHERE $where ORDER BY fn.comagentefn_fecha DESC")->all();
    }

    public function obtenerComisionesFacturas($where)
    {
        return $this->consultar("SELECT COUNT(comagentefn_id) as registro, SUM(comagentefn_monto) monto, comagentefn_fnempagente, einfo_nombres, einfo_apellidos
        FROM app_comisiones_agente_fn fn
        JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
        JOIN app_factura_master fm ON fn.comagentefn_fnid=fm.fm_id WHERE $where GROUP BY comagentefn_fnempagente")->all();
    }

    public function obtenerComisionesNotas($where)
    {
        return $this->consultar("SELECT COUNT(comagentefn_id) as registro,SUM(comagentefn_monto) monto, comagentefn_fnempagente, einfo_nombres, einfo_apellidos 
        FROM app_comisiones_agente_fn fn
        JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
        JOIN app_notas_de_entrega nt ON fn.comagentefn_fnid=nt.ne_id WHERE $where GROUP BY comagentefn_fnempagente")->all();
    }

    public function obtenerComisionesOrdenes($where)
    {
        return $this->consultar("SELECT COUNT(comagentefn_id) as registro,SUM(comagentefn_monto) monto, comagentefn_fnempagente, einfo_nombres, einfo_apellidos 
        FROM app_comisiones_agente_fn fn
        JOIN app_empleados_info ep ON fn.comagentefn_fnempagente=ep.einfo_id
        JOIN app_orden_de_entrega nt ON fn.comagentefn_fnid=nt.n_id WHERE $where GROUP BY comagentefn_fnempagente")->all();
    }
}
