<form action="#" autocomplete="off" @submit.prevent="guardarEditar" id="modal_form_divisa">
    <div class="modal fade" id="modalDivisa" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h5 class="modal-title">{{ titulo }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-row">
                        <div class="col">
                            <div class="form-group">
                                <label for="nombre_divisa">Nombre</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-money-bill-wave"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="nombre_divisa" class="form-control" v-model="dataForm.nombre" maxlength="50">
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-group">
                                <label for="descripcion_divisa">Descripción</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-pencil-alt"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="descripcion_divisa" class="form-control" v-model="dataForm.descripcion" maxlength="50">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col">
                            <div class="form-group">
                                <label for="simbolo_divisa">Símbolo</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-question-circle"></i>
                                        </span>
                                    </div>
                                    <input type="text" id="simbolo_divisa" class="form-control" v-model="dataForm.simbolo" maxlength="10">
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-group">
                                <label for="decimal_divisa">Decimales</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-question"></i>
                                        </span>
                                    </div>
                                    <input type="number" id="decimal_divisa" class="form-control" v-model.number="dataForm.decimal" min="0" max="2">
                                </div>
                            </div>
                        </div>
                        <div class="col">
                            <div class="form-group">
                                <label for="partedecimal">Signo Decimal</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-question"></i>
                                        </span>
                                    </div>
                                    <select id="partedecimal" class="form-control" v-model="dataForm.partedecimal">
                                        <option :value="','">coma (,)</option>
                                        <option :value="'.'">punto (.)</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary  btn-sm">{{ accion }}</button>
                </div>
            </div>
        </div>
    </div>
</form>