<?php

namespace App\Controladores;

use Core\Controller;
use App\Modelos\Cuentasmd;
use Core\Vista;

final class CuentasmdControlador extends Controller
{
    private $cuentasmd;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->cuentasmd = new Cuentasmd();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('cuentasmd/index');
        }
    }

    public function cmd()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->cuentasmd->cmd());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $cmp_cueid = filter_input(INPUT_POST, 'cuenta', FILTER_SANITIZE_NUMBER_INT);
            $cmp_mdid = filter_input(INPUT_POST, 'divisa_metodo', FILTER_SANITIZE_NUMBER_INT);

            if (empty($cmp_cueid))
                $this->array_errors[] = "El campo Cuentas es requerido";
            if (empty($cmp_mdid))
                $this->array_errors[] = "El campo Divisa / Metodos es requerido";

            if (empty($this->array_errors)) {

                if (!empty($_POST['id'])) {
                    $cmp_id  = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                }

                if ($this->cuentasmd->where(['cmp_cueid' => $cmp_cueid, 'cmp_mdid' => $cmp_mdid], true)) {
                    $this->array_errors[] = "La relacion que intenta crear ya existe";
                } else {

                    $metodo_divisa = $this->cuentasmd->obtenerMetodoDivisa($cmp_mdid);
                    $cuenta =  $this->cuentasmd->obtenerCuenta($cmp_cueid);

                    if (is_countable($cuenta) && count($cuenta)) {
                        foreach ($cuenta as $row) {
                            $this->array_errors = [];
                            if ($row['md_divid'] != $metodo_divisa['md_divid']) {
                                $this->array_errors[] = 'No puede asignarle a una cuenta diferentes divisas';
                            }
                        }
                    }

                    if (empty($this->array_errors)) {
                        if (!empty($_POST['id'])) {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->cuentasmd->editar($cmp_id, [
                                'cmp_cueid' => $cmp_cueid,
                                'cmp_mdid' => $cmp_mdid
                            ]));
                            exit;
                        } else {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->cuentasmd->guardar([
                                'cmp_cueid' => $cmp_cueid,
                                'cmp_mdid' => $cmp_mdid
                            ], true));
                            exit;
                        }
                    }
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_cmd)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_cmd = filter_var($id_cmd, FILTER_SANITIZE_NUMBER_INT);

            if ($this->cuentasmd->existe('cmp_id', $id_cmd)) {
                header('Content-Type: application/json', true);
                echo json_encode($this->cuentasmd->eliminar($id_cmd));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
