<form action="#" autocomplete="off" @submit.prevent="editarGuardar" id="modal_form_correlativos">
    <div class="modal fade" id="modal_correlativos" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h5 class="modal-title">{{ titulo }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                <div class="form-row ">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="cdmcuenta">Serie</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas  fa-sort-alpha-down"></i>
                                        </span>
                                    </div>
                                    <select id="cdmcuenta" v-model="dataForm.serie" class="form-control custom-select">
                                        <option disabled value="">Seleccione una Serie</option>
                                        <option v-for="row in series" :value="row.ser_id">{{ row.ser_descripcion }}</option>
                                    </select>
                                </div>
                                
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <label for="cmddm">Documento</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas  fa-file-alt"></i>
                                        </span>
                                    </div>
                                    <select id="cmddm" v-model="dataForm.documento" class="form-control custom-select">
                                        <option disabled value="">Seleccione un Documento</option>
                                        <option v-for="row in documentos" :value="row.doc_id">{{ row.doc_prefijo }} - {{ row.doc_descripcion }}</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="cmddm">Correlativo</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas  fa-sort-numeric-down"></i>
                                        </span>
                                    </div>
                                    <input type="number" v-model.number="dataForm.correlativo" min="0" class="form-control" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-warning" v-if="errorForm.length">
                        <p class="mb-1" v-for="row in errorForm">{{ row }}</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary  btn-sm">{{ accion }}</button>
                </div>
            </div>
        </div>
    </div>
</form>