<?php

namespace App\Modelos;

use Core\Database;

class Correlativos extends Database
{
    protected $table = 'app_correlativos';
    protected $id = 'cor_id';

    public function correlativos()
    {
        return $this->consultar('SELECT *
        FROM app_correlativos c
        JOIN app_series s ON s.ser_id = c.cor_serid
        JOIN app_documentos d ON d.doc_id = c.cor_docid')->all();
    }

    public function correlativosExite($id_serie, $id_documento)
    {
        return $this->consultar("SELECT cor_id FROM app_correlativos WHERE cor_serid=$id_serie and cor_docid=$id_documento")->row();
    }

    public function correlativosExiteNumero($id, $correlativo)
    {
        return $this->consultar("SELECT cor_correlativo FROM app_correlativos WHERE cor_id=$id and $correlativo <= cor_correlativo")->row();
    }

    public function correlativoSegunSerie($id_serie)
    {
        return $this->consultar("SELECT c.cor_id, c.cor_serid, c.cor_docid, s.ser_descripcion, s.ser_impuesto, d.doc_prefijo, c.cor_correlativo
        FROM app_correlativos c
        JOIN app_series s ON s.ser_id = c.cor_serid
        JOIN app_documentos d ON d.doc_id = c.cor_docid
        WHERE c.cor_serid = $id_serie")->row();
    }

    public function correlativo(int $id_serie, int $id_documento)
    {
        return $this->consultar("SELECT c.cor_id, c.cor_serid, c.cor_docid, s.ser_descripcion, s.ser_impuesto, d.doc_prefijo, c.cor_correlativo
        FROM app_correlativos c
        JOIN app_series s ON s.ser_id = c.cor_serid
        JOIN app_documentos d ON d.doc_id = c.cor_docid
        WHERE c.cor_serid = $id_serie AND c.cor_docid = $id_documento")->row();
    }
}
