<?php

namespace App\Controladores;

use App\Modelos\Cmpfactura;
use App\Modelos\CmpfacturaArticulos;
use App\Modelos\Cmpnotas;
use App\Modelos\CmpnotasArticulos;
use App\Modelos\CmpPedidos;
use App\Modelos\CmpPedidosArticulos;
use App\Modelos\Convertirdocumento;
use App\Modelos\Notasdeentrega;
use App\Modelos\NotasdeentregaArticulos;
use App\Modelos\Ordendeentrega;
use App\Modelos\OrdendeentregaArticulos;
use App\Modelos\Pedidos;
use App\Modelos\PedidosArticulos;
use App\Modelos\Presupuesto;
use App\Modelos\PresupuestoArticulos;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Helpers\Notifica;
use Core\Librerias\Http;

final class ConvertirdocumentoControlador extends Controller
{
    private $convertir_model;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->convertir_model = new Convertirdocumento();
    }

    public function obtenerDatos(int $sucursal)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $sucursal = filter_var($sucursal, FILTER_SANITIZE_NUMBER_INT);

            Http::json_response([
                'almacenes'     => $this->convertir_model->almacenes($sucursal),
                'divisas'       => $this->convertir_model->Divisas(),
                'series'        => $this->convertir_model->Series($sucursal)
            ]);
        }
    }

    public function obtenerSucursalesEmpleado()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $suc = $this->convertir_model->sucursales();

            $ID = '';
            foreach ($suc as $row) {
                if ($row['sucursal_predeterminado'] == 1) {
                    $ID = $row['sucursal_id'];
                }
            }

            if ($ID == "" && count($suc) > 0) {
                $ID = $suc[0]['empalm_almid'];
            }

            Http::json_response([
                'sucursales' => $suc,
                'id' => ($_SESSION['sucursal']['id'] != 0) ? $_SESSION['sucursal']['id'] : $ID,
                'desactivar' => ($_SESSION['sucursal']['id'] != 0) ? true : false
            ]);
        }
    }

    private function obtenerDescuentoMasIvaProducto(float $precio, float $iva, string $tipo_tarifa, float $tarifa)
    {
        $ivam = $precio * ($iva / 100);

        if ($tarifa > 0) {
            $precio = TarifasControlador::aplicar(null, $precio, "$tipo_tarifa", $tarifa, 0,$ivam); //DESCUENTO PRODUCTO
        }
        $ivam = $precio * ($iva / 100);
        return [
            'iva' => $ivam,
            'neto' => $precio,
            'total' => $precio + $ivam,
        ];
    }

    public function obtenerPrecioSegunDivisa(float $precio, int $id_divisa_master, int $id_divisa_buscada)
    {
        $divisa_factor = $this->convertir_model->obtenerDivisaAlCambio($id_divisa_master, $id_divisa_buscada);

        if ($divisa_factor) {
            $precio = round(($precio * $divisa_factor['df_factor']), 2);
            $factor = $divisa_factor['df_factor'];
        } else {
            $precio = $precio;
            $factor = 1;
        }

        return [
            'precio' => $precio,
            'factor' => $factor
        ];
    }

    public function convertirOrdenENFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $documento  = $this->convertir_model->obtenerDocumento(2);

                if ($serie && $documento) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Ordendeentrega();
                        $buscar_venta_articulos_model   = new OrdendeentregaArticulos();
                        $data_master                    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if (empty($this->array_errors) && $descontar == 1) {
                            if ($data_master['n_descontado'] == 1) {
                                if ($data_master['n_almid'] != $id_almacen) {
                                    $this->array_errors[] = 'EL documento que intenta convertir ya descontó inventario por lo tanto no puede cambiar los productos del almacen origen.';
                                }
                            } else {
                                foreach ($articulos as $row) {
                                    $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                        $cantidad = $this->convertir_model->chuequearStock($row['nart_proid'], $id_almacen);
                                        if ($cantidad) {
                                            if ($cantidad['ps_cantidad'] < $row['nart_procantidad']) {
                                                $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['nart_propnombre'] . ' supera la cantidad existente en Stock';
                                            }
                                        } else {
                                            $this->array_errors[] = 'Lo siento el producto ' . $row['nart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                        }
                                    }
                                }
                            }
                        }

                        if (empty($this->array_errors)) {

                            $div_facturar = Moneda::facturarPredeterminada();

                            if ($data_master['n_divid'] != $div_facturar['id']) {

                                $total_costo_servicio = 0;
                                $total_procosto = 0;
                                $i = 0;

                                foreach ($articulos as $row) {
                                    $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                    $precio = $this->obtenerPrecioSegunDivisa($row['nart_proprecio'], $data_master['n_divid'], $div_facturar['id']);
                                    $articulos[$i]['nart_proprecio'] = $precio['precio'];
                                    $pc = $row['nart_procantidad'] * $articulos[$i]['nart_proprecio'];
                                    $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['nart_proiva'], 'pvp', $row['nart_prodescuento']);
                                    $articulos[$i]['nart_ivatotal']     = round($precio['iva'], 2);
                                    $articulos[$i]['nart_proneto']          = round($precio['neto'], 2);
                                    $articulos[$i]['nart_prototal']         = round($precio['total'], 2);
                                    $costo = $this->obtenerPrecioSegunDivisa($row['nart_procosto'], $data_master['n_divid'], $div_facturar['id']);
                                    $articulos[$i]['nart_procosto'] = $costo['precio'];
                                    $costo_servicio = $this->obtenerPrecioSegunDivisa($row['nart_costo_servicio'], $data_master['n_divid'], $div_facturar['id']);
                                    $articulos[$i]['nart_costo_servicio'] = $costo_servicio['precio'];
                                    if ($producto['pro_tipo'] == 3) {
                                        $total_costo_servicio  += $articulos[$i]['nart_costo_servicio'] * $row['nart_procantidad'];
                                    } else {
                                        $total_procosto += $articulos[$i]['nart_procosto'] * $row['nart_procantidad'];
                                    }
                                    $i++;
                                }

                                $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                if ($data_master['n_descuento'] > 0) {
                                    foreach ($articulos as $row) {
                                        $articulos_cantidad += $row['nart_procantidad'];
                                        $subtotal += $row['nart_proneto'];
                                        $precio = $this->obtenerDescuentoMasIvaProducto($row['nart_proneto'], $row['nart_proiva'], 'pvp', $data_master['n_descuento'], 0);
                                        $neto += $precio['neto'];
                                        $total_iva += $precio['iva'];
                                        $total += $precio['total'];
                                    }
                                } else {
                                    foreach ($articulos as $row) {
                                        $articulos_cantidad += $row['nart_procantidad'];
                                        $neto += $row['nart_proneto'];
                                        $total_iva += $row['nart_ivatotal'];
                                        $total += $row['nart_prototal'];
                                    }
                                    $subtotal = $neto;
                                }

                                $data_master['n_articulos_total']      = $articulos_cantidad;
                                $data_master['n_subtotal']             = round($subtotal, 2);
                                $data_master['n_neto']                 = round($neto, 2);
                                $data_master['n_iva']                  = round($total_iva, 2);
                                $data_master['n_total']                = round(($neto + $total_iva), 2);
                                $data_master['total_costo_servicio']    = $total_costo_servicio;
                                $data_master['total_procosto']          = $total_procosto;
                            }

                            $modulo_origen  = $this->convertir_model->obtenerDocumento(12);

                            try {

                                $this->convertir_model->transactionBegin();

                                $id_venta = $this->convertir_model->guardar([
                                    'fm_articulos_total'    => $data_master['n_articulos_total'],
                                    'fm_subtotal'           => $data_master['n_subtotal'],
                                    'fm_neto'               => $data_master['n_neto'],
                                    'fm_iva'                => $data_master['n_iva'],
                                    'fm_descuento'          => $data_master['n_descuento'],
                                    'fm_total'              => $data_master['n_total'],
                                    'fm_divid'              => $div_facturar['id'],
                                    'fm_serid'              => $data_master['n_serid'],
                                    'fm_serie'              => $data_master['n_serie'],
                                    'fm_empresaid'          => $data_master['n_empresaid'],
                                    'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                    'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                    'fm_cliid'              => $data_master['n_cliid'],
                                    'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                    'fm_env_nombres'        => $data_master['n_env_nombres'],
                                    'fm_env_direccion'      => $data_master['n_env_direccion'],
                                    'fm_env_pais'           => $data_master['n_env_pais'],
                                    'fm_env_estado'         => $data_master['n_env_estado'],
                                    'fm_env_ciudad'         => $data_master['n_env_ciudad'],
                                    'fm_env_codigo_postal'  => $data_master['n_env_codigo_postal'],
                                    'fm_estatus'            => $data_master['n_estatus'],
                                    'fm_almid'              => $id_almacen,
                                    'fm_descontado'         => $descontar,
                                    'fm_empagente'          => $data_master['n_empagente'],
                                    'fm_descontado'         => $descontar,
                                    'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                    'total_procosto'        => $data_master['total_procosto'],
                                    'factor'                => $data_master['factor']
                                ], false, 'app_factura_master');

                                $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                $this->convertir_model->guardar([
                                    'rd_facid_procedencia'  => $id,
                                    'rd_docid_procedencia'  => 12,
                                    'rd_facid_conversion'   => $id_venta,
                                    'rd_docid_conversion'   => $documento['doc_id'],
                                    'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                    'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                ], true, 'app_ruta_documento');

                                foreach ($articulos as $row) {

                                    $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                    $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                    $cantidad = $this->convertir_model->chuequearStock($row['nart_proid'], $id_almacen);

                                    $this->convertir_model->guardar([
                                        'fa_fmid'                   => $id_venta,
                                        'fa_proid'                  => $row['nart_proid'],
                                        'fa_procodigo'              => $row['nart_procodigo'],
                                        'fa_propnombre'             => $row['nart_propnombre'],
                                        'fa_procosto'               => $row['nart_procosto'],
                                        'fa_proprecio'              => $row['nart_proprecio'],
                                        'fa_procantidad'            => $row['nart_procantidad'],
                                        'fa_prodescuento'           => $row['nart_prodescuento'],
                                        'fa_proneto'                => $row['nart_proneto'],
                                        'fa_idiva'                  => $row['nart_idiva'],
                                        'fa_almid'                  => $id_almacen,
                                        'fa_proiva'                 => $row['nart_proiva'],
                                        'fa_ivatotal'               => $row['nart_ivatotal'],
                                        'fa_prototal'               => $row['nart_prototal'],
                                        'fa_descontar_inventario'   => $row['nart_procantidad'],
                                        'fa_costo_servicio'         => $row['nart_costo_servicio']
                                    ], true, 'app_factura_articulos');

                                    if ($descontar == 1 && $producto['pro_tipo'] != 3 && $data_master['n_descontado'] == 0) {
                                        $this->convertir_model->desontardeStock($row['nart_proid'], $id_almacen, $row['nart_procantidad']);
                                        $this->convertir_model->guardar([
                                            'bsp_proid' => $row['nart_proid'],
                                            'bsp_almacen' =>  $almacen['alm_nombre'],
                                            'bsp_modulo' =>  'ventas convertir documento',
                                            'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                            'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                            'bsp_sube' => 0,
                                            'bsp_baja' => $row['nart_procantidad'],
                                            'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['nart_procantidad'],
                                            'bsp_facid' => $id_venta,
                                            'bsp_docid' => 2
                                        ], true, 'app_bitacora_stock_producto');
                                    }
                                }

                                $this->convertir_model->transactionCommit();
                            } catch (\Throwable $th) {
                                $this->convertir_model->transactionRollBack();
                                $this->array_errors[] = 'Error en transacción';
                            }

                            if (empty($this->array_errors)) {
                                Http::json_response(ruta_base() . "poseditar/verFactura/$id_venta");
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirOrdenENFacturaSeparar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $separar  = ('true' == filter_input(INPUT_POST, 'separar')) ? 1 : 0;
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $documento  = $this->convertir_model->obtenerDocumento(2);

                if ($serie && $documento) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Ordendeentrega();
                        $buscar_venta_articulos_model   = new OrdendeentregaArticulos();
                        $data_master                    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if (empty($this->array_errors) && $separar == 1) {

                            $servicio = 0;
                            $simple = 0;
                            $url = 0;
                            $url2 = 0;

                            foreach ($articulos as $row) {
                                $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);

                                if ($producto['pro_tipo'] == 3) {
                                    $servicio += 1;
                                } else {
                                    $simple += 1;
                                }
                            }

                            if ($servicio > 0) {
                                $div_facturar = Moneda::facturarPredeterminada();

                                if ($data_master['n_divid'] != $div_facturar['id']) {

                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;
                                    $i = 0;
                                    $simple = 0;
                                    $servicio = 0;

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                        if ($producto['pro_tipo'] == 3) {
                                            $precio = $this->obtenerPrecioSegunDivisa($row['nart_proprecio'], $data_master['n_divid'], $div_facturar['id']);
                                            $articulos[$i]['nart_proprecio'] = $precio['precio'];
                                            $pc = $row['nart_procantidad'] * $articulos[$i]['nart_proprecio'];
                                            $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['nart_proiva'], 'pvp', $row['nart_prodescuento']);
                                            $articulos[$i]['nart_ivatotal']     = round($precio['iva'], 2);
                                            $articulos[$i]['nart_proneto']          = round($precio['neto'], 2);
                                            $articulos[$i]['nart_prototal']         = round($precio['total'], 2);
                                            $costo = $this->obtenerPrecioSegunDivisa($row['nart_procosto'], $data_master['n_divid'], $div_facturar['id']);
                                            $articulos[$i]['nart_procosto'] = $costo['precio'];
                                            $costo_servicio = $this->obtenerPrecioSegunDivisa($row['nart_costo_servicio'], $data_master['n_divid'], $div_facturar['id']);
                                            $articulos[$i]['nart_costo_servicio'] = $costo_servicio['precio'];
                                            if ($producto['pro_tipo'] == 3) {
                                                $total_costo_servicio  += $articulos[$i]['nart_costo_servicio'] * $row['nart_procantidad'];
                                            }
                                        }
                                        $i++;
                                    }

                                    $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                    if ($data_master['n_descuento'] > 0) {
                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                            if ($producto['pro_tipo'] == 3) {
                                                $articulos_cantidad += $row['nart_procantidad'];
                                                $subtotal += $row['nart_proneto'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($row['nart_proneto'], $row['nart_proiva'], 'pvp', $data_master['n_descuento'], 0);
                                                $neto += $precio['neto'];
                                                $total_iva += $precio['iva'];
                                                $total += $precio['total'];
                                            }
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                            if ($producto['pro_tipo'] == 3) {
                                                $articulos_cantidad += $row['nart_procantidad'];
                                                $neto += $row['nart_proneto'];
                                                $total_iva += $row['nart_ivatotal'];
                                                $total += $row['nart_prototal'];
                                            }
                                        }
                                        $subtotal = $neto;
                                    }

                                    $data_master['n_articulos_total']      = $articulos_cantidad;
                                    $data_master['n_subtotal']             = round($subtotal, 2);
                                    $data_master['n_neto']                 = round($neto, 2);
                                    $data_master['n_iva']                  = round($total_iva, 2);
                                    $data_master['n_total']                = round(($neto + $total_iva), 2);
                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;
                                }

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(12);

                                try {

                                    $this->convertir_model->transactionBegin();

                                    $id_venta = $this->convertir_model->guardar([
                                        'fm_articulos_total'    => $data_master['n_articulos_total'],
                                        'fm_subtotal'           => $data_master['n_subtotal'],
                                        'fm_neto'               => $data_master['n_neto'],
                                        'fm_iva'                => $data_master['n_iva'],
                                        'fm_descuento'          => $data_master['n_descuento'],
                                        'fm_total'              => $data_master['n_total'],
                                        'fm_divid'              => $div_facturar['id'],
                                        'fm_serid'              => $data_master['n_serid'],
                                        'fm_serie'              => $data_master['n_serie'],
                                        'fm_empresaid'          => $data_master['n_empresaid'],
                                        'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'fm_cliid'              => $data_master['n_cliid'],
                                        'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'fm_env_nombres'        => $data_master['n_env_nombres'],
                                        'fm_env_direccion'      => $data_master['n_env_direccion'],
                                        'fm_env_pais'           => $data_master['n_env_pais'],
                                        'fm_env_estado'         => $data_master['n_env_estado'],
                                        'fm_env_ciudad'         => $data_master['n_env_ciudad'],
                                        'fm_env_codigo_postal'  => $data_master['n_env_codigo_postal'],
                                        'fm_estatus'            => $data_master['n_estatus'],
                                        'fm_almid'              => $id_almacen,
                                        'fm_descontado'         => $descontar,
                                        'fm_empagente'          => $data_master['n_empagente'],
                                        'fm_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => $data_master['factor']
                                    ], false, 'app_factura_master');

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 12,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ], true, 'app_ruta_documento');


                                    foreach ($articulos as $row) {

                                        $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                        $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                        $cantidad = $this->convertir_model->chuequearStock($row['nart_proid'], $id_almacen);
                                        if ($producto['pro_tipo'] == 3) {
                                            $this->convertir_model->guardar([
                                                'fa_fmid'                   => $id_venta,
                                                'fa_proid'                  => $row['nart_proid'],
                                                'fa_procodigo'              => $row['nart_procodigo'],
                                                'fa_propnombre'             => $row['nart_propnombre'],
                                                'fa_procosto'               => $row['nart_procosto'],
                                                'fa_proprecio'              => $row['nart_proprecio'],
                                                'fa_procantidad'            => $row['nart_procantidad'],
                                                'fa_prodescuento'           => $row['nart_prodescuento'],
                                                'fa_proneto'                => $row['nart_proneto'],
                                                'fa_idiva'                  => $row['nart_idiva'],
                                                'fa_almid'                  => $id_almacen,
                                                'fa_proiva'                 => $row['nart_proiva'],
                                                'fa_ivatotal'               => $row['nart_ivatotal'],
                                                'fa_prototal'               => $row['nart_prototal'],
                                                'fa_descontar_inventario'   => $row['nart_procantidad'],
                                                'fa_costo_servicio'         => $row['nart_costo_servicio']
                                            ], true, 'app_factura_articulos');
                                        }
                                    }

                                    $this->convertir_model->transactionCommit();
                                } catch (\Throwable $th) {
                                    $this->convertir_model->transactionRollBack();
                                    $this->array_errors[] = 'Error en transacción';
                                }

                                if (empty($this->array_errors)) {
                                    $url = ruta_base() . "poseditar/verFactura/$id_venta";
                                }
                            }
                            if ($simple > 0) {
                                $div_facturar = Moneda::facturarPredeterminada();

                                if ($data_master['n_divid'] != $div_facturar['id']) {

                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;
                                    $i = 0;

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                        if ($producto['pro_tipo'] == 1) {
                                            $precio = $this->obtenerPrecioSegunDivisa($row['nart_proprecio'], $data_master['n_divid'], $div_facturar['id']);
                                            $articulos[$i]['nart_proprecio'] = $precio['precio'];
                                            $pc = $row['nart_procantidad'] * $articulos[$i]['nart_proprecio'];
                                            $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['nart_proiva'], 'pvp', $row['nart_prodescuento']);
                                            $articulos[$i]['nart_ivatotal']     = round($precio['iva'], 2);
                                            $articulos[$i]['nart_proneto']          = round($precio['neto'], 2);
                                            $articulos[$i]['nart_prototal']         = round($precio['total'], 2);
                                            $costo = $this->obtenerPrecioSegunDivisa($row['nart_procosto'], $data_master['n_divid'], $div_facturar['id']);
                                            $articulos[$i]['nart_procosto'] = $costo['precio'];
                                            $costo_servicio = $this->obtenerPrecioSegunDivisa($row['nart_costo_servicio'], $data_master['n_divid'], $div_facturar['id']);
                                            $articulos[$i]['nart_costo_servicio'] = $costo_servicio['precio'];

                                            $total_procosto += $articulos[$i]['nart_procosto'] * $row['nart_procantidad'];
                                        }
                                        $i++;
                                    }

                                    $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                    if ($data_master['n_descuento'] > 0) {
                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                            if ($producto['pro_tipo'] == 1) {
                                                $articulos_cantidad += $row['nart_procantidad'];
                                                $subtotal += $row['nart_proneto'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($row['nart_proneto'], $row['nart_proiva'], 'pvp', $data_master['n_descuento'], 0);
                                                $neto += $precio['neto'];
                                                $total_iva += $precio['iva'];
                                                $total += $precio['total'];
                                            }
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                            if ($producto['pro_tipo'] == 1) {
                                                $articulos_cantidad += $row['nart_procantidad'];
                                                $neto += $row['nart_proneto'];
                                                $total_iva += $row['nart_ivatotal'];
                                                $total += $row['nart_prototal'];
                                            }
                                        }
                                        $subtotal = $neto;
                                    }

                                    $data_master['n_articulos_total']      = $articulos_cantidad;
                                    $data_master['n_subtotal']             = round($subtotal, 2);
                                    $data_master['n_neto']                 = round($neto, 2);
                                    $data_master['n_iva']                  = round($total_iva, 2);
                                    $data_master['n_total']                = round(($neto + $total_iva), 2);
                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;
                                }

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(12);

                                try {

                                    $this->convertir_model->transactionBegin();

                                    $id_venta = $this->convertir_model->guardar([
                                        'fm_articulos_total'    => $data_master['n_articulos_total'],
                                        'fm_subtotal'           => $data_master['n_subtotal'],
                                        'fm_neto'               => $data_master['n_neto'],
                                        'fm_iva'                => $data_master['n_iva'],
                                        'fm_descuento'          => $data_master['n_descuento'],
                                        'fm_total'              => $data_master['n_total'],
                                        'fm_divid'              => $div_facturar['id'],
                                        'fm_serid'              => $data_master['n_serid'],
                                        'fm_serie'              => $data_master['n_serie'],
                                        'fm_empresaid'          => $data_master['n_empresaid'],
                                        'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'fm_cliid'              => $data_master['n_cliid'],
                                        'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'fm_env_nombres'        => $data_master['n_env_nombres'],
                                        'fm_env_direccion'      => $data_master['n_env_direccion'],
                                        'fm_env_pais'           => $data_master['n_env_pais'],
                                        'fm_env_estado'         => $data_master['n_env_estado'],
                                        'fm_env_ciudad'         => $data_master['n_env_ciudad'],
                                        'fm_env_codigo_postal'  => $data_master['n_env_codigo_postal'],
                                        'fm_estatus'            => $data_master['n_estatus'],
                                        'fm_almid'              => $id_almacen,
                                        'fm_descontado'         => $descontar,
                                        'fm_empagente'          => $data_master['n_empagente'],
                                        'fm_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => $data_master['factor']
                                    ], false, 'app_factura_master');

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 12,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ], true, 'app_ruta_documento');

                                    foreach ($articulos as $row) {

                                        $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                        $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                        $cantidad = $this->convertir_model->chuequearStock($row['nart_proid'], $id_almacen);
                                        if ($producto['pro_tipo'] == 1) {
                                            $this->convertir_model->guardar([
                                                'fa_fmid'                   => $id_venta,
                                                'fa_proid'                  => $row['nart_proid'],
                                                'fa_procodigo'              => $row['nart_procodigo'],
                                                'fa_propnombre'             => $row['nart_propnombre'],
                                                'fa_procosto'               => $row['nart_procosto'],
                                                'fa_proprecio'              => $row['nart_proprecio'],
                                                'fa_procantidad'            => $row['nart_procantidad'],
                                                'fa_prodescuento'           => $row['nart_prodescuento'],
                                                'fa_proneto'                => $row['nart_proneto'],
                                                'fa_idiva'                  => $row['nart_idiva'],
                                                'fa_almid'                  => $id_almacen,
                                                'fa_proiva'                 => $row['nart_proiva'],
                                                'fa_ivatotal'               => $row['nart_ivatotal'],
                                                'fa_prototal'               => $row['nart_prototal'],
                                                'fa_descontar_inventario'   => $row['nart_procantidad'],
                                                'fa_costo_servicio'         => $row['nart_costo_servicio']
                                            ], true, 'app_factura_articulos');

                                            if ($descontar == 1 && $producto['pro_tipo'] == 1 && $data_master['n_descontado'] == 0) {
                                                $this->convertir_model->desontardeStock($row['nart_proid'], $id_almacen, $row['nart_procantidad']);
                                                $this->convertir_model->guardar([
                                                    'bsp_proid' => $row['nart_proid'],
                                                    'bsp_almacen' =>  $almacen['alm_nombre'],
                                                    'bsp_modulo' =>  'ventas convertir documento',
                                                    'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                    'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                    'bsp_sube' => 0,
                                                    'bsp_baja' => $row['nart_procantidad'],
                                                    'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['nart_procantidad'],
                                                    'bsp_facid' => $id_venta,
                                                    'bsp_docid' => 2
                                                ], true, 'app_bitacora_stock_producto');
                                            }
                                        }
                                    }

                                    $this->convertir_model->transactionCommit();
                                } catch (\Throwable $th) {
                                    $this->convertir_model->transactionRollBack();
                                    $this->array_errors[] = 'Error en transacción';
                                }

                                if (empty($this->array_errors)) {
                                    $url2 = ruta_base() . "poseditar/verFactura/$id_venta";
                                }
                            }

                            if (empty($this->array_errors)) {
                                Http::json_response([
                                    'servicios' => $url,
                                    'repuestos' => $url2
                                ]);
                            }
                        } else {
                            if (empty($this->array_errors)) {

                                $div_facturar = Moneda::facturarPredeterminada();

                                if ($data_master['n_divid'] != $div_facturar['id']) {

                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;
                                    $i = 0;

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                        $precio = $this->obtenerPrecioSegunDivisa($row['nart_proprecio'], $data_master['n_divid'], $div_facturar['id']);
                                        $articulos[$i]['nart_proprecio'] = $precio['precio'];
                                        $pc = $row['nart_procantidad'] * $articulos[$i]['nart_proprecio'];
                                        $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['nart_proiva'], 'pvp', $row['nart_prodescuento']);
                                        $articulos[$i]['nart_ivatotal']     = round($precio['iva'], 2);
                                        $articulos[$i]['nart_proneto']          = round($precio['neto'], 2);
                                        $articulos[$i]['nart_prototal']         = round($precio['total'], 2);
                                        $costo = $this->obtenerPrecioSegunDivisa($row['nart_procosto'], $data_master['n_divid'], $div_facturar['id']);
                                        $articulos[$i]['nart_procosto'] = $costo['precio'];
                                        $costo_servicio = $this->obtenerPrecioSegunDivisa($row['nart_costo_servicio'], $data_master['n_divid'], $div_facturar['id']);
                                        $articulos[$i]['nart_costo_servicio'] = $costo_servicio['precio'];
                                        if ($producto['pro_tipo'] == 3) {
                                            $total_costo_servicio  += $articulos[$i]['nart_costo_servicio'] * $row['nart_procantidad'];
                                        } else {
                                            $total_procosto += $articulos[$i]['nart_procosto'] * $row['nart_procantidad'];
                                        }
                                        $i++;
                                    }

                                    $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                    if ($data_master['n_descuento'] > 0) {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['nart_procantidad'];
                                            $subtotal += $row['nart_proneto'];
                                            $precio = $this->obtenerDescuentoMasIvaProducto($row['nart_proneto'], $row['nart_proiva'], 'pvp', $data_master['n_descuento'], 0);
                                            $neto += $precio['neto'];
                                            $total_iva += $precio['iva'];
                                            $total += $precio['total'];
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['nart_procantidad'];
                                            $neto += $row['nart_proneto'];
                                            $total_iva += $row['nart_ivatotal'];
                                            $total += $row['nart_prototal'];
                                        }
                                        $subtotal = $neto;
                                    }

                                    $data_master['n_articulos_total']      = $articulos_cantidad;
                                    $data_master['n_subtotal']             = round($subtotal, 2);
                                    $data_master['n_neto']                 = round($neto, 2);
                                    $data_master['n_iva']                  = round($total_iva, 2);
                                    $data_master['n_total']                = round(($neto + $total_iva), 2);
                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;
                                }

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(12);

                                try {

                                    $this->convertir_model->transactionBegin();

                                    $id_venta = $this->convertir_model->guardar([
                                        'fm_articulos_total'    => $data_master['n_articulos_total'],
                                        'fm_subtotal'           => $data_master['n_subtotal'],
                                        'fm_neto'               => $data_master['n_neto'],
                                        'fm_iva'                => $data_master['n_iva'],
                                        'fm_descuento'          => $data_master['n_descuento'],
                                        'fm_total'              => $data_master['n_total'],
                                        'fm_divid'              => $div_facturar['id'],
                                        'fm_serid'              => $data_master['n_serid'],
                                        'fm_serie'              => $data_master['n_serie'],
                                        'fm_empresaid'          => $data_master['n_empresaid'],
                                        'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'fm_cliid'              => $data_master['n_cliid'],
                                        'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'fm_env_nombres'        => $data_master['n_env_nombres'],
                                        'fm_env_direccion'      => $data_master['n_env_direccion'],
                                        'fm_env_pais'           => $data_master['n_env_pais'],
                                        'fm_env_estado'         => $data_master['n_env_estado'],
                                        'fm_env_ciudad'         => $data_master['n_env_ciudad'],
                                        'fm_env_codigo_postal'  => $data_master['n_env_codigo_postal'],
                                        'fm_estatus'            => $data_master['n_estatus'],
                                        'fm_almid'              => $id_almacen,
                                        'fm_descontado'         => $descontar,
                                        'fm_empagente'          => $data_master['n_empagente'],
                                        'fm_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => $data_master['factor']
                                    ], false, 'app_factura_master');

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 12,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ], true, 'app_ruta_documento');

                                    foreach ($articulos as $row) {

                                        $producto = $this->convertir_model->obtenerProducto($row['nart_proid']);
                                        $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                        $cantidad = $this->convertir_model->chuequearStock($row['nart_proid'], $id_almacen);

                                        $this->convertir_model->guardar([
                                            'fa_fmid'                   => $id_venta,
                                            'fa_proid'                  => $row['nart_proid'],
                                            'fa_procodigo'              => $row['nart_procodigo'],
                                            'fa_propnombre'             => $row['nart_propnombre'],
                                            'fa_procosto'               => $row['nart_procosto'],
                                            'fa_proprecio'              => $row['nart_proprecio'],
                                            'fa_procantidad'            => $row['nart_procantidad'],
                                            'fa_prodescuento'           => $row['nart_prodescuento'],
                                            'fa_proneto'                => $row['nart_proneto'],
                                            'fa_idiva'                  => $row['nart_idiva'],
                                            'fa_almid'                  => $id_almacen,
                                            'fa_proiva'                 => $row['nart_proiva'],
                                            'fa_ivatotal'               => $row['nart_ivatotal'],
                                            'fa_prototal'               => $row['nart_prototal'],
                                            'fa_descontar_inventario'   => $row['nart_procantidad'],
                                            'fa_costo_servicio'         => $row['nart_costo_servicio']
                                        ], true, 'app_factura_articulos');

                                        if ($descontar == 1 && $producto['pro_tipo'] != 3 && $data_master['n_descontado'] == 0) {
                                            $this->convertir_model->desontardeStock($row['nart_proid'], $id_almacen, $row['nart_procantidad']);
                                            $this->convertir_model->guardar([
                                                'bsp_proid' => $row['nart_proid'],
                                                'bsp_almacen' =>  $almacen['alm_nombre'],
                                                'bsp_modulo' =>  'ventas convertir documento',
                                                'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                'bsp_sube' => 0,
                                                'bsp_baja' => $row['nart_procantidad'],
                                                'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['nart_procantidad'],
                                                'bsp_facid' => $id_venta,
                                                'bsp_docid' => 2
                                            ], true, 'app_bitacora_stock_producto');
                                        }
                                    }

                                    $this->convertir_model->transactionCommit();
                                } catch (\Throwable $th) {
                                    $this->convertir_model->transactionRollBack();
                                    $this->array_errors[] = 'Error en transacción';
                                }

                                if (empty($this->array_errors)) {
                                    Http::json_response(ruta_base() . "poseditar/verFactura/$id_venta");
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirNotaENFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;
            $separar  = ('true' == filter_input(INPUT_POST, 'separar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $documento  = $this->convertir_model->obtenerDocumento(2);

                if ($serie && $documento) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Notasdeentrega();
                        $buscar_venta_articulos_model   = new NotasdeentregaArticulos();
                        $data_master                    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if ($separar == 1) {
                            $servicio = 0;
                            $simple = 0;
                            $url = 0;
                            $url2 = 0;

                            foreach ($articulos as $row) {
                                $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);

                                if ($producto['pro_tipo'] == 3) {
                                    $servicio += 1;
                                } else {
                                    $simple += 1;
                                }
                            }
                            if ($servicio > 0) {
                                if (empty($this->array_errors)) {

                                    $div_facturar = Moneda::facturarPredeterminada();

                                    if ($data_master['ne_divid'] != $div_facturar['id']) {

                                        $total_costo_servicio = 0;
                                        $total_procosto = 0;
                                        $i = 0;

                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                            if ($producto['pro_tipo'] == 3) {
                                                //$producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                                $precio = $this->obtenerPrecioSegunDivisa($row['neart_proprecio'], $data_master['ne_divid'], $div_facturar['id']);
                                                $articulos[$i]['neart_proprecio'] = $precio['precio'];
                                                $pc = $row['neart_procantidad'] * $articulos[$i]['neart_proprecio'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['neart_proiva'], 'pvp', $row['neart_prodescuento']);
                                                $articulos[$i]['neart_ivatotal']     = round($precio['iva'], 2);
                                                $articulos[$i]['neart_proneto']          = round($precio['neto'], 2);
                                                $articulos[$i]['neart_prototal']         = round($precio['total'], 2);
                                                $costo = $this->obtenerPrecioSegunDivisa($row['neart_procosto'], $data_master['ne_divid'], $div_facturar['id']);
                                                $articulos[$i]['neart_procosto'] = $costo['precio'];
                                                $costo_servicio = $this->obtenerPrecioSegunDivisa($row['neart_costo_servicio'], $data_master['ne_divid'], $div_facturar['id']);
                                                $articulos[$i]['neart_costo_servicio'] = $costo_servicio['precio'];
                                                if ($producto['pro_tipo'] == 3) {
                                                    $total_costo_servicio  += $articulos[$i]['neart_costo_servicio'] * $row['neart_procantidad'];
                                                } else {
                                                    $total_procosto += $articulos[$i]['neart_procosto'] * $row['neart_procantidad'];
                                                }
                                            }
                                            $i++;
                                        }

                                        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                        if ($data_master['ne_descuento'] > 0) {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                                if ($producto['pro_tipo'] == 3) {
                                                    $articulos_cantidad += $row['neart_procantidad'];
                                                    $subtotal += $row['neart_proneto'];
                                                    $precio = $this->obtenerDescuentoMasIvaProducto($row['neart_proneto'], $row['neart_proiva'], 'pvp', $data_master['ne_descuento'], 0);
                                                    $neto += $precio['neto'];
                                                    $total_iva += $precio['iva'];
                                                    $total += $precio['total'];
                                                }
                                            }
                                        } else {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                                if ($producto['pro_tipo'] == 3) {
                                                    $articulos_cantidad += $row['neart_procantidad'];
                                                    $neto += $row['neart_proneto'];
                                                    $total_iva += $row['neart_ivatotal'];
                                                    $total += $row['neart_prototal'];
                                                }
                                            }
                                            $subtotal = $neto;
                                        }

                                        $data_master['ne_articulos_total']      = $articulos_cantidad;
                                        $data_master['ne_subtotal']             = round($subtotal, 2);
                                        $data_master['ne_neto']                 = round($neto, 2);
                                        $data_master['ne_iva']                  = round($total_iva, 2);
                                        $data_master['ne_total']                = round(($neto + $total_iva), 2);
                                        $data_master['total_costo_servicio']    = $total_costo_servicio;
                                        $data_master['total_procosto']          = $total_procosto;
                                    }

                                    $modulo_origen  = $this->convertir_model->obtenerDocumento(1);

                                    try {

                                        $this->convertir_model->transactionBegin();

                                        $id_venta = $this->convertir_model->guardar([
                                            'fm_articulos_total'    => $data_master['ne_articulos_total'],
                                            'fm_subtotal'           => $data_master['ne_subtotal'],
                                            'fm_neto'               => $data_master['ne_neto'],
                                            'fm_iva'                => $data_master['ne_iva'],
                                            'fm_descuento'          => $data_master['ne_descuento'],
                                            'fm_total'              => $data_master['ne_total'],
                                            'fm_divid'              => $div_facturar['id'],
                                            'fm_serid'              => $data_master['ne_serid'],
                                            'fm_serie'              => $data_master['ne_serie'],
                                            'fm_empresaid'          => $data_master['ne_empresaid'],
                                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                            'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                            'fm_cliid'              => $data_master['ne_cliid'],
                                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                            'fm_env_nombres'        => $data_master['ne_env_nombres'],
                                            'fm_env_direccion'      => $data_master['ne_env_direccion'],
                                            'fm_env_pais'           => $data_master['ne_env_pais'],
                                            'fm_env_estado'         => $data_master['ne_env_estado'],
                                            'fm_env_ciudad'         => $data_master['ne_env_ciudad'],
                                            'fm_env_codigo_postal'  => $data_master['ne_env_codigo_postal'],
                                            'fm_estatus'            => $data_master['ne_estatus'],
                                            'fm_almid'              => $id_almacen,
                                            'fm_descontado'         => $descontar,
                                            'fm_empagente'          => $data_master['ne_empagente'],
                                            'fm_descontado'         => $descontar,
                                            'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                            'total_procosto'        => $data_master['total_procosto'],
                                            'factor'                => $data_master['factor'],
                                            'fm_surcid'             => $sucursal
                                        ], false, 'app_factura_master');

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 1,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ], true, 'app_ruta_documento');

                                        foreach ($articulos as $row) {

                                            $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                            $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                            $cantidad = $this->convertir_model->chuequearStock($row['neart_proid'], $id_almacen);

                                            if ($producto['pro_tipo'] == 3) {
                                                $this->convertir_model->guardar([
                                                    'fa_fmid'                   => $id_venta,
                                                    'fa_proid'                  => $row['neart_proid'],
                                                    'fa_procodigo'              => $row['neart_procodigo'],
                                                    'fa_propnombre'             => $row['neart_propnombre'],
                                                    'fa_procosto'               => $row['neart_procosto'],
                                                    'fa_proprecio'              => $row['neart_proprecio'],
                                                    'fa_procantidad'            => $row['neart_procantidad'],
                                                    'fa_prodescuento'           => $row['neart_prodescuento'],
                                                    'fa_proneto'                => $row['neart_proneto'],
                                                    'fa_idiva'                  => $row['neart_idiva'],
                                                    'fa_almid'                  => $id_almacen,
                                                    'fa_proiva'                 => $row['neart_proiva'],
                                                    'fa_ivatotal'               => $row['neart_ivatotal'],
                                                    'fa_prototal'               => $row['neart_prototal'],
                                                    'fa_descontar_inventario'   => $row['neart_procantidad'],
                                                    'fa_costo_servicio'         => $row['neart_costo_servicio']
                                                ], true, 'app_factura_articulos');
                                            }
                                        }

                                        $this->convertir_model->transactionCommit();
                                    } catch (\Throwable $th) {
                                        $this->convertir_model->transactionRollBack();
                                        $this->array_errors[] = 'Error en transacción';
                                    }

                                    if (empty($this->array_errors)) {
                                        $url = ruta_base() . "poseditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if ($simple > 0) {

                                if (empty($this->array_errors) && $descontar == 1) {
                                    if ($data_master['ne_descontado'] == 1) {
                                        if ($data_master['ne_almid'] != $id_almacen) {
                                            $this->array_errors[] = 'EL documento que intenta convertir ya descontó inventario por lo tanto no puede cambiar los productos del almacen origen.';
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                            if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                                $cantidad = $this->convertir_model->chuequearStock($row['neart_proid'], $id_almacen);
                                                if ($cantidad) {
                                                    if ($cantidad['ps_cantidad'] < $row['neart_procantidad']) {
                                                        $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['neart_propnombre'] . ' supera la cantidad existente en Stock';
                                                    }
                                                } else {
                                                    $this->array_errors[] = 'Lo siento el producto ' . $row['neart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                                }
                                            }
                                        }
                                    }
                                }

                                if (empty($this->array_errors)) {

                                    $div_facturar = Moneda::facturarPredeterminada();

                                    if ($data_master['ne_divid'] != $div_facturar['id']) {

                                        $total_costo_servicio = 0;
                                        $total_procosto = 0;
                                        $i = 0;

                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                            if ($producto['pro_tipo'] != 3) {
                                                $precio = $this->obtenerPrecioSegunDivisa($row['neart_proprecio'], $data_master['ne_divid'], $div_facturar['id']);
                                                $articulos[$i]['neart_proprecio'] = $precio['precio'];
                                                $pc = $row['neart_procantidad'] * $articulos[$i]['neart_proprecio'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['neart_proiva'], 'pvp', $row['neart_prodescuento']);
                                                $articulos[$i]['neart_ivatotal']     = round($precio['iva'], 2);
                                                $articulos[$i]['neart_proneto']          = round($precio['neto'], 2);
                                                $articulos[$i]['neart_prototal']         = round($precio['total'], 2);
                                                $costo = $this->obtenerPrecioSegunDivisa($row['neart_procosto'], $data_master['ne_divid'], $div_facturar['id']);
                                                $articulos[$i]['neart_procosto'] = $costo['precio'];
                                                $costo_servicio = $this->obtenerPrecioSegunDivisa($row['neart_costo_servicio'], $data_master['ne_divid'], $div_facturar['id']);
                                                $articulos[$i]['neart_costo_servicio'] = $costo_servicio['precio'];
                                                if ($row['pro_tipo'] == 3) {
                                                    $total_costo_servicio  += $articulos[$i]['neart_costo_servicio'] * $row['neart_procantidad'];
                                                } else {
                                                    $total_procosto += $articulos[$i]['neart_procosto'] * $row['neart_procantidad'];
                                                }
                                            }
                                            $i++;
                                        }

                                        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                        if ($data_master['ne_descuento'] > 0) {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                                if ($producto['pro_tipo'] != 3) {
                                                    $articulos_cantidad += $row['neart_procantidad'];
                                                    $subtotal += $row['neart_proneto'];
                                                    $precio = $this->obtenerDescuentoMasIvaProducto($row['neart_proneto'], $row['neart_proiva'], 'pvp', $data_master['ne_descuento'], 0);
                                                    $neto += $precio['neto'];
                                                    $total_iva += $precio['iva'];
                                                    $total += $precio['total'];
                                                }
                                            }
                                        } else {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                                if ($producto['pro_tipo'] != 3) {
                                                    $articulos_cantidad += $row['neart_procantidad'];
                                                    $neto += $row['neart_proneto'];
                                                    $total_iva += $row['neart_ivatotal'];
                                                    $total += $row['neart_prototal'];
                                                }
                                            }
                                            $subtotal = $neto;
                                        }

                                        $data_master['ne_articulos_total']      = $articulos_cantidad;
                                        $data_master['ne_subtotal']             = round($subtotal, 2);
                                        $data_master['ne_neto']                 = round($neto, 2);
                                        $data_master['ne_iva']                  = round($total_iva, 2);
                                        $data_master['ne_total']                = round(($neto + $total_iva), 2);
                                        $data_master['total_costo_servicio']    = $total_costo_servicio;
                                        $data_master['total_procosto']          = $total_procosto;
                                    }

                                    $modulo_origen  = $this->convertir_model->obtenerDocumento(1);

                                    try {

                                        $this->convertir_model->transactionBegin();

                                        $id_venta = $this->convertir_model->guardar([
                                            'fm_articulos_total'    => $data_master['ne_articulos_total'],
                                            'fm_subtotal'           => $data_master['ne_subtotal'],
                                            'fm_neto'               => $data_master['ne_neto'],
                                            'fm_iva'                => $data_master['ne_iva'],
                                            'fm_descuento'          => $data_master['ne_descuento'],
                                            'fm_total'              => $data_master['ne_total'],
                                            'fm_divid'              => $div_facturar['id'],
                                            'fm_serid'              => $data_master['ne_serid'],
                                            'fm_serie'              => $data_master['ne_serie'],
                                            'fm_empresaid'          => $data_master['ne_empresaid'],
                                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                            'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                            'fm_cliid'              => $data_master['ne_cliid'],
                                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                            'fm_env_nombres'        => $data_master['ne_env_nombres'],
                                            'fm_env_direccion'      => $data_master['ne_env_direccion'],
                                            'fm_env_pais'           => $data_master['ne_env_pais'],
                                            'fm_env_estado'         => $data_master['ne_env_estado'],
                                            'fm_env_ciudad'         => $data_master['ne_env_ciudad'],
                                            'fm_env_codigo_postal'  => $data_master['ne_env_codigo_postal'],
                                            'fm_estatus'            => $data_master['ne_estatus'],
                                            'fm_almid'              => $id_almacen,
                                            'fm_descontado'         => $descontar,
                                            'fm_empagente'          => $data_master['ne_empagente'],
                                            'fm_descontado'         => $descontar,
                                            'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                            'total_procosto'        => $data_master['total_procosto'],
                                            'factor'                => $data_master['factor'],
                                            'fm_surcid'             => $sucursal
                                        ], false, 'app_factura_master');

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 1,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ], true, 'app_ruta_documento');

                                        foreach ($articulos as $row) {

                                            $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                            if ($producto['pro_tipo'] != 3) {
                                                $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                                $cantidad = $this->convertir_model->chuequearStock($row['neart_proid'], $id_almacen);

                                                $this->convertir_model->guardar([
                                                    'fa_fmid'                   => $id_venta,
                                                    'fa_proid'                  => $row['neart_proid'],
                                                    'fa_procodigo'              => $row['neart_procodigo'],
                                                    'fa_propnombre'             => $row['neart_propnombre'],
                                                    'fa_procosto'               => $row['neart_procosto'],
                                                    'fa_proprecio'              => $row['neart_proprecio'],
                                                    'fa_procantidad'            => $row['neart_procantidad'],
                                                    'fa_prodescuento'           => $row['neart_prodescuento'],
                                                    'fa_proneto'                => $row['neart_proneto'],
                                                    'fa_idiva'                  => $row['neart_idiva'],
                                                    'fa_almid'                  => $id_almacen,
                                                    'fa_proiva'                 => $row['neart_proiva'],
                                                    'fa_ivatotal'               => $row['neart_ivatotal'],
                                                    'fa_prototal'               => $row['neart_prototal'],
                                                    'fa_descontar_inventario'   => $row['neart_procantidad'],
                                                    'fa_costo_servicio'         => $row['neart_costo_servicio']
                                                ], true, 'app_factura_articulos');

                                                if ($descontar == 1 && $producto['pro_tipo'] != 3 && $data_master['ne_descontado'] == 0) {
                                                    $this->convertir_model->desontardeStock($row['neart_proid'], $id_almacen, $row['neart_procantidad']);
                                                    $this->convertir_model->guardar([
                                                        'bsp_proid' => $row['neart_proid'],
                                                        'bsp_almacen' =>  $almacen['alm_nombre'],
                                                        'bsp_modulo' =>  'ventas convertir documento',
                                                        'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                        'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                        'bsp_sube' => 0,
                                                        'bsp_baja' => $row['neart_procantidad'],
                                                        'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['neart_procantidad'],
                                                        'bsp_facid' => $id_venta,
                                                        'bsp_docid' => 2
                                                    ], true, 'app_bitacora_stock_producto');
                                                }
                                            }
                                        }

                                        $this->convertir_model->transactionCommit();
                                    } catch (\Throwable $th) {
                                        $this->convertir_model->transactionRollBack();
                                        $this->array_errors[] = 'Error en transacción';
                                    }

                                    if (empty($this->array_errors)) {
                                        $url2 = ruta_base() . "poseditar/verFactura/$id_venta";
                                    }
                                }
                            }

                            if (empty($this->array_errors)) {
                                Http::json_response([
                                    'servicios' => $url,
                                    'repuestos' => $url2
                                ]);
                            }
                        } else {

                            if (empty($this->array_errors) && $descontar == 1) {
                                if ($data_master['ne_descontado'] == 1) {
                                    if ($data_master['ne_almid'] != $id_almacen) {
                                        $this->array_errors[] = 'EL documento que intenta convertir ya descontó inventario por lo tanto no puede cambiar los productos del almacen origen.';
                                    }
                                } else {
                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                        if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                            $cantidad = $this->convertir_model->chuequearStock($row['neart_proid'], $id_almacen);
                                            if ($cantidad) {
                                                if ($cantidad['ps_cantidad'] < $row['neart_procantidad']) {
                                                    $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['neart_propnombre'] . ' supera la cantidad existente en Stock';
                                                }
                                            } else {
                                                $this->array_errors[] = 'Lo siento el producto ' . $row['neart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                            }
                                        }
                                    }
                                }
                            }

                            if (empty($this->array_errors)) {

                                $div_facturar = Moneda::facturarPredeterminada();

                                if ($data_master['ne_divid'] != $div_facturar['id']) {

                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;
                                    $i = 0;

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                        $precio = $this->obtenerPrecioSegunDivisa($row['neart_proprecio'], $data_master['ne_divid'], $div_facturar['id']);
                                        $articulos[$i]['neart_proprecio'] = $precio['precio'];
                                        $pc = $row['neart_procantidad'] * $articulos[$i]['neart_proprecio'];
                                        $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['neart_proiva'], 'pvp', $row['neart_prodescuento']);
                                        $articulos[$i]['neart_ivatotal']     = round($precio['iva'], 2);
                                        $articulos[$i]['neart_proneto']          = round($precio['neto'], 2);
                                        $articulos[$i]['neart_prototal']         = round($precio['total'], 2);
                                        $costo = $this->obtenerPrecioSegunDivisa($row['neart_procosto'], $data_master['ne_divid'], $div_facturar['id']);
                                        $articulos[$i]['neart_procosto'] = $costo['precio'];
                                        $costo_servicio = $this->obtenerPrecioSegunDivisa($row['neart_costo_servicio'], $data_master['ne_divid'], $div_facturar['id']);
                                        $articulos[$i]['neart_costo_servicio'] = $costo_servicio['precio'];
                                        if ($row['pro_tipo'] == 3) {
                                            $total_costo_servicio  += $articulos[$i]['neart_costo_servicio'] * $row['neart_procantidad'];
                                        } else {
                                            $total_procosto += $articulos[$i]['neart_procosto'] * $row['neart_procantidad'];
                                        }
                                        $i++;
                                    }

                                    $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                    if ($data_master['ne_descuento'] > 0) {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['neart_procantidad'];
                                            $subtotal += $row['neart_proneto'];
                                            $precio = $this->obtenerDescuentoMasIvaProducto($row['neart_proneto'], $row['neart_proiva'], 'pvp', $data_master['ne_descuento'], 0);
                                            $neto += $precio['neto'];
                                            $total_iva += $precio['iva'];
                                            $total += $precio['total'];
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['neart_procantidad'];
                                            $neto += $row['neart_proneto'];
                                            $total_iva += $row['neart_ivatotal'];
                                            $total += $row['neart_prototal'];
                                        }
                                        $subtotal = $neto;
                                    }

                                    $data_master['ne_articulos_total']      = $articulos_cantidad;
                                    $data_master['ne_subtotal']             = round($subtotal, 2);
                                    $data_master['ne_neto']                 = round($neto, 2);
                                    $data_master['ne_iva']                  = round($total_iva, 2);
                                    $data_master['ne_total']                = round(($neto + $total_iva), 2);
                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;
                                }

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(1);

                                try {

                                    $this->convertir_model->transactionBegin();

                                    $id_venta = $this->convertir_model->guardar([
                                        'fm_articulos_total'    => $data_master['ne_articulos_total'],
                                        'fm_subtotal'           => $data_master['ne_subtotal'],
                                        'fm_neto'               => $data_master['ne_neto'],
                                        'fm_iva'                => $data_master['ne_iva'],
                                        'fm_descuento'          => $data_master['ne_descuento'],
                                        'fm_total'              => $data_master['ne_total'],
                                        'fm_divid'              => $div_facturar['id'],
                                        'fm_serid'              => $data_master['ne_serid'],
                                        'fm_serie'              => $data_master['ne_serie'],
                                        'fm_empresaid'          => $data_master['ne_empresaid'],
                                        'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'fm_cliid'              => $data_master['ne_cliid'],
                                        'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'fm_env_nombres'        => $data_master['ne_env_nombres'],
                                        'fm_env_direccion'      => $data_master['ne_env_direccion'],
                                        'fm_env_pais'           => $data_master['ne_env_pais'],
                                        'fm_env_estado'         => $data_master['ne_env_estado'],
                                        'fm_env_ciudad'         => $data_master['ne_env_ciudad'],
                                        'fm_env_codigo_postal'  => $data_master['ne_env_codigo_postal'],
                                        'fm_estatus'            => $data_master['ne_estatus'],
                                        'fm_almid'              => $id_almacen,
                                        'fm_descontado'         => $descontar,
                                        'fm_empagente'          => $data_master['ne_empagente'],
                                        'fm_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => $data_master['factor'],
                                        'fm_surcid'             => $sucursal
                                    ], false, 'app_factura_master');

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 1,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ], true, 'app_ruta_documento');

                                    foreach ($articulos as $row) {

                                        $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);
                                        $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                        $cantidad = $this->convertir_model->chuequearStock($row['neart_proid'], $id_almacen);

                                        $this->convertir_model->guardar([
                                            'fa_fmid'                   => $id_venta,
                                            'fa_proid'                  => $row['neart_proid'],
                                            'fa_procodigo'              => $row['neart_procodigo'],
                                            'fa_propnombre'             => $row['neart_propnombre'],
                                            'fa_procosto'               => $row['neart_procosto'],
                                            'fa_proprecio'              => $row['neart_proprecio'],
                                            'fa_procantidad'            => $row['neart_procantidad'],
                                            'fa_prodescuento'           => $row['neart_prodescuento'],
                                            'fa_proneto'                => $row['neart_proneto'],
                                            'fa_idiva'                  => $row['neart_idiva'],
                                            'fa_almid'                  => $id_almacen,
                                            'fa_proiva'                 => $row['neart_proiva'],
                                            'fa_ivatotal'               => $row['neart_ivatotal'],
                                            'fa_prototal'               => $row['neart_prototal'],
                                            'fa_descontar_inventario'   => $row['neart_procantidad'],
                                            'fa_costo_servicio'         => $row['neart_costo_servicio']
                                        ], true, 'app_factura_articulos');

                                        if ($descontar == 1 && $producto['pro_tipo'] != 3 && $data_master['ne_descontado'] == 0) {
                                            $this->convertir_model->desontardeStock($row['neart_proid'], $id_almacen, $row['neart_procantidad']);
                                            $this->convertir_model->guardar([
                                                'bsp_proid' => $row['neart_proid'],
                                                'bsp_almacen' =>  $almacen['alm_nombre'],
                                                'bsp_modulo' =>  'ventas convertir documento',
                                                'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                'bsp_sube' => 0,
                                                'bsp_baja' => $row['neart_procantidad'],
                                                'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['neart_procantidad'],
                                                'bsp_facid' => $id_venta,
                                                'bsp_docid' => 2
                                            ], true, 'app_bitacora_stock_producto');
                                        }
                                    }

                                    $this->convertir_model->transactionCommit();
                                } catch (\Throwable $th) {
                                    $this->convertir_model->transactionRollBack();
                                    $this->array_errors[] = 'Error en transacción';
                                }

                                if (empty($this->array_errors)) {
                                    Http::json_response(ruta_base() . "poseditar/verFactura/$id_venta");
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirPedidoENFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;
            $separar  = ('true' == filter_input(INPUT_POST, 'separar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';
            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $documento  = $this->convertir_model->obtenerDocumento(2);
                $almacen    = $this->convertir_model->obtenerAlmacen($id_almacen);

                if ($serie && $documento && $almacen) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Pedidos();
                        $buscar_venta_articulos_model   = new PedidosArticulos();
                        $data_master = $buscar_venta_model->obtenerFactura($id);
                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if ($separar == 1) {
                            $servicio = 0;
                            $simple = 0;
                            $url = 0;
                            $url2 = 0;

                            foreach ($articulos as $row) {
                                $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);

                                if ($producto['pro_tipo'] == 3) {
                                    $servicio += 1;
                                } else {
                                    $simple += 1;
                                }
                            }
                            if ($servicio > 0) {
                                if (empty($this->array_errors)) {

                                    $div_facturar = Moneda::facturarPredeterminada();
                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;

                                    if ($data_master['pe_divid'] != $div_facturar['id']) {

                                        $i = 0;

                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($producto['pro_tipo'] == 3) {
                                                $precio = $this->obtenerPrecioSegunDivisa($row['peart_proprecio'], $data_master['pe_divid'], $div_facturar['id']);
                                                $articulos[$i]['peart_proprecio'] = $precio['precio'];
                                                $pc = $row['peart_procantidad'] * $articulos[$i]['peart_proprecio'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['peart_proiva'], 'pvp', $row['peart_prodescuento']);
                                                $articulos[$i]['peart_ivatotal']     = round($precio['iva'], 2);
                                                $articulos[$i]['peart_proneto']          = round($precio['neto'], 2);
                                                $articulos[$i]['peart_prototal']         = round($precio['total'], 2);
                                                $costo = $this->obtenerPrecioSegunDivisa($row['peart_procosto'], $data_master['pe_divid'], $div_facturar['id']);
                                                $articulos[$i]['peart_procosto'] = $costo['precio'];
                                            }
                                            $i++;
                                        }

                                        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                        if ($data_master['pe_descuento'] > 0) {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                                if ($producto['pro_tipo'] == 3) {
                                                    $articulos_cantidad += $row['peart_procantidad'];
                                                    $subtotal += $row['peart_proneto'];
                                                    $precio = $this->obtenerDescuentoMasIvaProducto($row['peart_proneto'], $row['peart_proiva'], 'pvp', $data_master['pe_descuento'], 0);
                                                    $neto += $precio['neto'];
                                                    $total_iva += $precio['iva'];
                                                    $total += $precio['total'];
                                                }
                                            }
                                        } else {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                                if ($producto['pro_tipo'] == 3) {
                                                    $articulos_cantidad += $row['peart_procantidad'];
                                                    $neto += $row['peart_proneto'];
                                                    $total_iva += $row['peart_ivatotal'];
                                                    $total += $row['peart_prototal'];
                                                }
                                            }
                                            $subtotal = $neto;
                                        }

                                        $data_master['pe_subtotal']             = round($subtotal, 2);
                                        $data_master['pe_neto']                 = round($neto, 2);
                                        $data_master['pe_iva']                  = round($total_iva, 2);
                                        $data_master['pe_total']                = round(($neto + $total_iva), 2);
                                    }

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        if ($producto['pro_tipo'] == 3) {
                                            $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($tipo['pro_tipo'] == 3) {
                                                $total_costo_servicio += $row['peart_procosto'] * $row['peart_procantidad'];
                                            } else {
                                                $total_procosto += $row['peart_procosto'] * $row['peart_procantidad'];
                                            }
                                        }
                                    }

                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;

                                    $modulo_origen  = $this->convertir_model->obtenerDocumento(4);

                                    try {

                                        $this->convertir_model->transactionBegin();

                                        $id_venta = $this->convertir_model->guardar([
                                            'fm_articulos_total'    => $data_master['pe_articulos_total'],
                                            'fm_subtotal'           => $data_master['pe_subtotal'],
                                            'fm_neto'               => $data_master['pe_neto'],
                                            'fm_iva'                => $data_master['pe_iva'],
                                            'fm_descuento'          => $data_master['pe_descuento'],
                                            'fm_total'              => $data_master['pe_total'],
                                            'fm_divid'              => $div_facturar['id'],
                                            'fm_serid'              => $data_master['pe_serid'],
                                            'fm_serie'              => $data_master['pe_serie'],
                                            'fm_empresaid'          => $data_master['pe_empresaid'],
                                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                            'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                            'fm_cliid'              => $data_master['pe_cliid'],
                                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                            'fm_env_nombres'        => $data_master['pe_env_nombres'],
                                            'fm_env_direccion'      => $data_master['pe_env_direccion'],
                                            'fm_env_pais'           => $data_master['pe_env_pais'],
                                            'fm_env_estado'         => $data_master['pe_env_estado'],
                                            'fm_env_ciudad'         => $data_master['pe_env_ciudad'],
                                            'fm_env_codigo_postal'  => $data_master['pe_env_codigo_postal'],
                                            'fm_estatus'            => 2,
                                            'fm_almid'              => $id_almacen,
                                            'fm_descontado'         => $descontar,
                                            'fm_empagente'          => $data_master['pe_empagente'],
                                            'fm_descontado'         => $descontar,
                                            'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                            'total_procosto'        => $data_master['total_procosto'],
                                            'factor'                => 1,
                                            'fm_surcid'             => $sucursal
                                        ], false, 'app_factura_master');

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 4,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ], true, 'app_ruta_documento');

                                        foreach ($articulos as $row) {

                                            $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($producto['pro_tipo'] == 3) {
                                                $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                                $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);

                                                $this->convertir_model->guardar([
                                                    'fa_fmid'                   => $id_venta,
                                                    'fa_proid'                  => $row['peart_proid'],
                                                    'fa_procodigo'              => $row['peart_procodigo'],
                                                    'fa_propnombre'             => $row['peart_propnombre'],
                                                    'fa_procosto'               => ($producto['pro_tipo'] == 3) ? 0 : $row['peart_procosto'],
                                                    'fa_proprecio'              => $row['peart_proprecio'],
                                                    'fa_procantidad'            => $row['peart_procantidad'],
                                                    'fa_prodescuento'           => $row['peart_prodescuento'],
                                                    'fa_proneto'                => $row['peart_proneto'],
                                                    'fa_idiva'                  => $row['peart_idiva'],
                                                    'fa_almid'                  => $id_almacen,
                                                    'fa_proiva'                 => $row['peart_proiva'],
                                                    'fa_ivatotal'               => $row['peart_ivatotal'],
                                                    'fa_prototal'               => $row['peart_prototal'],
                                                    'fa_descontar_inventario'   => $row['peart_procantidad'],
                                                    'fa_costo_servicio'         => ($producto['pro_tipo'] == 3) ? $row['peart_procosto'] : 0
                                                ], true, 'app_factura_articulos');

                                                if ($descontar == 1 && ($data_master['pe_descontado'] == 0 && $producto['pro_tipo'] != 3)) {
                                                    $this->convertir_model->desontardeStock($row['peart_proid'], $id_almacen, $row['peart_procantidad']);
                                                    $this->convertir_model->guardar([
                                                        'bsp_proid' => $row['peart_proid'],
                                                        'bsp_almacen' =>  $almacen['alm_nombre'],
                                                        'bsp_modulo' =>  'ventas convertir documento',
                                                        'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                        'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                        'bsp_sube' => 0,
                                                        'bsp_baja' => $row['peart_procantidad'],
                                                        'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['peart_procantidad'],
                                                        'bsp_facid' => $id_venta,
                                                        'bsp_docid' => 2
                                                    ], true, 'app_bitacora_stock_producto');
                                                }
                                            }
                                        }

                                        $this->convertir_model->transactionCommit();
                                    } catch (\Throwable $th) {
                                        $this->convertir_model->transactionRollBack();
                                        $this->array_errors[] = 'Error en transacción';
                                    }

                                    if (empty($this->array_errors)) {
                                        $url = ruta_base() . "poseditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if ($simple > 0) {
                                if ($descontar == 1) {
                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);
                                        if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                            if ($cantidad) {
                                                if ($cantidad['ps_cantidad'] < $row['peart_procantidad']) {
                                                    $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['peart_propnombre'] . ' supera la cantidad existente en Stock';
                                                }
                                            } else {
                                                $this->array_errors[] = 'Lo siento el producto ' . $row['peart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                            }
                                        }
                                    }
                                }

                                if (empty($this->array_errors)) {

                                    /*
                                    $divisa_master = $this->convertir_model->obtenerDivisaMaster();
                                    $factor = 1;
                                    if ($data_master['pe_divid'] != $divisa_master['div_id']) {
                                        $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pe_divid'], $divisa_master['div_id']);
                                        $factor = $factor_div['df_factor'];
                                    }*/

                                    $div_facturar = Moneda::facturarPredeterminada();
                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;

                                    if ($data_master['pe_divid'] != $div_facturar['id']) {

                                        $i = 0;

                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($producto['pro_tipo'] != 3) {
                                                $precio = $this->obtenerPrecioSegunDivisa($row['peart_proprecio'], $data_master['pe_divid'], $div_facturar['id']);
                                                $articulos[$i]['peart_proprecio'] = $precio['precio'];
                                                $pc = $row['peart_procantidad'] * $articulos[$i]['peart_proprecio'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['peart_proiva'], 'pvp', $row['peart_prodescuento']);
                                                $articulos[$i]['peart_ivatotal']     = round($precio['iva'], 2);
                                                $articulos[$i]['peart_proneto']          = round($precio['neto'], 2);
                                                $articulos[$i]['peart_prototal']         = round($precio['total'], 2);
                                                $costo = $this->obtenerPrecioSegunDivisa($row['peart_procosto'], $data_master['pe_divid'], $div_facturar['id']);
                                                $articulos[$i]['peart_procosto'] = $costo['precio'];
                                            }
                                            $i++;
                                        }

                                        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                        if ($data_master['pe_descuento'] > 0) {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                                if ($producto['pro_tipo'] != 3) {
                                                    $articulos_cantidad += $row['peart_procantidad'];
                                                    $subtotal += $row['peart_proneto'];
                                                    $precio = $this->obtenerDescuentoMasIvaProducto($row['peart_proneto'], $row['peart_proiva'], 'pvp', $data_master['pe_descuento'], 0);
                                                    $neto += $precio['neto'];
                                                    $total_iva += $precio['iva'];
                                                    $total += $precio['total'];
                                                }
                                            }
                                        } else {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                                if ($producto['pro_tipo'] != 3) {
                                                    $articulos_cantidad += $row['peart_procantidad'];
                                                    $neto += $row['peart_proneto'];
                                                    $total_iva += $row['peart_ivatotal'];
                                                    $total += $row['peart_prototal'];
                                                }
                                            }
                                            $subtotal = $neto;
                                        }

                                        $data_master['pe_subtotal']             = round($subtotal, 2);
                                        $data_master['pe_neto']                 = round($neto, 2);
                                        $data_master['pe_iva']                  = round($total_iva, 2);
                                        $data_master['pe_total']                = round(($neto + $total_iva), 2);
                                    }

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        if ($producto['pro_tipo'] != 3) {
                                            $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($tipo['pro_tipo'] == 3) {
                                                $total_costo_servicio += $row['peart_procosto'] * $row['peart_procantidad'];
                                            } else {
                                                $total_procosto += $row['peart_procosto'] * $row['peart_procantidad'];
                                            }
                                        }
                                    }

                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;

                                    $modulo_origen  = $this->convertir_model->obtenerDocumento(4);

                                    try {

                                        $this->convertir_model->transactionBegin();

                                        $id_venta = $this->convertir_model->guardar([
                                            'fm_articulos_total'    => $data_master['pe_articulos_total'],
                                            'fm_subtotal'           => $data_master['pe_subtotal'],
                                            'fm_neto'               => $data_master['pe_neto'],
                                            'fm_iva'                => $data_master['pe_iva'],
                                            'fm_descuento'          => $data_master['pe_descuento'],
                                            'fm_total'              => $data_master['pe_total'],
                                            'fm_divid'              => $div_facturar['id'],
                                            'fm_serid'              => $data_master['pe_serid'],
                                            'fm_serie'              => $data_master['pe_serie'],
                                            'fm_empresaid'          => $data_master['pe_empresaid'],
                                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                            'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                            'fm_cliid'              => $data_master['pe_cliid'],
                                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                            'fm_env_nombres'        => $data_master['pe_env_nombres'],
                                            'fm_env_direccion'      => $data_master['pe_env_direccion'],
                                            'fm_env_pais'           => $data_master['pe_env_pais'],
                                            'fm_env_estado'         => $data_master['pe_env_estado'],
                                            'fm_env_ciudad'         => $data_master['pe_env_ciudad'],
                                            'fm_env_codigo_postal'  => $data_master['pe_env_codigo_postal'],
                                            'fm_estatus'            => 2,
                                            'fm_almid'              => $id_almacen,
                                            'fm_descontado'         => $descontar,
                                            'fm_empagente'          => $data_master['pe_empagente'],
                                            'fm_descontado'         => $descontar,
                                            'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                            'total_procosto'        => $data_master['total_procosto'],
                                            'factor'                => 1,
                                            'fm_surcid'             => $sucursal
                                        ], false, 'app_factura_master');

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 4,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ], true, 'app_ruta_documento');

                                        foreach ($articulos as $row) {

                                            $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($producto['pro_tipo'] != 3) {
                                                $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                                $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);

                                                $this->convertir_model->guardar([
                                                    'fa_fmid'                   => $id_venta,
                                                    'fa_proid'                  => $row['peart_proid'],
                                                    'fa_procodigo'              => $row['peart_procodigo'],
                                                    'fa_propnombre'             => $row['peart_propnombre'],
                                                    'fa_procosto'               => ($producto['pro_tipo'] == 3) ? 0 : $row['peart_procosto'],
                                                    'fa_proprecio'              => $row['peart_proprecio'],
                                                    'fa_procantidad'            => $row['peart_procantidad'],
                                                    'fa_prodescuento'           => $row['peart_prodescuento'],
                                                    'fa_proneto'                => $row['peart_proneto'],
                                                    'fa_idiva'                  => $row['peart_idiva'],
                                                    'fa_almid'                  => $id_almacen,
                                                    'fa_proiva'                 => $row['peart_proiva'],
                                                    'fa_ivatotal'               => $row['peart_ivatotal'],
                                                    'fa_prototal'               => $row['peart_prototal'],
                                                    'fa_descontar_inventario'   => $row['peart_procantidad'],
                                                    'fa_costo_servicio'         => ($producto['pro_tipo'] == 3) ? $row['peart_procosto'] : 0
                                                ], true, 'app_factura_articulos');

                                                if ($descontar == 1 && ($data_master['pe_descontado'] == 0 && $producto['pro_tipo'] != 3)) {
                                                    $this->convertir_model->desontardeStock($row['peart_proid'], $id_almacen, $row['peart_procantidad']);
                                                    $this->convertir_model->guardar([
                                                        'bsp_proid' => $row['peart_proid'],
                                                        'bsp_almacen' =>  $almacen['alm_nombre'],
                                                        'bsp_modulo' =>  'ventas convertir documento',
                                                        'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                        'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                        'bsp_sube' => 0,
                                                        'bsp_baja' => $row['peart_procantidad'],
                                                        'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['peart_procantidad'],
                                                        'bsp_facid' => $id_venta,
                                                        'bsp_docid' => 2
                                                    ], true, 'app_bitacora_stock_producto');
                                                }
                                            }
                                        }

                                        $this->convertir_model->transactionCommit();
                                    } catch (\Throwable $th) {
                                        $this->convertir_model->transactionRollBack();
                                        $this->array_errors[] = 'Error en transacción';
                                    }

                                    if (empty($this->array_errors)) {
                                        $url2 = ruta_base() . "poseditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if (empty($this->array_errors)) {
                                Http::json_response([
                                    'servicios' => $url,
                                    'repuestos' => $url2
                                ]);
                            }
                        } else {
                            if ($descontar == 1) {
                                foreach ($articulos as $row) {
                                    $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                    $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);
                                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                        if ($cantidad) {
                                            if ($cantidad['ps_cantidad'] < $row['peart_procantidad']) {
                                                $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['peart_propnombre'] . ' supera la cantidad existente en Stock';
                                            }
                                        } else {
                                            $this->array_errors[] = 'Lo siento el producto ' . $row['peart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                        }
                                    }
                                }
                            }

                            if (empty($this->array_errors)) {

                                /*
                                $divisa_master = $this->convertir_model->obtenerDivisaMaster();
                                $factor = 1;
                                if ($data_master['pe_divid'] != $divisa_master['div_id']) {
                                    $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pe_divid'], $divisa_master['div_id']);
                                    $factor = $factor_div['df_factor'];
                                }*/

                                $div_facturar = Moneda::facturarPredeterminada();
                                $total_costo_servicio = 0;
                                $total_procosto = 0;

                                if ($data_master['pe_divid'] != $div_facturar['id']) {

                                    $i = 0;

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        $precio = $this->obtenerPrecioSegunDivisa($row['peart_proprecio'], $data_master['pe_divid'], $div_facturar['id']);
                                        $articulos[$i]['peart_proprecio'] = $precio['precio'];
                                        $pc = $row['peart_procantidad'] * $articulos[$i]['peart_proprecio'];
                                        $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['peart_proiva'], 'pvp', $row['peart_prodescuento']);
                                        $articulos[$i]['peart_ivatotal']     = round($precio['iva'], 2);
                                        $articulos[$i]['peart_proneto']          = round($precio['neto'], 2);
                                        $articulos[$i]['peart_prototal']         = round($precio['total'], 2);
                                        $costo = $this->obtenerPrecioSegunDivisa($row['peart_procosto'], $data_master['pe_divid'], $div_facturar['id']);
                                        $articulos[$i]['peart_procosto'] = $costo['precio'];
                                        $i++;
                                    }

                                    $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                    if ($data_master['pe_descuento'] > 0) {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['peart_procantidad'];
                                            $subtotal += $row['peart_proneto'];
                                            $precio = $this->obtenerDescuentoMasIvaProducto($row['peart_proneto'], $row['peart_proiva'], 'pvp', $data_master['pe_descuento'], 0);
                                            $neto += $precio['neto'];
                                            $total_iva += $precio['iva'];
                                            $total += $precio['total'];
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['peart_procantidad'];
                                            $neto += $row['peart_proneto'];
                                            $total_iva += $row['peart_ivatotal'];
                                            $total += $row['peart_prototal'];
                                        }
                                        $subtotal = $neto;
                                    }

                                    $data_master['pe_subtotal']             = round($subtotal, 2);
                                    $data_master['pe_neto']                 = round($neto, 2);
                                    $data_master['pe_iva']                  = round($total_iva, 2);
                                    $data_master['pe_total']                = round(($neto + $total_iva), 2);
                                }

                                foreach ($articulos as $row) {
                                    $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                    if ($tipo['pro_tipo'] == 3) {
                                        $total_costo_servicio += $row['peart_procosto'] * $row['peart_procantidad'];
                                    } else {
                                        $total_procosto += $row['peart_procosto'] * $row['peart_procantidad'];
                                    }
                                }

                                $data_master['total_costo_servicio']    = $total_costo_servicio;
                                $data_master['total_procosto']          = $total_procosto;

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(4);

                                try {

                                    $this->convertir_model->transactionBegin();

                                    $id_venta = $this->convertir_model->guardar([
                                        'fm_articulos_total'    => $data_master['pe_articulos_total'],
                                        'fm_subtotal'           => $data_master['pe_subtotal'],
                                        'fm_neto'               => $data_master['pe_neto'],
                                        'fm_iva'                => $data_master['pe_iva'],
                                        'fm_descuento'          => $data_master['pe_descuento'],
                                        'fm_total'              => $data_master['pe_total'],
                                        'fm_divid'              => $div_facturar['id'],
                                        'fm_serid'              => $data_master['pe_serid'],
                                        'fm_serie'              => $data_master['pe_serie'],
                                        'fm_empresaid'          => $data_master['pe_empresaid'],
                                        'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'fm_cliid'              => $data_master['pe_cliid'],
                                        'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'fm_env_nombres'        => $data_master['pe_env_nombres'],
                                        'fm_env_direccion'      => $data_master['pe_env_direccion'],
                                        'fm_env_pais'           => $data_master['pe_env_pais'],
                                        'fm_env_estado'         => $data_master['pe_env_estado'],
                                        'fm_env_ciudad'         => $data_master['pe_env_ciudad'],
                                        'fm_env_codigo_postal'  => $data_master['pe_env_codigo_postal'],
                                        'fm_estatus'            => 2,
                                        'fm_almid'              => $id_almacen,
                                        'fm_descontado'         => $descontar,
                                        'fm_empagente'          => $data_master['pe_empagente'],
                                        'fm_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => 1,
                                        'fm_surcid'             => $sucursal
                                    ], false, 'app_factura_master');

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 4,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ], true, 'app_ruta_documento');

                                    foreach ($articulos as $row) {

                                        $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                        $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);

                                        $this->convertir_model->guardar([
                                            'fa_fmid'                   => $id_venta,
                                            'fa_proid'                  => $row['peart_proid'],
                                            'fa_procodigo'              => $row['peart_procodigo'],
                                            'fa_propnombre'             => $row['peart_propnombre'],
                                            'fa_procosto'               => ($producto['pro_tipo'] == 3) ? 0 : $row['peart_procosto'],
                                            'fa_proprecio'              => $row['peart_proprecio'],
                                            'fa_procantidad'            => $row['peart_procantidad'],
                                            'fa_prodescuento'           => $row['peart_prodescuento'],
                                            'fa_proneto'                => $row['peart_proneto'],
                                            'fa_idiva'                  => $row['peart_idiva'],
                                            'fa_almid'                  => $id_almacen,
                                            'fa_proiva'                 => $row['peart_proiva'],
                                            'fa_ivatotal'               => $row['peart_ivatotal'],
                                            'fa_prototal'               => $row['peart_prototal'],
                                            'fa_descontar_inventario'   => $row['peart_procantidad'],
                                            'fa_costo_servicio'         => ($producto['pro_tipo'] == 3) ? $row['peart_procosto'] : 0
                                        ], true, 'app_factura_articulos');

                                        if ($descontar == 1 && ($data_master['pe_descontado'] == 0 && $producto['pro_tipo'] != 3)) {
                                            $this->convertir_model->desontardeStock($row['peart_proid'], $id_almacen, $row['peart_procantidad']);
                                            $this->convertir_model->guardar([
                                                'bsp_proid' => $row['peart_proid'],
                                                'bsp_almacen' =>  $almacen['alm_nombre'],
                                                'bsp_modulo' =>  'ventas convertir documento',
                                                'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                'bsp_sube' => 0,
                                                'bsp_baja' => $row['peart_procantidad'],
                                                'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['peart_procantidad'],
                                                'bsp_facid' => $id_venta,
                                                'bsp_docid' => 2
                                            ], true, 'app_bitacora_stock_producto');
                                        }
                                    }

                                    $this->convertir_model->transactionCommit();
                                } catch (\Throwable $th) {
                                    $this->convertir_model->transactionRollBack();
                                    $this->array_errors[] = 'Error en transacción';
                                }

                                if (empty($this->array_errors)) {
                                    Http::json_response(ruta_base() . "poseditar/verFactura/$id_venta");
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirPedidoENNota()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa  = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;
            $separar  = ('true' == filter_input(INPUT_POST, 'separar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $divisa     = $this->convertir_model->obtenerDivisa($id_divisa);
                $documento  = $this->convertir_model->obtenerDocumento(1);
                $almacen    = $this->convertir_model->obtenerAlmacen($id_almacen);

                if ($serie && $divisa && $documento && $almacen) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Pedidos();
                        $buscar_venta_articulos_model   = new PedidosArticulos();
                        $venta_model                    = new Notasdeentrega();
                        $venta_articulos_model          = new NotasdeentregaArticulos();

                        $data_master    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if ($separar == 1) {
                            $servicio = 0;
                            $simple = 0;
                            $url = 0;
                            $url2 = 0;

                            foreach ($articulos as $row) {
                                $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);

                                if ($producto['pro_tipo'] == 3) {
                                    $servicio += 1;
                                } else {
                                    $simple += 1;
                                }
                            }
                            if ($servicio > 0) {
                                if (empty($this->array_errors)) {

                                    $divisa_master = $this->convertir_model->obtenerDivisaMaster();

                                    $factor = 1;

                                    if ($data_master['pe_divid'] != $divisa_master['div_id']) {
                                        $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pe_divid'], $divisa_master['div_id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $total_procosto = 0;
                                    $total_costo_servicio = 0;

                                    foreach ($articulos as $row) {
                                        $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        if ($tipo['pro_tipo'] == 3) {
                                            if ($tipo['pro_tipo'] == 3) {
                                                $total_costo_servicio += $row['peart_procosto'] * $row['peart_procantidad'];
                                            } else {
                                                $total_procosto += $row['peart_procosto'] * $row['peart_procantidad'];
                                            }
                                        }
                                    }

                                    $id_venta = $venta_model->guardar([
                                        'ne_articulos_total'    => $data_master['pe_articulos_total'],
                                        'ne_subtotal'           => $data_master['pe_subtotal'],
                                        'ne_neto'               => $data_master['pe_neto'],
                                        'ne_iva'                => $data_master['pe_iva'],
                                        'ne_descuento'          => $data_master['pe_descuento'],
                                        'ne_total'              => $data_master['pe_total'],
                                        'ne_divid'              => $data_master['pe_divid'],
                                        'ne_serid'              => $data_master['pe_serid'],
                                        'ne_serie'              => $data_master['pe_serie'],
                                        'ne_empresaid'          => $data_master['pe_empresaid'],
                                        'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'ne_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'ne_cliid'              => $data_master['pe_cliid'],
                                        'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'ne_env_nombres'        => $data_master['pe_env_nombres'],
                                        'ne_env_direccion'      => $data_master['pe_env_direccion'],
                                        'ne_env_pais'           => $data_master['pe_env_pais'],
                                        'ne_env_estado'         => $data_master['pe_env_estado'],
                                        'ne_env_ciudad'         => $data_master['pe_env_ciudad'],
                                        'ne_env_codigo_postal'  => $data_master['pe_env_codigo_postal'],
                                        'ne_estatus'            => 2,
                                        'ne_almid'              => $id_almacen,
                                        'ne_descontado'         => $data_master['pe_descontado'],
                                        'ne_empagente'          => $data_master['pe_empagente'],
                                        'ne_descontado'         => $descontar,
                                        'total_costo_servicio'  => $total_costo_servicio,
                                        'total_procosto'        => $total_procosto,
                                        'factor'                => $factor,
                                        'ne_surcid'             => $sucursal
                                    ]);

                                    if ($id_venta) {

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $modulo_origen  = $this->convertir_model->obtenerDocumento(4);

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 4,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ]);

                                        foreach ($articulos as $row) {

                                            $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($tipo['pro_tipo'] == 3) {
                                                $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);

                                                if ($venta_articulos_model->guardar([
                                                    'neart_neid'                   => $id_venta,
                                                    'neart_proid'                  => $row['peart_proid'],
                                                    'neart_procodigo'              => $row['peart_procodigo'],
                                                    'neart_propnombre'             => $row['peart_propnombre'],
                                                    'neart_procosto'               => ($tipo['pro_tipo'] == 3) ? 0 : $row['peart_procosto'],
                                                    'neart_proprecio'              => $row['peart_proprecio'],
                                                    'neart_procantidad'            => $row['peart_procantidad'],
                                                    'neart_prodescuento'           => $row['peart_prodescuento'],
                                                    'neart_proneto'                => $row['peart_proneto'],
                                                    'neart_idiva'                  => $row['peart_idiva'],
                                                    'neart_almid'                  => $id_almacen,
                                                    'neart_proiva'                 => $row['peart_proiva'],
                                                    'neart_ivatotal'               => $row['peart_ivatotal'],
                                                    'neart_prototal'               => $row['peart_prototal'],
                                                    'neart_descontar_inventario'   => ($descontar == 1) ? $row['peart_procantidad'] : $row['peart_descontar_inventario'],
                                                    'neart_costo_servicio'         => ($tipo['pro_tipo'] == 3) ? $row['peart_procosto'] : 0
                                                ], true) && ($data_master['pe_descontado'] == 0 && $descontar == 1 && $tipo['pro_tipo'] != 3) && $this->convertir_model->desontardeStock($row['peart_proid'], $id_almacen, $row['peart_procantidad'])) {
                                                    Notifica::stock($row['peart_proid'], $almacen['alm_nombre'], 'ventas', $cantidad['ps_cantidad'], 0, $row['peart_procantidad'], $cantidad['ps_cantidad'] - $row['peart_procantidad'], $id_venta, 1);
                                                }
                                            }
                                        }

                                        $url = ruta_base() . "notasdeentregaeditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if ($simple > 0) {
                                if ($descontar == 1) {
                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);
                                        if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                            if ($cantidad) {
                                                if ($cantidad['ps_cantidad'] < $row['peart_procantidad']) {
                                                    $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['peart_propnombre'] . ' supera la cantidad existente en Stock';
                                                }
                                            } else {
                                                $this->array_errors[] = 'Lo siento el producto ' . $row['peart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                            }
                                        }
                                    }
                                }
                                if (empty($this->array_errors)) {

                                    $divisa_master = $this->convertir_model->obtenerDivisaMaster();

                                    $factor = 1;

                                    if ($data_master['pe_divid'] != $divisa_master['div_id']) {
                                        $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pe_divid'], $divisa_master['div_id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $total_procosto = 0;
                                    $total_costo_servicio = 0;

                                    foreach ($articulos as $row) {
                                        $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        if ($tipo['pro_tipo'] != 3) {
                                            if ($tipo['pro_tipo'] == 3) {
                                                $total_costo_servicio += $row['peart_procosto'] * $row['peart_procantidad'];
                                            } else {
                                                $total_procosto += $row['peart_procosto'] * $row['peart_procantidad'];
                                            }
                                        }
                                    }

                                    $id_venta = $venta_model->guardar([
                                        'ne_articulos_total'    => $data_master['pe_articulos_total'],
                                        'ne_subtotal'           => $data_master['pe_subtotal'],
                                        'ne_neto'               => $data_master['pe_neto'],
                                        'ne_iva'                => $data_master['pe_iva'],
                                        'ne_descuento'          => $data_master['pe_descuento'],
                                        'ne_total'              => $data_master['pe_total'],
                                        'ne_divid'              => $data_master['pe_divid'],
                                        'ne_serid'              => $data_master['pe_serid'],
                                        'ne_serie'              => $data_master['pe_serie'],
                                        'ne_empresaid'          => $data_master['pe_empresaid'],
                                        'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'ne_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'ne_cliid'              => $data_master['pe_cliid'],
                                        'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'ne_env_nombres'        => $data_master['pe_env_nombres'],
                                        'ne_env_direccion'      => $data_master['pe_env_direccion'],
                                        'ne_env_pais'           => $data_master['pe_env_pais'],
                                        'ne_env_estado'         => $data_master['pe_env_estado'],
                                        'ne_env_ciudad'         => $data_master['pe_env_ciudad'],
                                        'ne_env_codigo_postal'  => $data_master['pe_env_codigo_postal'],
                                        'ne_estatus'            => 2,
                                        'ne_almid'              => $id_almacen,
                                        'ne_descontado'         => $data_master['pe_descontado'],
                                        'ne_empagente'          => $data_master['pe_empagente'],
                                        'ne_descontado'         => $descontar,
                                        'total_costo_servicio'  => $total_costo_servicio,
                                        'total_procosto'        => $total_procosto,
                                        'factor'                => $factor,
                                        'ne_surcid'             => $sucursal
                                    ]);

                                    if ($id_venta) {

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $modulo_origen  = $this->convertir_model->obtenerDocumento(4);

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 4,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ]);

                                        foreach ($articulos as $row) {

                                            $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                            if ($tipo['pro_tipo'] != 3) {
                                                $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);

                                                if ($venta_articulos_model->guardar([
                                                    'neart_neid'                   => $id_venta,
                                                    'neart_proid'                  => $row['peart_proid'],
                                                    'neart_procodigo'              => $row['peart_procodigo'],
                                                    'neart_propnombre'             => $row['peart_propnombre'],
                                                    'neart_procosto'               => ($tipo['pro_tipo'] == 3) ? 0 : $row['peart_procosto'],
                                                    'neart_proprecio'              => $row['peart_proprecio'],
                                                    'neart_procantidad'            => $row['peart_procantidad'],
                                                    'neart_prodescuento'           => $row['peart_prodescuento'],
                                                    'neart_proneto'                => $row['peart_proneto'],
                                                    'neart_idiva'                  => $row['peart_idiva'],
                                                    'neart_almid'                  => $id_almacen,
                                                    'neart_proiva'                 => $row['peart_proiva'],
                                                    'neart_ivatotal'               => $row['peart_ivatotal'],
                                                    'neart_prototal'               => $row['peart_prototal'],
                                                    'neart_descontar_inventario'   => ($descontar == 1) ? $row['peart_procantidad'] : $row['peart_descontar_inventario'],
                                                    'neart_costo_servicio'         => ($tipo['pro_tipo'] == 3) ? $row['peart_procosto'] : 0
                                                ], true) && ($data_master['pe_descontado'] == 0 && $descontar == 1 && $tipo['pro_tipo'] != 3) && $this->convertir_model->desontardeStock($row['peart_proid'], $id_almacen, $row['peart_procantidad'])) {
                                                    Notifica::stock($row['peart_proid'], $almacen['alm_nombre'], 'ventas', $cantidad['ps_cantidad'], 0, $row['peart_procantidad'], $cantidad['ps_cantidad'] - $row['peart_procantidad'], $id_venta, 1);
                                                }
                                            }
                                        }

                                        $url2 = ruta_base() . "notasdeentregaeditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if (empty($this->array_errors)) {
                                Http::json_response([
                                    'servicios' => $url,
                                    'repuestos' => $url2
                                ]);
                            }
                        } else {
                            if ($descontar == 1) {
                                foreach ($articulos as $row) {
                                    $producto = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                    $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);
                                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                        if ($cantidad) {
                                            if ($cantidad['ps_cantidad'] < $row['peart_procantidad']) {
                                                $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['peart_propnombre'] . ' supera la cantidad existente en Stock';
                                            }
                                        } else {
                                            $this->array_errors[] = 'Lo siento el producto ' . $row['peart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                        }
                                    }
                                }
                            }

                            if (empty($this->array_errors)) {

                                $divisa_master = $this->convertir_model->obtenerDivisaMaster();

                                $factor = 1;

                                if ($data_master['pe_divid'] != $divisa_master['div_id']) {
                                    $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pe_divid'], $divisa_master['div_id']);
                                    $factor = $factor_div['df_factor'];
                                }

                                $total_procosto = 0;
                                $total_costo_servicio = 0;

                                foreach ($articulos as $row) {
                                    $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                    if ($tipo['pro_tipo'] == 3) {
                                        $total_costo_servicio += $row['peart_procosto'] * $row['peart_procantidad'];
                                    } else {
                                        $total_procosto += $row['peart_procosto'] * $row['peart_procantidad'];
                                    }
                                }

                                $id_venta = $venta_model->guardar([
                                    'ne_articulos_total'    => $data_master['pe_articulos_total'],
                                    'ne_subtotal'           => $data_master['pe_subtotal'],
                                    'ne_neto'               => $data_master['pe_neto'],
                                    'ne_iva'                => $data_master['pe_iva'],
                                    'ne_descuento'          => $data_master['pe_descuento'],
                                    'ne_total'              => $data_master['pe_total'],
                                    'ne_divid'              => $data_master['pe_divid'],
                                    'ne_serid'              => $data_master['pe_serid'],
                                    'ne_serie'              => $data_master['pe_serie'],
                                    'ne_empresaid'          => $data_master['pe_empresaid'],
                                    'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                    'ne_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                    'ne_cliid'              => $data_master['pe_cliid'],
                                    'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                    'ne_env_nombres'        => $data_master['pe_env_nombres'],
                                    'ne_env_direccion'      => $data_master['pe_env_direccion'],
                                    'ne_env_pais'           => $data_master['pe_env_pais'],
                                    'ne_env_estado'         => $data_master['pe_env_estado'],
                                    'ne_env_ciudad'         => $data_master['pe_env_ciudad'],
                                    'ne_env_codigo_postal'  => $data_master['pe_env_codigo_postal'],
                                    'ne_estatus'            => 2,
                                    'ne_almid'              => $id_almacen,
                                    'ne_descontado'         => $data_master['pe_descontado'],
                                    'ne_empagente'          => $data_master['pe_empagente'],
                                    'ne_descontado'         => $descontar,
                                    'total_costo_servicio'  => $total_costo_servicio,
                                    'total_procosto'        => $total_procosto,
                                    'factor'                => $factor,
                                    'ne_surcid'             => $sucursal
                                ]);

                                if ($id_venta) {

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $modulo_origen  = $this->convertir_model->obtenerDocumento(4);

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 4,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ]);

                                    foreach ($articulos as $row) {

                                        $tipo = $this->convertir_model->obtenerProducto($row['peart_proid']);
                                        $cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);

                                        if ($venta_articulos_model->guardar([
                                            'neart_neid'                   => $id_venta,
                                            'neart_proid'                  => $row['peart_proid'],
                                            'neart_procodigo'              => $row['peart_procodigo'],
                                            'neart_propnombre'             => $row['peart_propnombre'],
                                            'neart_procosto'               => ($tipo['pro_tipo'] == 3) ? 0 : $row['peart_procosto'],
                                            'neart_proprecio'              => $row['peart_proprecio'],
                                            'neart_procantidad'            => $row['peart_procantidad'],
                                            'neart_prodescuento'           => $row['peart_prodescuento'],
                                            'neart_proneto'                => $row['peart_proneto'],
                                            'neart_idiva'                  => $row['peart_idiva'],
                                            'neart_almid'                  => $id_almacen,
                                            'neart_proiva'                 => $row['peart_proiva'],
                                            'neart_ivatotal'               => $row['peart_ivatotal'],
                                            'neart_prototal'               => $row['peart_prototal'],
                                            'neart_descontar_inventario'   => ($descontar == 1) ? $row['peart_procantidad'] : $row['peart_descontar_inventario'],
                                            'neart_costo_servicio'         => ($tipo['pro_tipo'] == 3) ? $row['peart_procosto'] : 0
                                        ], true) && ($data_master['pe_descontado'] == 0 && $descontar == 1 && $tipo['pro_tipo'] != 3) && $this->convertir_model->desontardeStock($row['peart_proid'], $id_almacen, $row['peart_procantidad'])) {
                                            Notifica::stock($row['peart_proid'], $almacen['alm_nombre'], 'ventas', $cantidad['ps_cantidad'], 0, $row['peart_procantidad'], $cantidad['ps_cantidad'] - $row['peart_procantidad'], $id_venta, 1);
                                        }
                                    }

                                    Http::json_response(ruta_base() . "notasdeentregaeditar/verFactura/$id_venta");
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirPresupuestoENFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;
            $separar  = ('true' == filter_input(INPUT_POST, 'separar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';
            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $documento  = $this->convertir_model->obtenerDocumento(2);

                if ($serie && $documento) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Presupuesto();
                        $buscar_venta_articulos_model   = new PresupuestoArticulos();
                        $data_master = $buscar_venta_model->obtenerFactura($id);
                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if ($separar == 1) {
                            $servicio = 0;
                            $simple = 0;
                            $url = 0;
                            $url2 = 0;

                            foreach ($articulos as $row) {
                                $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                if ($producto['pro_tipo'] == 3) {
                                    $servicio += 1;
                                } else {
                                    $simple += 1;
                                }
                            }

                            if ($servicio > 0) {

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(3);

                                if (empty($this->array_errors)) {

                                    $div_facturar = Moneda::facturarPredeterminada();

                                    if ($data_master['pre_divid'] != $div_facturar['id']) {

                                        $total_costo_servicio = 0;
                                        $total_procosto = 0;
                                        $i = 0;

                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                            if ($producto['pro_tipo'] == 3) {
                                                $precio = $this->obtenerPrecioSegunDivisa($row['preart_proprecio'], $data_master['pre_divid'], $div_facturar['id']);
                                                $articulos[$i]['preart_proprecio'] = $precio['precio'];
                                                $pc = $row['preart_procantidad'] * $articulos[$i]['preart_proprecio'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['preart_proiva'], 'pvp', $row['preart_prodescuento']);
                                                $articulos[$i]['preart_ivatotal']     = round($precio['iva'], 2);
                                                $articulos[$i]['preart_proneto']          = round($precio['neto'], 2);
                                                $articulos[$i]['preart_prototal']         = round($precio['total'], 2);
                                                $costo = $this->obtenerPrecioSegunDivisa($row['preart_procosto'], $data_master['pre_divid'], $div_facturar['id']);
                                                $articulos[$i]['preart_procosto'] = $costo['precio'];
                                                $costo_servicio = $this->obtenerPrecioSegunDivisa($row['preart_costo_servicio'], $data_master['pre_divid'], $div_facturar['id']);
                                                $articulos[$i]['preart_costo_servicio'] = $costo_servicio['precio'];
                                                if ($producto['pro_tipo'] == 3) {
                                                    $total_costo_servicio  += $articulos[$i]['preart_costo_servicio'] * $row['preart_procantidad'];
                                                } else {
                                                    $total_procosto += $articulos[$i]['preart_procosto'] * $row['preart_procantidad'];
                                                }
                                            }
                                            $i++;
                                        }

                                        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                        if ($data_master['pre_descuento'] > 0) {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                                if ($producto['pro_tipo'] == 3) {
                                                    $articulos_cantidad += $row['preart_procantidad'];
                                                    $subtotal += $row['preart_proneto'];
                                                    $precio = $this->obtenerDescuentoMasIvaProducto($row['preart_proneto'], $row['preart_proiva'], 'pvp', $data_master['pre_descuento'], 0);
                                                    $neto += $precio['neto'];
                                                    $total_iva += $precio['iva'];
                                                    $total += $precio['total'];
                                                }
                                            }
                                        } else {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                                if ($producto['pro_tipo'] == 3) {
                                                    $articulos_cantidad += $row['preart_procantidad'];
                                                    $neto += $row['preart_proneto'];
                                                    $total_iva += $row['preart_ivatotal'];
                                                    $total += $row['preart_prototal'];
                                                }
                                            }
                                            $subtotal = $neto;
                                        }

                                        $data_master['pre_articulos_total']      = $articulos_cantidad;
                                        $data_master['pre_subtotal']             = round($subtotal, 2);
                                        $data_master['pre_neto']                 = round($neto, 2);
                                        $data_master['pre_iva']                  = round($total_iva, 2);
                                        $data_master['pre_total']                = round(($neto + $total_iva), 2);
                                        $data_master['total_costo_servicio']    = $total_costo_servicio;
                                        $data_master['total_procosto']          = $total_procosto;
                                    }

                                    try {

                                        $this->convertir_model->transactionBegin();

                                        $id_venta = $this->convertir_model->guardar([
                                            'fm_articulos_total'    => $data_master['pre_articulos_total'],
                                            'fm_subtotal'           => $data_master['pre_subtotal'],
                                            'fm_neto'               => $data_master['pre_neto'],
                                            'fm_iva'                => $data_master['pre_iva'],
                                            'fm_descuento'          => $data_master['pre_descuento'],
                                            'fm_total'              => $data_master['pre_total'],
                                            'fm_divid'              => $div_facturar['id'],
                                            'fm_serid'              => $data_master['pre_serid'],
                                            'fm_serie'              => $data_master['pre_serie'],
                                            'fm_empresaid'          => $data_master['pre_empresaid'],
                                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                            'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                            'fm_cliid'              => $data_master['pre_cliid'],
                                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                            'fm_env_nombres'        => $data_master['pre_env_nombres'],
                                            'fm_env_direccion'      => $data_master['pre_env_direccion'],
                                            'fm_env_pais'           => $data_master['pre_env_pais'],
                                            'fm_env_estado'         => $data_master['pre_env_estado'],
                                            'fm_env_ciudad'         => $data_master['pre_env_ciudad'],
                                            'fm_env_codigo_postal'  => $data_master['pre_env_codigo_postal'],
                                            'fm_estatus'            => 2,
                                            'fm_almid'              => $id_almacen,
                                            'fm_descontado'         => $descontar,
                                            'fm_empagente'          => $data_master['pre_empagente'],
                                            'fm_descontado'         => 1,
                                            'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                            'total_procosto'        => $data_master['total_procosto'],
                                            'factor'                => 1,
                                            'fm_surcid'             => $sucursal
                                        ], false, 'app_factura_master');

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 3,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ], true, 'app_ruta_documento');

                                        foreach ($articulos as $row) {

                                            $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                            if ($producto['pro_tipo'] == 3) {
                                                $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                                $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);

                                                $this->convertir_model->guardar([
                                                    'fa_fmid'                   => $id_venta,
                                                    'fa_proid'                  => $row['preart_proid'],
                                                    'fa_procodigo'              => $row['preart_procodigo'],
                                                    'fa_propnombre'             => $row['preart_propnombre'],
                                                    'fa_procosto'               => $row['preart_procosto'],
                                                    'fa_proprecio'              => $row['preart_proprecio'],
                                                    'fa_procantidad'            => $row['preart_procantidad'],
                                                    'fa_prodescuento'           => $row['preart_prodescuento'],
                                                    'fa_proneto'                => $row['preart_proneto'],
                                                    'fa_idiva'                  => $row['preart_idiva'],
                                                    'fa_almid'                  => $id_almacen,
                                                    'fa_proiva'                 => $row['preart_proiva'],
                                                    'fa_ivatotal'               => $row['preart_ivatotal'],
                                                    'fa_prototal'               => $row['preart_prototal'],
                                                    'fa_descontar_inventario'   => $row['preart_procantidad'],
                                                    'fa_costo_servicio'         => $row['preart_procosto']
                                                ], true, 'app_factura_articulos');
                                            }
                                        }

                                        $this->convertir_model->transactionCommit();
                                    } catch (\Throwable $th) {
                                        $this->convertir_model->transactionRollBack();
                                        $this->array_errors[] = 'Error en transacción';
                                    }

                                    if (empty($this->array_errors)) {
                                        $url = ruta_base() . "poseditar/verFactura/$id_venta";
                                    }
                                }
                            }

                            if ($simple > 0) {
                                if ($descontar == 1) {
                                    foreach ($articulos as $row) {
                                        $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);
                                        $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                        if ($producto['pro_tipo'] != 3) {
                                            if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                                if ($cantidad) {
                                                    if ($cantidad['ps_cantidad'] < $row['preart_procantidad']) {
                                                        $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['preart_propnombre'] . ' supera la cantidad existente en Stock';
                                                    }
                                                } else {
                                                    $this->array_errors[] = 'Lo siento el producto ' . $row['preart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                                }
                                            }
                                        }
                                    }
                                }

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(3);

                                if (empty($this->array_errors)) {

                                    $div_facturar = Moneda::facturarPredeterminada();

                                    if ($data_master['pre_divid'] != $div_facturar['id']) {

                                        $total_costo_servicio = 0;
                                        $total_procosto = 0;
                                        $i = 0;

                                        foreach ($articulos as $row) {
                                            $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                            if ($producto['pro_tipo'] != 3) {
                                                $precio = $this->obtenerPrecioSegunDivisa($row['preart_proprecio'], $data_master['pre_divid'], $div_facturar['id']);
                                                $articulos[$i]['preart_proprecio'] = $precio['precio'];
                                                $pc = $row['preart_procantidad'] * $articulos[$i]['preart_proprecio'];
                                                $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['preart_proiva'], 'pvp', $row['preart_prodescuento']);
                                                $articulos[$i]['preart_ivatotal']     = round($precio['iva'], 2);
                                                $articulos[$i]['preart_proneto']          = round($precio['neto'], 2);
                                                $articulos[$i]['preart_prototal']         = round($precio['total'], 2);
                                                $costo = $this->obtenerPrecioSegunDivisa($row['preart_procosto'], $data_master['pre_divid'], $div_facturar['id']);
                                                $articulos[$i]['preart_procosto'] = $costo['precio'];
                                                $costo_servicio = $this->obtenerPrecioSegunDivisa($row['preart_costo_servicio'], $data_master['pre_divid'], $div_facturar['id']);
                                                $articulos[$i]['preart_costo_servicio'] = $costo_servicio['precio'];
                                                if ($producto['pro_tipo'] == 3) {
                                                    $total_costo_servicio  += $articulos[$i]['costo_servicio'] * $row['preart_procantidad'];
                                                } else {
                                                    $total_procosto += $articulos[$i]['preart_procosto'] * $row['preart_procantidad'];
                                                }
                                            }
                                            $i++;
                                        }

                                        $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                        if ($data_master['pre_descuento'] > 0) {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                                if ($producto['pro_tipo'] != 3) {
                                                    $articulos_cantidad += $row['preart_procantidad'];
                                                    $subtotal += $row['preart_proneto'];
                                                    $precio = $this->obtenerDescuentoMasIvaProducto($row['preart_proneto'], $row['preart_proiva'], 'pvp', $data_master['pre_descuento'], 0);
                                                    $neto += $precio['neto'];
                                                    $total_iva += $precio['iva'];
                                                    $total += $precio['total'];
                                                }
                                            }
                                        } else {
                                            foreach ($articulos as $row) {
                                                $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                                if ($producto['pro_tipo'] != 3) {
                                                    $articulos_cantidad += $row['preart_procantidad'];
                                                    $neto += $row['preart_proneto'];
                                                    $total_iva += $row['preart_ivatotal'];
                                                    $total += $row['preart_prototal'];
                                                }
                                            }
                                            $subtotal = $neto;
                                        }

                                        $data_master['pre_articulos_total']      = $articulos_cantidad;
                                        $data_master['pre_subtotal']             = round($subtotal, 2);
                                        $data_master['pre_neto']                 = round($neto, 2);
                                        $data_master['pre_iva']                  = round($total_iva, 2);
                                        $data_master['pre_total']                = round(($neto + $total_iva), 2);
                                        $data_master['total_costo_servicio']    = $total_costo_servicio;
                                        $data_master['total_procosto']          = $total_procosto;
                                    }

                                    try {

                                        $this->convertir_model->transactionBegin();

                                        $id_venta = $this->convertir_model->guardar([
                                            'fm_articulos_total'    => $data_master['pre_articulos_total'],
                                            'fm_subtotal'           => $data_master['pre_subtotal'],
                                            'fm_neto'               => $data_master['pre_neto'],
                                            'fm_iva'                => $data_master['pre_iva'],
                                            'fm_descuento'          => $data_master['pre_descuento'],
                                            'fm_total'              => $data_master['pre_total'],
                                            'fm_divid'              => $div_facturar['id'],
                                            'fm_serid'              => $data_master['pre_serid'],
                                            'fm_serie'              => $data_master['pre_serie'],
                                            'fm_empresaid'          => $data_master['pre_empresaid'],
                                            'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                            'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                            'fm_cliid'              => $data_master['pre_cliid'],
                                            'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                            'fm_env_nombres'        => $data_master['pre_env_nombres'],
                                            'fm_env_direccion'      => $data_master['pre_env_direccion'],
                                            'fm_env_pais'           => $data_master['pre_env_pais'],
                                            'fm_env_estado'         => $data_master['pre_env_estado'],
                                            'fm_env_ciudad'         => $data_master['pre_env_ciudad'],
                                            'fm_env_codigo_postal'  => $data_master['pre_env_codigo_postal'],
                                            'fm_estatus'            => 2,
                                            'fm_almid'              => $id_almacen,
                                            'fm_descontado'         => $descontar,
                                            'fm_empagente'          => $data_master['pre_empagente'],
                                            'fm_descontado'         => 1,
                                            'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                            'total_procosto'        => $data_master['total_procosto'],
                                            'factor'                => 1,
                                            'fm_surcid'             => $sucursal
                                        ], false, 'app_factura_master');

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 3,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ], true, 'app_ruta_documento');

                                        foreach ($articulos as $row) {

                                            $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                            if ($producto['pro_tipo'] != 3) {

                                                $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                                $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);

                                                $this->convertir_model->guardar([
                                                    'fa_fmid'                   => $id_venta,
                                                    'fa_proid'                  => $row['preart_proid'],
                                                    'fa_procodigo'              => $row['preart_procodigo'],
                                                    'fa_propnombre'             => $row['preart_propnombre'],
                                                    'fa_procosto'               => $row['preart_procosto'],
                                                    'fa_proprecio'              => $row['preart_proprecio'],
                                                    'fa_procantidad'            => $row['preart_procantidad'],
                                                    'fa_prodescuento'           => $row['preart_prodescuento'],
                                                    'fa_proneto'                => $row['preart_proneto'],
                                                    'fa_idiva'                  => $row['preart_idiva'],
                                                    'fa_almid'                  => $id_almacen,
                                                    'fa_proiva'                 => $row['preart_proiva'],
                                                    'fa_ivatotal'               => $row['preart_ivatotal'],
                                                    'fa_prototal'               => $row['preart_prototal'],
                                                    'fa_descontar_inventario'   => $row['preart_procantidad'],
                                                    'fa_costo_servicio'         => $row['preart_procosto']
                                                ], true, 'app_factura_articulos');

                                                if ($descontar == 1 && ($data_master['pre_descontado'] == 0 && $producto['pro_tipo'] != 3)) {
                                                    $this->convertir_model->desontardeStock($row['preart_proid'], $id_almacen, $row['preart_procantidad']);
                                                    $this->convertir_model->guardar([
                                                        'bsp_proid' => $row['preart_proid'],
                                                        'bsp_almacen' =>  $almacen['alm_nombre'],
                                                        'bsp_modulo' =>  'ventas convertir documento',
                                                        'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                        'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                        'bsp_sube' => 0,
                                                        'bsp_baja' => $row['preart_procantidad'],
                                                        'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['preart_procantidad'],
                                                        'bsp_facid' => $id_venta,
                                                        'bsp_docid' => 2
                                                    ], true, 'app_bitacora_stock_producto');
                                                }
                                            }
                                        }

                                        $this->convertir_model->transactionCommit();
                                    } catch (\Throwable $th) {
                                        $this->convertir_model->transactionRollBack();
                                        $this->array_errors[] = 'Error en transacción';
                                    }

                                    if (empty($this->array_errors)) {
                                        $url2 = ruta_base() . "poseditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if (empty($this->array_errors)) {
                                Http::json_response([
                                    'servicios' => $url,
                                    'repuestos' => $url2
                                ]);
                            }
                        } else {

                            if ($descontar == 1) {
                                foreach ($articulos as $row) {
                                    $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);
                                    $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                        if ($cantidad) {
                                            if ($cantidad['ps_cantidad'] < $row['preart_procantidad']) {
                                                $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['preart_propnombre'] . ' supera la cantidad existente en Stock';
                                            }
                                        } else {
                                            $this->array_errors[] = 'Lo siento el producto ' . $row['preart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                        }
                                    }
                                }
                            }

                            $modulo_origen  = $this->convertir_model->obtenerDocumento(3);

                            if (empty($this->array_errors)) {

                                $div_facturar = Moneda::facturarPredeterminada();

                                if ($data_master['pre_divid'] != $div_facturar['id']) {

                                    $total_costo_servicio = 0;
                                    $total_procosto = 0;
                                    $i = 0;

                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                        $precio = $this->obtenerPrecioSegunDivisa($row['preart_proprecio'], $data_master['pre_divid'], $div_facturar['id']);
                                        $articulos[$i]['preart_proprecio'] = $precio['precio'];
                                        $pc = $row['preart_procantidad'] * $articulos[$i]['preart_proprecio'];
                                        $precio = $this->obtenerDescuentoMasIvaProducto($pc, $row['preart_proiva'], 'pvp', $row['preart_prodescuento']);
                                        $articulos[$i]['preart_ivatotal']     = round($precio['iva'], 2);
                                        $articulos[$i]['preart_proneto']          = round($precio['neto'], 2);
                                        $articulos[$i]['preart_prototal']         = round($precio['total'], 2);
                                        $costo = $this->obtenerPrecioSegunDivisa($row['preart_procosto'], $data_master['pre_divid'], $div_facturar['id']);
                                        $articulos[$i]['preart_procosto'] = $costo['precio'];
                                        $costo_servicio = $this->obtenerPrecioSegunDivisa($row['preart_costo_servicio'], $data_master['pre_divid'], $div_facturar['id']);
                                        $articulos[$i]['preart_costo_servicio'] = $costo_servicio['precio'];
                                        if ($producto['pro_tipo'] == 3) {
                                            $total_costo_servicio  += $articulos[$i]['preart_costo_servicio'] * $row['preart_procantidad'];
                                        } else {
                                            $total_procosto += $articulos[$i]['preart_procosto'] * $row['preart_procantidad'];
                                        }
                                        $i++;
                                    }

                                    $subtotal = $total_iva = $neto = $total = $articulos_cantidad = 0;

                                    if ($data_master['pre_descuento'] > 0) {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['preart_procantidad'];
                                            $subtotal += $row['preart_proneto'];
                                            $precio = $this->obtenerDescuentoMasIvaProducto($row['preart_proneto'], $row['preart_proiva'], 'pvp', $data_master['pre_descuento'], 0);
                                            $neto += $precio['neto'];
                                            $total_iva += $precio['iva'];
                                            $total += $precio['total'];
                                        }
                                    } else {
                                        foreach ($articulos as $row) {
                                            $articulos_cantidad += $row['preart_procantidad'];
                                            $neto += $row['preart_proneto'];
                                            $total_iva += $row['preart_ivatotal'];
                                            $total += $row['preart_prototal'];
                                        }
                                        $subtotal = $neto;
                                    }

                                    $data_master['pre_articulos_total']      = $articulos_cantidad;
                                    $data_master['pre_subtotal']             = round($subtotal, 2);
                                    $data_master['pre_neto']                 = round($neto, 2);
                                    $data_master['pre_iva']                  = round($total_iva, 2);
                                    $data_master['pre_total']                = round(($neto + $total_iva), 2);
                                    $data_master['total_costo_servicio']    = $total_costo_servicio;
                                    $data_master['total_procosto']          = $total_procosto;
                                }

                                try {

                                    $this->convertir_model->transactionBegin();

                                    $id_venta = $this->convertir_model->guardar([
                                        'fm_articulos_total'    => $data_master['pre_articulos_total'],
                                        'fm_subtotal'           => $data_master['pre_subtotal'],
                                        'fm_neto'               => $data_master['pre_neto'],
                                        'fm_iva'                => $data_master['pre_iva'],
                                        'fm_descuento'          => $data_master['pre_descuento'],
                                        'fm_total'              => $data_master['pre_total'],
                                        'fm_divid'              => $div_facturar['id'],
                                        'fm_serid'              => $data_master['pre_serid'],
                                        'fm_serie'              => $data_master['pre_serie'],
                                        'fm_empresaid'          => $data_master['pre_empresaid'],
                                        'fm_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'fm_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'fm_cliid'              => $data_master['pre_cliid'],
                                        'fm_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'fm_env_nombres'        => $data_master['pre_env_nombres'],
                                        'fm_env_direccion'      => $data_master['pre_env_direccion'],
                                        'fm_env_pais'           => $data_master['pre_env_pais'],
                                        'fm_env_estado'         => $data_master['pre_env_estado'],
                                        'fm_env_ciudad'         => $data_master['pre_env_ciudad'],
                                        'fm_env_codigo_postal'  => $data_master['pre_env_codigo_postal'],
                                        'fm_estatus'            => 2,
                                        'fm_almid'              => $id_almacen,
                                        'fm_descontado'         => $descontar,
                                        'fm_empagente'          => $data_master['pre_empagente'],
                                        'fm_descontado'         => 1,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => 1,
                                        'fm_surcid'             => $sucursal
                                    ], false, 'app_factura_master');

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 3,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ], true, 'app_ruta_documento');

                                    foreach ($articulos as $row) {

                                        $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);
                                        $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                        $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);

                                        $this->convertir_model->guardar([
                                            'fa_fmid'                   => $id_venta,
                                            'fa_proid'                  => $row['preart_proid'],
                                            'fa_procodigo'              => $row['preart_procodigo'],
                                            'fa_propnombre'             => $row['preart_propnombre'],
                                            'fa_procosto'               => $row['preart_procosto'],
                                            'fa_proprecio'              => $row['preart_proprecio'],
                                            'fa_procantidad'            => $row['preart_procantidad'],
                                            'fa_prodescuento'           => $row['preart_prodescuento'],
                                            'fa_proneto'                => $row['preart_proneto'],
                                            'fa_idiva'                  => $row['preart_idiva'],
                                            'fa_almid'                  => $id_almacen,
                                            'fa_proiva'                 => $row['preart_proiva'],
                                            'fa_ivatotal'               => $row['preart_ivatotal'],
                                            'fa_prototal'               => $row['preart_prototal'],
                                            'fa_descontar_inventario'   => $row['preart_procantidad'],
                                            'fa_costo_servicio'         => $row['preart_procosto']
                                        ], true, 'app_factura_articulos');

                                        if ($descontar == 1 && ($data_master['pre_descontado'] == 0 && $producto['pro_tipo'] != 3)) {
                                            $this->convertir_model->desontardeStock($row['preart_proid'], $id_almacen, $row['preart_procantidad']);
                                            $this->convertir_model->guardar([
                                                'bsp_proid' => $row['preart_proid'],
                                                'bsp_almacen' =>  $almacen['alm_nombre'],
                                                'bsp_modulo' =>  'ventas convertir documento',
                                                'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                                'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                                'bsp_sube' => 0,
                                                'bsp_baja' => $row['preart_procantidad'],
                                                'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) - $row['preart_procantidad'],
                                                'bsp_facid' => $id_venta,
                                                'bsp_docid' => 2
                                            ], true, 'app_bitacora_stock_producto');
                                        }
                                    }

                                    $this->convertir_model->transactionCommit();
                                } catch (\Throwable $th) {
                                    $this->convertir_model->transactionRollBack();
                                    $this->array_errors[] = 'Error en transacción';
                                }

                                if (empty($this->array_errors)) {
                                    Http::json_response(ruta_base() . "poseditar/verFactura/$id_venta");
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirPresupuestoENNota()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $sucursal = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa  = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;
            $separar  = ('true' == filter_input(INPUT_POST, 'separar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $divisa     = $this->convertir_model->obtenerDivisa($id_divisa);
                $documento  = $this->convertir_model->obtenerDocumento(1);

                if ($serie && $divisa && $documento) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Presupuesto();
                        $buscar_venta_articulos_model   = new PresupuestoArticulos();
                        $venta_model                    = new Notasdeentrega();
                        $venta_articulos_model          = new NotasdeentregaArticulos();

                        $data_master    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if ($separar == 1) {
                            $servicio = 0;
                            $simple = 0;
                            $url = 0;
                            $url2 = 0;

                            foreach ($articulos as $row) {
                                $producto = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                if ($producto['pro_tipo'] == 3) {
                                    $servicio += 1;
                                } else {
                                    $simple += 1;
                                }
                            }

                            if ($servicio > 0) {
                                if (empty($this->array_errors)) {

                                    $divisa_master = $this->convertir_model->obtenerDivisaMaster();

                                    $factor = 1;

                                    if ($data_master['pre_divid'] != $divisa_master['div_id']) {
                                        $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pre_divid'], $divisa_master['div_id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $id_venta = $venta_model->guardar([
                                        'ne_articulos_total'    => $data_master['pre_articulos_total'],
                                        'ne_subtotal'           => $data_master['pre_subtotal'],
                                        'ne_neto'               => $data_master['pre_neto'],
                                        'ne_iva'                => $data_master['pre_iva'],
                                        'ne_descuento'          => $data_master['pre_descuento'],
                                        'ne_total'              => $data_master['pre_total'],
                                        'ne_divid'              => $data_master['pre_divid'],
                                        'ne_serid'              => $data_master['pre_serid'],
                                        'ne_serie'              => $data_master['pre_serie'],
                                        'ne_empresaid'          => $data_master['pre_empresaid'],
                                        'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'ne_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'ne_cliid'              => $data_master['pre_cliid'],
                                        'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'ne_env_nombres'        => $data_master['pre_env_nombres'],
                                        'ne_env_direccion'      => $data_master['pre_env_direccion'],
                                        'ne_env_pais'           => $data_master['pre_env_pais'],
                                        'ne_env_estado'         => $data_master['pre_env_estado'],
                                        'ne_env_ciudad'         => $data_master['pre_env_ciudad'],
                                        'ne_env_codigo_postal'  => $data_master['pre_env_codigo_postal'],
                                        'ne_estatus'            => 2,
                                        'ne_almid'              => $id_almacen,
                                        'ne_descontado'         => $data_master['pre_descontado'],
                                        'ne_empagente'          => $data_master['pre_empagente'],
                                        'ne_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => $factor,
                                        'ne_surcid'             => $sucursal
                                    ]);

                                    if ($id_venta) {

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $modulo_origen  = $this->convertir_model->obtenerDocumento(3);

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 3,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ]);

                                        foreach ($articulos as $row) {

                                            $tipo = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                            if ($tipo['pro_tipo'] == 3) {
                                                if ($venta_articulos_model->guardar([
                                                    'neart_neid'                   => $id_venta,
                                                    'neart_proid'                  => $row['preart_proid'],
                                                    'neart_procodigo'              => $row['preart_procodigo'],
                                                    'neart_propnombre'             => $row['preart_propnombre'],
                                                    'neart_procosto'               => ($tipo['pro_tipo'] == 3) ? 0 : $row['preart_procosto'],
                                                    'neart_proprecio'              => $row['preart_proprecio'],
                                                    'neart_procantidad'            => $row['preart_procantidad'],
                                                    'neart_prodescuento'           => $row['preart_prodescuento'],
                                                    'neart_proneto'                => $row['preart_proneto'],
                                                    'neart_idiva'                  => $row['preart_idiva'],
                                                    'neart_almid'                  => $id_almacen,
                                                    'neart_proiva'                 => $row['preart_proiva'],
                                                    'neart_ivatotal'               => $row['preart_ivatotal'],
                                                    'neart_prototal'               => $row['preart_prototal'],
                                                    'neart_descontar_inventario'   => ($descontar == 1) ? $row['preart_procantidad'] : $row['preart_descontar_inventario'],
                                                    'neart_costo_servicio'         => $row['preart_procosto']
                                                ]));

                                                if ($data_master['pre_descontado'] == 0 && $descontar == 1) {
                                                    $this->convertir_model->desontardeStock($row['preart_proid'], $id_almacen, $row['preart_procantidad']);
                                                }
                                            }
                                        }

                                        $url = ruta_base() . "notasdeentregaeditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if ($simple > 0) {
                                if ($descontar == 1) {
                                    foreach ($articulos as $row) {
                                        $producto = $this->convertir_model->obtenerProducto($row['neart_proid']);

                                        if ($producto['pro_tipo'] != 3) {
                                            $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);
                                            if ($cantidad) {
                                                if ($cantidad['ps_cantidad'] < $row['preart_procantidad']) {
                                                    $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['preart_propnombre'] . ' supera la cantidad existente en Stock';
                                                }
                                            } else {
                                                $this->array_errors[] = 'Lo siento el producto ' . $row['preart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                            }
                                        }
                                    }
                                }

                                if (empty($this->array_errors)) {

                                    $divisa_master = $this->convertir_model->obtenerDivisaMaster();

                                    $factor = 1;

                                    if ($data_master['pre_divid'] != $divisa_master['div_id']) {
                                        $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pre_divid'], $divisa_master['div_id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $id_venta = $venta_model->guardar([
                                        'ne_articulos_total'    => $data_master['pre_articulos_total'],
                                        'ne_subtotal'           => $data_master['pre_subtotal'],
                                        'ne_neto'               => $data_master['pre_neto'],
                                        'ne_iva'                => $data_master['pre_iva'],
                                        'ne_descuento'          => $data_master['pre_descuento'],
                                        'ne_total'              => $data_master['pre_total'],
                                        'ne_divid'              => $data_master['pre_divid'],
                                        'ne_serid'              => $data_master['pre_serid'],
                                        'ne_serie'              => $data_master['pre_serie'],
                                        'ne_empresaid'          => $data_master['pre_empresaid'],
                                        'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                        'ne_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                        'ne_cliid'              => $data_master['pre_cliid'],
                                        'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                        'ne_env_nombres'        => $data_master['pre_env_nombres'],
                                        'ne_env_direccion'      => $data_master['pre_env_direccion'],
                                        'ne_env_pais'           => $data_master['pre_env_pais'],
                                        'ne_env_estado'         => $data_master['pre_env_estado'],
                                        'ne_env_ciudad'         => $data_master['pre_env_ciudad'],
                                        'ne_env_codigo_postal'  => $data_master['pre_env_codigo_postal'],
                                        'ne_estatus'            => 2,
                                        'ne_almid'              => $id_almacen,
                                        'ne_descontado'         => $data_master['pre_descontado'],
                                        'ne_empagente'          => $data_master['pre_empagente'],
                                        'ne_descontado'         => $descontar,
                                        'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                        'total_procosto'        => $data_master['total_procosto'],
                                        'factor'                => $factor,
                                        'ne_surcid'             => $sucursal
                                    ]);

                                    if ($id_venta) {

                                        $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                        $modulo_origen  = $this->convertir_model->obtenerDocumento(3);

                                        $this->convertir_model->guardar([
                                            'rd_facid_procedencia'  => $id,
                                            'rd_docid_procedencia'  => 3,
                                            'rd_facid_conversion'   => $id_venta,
                                            'rd_docid_conversion'   => $documento['doc_id'],
                                            'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                            'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                        ]);

                                        foreach ($articulos as $row) {

                                            $tipo = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                            if ($tipo['pro_tipo'] != 3) {
                                                if ($venta_articulos_model->guardar([
                                                    'neart_neid'                   => $id_venta,
                                                    'neart_proid'                  => $row['preart_proid'],
                                                    'neart_procodigo'              => $row['preart_procodigo'],
                                                    'neart_propnombre'             => $row['preart_propnombre'],
                                                    'neart_procosto'               => ($tipo['pro_tipo'] == 3) ? 0 : $row['preart_procosto'],
                                                    'neart_proprecio'              => $row['preart_proprecio'],
                                                    'neart_procantidad'            => $row['preart_procantidad'],
                                                    'neart_prodescuento'           => $row['preart_prodescuento'],
                                                    'neart_proneto'                => $row['preart_proneto'],
                                                    'neart_idiva'                  => $row['preart_idiva'],
                                                    'neart_almid'                  => $id_almacen,
                                                    'neart_proiva'                 => $row['preart_proiva'],
                                                    'neart_ivatotal'               => $row['preart_ivatotal'],
                                                    'neart_prototal'               => $row['preart_prototal'],
                                                    'neart_descontar_inventario'   => ($descontar == 1) ? $row['preart_procantidad'] : $row['preart_descontar_inventario'],
                                                    'neart_costo_servicio'         => $row['preart_procosto']
                                                ]));

                                                if ($data_master['pre_descontado'] == 0 && $descontar == 1) {
                                                    $this->convertir_model->desontardeStock($row['preart_proid'], $id_almacen, $row['preart_procantidad']);
                                                }
                                            }
                                        }

                                        $url2 = ruta_base() . "notasdeentregaeditar/verFactura/$id_venta";
                                    }
                                }
                            }
                            if (empty($this->array_errors)) {
                                Http::json_response([
                                    'servicios' => $url,
                                    'repuestos' => $url2
                                ]);
                            }
                        } else {
                            if ($descontar == 1) {
                                foreach ($articulos as $row) {
                                    $cantidad = $this->convertir_model->chuequearStock($row['preart_proid'], $id_almacen);
                                    if ($cantidad) {
                                        if ($cantidad['ps_cantidad'] < $row['preart_procantidad']) {
                                            $this->array_errors[] = 'Lo siento la cantidad a descontar del producto ' . $row['preart_propnombre'] . ' supera la cantidad existente en Stock';
                                        }
                                    } else {
                                        $this->array_errors[] = 'Lo siento el producto ' . $row['preart_propnombre'] . ' no tiene existencia en el almacen seleccionado';
                                    }
                                }
                            }

                            if (empty($this->array_errors)) {

                                $divisa_master = $this->convertir_model->obtenerDivisaMaster();

                                $factor = 1;

                                if ($data_master['pre_divid'] != $divisa_master['div_id']) {
                                    $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['pre_divid'], $divisa_master['div_id']);
                                    $factor = $factor_div['df_factor'];
                                }

                                $id_venta = $venta_model->guardar([
                                    'ne_articulos_total'    => $data_master['pre_articulos_total'],
                                    'ne_subtotal'           => $data_master['pre_subtotal'],
                                    'ne_neto'               => $data_master['pre_neto'],
                                    'ne_iva'                => $data_master['pre_iva'],
                                    'ne_descuento'          => $data_master['pre_descuento'],
                                    'ne_total'              => $data_master['pre_total'],
                                    'ne_divid'              => $data_master['pre_divid'],
                                    'ne_serid'              => $data_master['pre_serid'],
                                    'ne_serie'              => $data_master['pre_serie'],
                                    'ne_empresaid'          => $data_master['pre_empresaid'],
                                    'ne_empleadoid'         => $_SESSION['user_data']['einfo_id'],
                                    'ne_fecha'              => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                    'ne_cliid'              => $data_master['pre_cliid'],
                                    'ne_correlativo'        => $correlativo['cor_correlativo'] + 1,
                                    'ne_env_nombres'        => $data_master['pre_env_nombres'],
                                    'ne_env_direccion'      => $data_master['pre_env_direccion'],
                                    'ne_env_pais'           => $data_master['pre_env_pais'],
                                    'ne_env_estado'         => $data_master['pre_env_estado'],
                                    'ne_env_ciudad'         => $data_master['pre_env_ciudad'],
                                    'ne_env_codigo_postal'  => $data_master['pre_env_codigo_postal'],
                                    'ne_estatus'            => 2,
                                    'ne_almid'              => $id_almacen,
                                    'ne_descontado'         => $data_master['pre_descontado'],
                                    'ne_empagente'          => $data_master['pre_empagente'],
                                    'ne_descontado'         => $descontar,
                                    'total_costo_servicio'  => $data_master['total_costo_servicio'],
                                    'total_procosto'        => $data_master['total_procosto'],
                                    'factor'                => $factor,
                                    'ne_surcid'             => $sucursal
                                ]);

                                if ($id_venta) {

                                    $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                    $modulo_origen  = $this->convertir_model->obtenerDocumento(3);

                                    $this->convertir_model->guardar([
                                        'rd_facid_procedencia'  => $id,
                                        'rd_docid_procedencia'  => 3,
                                        'rd_facid_conversion'   => $id_venta,
                                        'rd_docid_conversion'   => $documento['doc_id'],
                                        'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                        'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                    ]);

                                    foreach ($articulos as $row) {

                                        $tipo = $this->convertir_model->obtenerProducto($row['preart_proid']);

                                        if ($venta_articulos_model->guardar([
                                            'neart_neid'                   => $id_venta,
                                            'neart_proid'                  => $row['preart_proid'],
                                            'neart_procodigo'              => $row['preart_procodigo'],
                                            'neart_propnombre'             => $row['preart_propnombre'],
                                            'neart_procosto'               => ($tipo['pro_tipo'] == 3) ? 0 : $row['preart_procosto'],
                                            'neart_proprecio'              => $row['preart_proprecio'],
                                            'neart_procantidad'            => $row['preart_procantidad'],
                                            'neart_prodescuento'           => $row['preart_prodescuento'],
                                            'neart_proneto'                => $row['preart_proneto'],
                                            'neart_idiva'                  => $row['preart_idiva'],
                                            'neart_almid'                  => $id_almacen,
                                            'neart_proiva'                 => $row['preart_proiva'],
                                            'neart_ivatotal'               => $row['preart_ivatotal'],
                                            'neart_prototal'               => $row['preart_prototal'],
                                            'neart_descontar_inventario'   => ($descontar == 1) ? $row['preart_procantidad'] : $row['preart_descontar_inventario'],
                                            'neart_costo_servicio'         => $row['preart_procosto']
                                        ]));

                                        if ($data_master['pre_descontado'] == 0 && $descontar == 1) {
                                            $this->convertir_model->desontardeStock($row['preart_proid'], $id_almacen, $row['preart_procantidad']);
                                        }
                                    }

                                    Http::json_response(ruta_base() . "notasdeentregaeditar/verFactura/$id_venta");
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertir()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            Http::json_response('En contruccion...');
        }
    }

    public function convertirPedidoCompraENNota()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa  = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $divisa_master     = $this->convertir_model->obtenerDivisa($id_divisa);
                $documento  = $this->convertir_model->obtenerDocumento(9);
                $almacen    = $this->convertir_model->obtenerAlmacen($id_almacen);

                if ($serie && $divisa_master && $documento && $almacen) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new CmpPedidos();
                        $buscar_venta_articulos_model   = new CmpPedidosArticulos();
                        $venta_model                    = new Cmpnotas();
                        $venta_articulos_model          = new CmpnotasArticulos();

                        $data_master    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if (empty($this->array_errors) && $descontar == 1) {
                            if ($data_master['cmppe_descontado'] == 1) {
                                if ($data_master['cmppe_almid'] != $id_almacen) {
                                    $this->array_errors[] = 'EL documento que intenta convertir ya agrego al inventario por lo tanto no puede cambiar los productos del almacen origen.';
                                }
                            } else {
                                foreach ($articulos as $row) {
                                    $producto = $this->convertir_model->obtenerProducto($row['cmppeart_proid']);
                                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                        $cantidad = $this->convertir_model->chuequearStock($row['cmppeart_proid'], $id_almacen);
                                        if (!$cantidad) {
                                            $this->array_errors[] = 'Lo siento el producto ' . $row['cmppeart_propnombre'] . ' no existe en el almacen seleccionado';
                                        }
                                    }
                                }
                            }
                        }

                        if (empty($this->array_errors)) {

                            //$divisa_master = $this->convertir_model->obtenerDivisaMaster();

                            $factor = 1;

                            if ($data_master['cmppe_divid'] != $divisa_master['div_id']) {
                                $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['cmppe_divid'], $divisa_master['div_id']);
                                $factor = $factor_div['df_factor'];
                            }

                            $total_procosto = 0;
                            $total_costo_servicio = 0;

                            $id_venta = $venta_model->guardar([
                                'cmpn_subtotal'          => $data_master['cmppe_subtotal'] * $factor,
                                'cmpn_descuento'         =>  $data_master['cmppe_descuento'],
                                'cmpn_neto'              => $data_master['cmppe_neto'] * $factor,
                                'cmpn_iva'               => $data_master['cmppe_iva'] * $factor,
                                'cmpn_total'             => $data_master['cmppe_total'] * $factor,
                                'cmpn_articulos_total'   => $data_master['cmppe_articulos_total'],
                                'cmpn_divid'             => $id_divisa,
                                'cmpn_almid'             => $id_almacen,
                                'cmpn_empleadoid'        => $_SESSION['user_data']['einfo_id'],
                                'cmpn_correlativo'       => $correlativo['cor_correlativo'] + 1,
                                'cmpn_cliid'            => $data_master['cmppe_cliid'],
                                'cmpn_serid'             => $data_master['cmppe_serid'],
                                'cmpn_serie'             => $data_master['cmppe_serie'],
                                'cmpn_env_nombres'        => $data_master['cmppe_env_nombres'],
                                'cmpn_env_direccion'      => $data_master['cmppe_env_direccion'],
                                'cmpn_env_pais'           => $data_master['cmppe_env_pais'],
                                'cmpn_env_estado'         => $data_master['cmppe_env_estado'],
                                'cmpn_env_ciudad'         => $data_master['cmppe_env_ciudad'],
                                'cmpn_env_codigo_postal'  => $data_master['cmppe_env_codigo_postal'],
                                'cmpn_fecha'             => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                'cmpn_empresaid'         => 1,
                                'cmpn_estatus'           => 2,
                                'cmpn_observaciones'     => '',
                                'cmpn_agregado'          => 0,
                                'cmpn_precio'            => 0
                            ]);

                            if ($id_venta) {

                                $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(10);

                                $this->convertir_model->guardar([
                                    'rd_facid_procedencia'  => $id,
                                    'rd_docid_procedencia'  => 10,
                                    'rd_facid_conversion'   => $id_venta,
                                    'rd_docid_conversion'   => $documento['doc_id'],
                                    'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                    'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                ]);

                                foreach ($articulos as $row) {

                                    $tipo = $this->convertir_model->obtenerProducto($row['cmppeart_proid']);
                                    //$cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);
                                    $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                    $cantidad = $this->convertir_model->chuequearStock($row['cmppeart_proid'], $id_almacen);

                                    $venta_articulos_model->guardar([
                                        'cmpnart_cmpnid'                   => $id_venta,
                                        'cmpnart_proid'                  => $row['cmppeart_proid'],
                                        'cmpnart_procodigo'              => $row['cmppeart_procodigo'],
                                        'cmpnart_propnombre'             => $row['cmppeart_propnombre'],
                                        'cmpnart_proprecio'              => $row['cmppeart_proprecio'] * $factor,
                                        'cmpnart_procantidad'            => $row['cmppeart_procantidad'],
                                        'cmpnart_prodescuento'           => $row['cmppeart_prodescuento'],
                                        'cmpnart_proneto'                => $row['cmppeart_proneto'] * $factor,
                                        'cmpnart_idiva'                  => $row['cmppeart_idiva'],
                                        'cmpnart_almid'                  => $id_almacen,
                                        'cmpnart_proiva'                 => $row['cmppeart_proiva'],
                                        'cmpnart_ivatotal'               => $row['cmppeart_ivatotal'] * $factor,
                                        'cmpnart_prototal'               => $row['cmppeart_prototal'] * $factor,
                                        'cmpnart_agregar_inventario'   => 0,
                                    ]);

                                    if ($descontar == 1 && $tipo['pro_tipo'] != 3 && $data_master['cmppe_descontado'] == 0) {
                                        $this->convertir_model->agregardeStock($row['cmppeart_proid'], $id_almacen, $row['cmppeart_procantidad']);
                                        $this->convertir_model->guardar([
                                            'bsp_proid' => $row['cmppeart_proid'],
                                            'bsp_almacen' =>  $almacen['alm_nombre'],
                                            'bsp_modulo' =>  'Compras',
                                            'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                            'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                            'bsp_sube' => $row['cmppeart_procantidad'],
                                            'bsp_baja' => 0,
                                            'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) + $row['cmppeart_procantidad'],
                                            'bsp_facid' => $id_venta,
                                            'bsp_docid' => 9
                                        ], true, 'app_bitacora_stock_producto');
                                    }
                                
                                }

                                Http::json_response(ruta_base() . "cmpnotaseditar/verFactura/$id_venta");
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function convertirNotaCompraENFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $fecha      = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $id_serie   = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $id_divisa  = filter_input(INPUT_POST, 'divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'almacen', FILTER_SANITIZE_NUMBER_INT);
            $descontar  = ('true' == filter_input(INPUT_POST, 'descontar')) ? 1 : 0;

            if (empty($fecha))
                $this->array_errors[] = 'El campo fecha es obligatorio.';
            if (empty($id_serie))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($id_divisa))
                $this->array_errors[] = 'El campo Divisa es obligatorio.';
            if (empty($id_almacen))
                $this->array_errors[] = 'El campo Almacen es obligatorio.';

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'Fecha incorrecta';

            if (empty($this->array_errors)) {

                $serie      = $this->convertir_model->obtenerSerie($id_serie);
                $divisa_master     = $this->convertir_model->obtenerDivisa($id_divisa);
                $documento  = $this->convertir_model->obtenerDocumento(8);
                $almacen    = $this->convertir_model->obtenerAlmacen($id_almacen);

                if ($serie && $divisa_master && $documento && $almacen) {

                    $correlativo = $this->convertir_model->chuequearCorrelativo($serie['ser_id'], $documento['doc_id']);

                    if (!$correlativo)
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento $documento[doc_descripcion] por favor dirijase a Modulo Configuración -> correlativos";

                    if (empty($this->array_errors)) {

                        $buscar_venta_model             = new Cmpnotas();
                        $buscar_venta_articulos_model   = new CmpnotasArticulos();
                        $venta_model                    = new Cmpfactura();
                        $venta_articulos_model          = new CmpfacturaArticulos();

                        $data_master    = $buscar_venta_model->obtenerFactura($id);

                        $articulos = $buscar_venta_articulos_model->articulos($id);

                        if (empty($this->array_errors) && $descontar == 1) {
                            if ($data_master['cmpn_agregado'] == 1) {
                                if ($data_master['cmpn_almid'] != $id_almacen) {
                                    $this->array_errors[] = 'EL documento que intenta convertir ya agrego al inventario por lo tanto no puede cambiar los productos del almacen origen.';
                                }
                            } else {
                                foreach ($articulos as $row) {
                                    $producto = $this->convertir_model->obtenerProducto($row['cmpnart_proid']);
                                    if ($producto['pro_tipo'] != 3 && $producto['pro_nostock'] == 0) {
                                        $cantidad = $this->convertir_model->chuequearStock($row['cmpnart_proid'], $id_almacen);
                                        if (!$cantidad) {
                                            $this->array_errors[] = 'Lo siento el producto ' . $row['cmpnart_propnombre'] . ' no existe en el almacen seleccionado';
                                        }
                                    }
                                }
                            }
                        }

                        if (empty($this->array_errors)) {

                            //$divisa_master = $this->convertir_model->obtenerDivisaMaster();

                            $factor = 1;

                            if ($data_master['cmpn_divid'] != $divisa_master['div_id']) {
                                $factor_div = $this->convertir_model->obtenerDivisaAlCambio($data_master['cmpn_divid'], $divisa_master['div_id']);
                                $factor = $factor_div['df_factor'];
                            }

                            $total_procosto = 0;
                            $total_costo_servicio = 0;

                            $id_venta = $venta_model->guardar([
                                'cmp_subtotal'          => $data_master['cmpn_subtotal'] * $factor,
                                'cmp_descuento'         =>  $data_master['cmpn_descuento'],
                                'cmp_neto'              => $data_master['cmpn_neto'] * $factor,
                                'cmp_iva'               => $data_master['cmpn_iva'] * $factor,
                                'cmp_total'             => $data_master['cmpn_total'] * $factor,
                                'cmp_articulos_total'   => $data_master['cmpn_articulos_total'],
                                'cmp_divid'             => $id_divisa,
                                'cmp_almid'             => $id_almacen,
                                'cmp_empleadoid'        => $_SESSION['user_data']['einfo_id'],
                                'cmp_correlativo'       => $correlativo['cor_correlativo'] + 1,
                                'cmp_cliid'            => $data_master['cmpn_cliid'],
                                'cmp_serid'             => $data_master['cmpn_serid'],
                                'cmp_serie'             => $data_master['cmpn_serie'],
                                'cmp_env_nombres'        => $data_master['cmpn_env_nombres'],
                                'cmp_env_direccion'      => $data_master['cmpn_env_direccion'],
                                'cmp_env_pais'           => $data_master['cmpn_env_pais'],
                                'cmp_env_estado'         => $data_master['cmpn_env_estado'],
                                'cmp_env_ciudad'         => $data_master['cmpn_env_ciudad'],
                                'cmp_env_codigo_postal'  => $data_master['cmpn_env_codigo_postal'],
                                'cmp_fecha'             => date('Y-m-d', strtotime($fecha)) . ' ' . date('H:i:s'),
                                'cmp_empresaid'         => $data_master['cmpn_empresaid'],
                                'cmp_estatus'           => $data_master['cmpn_estatus'],
                                'cmp_observaciones'     => $data_master['cmpn_observaciones'],
                                'cmp_agregado'          => $data_master['cmpn_agregado'],
                                'cmp_precio'            => $data_master['cmpn_precio']
                            ]);
                           

                            if ($id_venta) {

                                $this->convertir_model->actualizarCorrelativo($serie['ser_id'], $documento['doc_id'], ($correlativo['cor_correlativo'] + 1));

                                $modulo_origen  = $this->convertir_model->obtenerDocumento(10);

                                $this->convertir_model->guardar([
                                    'rd_facid_procedencia'  => $id,
                                    'rd_docid_procedencia'  => 10,
                                    'rd_facid_conversion'   => $id_venta,
                                    'rd_docid_conversion'   => $documento['doc_id'],
                                    'rd_observacion'        => "conversion de documento de $modulo_origen[doc_descripcion] hacia $documento[doc_descripcion]",
                                    'rd_empleadoid'         => $_SESSION['user_data']['emp_id']
                                ]);

                                foreach ($articulos as $row) {

                                    $tipo = $this->convertir_model->obtenerProducto($row['cmpnart_proid']);
                                    //$cantidad = $this->convertir_model->chuequearStock($row['peart_proid'], $id_almacen);
                                    $almacen = $this->convertir_model->obtenerAlmacen($id_almacen);
                                    $cantidad = $this->convertir_model->chuequearStock($row['cmpnart_proid'], $id_almacen);

                                    $venta_articulos_model->guardar([
                                        'cmpart_cmpid'                   => $id_venta,
                                        'cmpart_proid'                  => $row['cmpnart_proid'],
                                        'cmpart_procodigo'              => $row['cmpnart_procodigo'],
                                        'cmpart_propnombre'             => $row['cmpnart_propnombre'],
                                        'cmpart_proprecio'              => $row['cmpnart_proprecio'] * $factor,
                                        'cmpart_procantidad'            => $row['cmpnart_procantidad'],
                                        'cmpart_prodescuento'           => $row['cmpnart_prodescuento'],
                                        'cmpart_proneto'                => $row['cmpnart_proneto'] * $factor,
                                        'cmpart_idiva'                  => $row['cmpnart_idiva'],
                                        'cmpart_almid'                  => $id_almacen,
                                        'cmpart_proiva'                 => $row['cmpnart_proiva'],
                                        'cmpart_ivatotal'               => $row['cmpnart_ivatotal'] * $factor,
                                        'cmpart_prototal'               => $row['cmpnart_prototal'] * $factor,
                                        'cmpart_agregar_inventario'   => 0,
                                    ]);

                                    if ($descontar == 1 && $tipo['pro_tipo'] != 3 && $data_master['cmpn_agregado'] == 0) {
                                        $this->convertir_model->agregardeStock($row['cmpnart_proid'], $id_almacen, $row['cmpnart_procantidad']);
                                        $this->convertir_model->guardar([
                                            'bsp_proid' => $row['cmpnart_proid'],
                                            'bsp_almacen' =>  $almacen['alm_nombre'],
                                            'bsp_modulo' =>  'Compras',
                                            'bsp_empleado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                                            'bsp_habia'  => $cantidad['ps_cantidad'] ?? 0,
                                            'bsp_sube' => $row['cmpnart_procantidad'],
                                            'bsp_baja' => 0,
                                            'bsp_total' => ($cantidad['ps_cantidad'] ?? 0) + $row['cmpnart_procantidad'],
                                            'bsp_facid' => $id_venta,
                                            'bsp_docid' => 8
                                        ], true, 'app_bitacora_stock_producto');
                                    }
                                
                                }

                                Http::json_response(ruta_base() . "cmpfacturaeditar/verFactura/$id_venta");
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
