<?php

namespace App\Controladores;

use App\Modelos\CategoriasIngresoEgreso;
use App\Modelos\Configuracion;
use Core\Controller;
use App\Modelos\Pais;
use App\Modelos\WCModel;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;

final class ConfiguracionControlador extends Controller
{
    private $module;
    private $configuracion;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('configuracion');
        $this->configuracion = new Configuracion();
    }

    public function index()
    {
        $new_pais =  new Pais();
        $wc_conf = $this->module->has_module_action_permission('woocommerce', 'edit_params', $_SESSION['user_data']['emp_id']);
        return Vista::view('configuracion/index', [
            'paises' => $new_pais->todos(),
            'wc_conf' => $wc_conf
        ]);
    }

    public function obtenerCategorias()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $categorias = $this->configuracion->obtenerCategorias();
            $list_cat = [];

            if (is_countable($categorias) && count($categorias)) {
                foreach ($categorias as $row) {
                    $list_cat[] = [
                        'id' => $row['cie_id'],
                        'categoria' => $row['cie_descripcion']
                    ];
                }
            }

            Http::json_response($list_cat);
        }
    }

    public function guardar()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_POST['descripcion'])) {

                $newCatIE = new CategoriasIngresoEgreso();

                $descripcion = $this->solicitud->sanitize($_POST['descripcion']);

                if (empty($_POST['id'])) {
                    Http::json_response($newCatIE->guardar([
                        'cie_descripcion' => $descripcion,
                    ], true));
                } else {

                    $id = $this->solicitud->sanitize($_POST['id'], FILTER_VALIDATE_INT);

                    if ($id && $newCatIE->existe('cie_id', $id)) {
                        Http::json_response($newCatIE->editar($id, [
                            'cie_descripcion' => $descripcion,
                        ], true));
                    }
                }
            }

            Http::json_response(false);
        }
    }

    public function eliminar(int $id_categoria)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($id_categoria)) {

                $newCatIE = new CategoriasIngresoEgreso();

                $id = $this->solicitud->sanitize($id_categoria, FILTER_VALIDATE_INT);

                if ($id) {

                    $existe = $newCatIE->consultar("SELECT fab_id FROM app_movimientos WHERE fab_categoria = $id")->row();

                    if ($existe) {
                        $this->array_errors[] = 'Lo siento no puede eliminar la categoria ya que se encuentra relacionado con movimientos';
                        Http::json_response(['errors' => $this->array_errors]);
                    } else {
                        if ($newCatIE->existe('cie_id', $id)) {
                            Http::json_response($newCatIE->eliminar($id));
                        }
                    }
                }
            }

            Http::json_response(false);
        }
    }

    public function obtenerDatosWC()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $wc = $this->configuracion->obtenerDatosWC();

            if ($wc) {
                $wc_ = [
                    'url' => $wc['wc_url'],
                    'key' => $wc['wc_key'],
                    'secret' => $wc['wc_secret'],
                    'img' => $wc['wc_url_img'],
                    'pro' => $wc['wc_pro'] ? true : false,
                    'prec' => $wc['wc_precio']==1 ? true : false
                ];
            } else {
                $wc_ = [
                    'url' => '',
                    'key' => '',
                    'secret' => '',
                    'img' => '',
                    'pro' => false,
                    'prec' =>false
                ];
            };

            Http::json_response($wc_);
        }
    }


    public function guardarWC()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['url']))
                $this->array_errors[] = 'El campo URL es obligatorio.';
            if (empty($_POST['secret']))
                $this->array_errors[] = 'El campo Key es obligatorio.';
            if (empty($_POST['img']))
                $this->array_errors[] = 'El campo Secret es obligatorio.';
            if (empty($_POST['pro']))
                $this->array_errors[] = 'El campo Producto es obligatorio.';
            if (empty($_POST['prec']))
                $this->array_errors[] = 'El campo Precio es obligatorio.';

            if (empty($this->array_errors)) {

                $url = $this->solicitud->sanitize($_POST['url'], FILTER_SANITIZE_URL);
                $key = $this->solicitud->sanitize($_POST['key'], FILTER_SANITIZE_STRING);
                $secret = $this->solicitud->sanitize($_POST['secret'], FILTER_SANITIZE_STRING);
                $img = $this->solicitud->sanitize($_POST['img'], FILTER_SANITIZE_URL);
                $pro = ('true' == $_POST['pro']) ? 1 : 0;
                $prec = ('true' == $_POST['prec']) ? 1 : 0;

                $newWC = new WCModel();

                Http::json_response($newWC->editar(1, [
                    'wc_url' => $url,
                    'wc_key' => $key,
                    'wc_url_img' => $img,
                    'wc_secret' => $secret,
                    'wc_pro' => $pro,
                    'wc_precio' => $prec
                ]));
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
