<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscarFacturasCompras($event)" id="form_mescomp_busqueda">
                    <div class="form-row">
                        <div class="col-sm-3">
                            <div class="form-group form-floating-label">
                                <input id="mes_anio" type="text" class="form-control input-border-bottom" v-model.number="anio">
                                <label for="mes_anio" class="placeholder">Año</label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group input-group form-floating-label">
                                <select id="mes_divisasc" class="form-control input-border-bottom" ref="divisa">
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_facturar'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="mes_divisasc" class="placeholder">Divisa</label>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group input-group form-floating-label">
                                <select id="sucursal" class="form-control input-border-bottom" v-model="sucursal">
                                    <option value="0">Todos</option>
                                    <?php foreach ($sucursales as $row) : ?>
                                        <option value="<?= $row['su_id'] ?>"> <?= $row['su_nombre'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="sucursal" class="placeholder">Sucursal</label>
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-border btn-info btn-sm ml-2">Buscar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12" :class="cargando_tabla">
        <div class="row mt-3" v-for="row in meses">
            <div class="col-12">
                <div class="card card-invoice">
                    <div class="card-body" style="width: 95%;">
                        <div class="invoice-detail">
                            <div class="invoice-top text-center mt-3" style="background-color: rgba(222, 222, 222, 0.4);">
                                <h3 class="title"><strong>Mes {{ row.mes }} <button class="btn btn-warning btn-round btn-sm mr-2" @click="GenerarExcel(row)">Reporte detallado de ENTRADA/SALIDA INVENTARIO EXCEL</button></strong></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12">
                <div class="card">
                    <div class="card-body" style="width: 95%;">
                        <div class="invoice-item">
                            <div class="table-responsive">
                                <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" :id="'tabla_productoscompras'+row.mes">
                                    <thead>
                                        <tr>
                                            <th style="width: 18%;">Descripción</th>
                                            <th>Cantidad</th>
                                            <th>Costo</th>
                                            <th>Venta</th>
                                            <th class="text-center">Facturas</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row1 in row.productos">
                                            <td style="width: 18%;">
                                                {{row1.producto}}
                                            </td>
                                            <td style="width: 18%;">
                                                {{row1.cantidad}}
                                            </td>
                                            <td class="text-right">{{ moneda(row1.costo, row1.div_locale, row1.div_simbolo) }}</td>
                                            <td class="text-right">{{ moneda(row1.venta, row1.div_locale, row1.div_simbolo) }}</td>
                                            <td style="width: 18%;">
                                                <span v-for="row2 in row1.facturas"><a :href="row2.uri">#FACC{{row2.correlativo}}</a></span>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>