<div class="row d-flex justify-content-center container">
    <div class="col-lg-4">
        <div class="card">
            <div class="card-body" :class="cargando">
                <div class="row">
                    <div class="col-12">
                        <form>
                            <div class="form-row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Proveedor</label>
                                        <select id="proveedor" v-model="proveedor_filtro" class="form-control custom-select" @change="obtenerProductosStockBajo()">
                                            <option value="" disabled selected>Seleccione un proveedor</option>
                                            <option v-for="row in optionsProveedores" :value="row.prov_id">{{row.prov_nombre}}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label>Almacen</label>
                                        <select name="e_categoria" id="e_categoria" v-model="almacen_prov" class="form-control" @change="obtenerProductosStockBajo()">
                                            <option value="" disabled selected>Seleccionar almacenes</option>
                                            <?php foreach ($almacenes as $row) : ?>
                                                <option value="<?= $row['alm_id'] ?>">
                                                    <?= $row['alm_nombre'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card-hover-shadow-2x mb-3 card">
            <div class="card-header-tab card-header">
                <div class="card-header-title font-size-lg text-capitalize font-weight-normal"><i class="fa fa-tasks"></i>&nbsp;Productos con stock bajo del proveedor: <span class="badge badge-primary ml-2">{{pro_nombre}}</span></div>
                <div class="form-group" v-show="Object.keys(stockbajo).length > 0">
                    <label for="s_categoria">Buscar</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-search-2"></i>
                            </span>
                        </div>
                        <input type="text" class="form-control" v-model="searc">
                    </div>
                </div>
            </div>
            <div class="scroll-area-sm">
                <div class="row" v-show="Object.keys(stockbajo).length > 0">
                    <div class="col mt-3">
                        <table class="table table-striped table-hover" id="tabla_servicios_">
                            <thead>
                                <tr>
                                    <th>Parte</th>
                                    <th>Stock</th>
                                    <th>Cantidad</th>
                                    <th class="text-center">
                                        <div class="form-check">
                                            <label for="checkbox-todos-servicios" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" id="checkbox-todos-servicios" @change="checktodosServicios">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in filteredStockbajo" :key="row.id">
                                    <td style="width: 60%;">{{ row.descripcion }}</td>
                                    <td>
                                        <span class="badge badge-warning ml-2">{{ row.cantidad_disponible }}</span>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-gruop">
                                            <input type="text" class="form-control" v-model="row.cantidad">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check">
                                            <label :for="'prod'+row.id" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'prod'+row.id">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="d-block text-right card-footer"><button class="btn btn-primary" @click="modal_crearorden()">Crer orden</button></div>
        </div>
    </div>
</div>