<?php

use Core\Helpers\Documento;
use Core\Helpers\Moneda;

$doc_ = Documento::obtener(12);

?>
<style>
    tr.group,
    tr.group:hover {
        background-color: #c1bfba !important;
    }
</style>
<div class="container" v-cloak id="appClienteEditar">
    <input type="hidden" value="<?= $cliente['cli_id']; ?>" id="id_cliente">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Clientes</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('clientes') ?>">Clientes</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item" id="submodulo">
                    <a href="<?= ruta_base() ?>clientes/ver/<?= $cliente['cli_id'] ?>" id="gui_cliente"><?= $cliente['cli_razon_social'] ?></a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="btn-group" role="group" aria-label="Basic example" style="box-shadow: 2px 6px 15px 0px rgba(69, 65, 78, 0.1);">
                    <button type="button" class="btn btn-light" data-toggle="modal" data-target="#modalContacto"><i class="fa fa-save"></i> Contactos</button>
                    <button type="button" class="btn btn-light" @click.prevent="proveedor('<?= $cliente['cli_id'] ?>', '<?= $cliente['cli_razon_social'] ?>')"><i class="fa fa-edit"></i> Convertir a proveedor</button>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-md-2">
                <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                    <a class="nav-link active" data-toggle="pill" href="#tab_datosbasicos" role="tab" aria-controls="tab_datosbasicos" aria-selected="true">Datos basicos</a>
                    <a class="nav-link" data-toggle="pill" href="#tab_direccion" role="tab" aria-controls="tab_direccion" aria-selected="false" @click.prevent="obtenerDireccionesEnvios">Dirección</a>
                    <a class="nav-link" data-toggle="pill" href="#tab_intereses" role="tab" aria-controls="tab_intereses" aria-selected="false" @click.prevent="obtenerInteresesCli">Intereses</a>
                    <a class="nav-link" role="tab" aria-selected="false" data-toggle="modal" data-target="#modal-redes">Redes Sociales</a>
                    <a class="nav-link" data-toggle="pill" href="#prodvendidos" role="tab" aria-controls="prodvendidos" aria-selected="false" @click.prevent="productosvendidos">Productos vendidos</a>
                    <a class="nav-link" data-toggle="pill" href="#Facturas" role="tab" aria-controls="Facturas" aria-selected="false" @click.prevent="obtenerFacturas">Facturas</a>
                    <a class="nav-link" data-toggle="pill" href="#Notasentrega" role="tab" aria-controls="Notas Entrega" aria-selected="false" @click.prevent="obtenerNotasdeentrega">Notas Entrega</a>
                    <a class="nav-link" data-toggle="pill" href="#Ordenesdeentrega" role="tab" aria-controls="Ordenes de Entrega" aria-selected="false" @click.prevent="obtenerOrdenesdeentrega"><?= $doc_['descripcion'] ?></a>
                    <a class="nav-link" data-toggle="pill" href="#Presupuestos" role="tab" aria-controls="Presupuestos" aria-selected="false" @click.prevent="obtenerPresupuestos">Presupuestos</a>
                    <a class="nav-link" data-toggle="pill" href="#Pedidos" role="tab" aria-controls="Pedidos" aria-selected="false" @click.prevent="obtenerPedidos">Pedidos</a>
                    <a class="nav-link" data-toggle="pill" href="#NotasCredito" role="tab" aria-controls="NotasCredito" aria-selected="false" @click="obtenerNotasdeCredito">Notas Credito</a>
                    <a class="nav-link" data-toggle="pill" href="#abonos" role="tab" aria-controls="abonos" aria-selected="false">Abonos</a>
                    <a class="nav-link" role="tab" aria-selected="false" data-toggle="modal" data-target="#modal-licencias">Licencias</a>
                    <!-- <a class="nav-link" data-toggle="pill" href="#agenteventa" role="tab" aria-controls="agenteventa" aria-selected="false" @click.prevent="obtenerAgente">Agente de Venta</a>-->
                </div>
            </div>
            <div class="col-12 col-md-10">
                <div class="tab-content" id="v-pills-tabContent">
                    <div class="tab-pane fade show active" id="tab_datosbasicos" role="tabpanel">
                        <form autocomplete="off" @submit.prevent="editarDatosBasicos">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-row">
                                        <div class="col-md-4">
                                            <div class="form-group form-group-default">
                                                <select class="form-control input-border-bottom" id="tipo_documento" required="" value="<?= $cliente['cli_tipodocid']; ?>">
                                                    <option value="">&nbsp;</option>
                                                    <?php foreach ($tipo_de_documentos as $row) : ?>
                                                        <option value="<?= $row['tipodoc_id'] ?>" <?= ($row['tipodoc_id'] == $cliente['cli_tipodocid']) ? 'selected' : '' ?>><?= $row['tipodoc_codigo'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="tipo_documento" class="placeholder">Tipo de documento</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group form-group-default">
                                                <label for="dni">N° del Documento:</label>
                                                <input type="text" id="dni" class="form-control" value="<?= $cliente['cli_dni']; ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group form-group-default">
                                                <label for="fecha_nac">Fecha de Nacimiento:</label>
                                                <input type="date" id="fecha_nac" class="form-control" value="<?= $cliente['cli_fecha_nac']; ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col">
                                            <div class="form-group form-group-default">
                                                <label for="razon_social">Razón social:</label>
                                                <input type="text" id="razon_social" class="form-control" value="<?= $cliente['cli_razon_social']; ?>" onkeyup="this.value=this.value.toUpperCase()">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-4">
                                            <div class="form-group form-group-default">
                                                <label for="correo">Correo Electrónico:</label>
                                                <input type="text" id="correo" class="form-control" value="<?= $cliente['cli_email']; ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group form-group-default">
                                                <label for="telefono">Teléfono:</label>
                                                <input type="tel" id="telefono" v-mask="'(####) ###-####'" class="form-control" value="<?= $cliente['cli_telefono']; ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group form-group-default">
                                                <label for="telefono_2">Teléfono secundario:</label>
                                                <input type="tel" v-mask="'(####) ###-####'" id="telefono_2" class="form-control" value="<?= $cliente['cli_telefono_2']; ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-md-4">
                                            <div class="form-group form-group-default">
                                                <label for="tarifa">Tarifas</label>
                                                <select id="tarifa" class="form-control">
                                                    <option value="">--</option>
                                                    <?php foreach ($tarifas as $row) : ?>
                                                        <option value="<?= $row['tar_id'] ?>" <?= ($row['tar_id'] == $cliente['cli_gruptarid']) ? 'selected' : '' ?>><?= $row['tar_nombre'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group form-group-default">
                                                <label for="grupo">Grupos</label>
                                                <select id="grupo" class="form-control">
                                                    <option value="">--</option>
                                                    <?php foreach ($grupos as $row) : ?>
                                                        <option value="<?= $row['grup_id'] ?>" <?= ($row['grup_id'] == $cliente['cli_grupid']) ? 'selected' : '' ?>><?= $row['grup_nombre'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="alert alert-warning" role="alert" v-for="row in errorForm">
                                                {{ row }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col text-right">
                                            <button class="btn btn-sm btn-success" type="button" @click="guardarContactoDirecto()">
                                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                                <span class="d-none d-sm-inline-block">Guardar datos de contacto</span>
                                            </button>
                                            <button class="btn btn-sm btn-secondary" type="reset">
                                                <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                                                <span class="d-none d-sm-inline-block">Deshacer</span>
                                            </button>
                                            <button class="btn btn-sm btn-primary" type="submit">
                                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                                <span class="d-none d-sm-inline-block">Actualizar</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="card">
                            <div class="card-header">
                                <i class=" fa fa-list"></i> Contactos
                            </div>
                            <div class="card-body table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Nombre</th>
                                            <th>Cargo</th>
                                            <th>Teléfono</th>
                                            <th>Email</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in contactos">
                                            <td>{{ row.nombre }}</td>
                                            <td>{{ row.cargo }}</td>
                                            <td>{{ row.telefono }}</td>
                                            <td>{{ row.email }}</td>
                                            <td class="text-center">
                                                <div class="form-button-action">
                                                    <button type="button" title="Editar" class="btn btn-link btn-primary" @click="verContacto(row)">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                    <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminarContacto(row)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_direccion" role="tabpanel">
                        <form autocomplete="off" @submit.prevent="editarDireccion">
                            <div class="card">
                                <div class="card-body">
                                    <form autocomplete="off">
                                        <div class="form-group form-group-default">
                                            <label for="direccion">Dirección:</label>
                                            <textarea type="text" id="direccion" class="form-control"><?= $cliente['cli_direccion']; ?></textarea>
                                        </div>
                                        <div class="form-row">
                                            <div class="col">
                                                <div class="form-group form-group-default">
                                                    <label for="pais">País:</label>
                                                    <select id="pais" class="form-control">
                                                        <?php foreach ($paises as $pais) : ?>
                                                            <option value="<?= $pais['pa_id']; ?>" <?= ($pais['pa_id'] == $cliente['cli_paisid']) ? 'selected' : '' ?>><?= $pais['pa_nombre']; ?></option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col">
                                                <div class="form-group form-group-default">
                                                    <label for="ciudad">Ciudad:</label>
                                                    <input type="text" id="ciudad" class="form-control" value="<?= $cliente['cli_ciudad']; ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group form-group-default">
                                                    <label for="estado">Estado / Provincia:</label>
                                                    <input type="text" id="estado" class="form-control" value="<?= $cliente['cli_estado']; ?>">
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-group form-group-default">
                                                    <label for="codigo_postal">Código Postal:</label>
                                                    <input type="text" id="codigo_postal" class="form-control" value="<?= $cliente['cli_codpostal']; ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="col-lg-6">
                                                <div class="form-group form-group-default">
                                                    <label for="lat">Latitud.</label>
                                                    <input type="text" id="txtLat" class="form-control" value="<?= $cliente['cli_lat']; ?>" disabled>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group form-group-default">
                                                    <label for="lat">Longitud.</label>
                                                    <input type="text" id="txtLng" class="form-control" value="<?= $cliente['cli_lng']; ?>" disabled>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-2">
                                                <div id="map_canvas" style="width: auto; height: 200px;">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                                    {{ row }}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col text-right">
                                                <a href="#" class="btn btn-success btn-sm mr-3" @click="modal_redes()"><i class="fab fa-whatsapp"></i> Enviar al whatsapp</a>
                                                <button class="btn btn-sm btn-secondary" type="reset">
                                                    <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                                                    <span class="d-none d-sm-inline-block">Deshacer</span>
                                                </button>
                                                <button class="btn btn-sm btn-primary" type="submit">
                                                    <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                                    <span class="d-none d-sm-inline-block">Actualizar</span>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="card">
                                <div class="card-header">
                                    <div class="card-head-row">
                                        <div class="card-title">Direcciones de envios</div>
                                        <div class="card-tools">
                                            <a href="#" class="btn btn-info btn-border btn-round btn-sm" @click.prevent="modalEnvios">
                                                <span class="btn-label">
                                                    <i class="fa fa-save"></i>
                                                </span>
                                                Agregar
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Estado</th>
                                                <th>Ciudad</th>
                                                <th>Direccion</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in direccionesEnvio">
                                                <td>{{ row.cde_estado }}</td>
                                                <td>{{ row.cde_ciudad }}</td>
                                                <td>{{ row.cde_direccion }}</td>
                                                <td class="text-center">
                                                    <div class="form-button-action">
                                                        <button type="button" title="Editar" class="btn btn-link" @click.prevent="verDireccionEnvio(row.cde_id, row.cde_pais, row.cde_estado, row.cde_ciudad, row.cde_codigo_postal, row.cde_direccion,row.cde_lat,row.cde_lng)">
                                                            <i class="fa fa-edit"></i>
                                                        </button>
                                                        <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click.prevent="eliminarDireccionEnvio(row.cde_id, row.cde_direccion)">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                        <button type="button" title="map" class="btn btn-link btn-success" @click.prevent="modal_redesdireccion(row.cde_lat, row.cde_lng)">
                                                            <i class="fab fa-whatsapp"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane fade" id="tab_intereses" role="tabpanel">
                        <div class="row">
                            <div class="col-6">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-head-row">
                                            <div class="card-title">Favoritos</div>
                                            <div class="card-tools">
                                                <a href="#" class="btn btn-info btn-border btn-round btn-sm" data-toggle="modal" @click.prevent="modalInteres">
                                                    <span class="btn-label">
                                                        <i class="fa fa-plus"></i>
                                                    </span>
                                                    Agregar
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <table class="table table-hover">

                                            <tbody>
                                                <tr v-for="interes in tiposcli">
                                                    <td>{{ interes.cliint_descripcion }}</td>
                                                    <td class="text-center">
                                                        <div class="form-button-action">
                                                            <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click.prevent="eliminarInteres(interes.cliint_id,interes.cliint_descripcion)">
                                                                <i class="fa fa-trash"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="card-head-row">
                                            <div class="card-title">Productos de preferencia</div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>Producto / Categoria</th>
                                                        <th>Ultima vez comprado</th>
                                                        <th>Cantidad</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in top_productos">
                                                        <td>
                                                            <a :href="'<?= ruta_base() ?>productos/editar/'+row.id" class="text-info fw-bold">{{ row.descripcion }}</a> /
                                                            <p>{{ row.categoria }}</p>
                                                        </td>
                                                        <td>{{ row.fecha }}</td>
                                                        <td>
                                                            <h2 class="text-info fw-bold">+ {{ row.cantidad }}</h2>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="tab-pane fade" id="prodvendidos" role="tabpanel">
                        <div class="card">
                            <div class="card-body" :class="cargando_tablas">
                                <div class="row">
                                    <div class="col-12">
                                        <form>
                                            <div class="form-row">
                                                <div class="col-md-8">
                                                    <!--<input type="text"> -->
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Filtrar por Mes</label>
                                                        <select name="mes" class="form-control custom-select" v-model="mes" @change="productosvendidos()">
                                                            <option value="0">Todos</option>
                                                            <option value="01">Enero</option>
                                                            <option value="02">Febrero</option>
                                                            <option value="03">Marzo</option>
                                                            <option value="04">Abril</option>
                                                            <option value="05">Mayo</option>
                                                            <option value="06">Junio</option>
                                                            <option value="07">Julio</option>
                                                            <option value="08">Agosto</option>
                                                            <option value="09">Septiembre</option>
                                                            <option value="10">Octubre</option>
                                                            <option value="11">Noviembre</option>
                                                            <option value="12">Diciembre</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>Filtrar por Año</label>
                                                        <select name="anio" class="form-control custom-select" v-model="anio" @change="productosvendidos()">
                                                            <?php for ($m = date('o'); $m >= 2019; $m--) {
                                                                if ($m == date('o')) {
                                                                    echo '<option value="' . $m . '" selected>' . $m . '</option>';
                                                                } else {
                                                                    echo '<option value="' . $m . '">' . $m . '</option>';
                                                                }
                                                            }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-hover" id="table_prodvendidos">
                                        <thead>
                                            <tr>
                                                <th>Producto</th>
                                                <th>Categoria</th>
                                                <th>Cantidad</th>
                                                <th>Precio venta</th>
                                                <th>Fecha / Hora</th>
                                                <th>Documento</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in prodvendidos">
                                                <td>{{ row.descripcion }}</td>
                                                <td><span v-for="row1 in row.categoria">{{row1.cat_nombre}} / </span></td>
                                                <td>{{ row.cantidad }}</td>
                                                <td>{{ row.monto }}</td>
                                                <td>{{ row.fecha }} {{row.tipo}}</td>
                                                <td><a :href="'<?= url('ptv'); ?>?factura='+row.factura+'&tipo='+row.tipo">
                                                        <span v-if="row.tipo==1">NEV{{row.factura}}</span>
                                                        <span v-if="row.tipo==2">FACV{{row.factura}}</span>
                                                        <span v-if="row.tipo==12">ORDENV{{row.factura}}</span></a></td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th class="text-left"></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="Facturas" role="tabpanel">
                        <div class="card">
                            <div class="card-body" :class="cargando_tablas">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="table_facturas">
                                        <thead>
                                            <tr>
                                                <th>Correlativo</th>
                                                <th>Total</th>
                                                <th>Acumulado</th>
                                                <th>Pendiente</th>
                                                <th>Estatus</th>
                                                <th>Fecha</th>
                                                <th>Sucursal</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in facturas">
                                                <td>{{ row.correlativo }}</td>
                                                <td>{{ moneda(row.total, row.div_locale, row.div_simbolo)  }}</td>
                                                <td>{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                <td>{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                <td>
                                                    <span v-if="row.estatus == 1" class="text-uppercase fw-bold text-success">pagado</span>
                                                    <span v-if="row.estatus == 2" class="text-uppercase fw-bold text-warning">pendiente</span>
                                                    <span v-if="row.estatus == 3" class="text-uppercase fw-bold text-danger">anulado</span>
                                                </td>
                                                <td>{{ row.fecha }}</td>
                                                <td>{{ row.su_nombre }}</td>
                                                <td>
                                                    <div class="form-button-action">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                            <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>poseditar/verFactura/'+row.id" target="_blank">ver</a>
                                                                <div role="separator" class="dropdown-divider"></div>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>poseditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>poseditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>poseditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="Notasentrega" role="tabpanel">
                        <div class="card">
                            <div class="card-body" :class="cargando_tablas">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="table_Notasentrega">
                                        <thead>
                                            <tr>
                                                <th>Correlativo</th>
                                                <th>Total</th>
                                                <th>Acumulado</th>
                                                <th>Pendiente</th>
                                                <th>Estatus</th>
                                                <th>Fecha / Hora</th>
                                                <th>Sucursal</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in notasdeentrega">
                                                <td>{{ row.correlativo }}</td>
                                                <td>{{ moneda(row.total, row.div_locale, row.div_simbolo)  }}</td>
                                                <td>{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                <td>{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                <td>
                                                    <span v-if="row.estatus == 1" class="text-uppercase fw-bold text-success">pagado</span>
                                                    <span v-if="row.estatus == 2" class="text-uppercase fw-bold text-warning">pendiente</span>
                                                    <span v-if="row.estatus == 3" class="text-uppercase fw-bold text-danger">anulado</span>
                                                </td>
                                                <td>{{ row.fecha }}</td>
                                                <td>{{ row.su_nombre }}</td>
                                                <td>
                                                    <div class="form-button-action">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                            <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>notasdeentregaeditar/verFactura/'+row.id" target="_blank">ver</a>
                                                                <div role="separator" class="dropdown-divider"></div>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>notasdeentregaeditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>notasdeentregaeditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>notasdeentregaeditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="Ordenesdeentrega" role="tabpanel">
                        <div class="card">
                            <div class="card-body" :class="cargando_tablas">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="table_orden_de_entrega">
                                        <thead>
                                            <tr>
                                                <th>Correlativo</th>
                                                <th>Total</th>
                                                <th>Acumulado</th>
                                                <th>Pendiente</th>
                                                <th>Estatus</th>
                                                <th>Fecha / Hora</th>
                                                <th>Sucursal</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in ordenesdeentrega">
                                                <td>{{ row.correlativo }}</td>
                                                <td>{{ moneda(row.total, row.div_locale, row.div_simbolo)  }}</td>
                                                <td>{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                                <td>{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                                <td>
                                                    <span v-if="row.estatus == 1" class="text-uppercase fw-bold text-success">pagado</span>
                                                    <span v-if="row.estatus == 2" class="text-uppercase fw-bold text-warning">pendiente</span>
                                                    <span v-if="row.estatus == 3" class="text-uppercase fw-bold text-danger">anulado</span>
                                                </td>
                                                <td>{{ row.fecha }}</td>
                                                <td>{{ row.su_nombre }}</td>
                                                <td>
                                                    <div class="form-button-action">
                                                        <div class="input-group-append">
                                                            <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                            <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>ordendeentregaeditar/verFactura/'+row.id" target="_blank">ver</a>
                                                                <div role="separator" class="dropdown-divider"></div>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>ordendeentregaeditar/pdf/'+row.id" target="_blank">PDF completo</a>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>ordendeentregaeditar/pdfMP/'+row.id" target="_blank">PDF media pagina</a>
                                                                <a class="dropdown-item" :href="'<?= ruta_base() ?>ordendeentregaeditar/pdfFMP/'+row.id" target="_blank">PDF pagos</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="Pedidos" role="tabpanel">
                        <div class="card">
                            <div class="card-body" :class="cargando_tablas">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="table_pedidos">
                                        <thead>
                                            <tr>
                                                <th>Correlativo</th>
                                                <th>Total</th>
                                                <th>Estatus</th>
                                                <th>Fecha / Hora</th>
                                                <th>Sucursal</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in pedidos">
                                                <td>{{ row.correlativo }}</td>
                                                <td>{{ moneda(row.total, row.div_locale, row.div_simbolo)  }}</td>
                                                <td>
                                                    <span v-if="row.estatus == 1" class="text-uppercase fw-bold text-success">convertido</span>
                                                    <span v-else class="text-uppercase fw-bold text-warning">pendiente</span>
                                                </td>
                                                <td>{{ row.fecha }}</td>
                                                <td>{{ row.su_nombre }}</td>
                                                <td>
                                                    <div class="form-button-action">
                                                        <a :href="'<?= ruta_base() ?>pedidoseditar/pdf/'+row.id" target="_blank" rel="noopener noreferrer">
                                                            <button type="button" title="Imprimir" class="btn btn-link btn-success">
                                                                <i class="fa fa-print"></i>
                                                            </button>
                                                        </a>
                                                        <a :href="'<?= ruta_base() ?>pedidoseditar/verFactura/'+row.id" target="_blank" rel="noopener noreferrer">
                                                            <button type="button" title="Ver" class="btn btn-link btn-info">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="Presupuestos" role="tabpanel">
                        <div class="card">
                            <div class="card-body" :class="cargando_tablas">
                                <div class="table-responsive">
                                    <table class="table table-hover" id="table_presupuestos">
                                        <thead>
                                            <tr>
                                                <th>Correlativo</th>
                                                <th>Total</th>
                                                <th>Estatus</th>
                                                <th>Fecha / Hora</th>
                                                <th>Sucursal</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in presupuestos">
                                                <td>{{ row.correlativo }}</td>
                                                <td>{{ moneda(row.total, row.div_locale, row.div_simbolo)  }}</td>
                                                <td>
                                                    <span v-if="row.estatus == 1" class="text-uppercase fw-bold text-success">convertido</span>
                                                    <span v-else class="text-uppercase fw-bold text-warning">pendiente</span>
                                                </td>
                                                <td>{{ row.fecha }}</td>
                                                <td>{{ row.su_nombre }}</td>
                                                <td>
                                                    <div class="form-button-action">
                                                        <a :href="'<?= ruta_base() ?>presupuestoeditar/pdf/'+row.id" target="_blank" rel="noopener noreferrer">
                                                            <button type="button" title="Imprimir" class="btn btn-link btn-success">
                                                                <i class="fa fa-print"></i>
                                                            </button>
                                                        </a>
                                                        <a :href="'<?= ruta_base() ?>presupuestoeditar/verFactura/'+row.id" target="_blank" rel="noopener noreferrer">
                                                            <button type="button" title="Ver" class="btn btn-link btn-info">
                                                                <i class="fa fa-eye"></i>
                                                            </button>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="NotasCredito" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive" :class="cargando_tablas">
                                    <table class="table table-hover bg-white" id="table_creditos">
                                        <thead>
                                            <tr>
                                                <th>Codigo</th>
                                                <th>Total</th>
                                                <th>Fecha</th>
                                                <th>Sucursal</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in creditos">
                                                <td>NCV{{ row.cre_id }}</td>
                                                <td>
                                                    <span v-if="row.cre_estatus == 1" class=text-danger>FINALIZADO</span>
                                                    <span v-else-if="row.cre_estatus == 0" class="text-success">DISPONIBLE</span>
                                                </td>
                                                <td>{{ row.fecha }}</td>
                                                <td>{{ row.su_nombre }}</td>
                                                <td>
                                                    <button type="button" title="Ver pedido" class="btn btn-icon btn-round" @click="verDetalleCredito(row.cre_id)">
                                                        <i class="fas fa-eye"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th>Total:</th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="abonos" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <table class="table table-hover bg-white" id="table_abonos" style="width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>Fecha /Hora</th>
                                            <th>Abono</th>
                                            <th>Documento</th>
                                            <th>Divisa</th>
                                            <th>Sucursal</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in abonos">
                                            <td>{{row.fecha}}</td>
                                            <td> {{row.abono}}</td>
                                            <td>
                                            <div >
                                                    <span style="width: 30%;">{{row.correlativo}}</span>
                                                    <b class="text-primary mr-3" style="float: right;">TOTAL: {{row.total}}</b><b class=" ml-3 mr-5" style="float: right;"> ACUMULADO: {{row.acumulado}} </b><b class="text-danger ml-4 mr-4" style="float: right;">PENDIENTE: {{row.pendiente}}</b>
                                                </div>
                                            </td>
                                            <td>{{row.divisa}}</td>
                                            <td>{{row.su_nombre}}</td>
                                            <td></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="agenteventa" role="tabpanel">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-head-row">
                                    <div class="card-title"></div>
                                    <div class="card-tools">
                                        <a href="#" class="btn btn-info btn-border btn-round btn-sm" @click.prevent="modalAgente">
                                            <span class="btn-label">
                                                <i class="fa fa-save"></i>
                                            </span>
                                            Actualizar
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Nombres y Apellidos</th>
                                            <th>Teléfono</th>
                                            <th>Correo Electrónico</th>
                                            <th>Captado por:</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in agentes">
                                            <td>{{ row.einfo_nombres }} {{ row.einfo_apellidos  }}</td>
                                            <td>{{ row.einfo_telefono_movil }}</td>
                                            <td>{{ row.einfo_email }}</td>
                                            <td>{{ row.empagent_captado }}</td>
                                            <td class="text-center">
                                                <div class="form-button-action">
                                                    <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click.prevent="eliminarAgente(row.empagent_clientid,row.einfo_nombres,row.einfo_apellidos)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalguardarenvios.php'  ?>
    <?php include 'modal_detalle_credito.php'  ?>
    <?php include 'modal_agente_venta.php' ?>
    <?php include 'modal_agregar_interes.php' ?>
    <?php include 'modalcontactos.php' ?>
    <?php include 'modal_redes.php' ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_whatsapp.php' ?>
    <?php include 'modal_licencias.php' ?>
</div>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/clientes/editar.js"></script>