<script src="<?= asset('assets/js/plugin/moment/moment.min.js'); ?>"></script>
<script src="<?= ruta_base() ?>public/assets/v-money.js"></script>
<div class="container">
    <div class="page-inner" id="appClientes" v-cloak>
        <div class="page-header">
            <h4 class="page-title">Clientes</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('clientes') ?>">Clientes</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <a href="<?= url('clientes/crear'); ?>" class="btn btn-info btn-border btn-round mr-2">Nuevo cliente</a>
                <a href="<?= url('grupos'); ?>" class="btn btn-info btn-border btn-round">Grupos</a>
                <a href="<?= ruta_base() ?>clientes/txt_clientes" target="_blank" class="btn btn-info btn-border btn-round ml-2"><i class="fab fa-facebook"></i> TXT</a>
            </div>
        </div>
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-users text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Clientes</p>
                                    <h4 class="card-title">
                                        {{ clientes }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-user-2 text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Activos</p>
                                    <h4 class="card-title">
                                        {{ clientesActivos }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-remove-user-1 text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Inactivos</p>
                                    <h4 class="card-title">
                                        {{ clientesInactivos }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card card-stats card-round">
                    <div class="card-body ">
                        <div class="row">
                            <div class="col-4">
                                <div class="icon-big text-center">
                                    <i class="flaticon-user-5 text-success"></i>
                                </div>
                            </div>
                            <div class="col-8 col-stats">
                                <div class="numbers">
                                    <p class="card-category">Grupos</p>
                                    <h4 class="card-title">
                                        {{ clientesGrupos }}
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <ul class="nav nav-tabs mb-3 d-print-none" id="mainTabs" role="tablist">
                    <li class="nav-item">
                        <a href="#ListClientes" class="nav-link active" data-toggle="tab" role="tab" aria-controls="ListClientes">
                            <span class="d-none d-sm-inline-block" id="tab_count_productos">Clientes ({{ clientes }})</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="#ListmasCompran" class="nav-link" data-toggle="tab" role="tab" aria-controls="ListmasCompran">
                            <span class="d-none d-sm-inline-block">Ventas por clientes</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="tab-content" id="mainTabsContent">
            <div class="tab-pane fade show active" id="ListClientes" role="tabpanel">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="clientes-table">
                                <thead>
                                    <tr>
                                        <th class="buscar" style="width: 15%;"> Nº Documento </th>
                                        <th class="buscar" style="width: 30%;">Razón social</th>
                                        <th class="buscar" style="width: 10%;">Teléfono</th>
                                        <th class="buscar" style="width: 15%;">Correo</th>
                                        <th style="width: 10%;">Estatus</th>
                                        <th style="width: 20%;"></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="ListmasCompran" role="tabpanel">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form @submit.prevent="buscar()" id="form_proven_busqueda">
                                    <div class="form-row">
                                        <div class="col-sm-4">
                                            <div class="form-group form-floating-label">
                                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                                <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group input-group form-floating-label">
                                                <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                                <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                                <div class="input-group-append">
                                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group input-group form-floating-label">
                                                <select id="mes_divisas" class="form-control input-border-bottom" v-model="divisa">
                                                    <?php foreach ($divisas as $row) : ?>
                                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                                <label for="mes_divisas" class="placeholder">Divisa</label>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body"  :class="cargando">
                                <div class="table-responsive">
                                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_clientes_compran">
                                        <thead>
                                            <tr>
                                                <th class="text-left">Cliente</th>
                                                <th class="text-center">Cantidad productos</th>
                                                <th class="text-center">Total venta</th>
                                                <th class="text-center">Costo total</th>
                                                <th class="text-center">Cantidad documentos</th>
                                                <th class="text-center">ganancia</th>
                                                <th class="text-center">Porcentaje</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in clientesCompran">
                                                <td class="text-left">{{ row.cli_razon_social }}</td>
                                                <td class="text-center">{{ row.cantidad }}</td>
                                                <td class="text-center">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                                <td class="text-center">{{ moneda(row.costo, row.div_locale, row.div_simbolo)}}</td>
                                                <td class="text-center">{{ row.cantidad_documento }}</td>
                                                <td class="text-center">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                                                <td class="text-center">{{ row.ganancia_porct }} %</td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th>TOTAL</th>
                                                <th  class="text-center"></th>
                                                <th  class="text-center"></th>
                                                <th  class="text-center"></th>
                                                <th  class="text-center"></th>
                                                <th  class="text-center"></th>
                                                <th></th>
                                            </tr>
                                         </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= asset('assetsvuejs/clientes/clientes.js'); ?>"></script>