<div class="container" id="appClientesCrear" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Clientes</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('clientes') ?>">Clientes</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('clientes/crear') ?>">Crear</a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="#" autocomplete="off" @submit.prevent="guardar">
                            <div class="form-row">
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="tipodoc">Tipo de documento:</label>
                                        <?php if (is_countable($tipos_de_documento)) : ?>
                                            <select class="form-control" ref="seleccionado">
                                                <option disabled value="">Seleccione un elemento</option>
                                                <?php foreach ($tipos_de_documento as $row) : ?>
                                                    <option value="<?= $row['tipodoc_id'] ?>" <?= ($row['tipodoc_predeterminado']) ? 'selected' : '' ?>><?= $row['tipodoc_codigo'] ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="dni">Nº de documento:</label>
                                        <input type="text" ref="dni" id="dni" class="form-control" v-model="dataForm.cli_dni">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="razon_social">Razón social:</label>
                                        <input type="text" id="razon_social" class="form-control" v-model="dataForm.cli_razon_social" maxlength="150" @keyup="dataForm.cli_razon_social=dataForm.cli_razon_social.toUpperCase()">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="fechanac">Fecha de nacimiento:</label>
                                        <input type="date" id="fechanac" class="form-control" v-model="dataForm.cli_fecha_nac">
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="telefono">Teléfono:</label>
                                        <input type="tel" v-mask="'(####) ###-####'" id="telefono" class="form-control" v-model="dataForm.cli_telefono">
                                        <small class="form-text text-muted">(0000) 000-0000</small>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="telefono_2">Teléfono secundario:</label>
                                        <input type="tel" v-mask="'(####) ###-####'" id="telefono_2" class="form-control" v-model="dataForm.cli_telefono_2">
                                        <small class="form-text text-muted">(0000) 000-0000</small>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label for="correo">Correo electrónico:</label>
                                        <input type="text" id="correo" class="form-control" v-model="dataForm.cli_email" maxlength="100">
                                        <small class="form-text text-muted">usuario@ejemplo.com</small>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="direccion_uno">Dirección:</label>
                                <input type="text" id="direccion_uno" class="form-control" v-model="dataForm.cli_direccion" maxlength="250">
                            </div>
                            <div class="form-row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="pais">País:</label>
                                        <select id="pais" class="form-control" v-model="dataForm.cli_paisid">
                                            <?php foreach ($paises as $pais) : ?>
                                                <option value="<?= $pais['pa_id']; ?>"><?= $pais['pa_nombre']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="ciudad">Ciudad:</label>
                                        <input type="text" id="ciudad" class="form-control" v-model="dataForm.cli_ciudad">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="estado">Estado / Provincia:</label>
                                        <input type="text" id="estado" class="form-control" v-model="dataForm.cli_estado">
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="codigo_postal">Código Postal:</label>
                                        <input type="text" id="codigo_postal" class="form-control" v-model="dataForm.cli_codpostal">
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label>Grupo</label>
                                        <select v-model="dataForm['cli_grupid']" class="form-control">
                                            <option value="">--</option>
                                            <?php foreach ($grupos as $row) : ?>
                                                <option value="<?= $row['grup_id'] ?>"><?= $row['grup_nombre'] ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-check">
                                        <label class="form-check-label">
                                            <input class="form-check-input" type="checkbox" v-model="dataForm.cli_natural">
                                            <span class="form-check-sign">Persona natural (no jurídica)</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col text-right">
                                    <button class="btn btn-sm btn-secondary" type="reset">
                                        <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                                        <span class="d-none d-sm-inline-block">Deshacer</span>
                                    </button>
                                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                                        <i class="loader loader-info"></i>
                                    </button>
                                    <button v-else class="btn btn-sm btn-primary" type="submit">
                                        <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                        <span class="d-none d-sm-inline-block">Guardar</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/clientes/crear.js"></script>
