<?php

namespace App\Modelos;

use Core\Database;

class Clienteintereses extends Database
{
    protected $table    = 'app_clientes_intereses';
    protected $id       = 'cliInt_id';

    public function obtenerIntereses(int $id_cliente)
    {
        return $this->consultar("SELECT * FROM app_clientes_intereses WHERE cliint_cli_id=$id_cliente")->all();
    }

    public function obtenerTopArtProduccionNEVDia($id_cliente)
    {
        return $this->consultar("SELECT p.pro_id, p.pro_descripcion,ne.ne_fecha, SUM(neart.neart_procantidad) AS cantidad
        FROM app_notas_de_entrega_articulos neart 
        JOIN app_notas_de_entrega ne ON ne.ne_id = neart.neart_neid 
        JOIN app_productos p ON p.pro_id = neart.neart_proid 
        WHERE p.pro_tipo != 3 AND MONTH(ne.ne_fecha) = MONTH(CURRENT_DATE)
        AND ne.ne_id not in (SELECT ard.rd_facid_procedencia FROM app_ruta_documento ard WHERE rd_docid_procedencia=1 AND rd_docid_conversion =2)
        AND ne.ne_cliid=$id_cliente GROUP BY p.pro_id ORDER BY cantidad DESC LIMIT 30")->all();
    }

    public function obtenerTopArtProduccionFACVDia($id_cliente)
    {
        return $this->consultar("SELECT p.pro_id, p.pro_descripcion,fm.fm_fecha, SUM(fa.fa_procantidad) AS cantidad
        FROM app_factura_articulos fa
        JOIN app_factura_master fm ON fm.fm_id = fa.fa_fmid 
        JOIN app_productos p ON p.pro_id = fa.fa_proid 
        WHERE p.pro_tipo != 3 AND MONTH(fm.fm_fecha) = MONTH(CURRENT_DATE)
        AND fm.fm_cliid=$id_cliente GROUP BY p.pro_id ORDER BY cantidad DESC LIMIT 30")->all();
    }

    public function eliminarInteres($id_interes)
    {
        return $this->consultar("DELETE FROM app_clientes_intereses WHERE cliint_id = $id_interes")->run();
    }
}
