<?php

namespace App\Controladores;

use App\Modelos\Categorias;
use Core\Controller;
use Core\Librerias\Module;
use Core\Vista;

final class CategoriasControlador extends Controller
{
    protected $categorias_model;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('categorias');
        $this->categorias_model = new Categorias();
    }

    public function index()
    {
        return Vista::view('categorias/index');
    }

    public function obtenerCategorias()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $categ=$this->categorias_model->obtenerCategorias();
            $catgeorias=[];

            if (is_countable($categ) && count($categ)) {

                foreach ($categ as $row) {

                    $catgeorias[]=[
                        'cat_id'=>$row['cat_id'],
                        'cat_codigo'=>$row['cat_codigo'],
                        'cat_nombre'=>$row['cat_nombre'],
                        'cat_wooc'=>$row['cat_wooc'],
                        'cat_padre'=>($row['cat_padre']==null)?'':$row['cat_padre'],
                        'subcategoria'=>$this->categorias_model->obtenerSubategorias($row['cat_id'])
                    ];
                }
            }
            header('Content-Type: application/json', true);
            echo json_encode($catgeorias);
            exit;
        }
    }

    public function obtenerCategoriasPadre()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->categorias_model->obtenerCategorias());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $cat_codigo  = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
            $wooc  = (filter_input(INPUT_POST, 'wooc')>0) ?filter_input(INPUT_POST, 'wooc') : NULL;
            $cat_nombre  = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
            $dependencia = (filter_input(INPUT_POST, 'dependencia')!='') ?filter_input(INPUT_POST, 'dependencia') : NULL;

            if (empty($cat_codigo))
                $this->array_errors[] = "El campo Código es obligatorio.";
            if (empty($cat_nombre))
                $this->array_errors[] = "El campo Descripción es obligatorio.";

            if (empty($this->array_errors)) {

                if (!empty($_POST['id'])) {
                    $cat_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                    if ($this->categorias_model->where(['cat_codigo' => $cat_codigo, 'cat_id!=' => $cat_id], true))
                        $this->array_errors[] = "Lo siento ya existe una categoria con el mismo código";
                    if ($this->categorias_model->where(['cat_nombre' => $cat_nombre, 'cat_id!=' => $cat_id], true))
                        $this->array_errors[] = "Lo siento ya existe una categoria con el mismo nombre";
                } else {
                    if ($this->categorias_model->where(['cat_codigo' => $cat_codigo], true))
                        $this->array_errors[] = "Lo siento ya existe una categoria con el mismo código";
                    if ($this->categorias_model->where(['cat_nombre' => $cat_nombre], true))
                        $this->array_errors[] = "Lo siento ya existe una categoria con el mismo nombre";
                }

                if (empty($this->array_errors)) {

                    if (!empty($_POST['id'])) {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->categorias_model->editar($cat_id, [
                            'cat_codigo' => $cat_codigo,
                            'cat_nombre' => $cat_nombre,
                            'cat_padre'=>$dependencia,
                            'cat_wooc'=> $wooc
                        ]));
                        exit;
                    } else {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->categorias_model->guardar([
                            'cat_codigo' => $cat_codigo,
                            'cat_nombre' => $cat_nombre,
                            'cat_padre'=>$dependencia,
                            'cat_wooc'=> $wooc
                        ], true));
                        exit;
                    }
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_categoria)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_categoria = filter_var($id_categoria, FILTER_SANITIZE_NUMBER_INT);

            if ($this->categorias_model->existe('cat_id', $id_categoria)) {
                if ($this->categorias_model->chequearForanea($id_categoria)) {
                    $this->array_errors[] = "La categoria no puede ser ELIMINADA ya que se encuentra relacionada con algun producto.";
                } else {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->categorias_model->eliminar($id_categoria));
                    exit;
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
