<div class="card" id="appCajas">
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Listado de Cajas</div>
            <div class="card-tools">
                <a href="#" class="btn btn-light" style="box-shadow: 2px 6px 15px 0px #ddd;" @click.prevent="modalCaja">
                    <span class="btn-label"><i class="fa fa-plus"></i></span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Caja</th>
                        <th>Método de Pago</th>
                        <th>Impresora</th>
                        <th class="text-center">Estatus</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in cajas">
                        <td>{{ row.codigo }}</td>
                        <td>{{ row.descripcion }}</td>
                        <td>{{ row.metododepago_descripcion }}</td>
                        <td>{{ row.impresora_descripcion }}</td>
                        <td class="text-center">
                            <button class="btn btn-icon btn-round" data-toggle="tooltip" title="Cambiar estatus" data-original-title="Cambiar estatus" @click="cambiarEstatus(row)">
                                <i class="fa" :class="[row.estatus == 1 ?  'fa-check text-success' : 'fa-ban text-danger']"></i>
                            </button>
                        </td>
                        <td class="text-center">
                            <div class="form-button-action">
                                <div class="input-group-append">
                                    <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="#" @click.prevent="cajero(row)">Cajeros</a>
                                        <a class="dropdown-item" href="#" @click.prevent="ver(row)">Editar</a>
                                        <?php /* <a class="dropdown-item" href="#" @click.prevent="eliminar(row)">Eliminar</a>*/ ?>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php include 'modal_editar_guardar.php'; ?>
    <?php include 'modal_buscar_empleados.php'; ?>
</div>
<script src="<?= asset('assetsvuejs/cajas/cajas.js'); ?>"></script>
