<form action="#" autocomplete="off" @submit.prevent="editarGuardar" id="form_modal_cuentas">
    <div class="modal fade" id="modal_cuentas" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h5 class="modal-title">{{ titulo }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="bancodigo">Banco</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-dollar-sign"></i>
                                </span>
                            </div>
                            <select id="bcbanco" v-model="dataForm.banco" class="form-control custom-select">
                                <option disabled value="">Seleccione un Banco</option>
                                <option v-for="row in bancos" :value="row.ban_id">{{ row.ban_descripcion }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="bctipo">Tipo</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-question-circle"></i>
                                </span>
                            </div>
                            <select id="bctipo" v-model="dataForm.tipo" class="form-control custom-select">
                                <option disabled value="">Seleccione un Tipo de Cuenta</option>
                                <option value="AHORRO">AHORRO</option>
                                <option value="CORRIENTE">CORRIENTE</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="bccuenta">N° de Cuenta</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-hand-holding-usd"></i>
                                </span>
                            </div>
                            <input type="text" id="bccuenta" v-model="dataForm.cuenta" class="form-control" maxlength="20">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="bcalias">Alias</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-edit"></i>
                                </span>
                            </div>
                            <input type="text" id="bcalias" v-model="dataForm.alias" class="form-control" maxlength="100">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                    <button type="submit" class="btn btn-primary  btn-sm">{{ accion }}</button>
                </div>
            </div>
        </div>
    </div>
</form>