<?php

namespace App\Controladores;

use Core\Controller;
use App\Modelos\Bancocuentas;
use Core\Vista;

final class BancocuentasControlador extends Controller
{
    private $bancocuentas;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->bancocuentas = new Bancocuentas();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('bancocuentas/index');
        }
    }

    public function cuentas()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->bancocuentas->cuentas());
            exit;
        }
    }

    public function cuentasActivas()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->bancocuentas->cuentasActivas());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $bc_banid  = filter_input(INPUT_POST, 'banco', FILTER_SANITIZE_NUMBER_INT);
            $bc_cuenta = filter_input(INPUT_POST, 'cuenta', FILTER_SANITIZE_STRING);
            $bc_tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_STRING);
            $bc_alias = filter_input(INPUT_POST, 'alias', FILTER_SANITIZE_STRING) ?? '';

            if (empty($bc_banid))
                $this->array_errors[] = "El campo Código es requerido";
            if (empty($bc_cuenta))
                $this->array_errors[] = "El campo Descripción es requerido";
            if (empty($bc_tipo))
                $this->array_errors[] = "El campo Tipo es requerido";

            if (empty($this->array_errors)) {

                if (strlen($bc_cuenta) < 20) {
                    $this->array_errors[] = "El campo Cuenta debe poseer 20 digitos.";
                }

                if (empty($this->array_errors)) {

                    if (empty($_POST['id'])) {
                        if ($this->bancocuentas->where(['bc_cuenta' => $bc_cuenta], true))
                            $this->array_errors[] = "La cuenta $bc_cuenta ya se encuentra registrada";
                    } else {
                        $bc_id = filter_var($_POST['id'], FILTER_SANITIZE_NUMBER_INT);
                        if ($this->bancocuentas->where(['bc_cuenta' => $bc_cuenta, 'bc_id!=' => $bc_id], true))
                            $this->array_errors[] = "La cuenta $bc_cuenta ya se encuentra registrada";
                    }

                    if (empty($this->array_errors)) {
                        if (empty($_POST['id'])) {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->bancocuentas->guardar([
                                'bc_banid'   => $bc_banid,
                                'bc_cuenta'  => $bc_cuenta,
                                'bc_tipo'    => $bc_tipo,
                                'bc_alias'   => $bc_alias
                            ], true));
                            exit;
                        } else {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->bancocuentas->editar($bc_id, [
                                'bc_banid'   => $bc_banid,
                                'bc_cuenta'  => $bc_cuenta,
                                'bc_tipo'    => $bc_tipo,
                                'bc_alias'   => $bc_alias
                            ], true));
                            exit;
                        }
                    }
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function modificarEstatus(int $id_banco_cuenta)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_banco_cuenta = filter_var($id_banco_cuenta, FILTER_SANITIZE_NUMBER_INT);

            if ($this->bancocuentas->existe('bc_id', $id_banco_cuenta)) {

                $estatus = $this->bancocuentas->obtener($id_banco_cuenta);

                header('Content-Type: application/json', true);
                echo json_encode($this->bancocuentas->editar($id_banco_cuenta, [
                    'bc_estatus' => $estatus['$estatus'] == 1 ? 0 : 1
                ]));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_banco_cuenta)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_banco_cuenta = filter_var($id_banco_cuenta, FILTER_SANITIZE_NUMBER_INT);

            if ($this->bancocuentas->existe('bc_id', $id_banco_cuenta)) {
                if ($this->bancocuentas->chequearForanea($id_banco_cuenta)) {
                    $this->array_errors[] = "La cuenta no puede ser ELIMINADA ya que se encuentra relacionada con algun metodo de pago.";
                } else {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->bancocuentas->eliminar($id_banco_cuenta));
                    exit;
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
