<div class="container" id="appUbicacion" v-cloak>
    <input type="hidden" id="almacen" value="<?= $almacen ?>">
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Almacenes</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('almacenes') ?>">ubicación</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <form action="">
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group form-group-default">
                                <label for="zonas"><a href="#" @click.prevent="llamarModal('Zonas')">Zonas</a> </label>
                                <select id="zonas" class="form-control" v-model="zona" @change="llenarCombo($event, 'Zonas')">
                                    <option value="" disabled>seleccionar una zona</option>
                                    <option :value="row.id" v-for="row in zonas">{{ row.descripcion }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group form-group-default">
                                <label for="pasillos"><a href="" @click.prevent="llamarModal('Pasillos')">Pasillos</a> </label>
                                <select id="pasillos" class="form-control" v-model="pasillo" @change="llenarCombo($event, 'Pasillos')">
                                    <option value="" disabled>seleccionar una pasillo</option>
                                    <option value="">--</option>
                                    <option :value="row.id" v-for="row in pasillos">{{ row.descripcion }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group form-group-default">
                                <label for="armarios"><a href="" @click.prevent="llamarModal('Armarios')">Armarios</a> </label>
                                <select id="armarios" class="form-control" v-model="armario" @change="llenarCombo($event, 'Armarios')">
                                    <option value="" disabled>seleccionar una armario</option>
                                    <option value="">--</option>
                                    <option :value="row.id" v-for="row in armarios">{{ row.descripcion }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group form-group-default">
                                <label for="secciones"><a href="" @click.prevent="llamarModal('Secciones')">Secciones</a> </label>
                                <select id="secciones" class="form-control" v-model="seccion" @change="llenarCombo($event, 'Secciones')">
                                    <option value="" disabled>seleccionar una sección</option>
                                    <option value="">--</option>
                                    <option :value="row.id" v-for="row in secciones">{{ row.descripcion }}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group form-group-default">
                                <label for="cajones"><a href="" @click.prevent="llamarModal('Cajones')">Cajónes</a> </label>
                                <select id="cajones" class="form-control" v-model="cajon" @change="llenarCombo($event, 'Cajones')">
                                    <option value="" disabled>seleccionar un cajón</option>
                                    <option value="">--</option>
                                    <option :value="row.id" v-for="row in cajones">{{ row.descripcion }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <ul>
                            <li class="list-group-item">
                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> ZONAS <i class="agregar fa fa-save" @click="agregarUbicacion('')"></i> </span>
                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(0, 'Zonas', $event)" :id="'inputagregarubi'">
                                <ul class="ocultar-treeview">
                                    <li v-for="(zona, index) in ubicaciones">
                                        <div class="titulo">
                                            {{ zona.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(zona, 'Zonas')"></i>
                                        </div>
                                        <ul>
                                            <li>
                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> PASILLOS <i class="agregar fa fa-save" @click="agregarUbicacion(zona.id)"></i> </span>
                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(zona.id, 'Pasillos', $event)" :id="'inputagregarubi'+zona.id">
                                                <ul class="ocultar-treeview">
                                                    <li v-for="(pasillo, index) in zona.pasillos">
                                                        <div class="titulo">
                                                            {{ pasillo.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(pasillo, 'Pasillos')"></i>
                                                        </div>
                                                        <ul>
                                                            <li>
                                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> ARMARIOS <i class="agregar fa fa-save" @click="agregarUbicacion(pasillo.id)"></i> </span>
                                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(pasillo.id, 'Armarios', $event)" :id="'inputagregarubi'+pasillo.id">
                                                                <ul class="ocultar-treeview">
                                                                    <li v-for="(armario, index) in pasillo.armarios">
                                                                        <div class="titulo">
                                                                            {{ armario.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(armario, 'Armarios')"></i>
                                                                        </div>
                                                                        <ul>
                                                                            <li>
                                                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> SECCIONES <i class="agregar fa fa-save" @click="agregarUbicacion(armario.id)"></i> </span>
                                                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(armario.id, 'Secciones', $event)" :id="'inputagregarubi'+armario.id">
                                                                                <ul class="ocultar-treeview">
                                                                                    <li v-for="(seccion, index) in armario.secciones">
                                                                                        <div class="titulo">
                                                                                            {{ seccion.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(seccion, 'Secciones')"></i>
                                                                                        </div>
                                                                                        <ul>
                                                                                            <li>
                                                                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> CAJONES <i class="agregar fa fa-save" @click="agregarUbicacion(seccion.id)"></i> </span>
                                                                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(seccion.id, 'Cajones', $event)" :id="'inputagregarubi'+seccion.id">
                                                                                                <ul class="ocultar-treeview">
                                                                                                    <li v-for="(cajon, index) in seccion.cajones">
                                                                                                        <div class="titulo">
                                                                                                            {{ cajon.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(cajon, 'Cajones')"></i>
                                                                                                        </div>
                                                                                                    </li>
                                                                                                </ul>
                                                                                            </li>
                                                                                        </ul>
                                                                                    </li>
                                                                                </ul>
                                                                            </li>
                                                                        </ul>
                                                                    </li>
                                                                </ul>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </li>
                                            <li>
                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> ARMARIOS <i class="agregar fa fa-save" @click="agregarUbicacionArmarios(zona.id)"></i> </span>
                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(zona.id, 'Armarios', $event)" :id="'inputagregarubiarm'+zona.id">
                                                <ul class="ocultar-treeview">
                                                    <li v-for="(armario, index) in zona.armarios">
                                                        <div class="titulo">
                                                            {{ armario.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(armario, 'Armarios')"></i>
                                                        </div>
                                                        <ul>
                                                            <li>
                                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> SECCIONES <i class="agregar fa fa-save" @click="agregarUbicacionArmarios(armario.id)"></i> </span>
                                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(armario.id, 'Secciones', $event)" :id="'inputagregarubiarm'+armario.id">
                                                                <ul class="ocultar-treeview">
                                                                    <li v-for="(seccion, index) in armario.secciones">
                                                                        <div class="titulo">
                                                                            {{ seccion.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(seccion, 'Secciones')"></i>
                                                                        </div>
                                                                        <ul>
                                                                            <li>
                                                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> CAJONES <i class="agregar fa fa-save" @click="agregarUbicacionArmarios(seccion.id)"></i> </span>
                                                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(seccion.id, 'Cajones', $event)" :id="'inputagregarubiarm'+seccion.id">
                                                                                <ul class="ocultar-treeview">
                                                                                    <li v-for="(cajon, index) in seccion.cajones">
                                                                                        <div class="titulo">
                                                                                            {{ cajon.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(cajon, 'Cajon')"></i>
                                                                                        </div>
                                                                                    </li>
                                                                                </ul>
                                                                            </li>
                                                                        </ul>
                                                                    </li>
                                                                </ul>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </li>
                                            <li>
                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> SECCIONES <i class="agregar fa fa-save" @click="agregarUbicacionSecciones(zona.id)"></i> </span>
                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(zona.id, 'Secciones', $event)" :id="'inputagregarubisec'+zona.id">
                                                <ul class="ocultar-treeview">
                                                    <li v-for="(seccion, index) in zona.secciones">
                                                        <div class="titulo">
                                                            {{ seccion.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(seccion, 'Secciones')"></i>
                                                        </div>
                                                        <ul>
                                                            <li>
                                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> CAJONES <i class="agregar fa fa-save" @click="agregarUbicacionSecciones(seccion.id)"></i> </span>
                                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(seccion.id, 'Cajones', $event)" :id="'inputagregarubisec'+seccion.id">
                                                                <ul class="ocultar-treeview">
                                                                    <li v-for="(cajon, index) in seccion.cajones">
                                                                        <div class="titulo">
                                                                            {{ cajon.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(cajon, 'Cajones')"></i>
                                                                        </div>
                                                                    </li>
                                                                </ul>
                                                            </li>
                                                        </ul>
                                                    </li>
                                                </ul>
                                            </li>
                                            <li>
                                                <span class="encabezado fas fa-angle-right" @click="toggleTreeView"> CAJONES <i class="agregar fa fa-save" @click="agregarUbicacionCajones(zona.id)"></i> </span>
                                                <input type="text" class="inputInactive" @keyup.enter="guardarUbicacionTreeView(zona.id, 'Cajones', $event)" :id="'inputagregarubicaj'+zona.id">
                                                <ul class="ocultar-treeview">
                                                    <li v-for="(cajon, index) in zona.cajones">
                                                        <div class="titulo">
                                                            {{ cajon.descripcion }} <i class="eliminar fa fa-trash" @click="eliminar(cajon, 'Cajones')"></i>
                                                        </div>
                                                    </li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modalubicacion.php' ?>
</div>
<link rel="stylesheet" href="<?= asset('assets/ubicaciontreeview.css') ?>">
<script src="<?= asset('assetsvuejs/almacenes/ubicacion.js') ?>"></script>
