<div class="modal fade" id="modal_sucursales" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header mh">
                <h5 class="modal-title">{{ titulo }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" style="padding-top: 0px;">
                <form @submit.prevent="GuardarSucursal" id="form-sucursal-modal">
                    <div class="form-group">
                        <label for="catie-descripcion">Sucursal</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-store"></i>
                                </span>
                            </div>
                            <select id="sucursal" name="sucursal"  class="form-control">
                            <option disabled value="">Seleccione una sucursal</option>
                                <?php foreach ($sucursales as $row) : ?>
                                    <option value="<?= $row['su_id'] ?>"><?= $row['su_nombre'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="alert alert-warning" v-for="row in errorForm">{{ row }}</div>
                    </div>
                    <div class="form-group d-flex justify-content-end">
                        <button v-if="cargando == true" type="button" class="btn btn-primary  btn-sm" disabled>
                            <i class="loader loader-info"></i>
                        </button>
                        <button v-else type="submit" class="btn btn-primary  btn-sm">{{ accion }}</button>
                    </div>
                </form>
                <div class="card-category text-primary pb-2" style="padding-left: 10px;"> <i class="fas fa-list-ul"></i> Lista de sucursales</div>
                <div class="form-row">
                    <div class="col-12">
                        <ul class="list-group">
                            <li class="list-group-item d-flex justify-content-between align-items-center" title="Eliminar Sucursal" v-for="row in sucursals" style="cursor: pointer; padding: .25rem 1.25rem;">
                                {{ row.su_nombre }}
                                <button class="btn btn-icon btn-sm btn-light" @click="eliminarSucursal(row)" style="box-shadow: #ddd 2px 6px 15px 0px;">
                                    <span class="fa fa-trash"></span>
                                </button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>