<div class="container" id="appAlmacenes" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Almacenes</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('almacenes') ?>">Almacenes</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="dropdown d-inline mr-3 mr-md-2">
                    <button class="btn btn-info btn-border btn-round dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Acciones
                    </button>
                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="top-start" style="position: absolute; transform: translate3d(0px, -7px, 0px); top: 0px; left: 0px; will-change: transform;">
                        <a class="dropdown-item" href="<?= url('productos') ?>">Productos</a>
                        <a class="dropdown-item" href="<?= url('fabricantes') ?>">Fabricantes</a>
                        <a class="dropdown-item" href="<?= url('categorias') ?>">Categorias</a>
                        <a class="dropdown-item" href="<?= url('tarifas') ?>">Tarifas</a>
                        <a class="dropdown-item" href="<?= url('almacenes') ?>">Almacenes</a>
                    </div>
                </div>
                <a href="#" class="btn btn-info btn-border btn-round" @click.prevent="modalGuardar"> <span class="fa fa-plus"></span> Nuevo almacen</a>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="text-left">#</th>
                                <th class="text-left">Código</th>
                                <th class="text-left">Nombre</th>
                                <th class="text-left">Telefono</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in almacenes">
                                <td class="text-left">{{ row.alm_id }}</td>
                                <td class="text-left">{{ row.alm_codigo }}</a></td>
                                <td class="text-left">{{ row.alm_nombre }}</td>
                                <td class="text-left">{{ row.alm_telefono }}</td>
                                <td class="text-center">
                                    <div class="form-button-action">
                                        <button type="button" title="sucursales" class="btn btn-link btn-primary" @click="sucursales(row)">
                                            <i class="fa fa-store"></i>
                                        </button>
                                        <a target="_blank" :href="'<?= ruta_base() ?>almacenes/ubicacion/' + row.alm_id">
                                            <button type="button" title="Ubicación" class="btn btn-link btn-primary">
                                                <i class="fas fa-people-carry"></i>
                                            </button>
                                        </a>
                                        <button type="button" title="Editar" class="btn btn-link btn-primary" @click="ver(row)">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button type="button" title="Eliminar" class="btn btn-link btn-danger" @click="eliminar(row)">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include 'modaleditarguardar.php' ?>
    <?php include 'modal_sucursales.php' ?>
</div>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/almacenes/index.js"></script>