<?php

namespace App\Controladores;

use App\Modelos\Agencias;
use Core\Controller;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;

final class AgenciasControlador extends Controller
{
    private $agencia_model;
    private $array_errors = [];
    private $module;

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('agencias');
        $this->agencia_model = new Agencias();
    }

    public function index()
    {
        return Vista::view('agencias/index', []);
    }

    public function obtenerAgencias()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->agencia_model->consultar("SELECT * FROM app_agencias")->all());
            exit;
        }
    }

    public function eliminar(int $id_agencia)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_agencia = filter_var($id_agencia, FILTER_SANITIZE_NUMBER_INT);

            if ($this->agencia_model->existe('ag_id', $id_agencia)) {
                header('Content-Type: application/json', true);
                echo json_encode($this->agencia_model->eliminar($id_agencia));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $tar_aplicar    = filter_input(INPUT_POST, 'aplicar', FILTER_SANITIZE_NUMBER_INT);
            $tar_descripcion     = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
            $tar_tarifa     =  filter_input(INPUT_POST, 'tarifa', FILTER_SANITIZE_STRING);
            $tar_servicio   =  filter_input(INPUT_POST, 'servicio', FILTER_SANITIZE_NUMBER_INT);
            $tar_porcentaje     = filter_input(INPUT_POST, 'porcentaje', FILTER_SANITIZE_STRING);
            $ag_pesomin=filter_input(INPUT_POST, 'pesomin', FILTER_SANITIZE_STRING);

            if (empty($tar_descripcion))
                $this->array_errors[] = "El campo Descripcion es obligatorio.";

            if (empty($this->array_errors)) {

                $tar_tarifa = convertir_a_float($tar_tarifa);
                $tar_porcentaje = convertir_a_float($tar_porcentaje);

                if (empty($_POST['id'])) {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->agencia_model->guardar([
                        'ag_aplicar'     => $tar_aplicar,
                        'ag_descripcion'     => $tar_descripcion,
                        'ag_servicio'      => $tar_servicio,
                        'ag_tarifa'    => $tar_tarifa,
                        'ag_porcentaje'      => $tar_porcentaje,
                        'ag_pesomin'=>convertir_a_float($ag_pesomin)
                    ], true));
                    exit;
                } else {
                    $tar_id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                    header('Content-Type: application/json', true);
                    echo json_encode($this->agencia_model->editar($tar_id, [
                        'ag_aplicar'     => $tar_aplicar,
                        'ag_descripcion'     => $tar_descripcion,
                        'ag_servicio'      => $tar_servicio,
                        'ag_tarifa'    => $tar_tarifa,
                        'ag_porcentaje'      => $tar_porcentaje,
                        'ag_pesomin'=>convertir_a_float($ag_pesomin)
                    ]));
                    exit;
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
