<?php

namespace App\Modelos;

use Core\Database;

class CarritoVentasModel extends Database
{
    public function obtenerDatosEmpresa()
    {
        return $this->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();
    }

    public function obtenerDivisa(int $id_divisa)
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_id=$id_divisa")->row();
    }

    public function obtenerUltimaNota()
    {
        return $this->consultar("SELECT MAX(ne_id) as ultimo 
        FROM app_notas_de_entrega")->row();
    }

    public function obtenerMetodoCuenta(int $id)
    {
        return $this->consultar("SELECT cmp_id, bc_cuenta, bc_tipo, bc_alias, b.ban_codigo, b.ban_descripcion, m.mp_nombre
        FROM app_metodopago_divisa md 
        JOIN app_metodopago m ON m.mp_id = md.md_mpid
        JOIN app_cuentas_metodopago cmp ON cmp.cmp_mdid = md.md_id
        JOIN app_bancos_cuentas bc ON bc.bc_id = cmp.cmp_cueid
        JOIN app_bancos b ON b.ban_id = bc.bc_banid
        WHERE cmp.cmp_id = $id")->row();
    }

    public function obtenerUltimaFact()
    {
        return $this->consultar("SELECT MAX(fm_id) as ultimo 
        FROM app_factura_master")->row();
    }

    public function obtenerDivisaFacturar()
    {
        return $this->consultar('SELECT * FROM app_divisas WHERE div_status = 1 AND div_facturar = 1')->row();
    }

    public function obtenerDivisas()
    {
        return $this->consultar('SELECT * FROM app_divisas WHERE div_status = 1')->all();
    }

    public function obtenerEmpleado(int $id_empleado)
    {
        return $this->consultar("SELECT * FROM app_empleados_info WHERE einfo_id=$id_empleado")->row();
    }

    public function obtenerAgentesdeVenta()
    {
        return $this->consultar('SELECT * FROM app_empleados_info WHERE einfo_agente_de_venta = 1')->all();
    }

    public function chuequearCorrelativo(int $id_serie, int $id_documento)
    {
        return $this->consultar("SELECT * FROM app_correlativos WHERE cor_serid = $id_serie AND cor_docid = $id_documento")->row();
    }

    public function obtenerPaises()
    {
        return $this->consultar('SELECT * FROM app_paises')->all();
    }

    public function obternerTiposDeDocumentos()
    {
        return $this->consultar('SELECT * FROM app_tipo_documentos')->all();
    }

    public function obtenerImpuestos()
    {
        return $this->consultar("SELECT * FROM app_impuestos WHERE imp_retencion = '0' order by imp_id asc")->all();
    }

    public function obtenerSerie($id_serie)
    {
        return $this->consultar("SELECT * FROM app_series WHERE ser_id=$id_serie")->row();
    }

    public function obtenerAlmacenes()
    {
        return $this->consultar("SELECT * 
        FROM app_almacenes")->all();
    }

    public function obtenerSeries()
    {
        return $this->consultar("SELECT * FROM app_series")->all();
    }

    public function obtenerAlmacenesEmpleado()
    {
        return $this->consultar("SELECT * 
        FROM app_empleados_almacen 
        JOIN app_almacenes a ON a.alm_id = empalm_almid
        WHERE empalm_empid={$_SESSION['user_data']['emp_id']}")->all();
    }

    public function obtenerSeriesEmpleado()
    {
        return $this->consultar("SELECT * FROM app_empleados_serie 
        JOIN app_series s ON s.ser_id = empser_serid
        JOIN app_sucursales su ON s.ser_sucursal = su.su_id
        WHERE empser_empid={$_SESSION['user_data']['emp_id']}")->all();
    }

    public function obtenerSeriesEmpleadoSucursales($sucursal)
    {
        return $this->consultar("SELECT * FROM app_empleados_serie e 
        JOIN app_series s ON s.ser_id = e.empser_serid
        JOIN app_sucursales su ON s.ser_sucursal = su.su_id
        WHERE e.empser_empid={$_SESSION['user_data']['emp_id']} AND s.ser_sucursal=$sucursal")->all();
    }

    public function obtenerAlmacenesEmpleadoSucursales($sucursal)
    {
        return $this->consultar("SELECT * 
        FROM app_empleados_almacen ea
        JOIN app_almacenes a ON a.alm_id = ea.empalm_almid 
        JOIN app_almacen_sucursal alms ON alms.alsu_almid = a.alm_id 
        JOIN app_sucursales su ON su.su_id = alms.alsu_suid 
        WHERE empalm_empid={$_SESSION['user_data']['emp_id']} AND alms.alsu_suid =$sucursal")->all();
    }

    public function obtenerDivisaEmpleado()
    {
        return $this->consultar("SELECT *
        FROM app_empleados_divisas ed
        JOIN app_divisas d ON d.div_id = ed.ed_divid
        WHERE ed_empid={$_SESSION['user_data']['emp_id']}")->all();
    }

    public function obtenerProducto(int $id_producto)
    {
        return $this->consultar("SELECT p.pro_id, p.pro_codigo, p.pro_descripcion, p.pro_costo, p.pro_precio, p.pro_tipo, p.pro_impid, p.pro_nostock
        FROM app_productos p WHERE p.pro_id=$id_producto")->row();
    }

    public function obtenerProductoCategoria(int $id_producto)
    {
        return $this->consultar("SELECT * FROM app_productos p 
        LEFT JOIN app_productos_categorias cp ON cp.pc_proid=p.pro_id 
        LEFT JOIN app_categorias c ON c.cat_id=cp.pc_catid  
        WHERE (cp.pc_catid=148 OR c.cat_padre=148 OR cp.pc_catid=163) AND cp.pc_proid=$id_producto ")->row();
    }

    public function obtenerProductoFactor(int $id_producto)
    {
        return $this->consultar("SELECT *
        FROM app_producto_factor p 
        WHERE p.profac_proid=$id_producto")->row();
    }

    public function obtenerDivisaAlCambio(int $id_divisa_master, int $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_divisas_factor WHERE df_divid_master=$id_divisa_master and df_divid=$id_divisa_buscada")->row();
    }

    public function obtenerDivisaAlCambioProducto(string $serial, int $id_divisa_master, int $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_bitacora_factor 
        WHERE bitfac_relacion = '$serial' AND bifac_divid_uno=$id_divisa_master and bifac_divid_dos=$id_divisa_buscada")->row();
    }

    public function verificarProductoEnStock(int $id_producto, int $id_almacen)
    {
        return $this->consultar("SELECT ps_cantidad, ps_stockmin 
        FROM app_productos_stocks ps WHERE ps.ps_proid=$id_producto and ps_almid=$id_almacen")->row();
    }

    public function obtenerDescuento(int $id_cliente)
    {
        return $this->consultar("SELECT cli_descuento FROM app_clientes WHERE cli_id=$id_cliente")->row();
    }

    public function obtenerImpuesto(int $imp_id)
    {
        return $this->consultar("SELECT * FROM app_impuestos WHERE imp_id=$imp_id")->row();
    }

    public function buscarProductoBarcode(int $id_almacen, string $barcode)
    {
        return $this->consultar("SELECT p.pro_id, p.pro_codigo, p.pro_descripcion, p.pro_impid, p.pro_costo, p.pro_precio, p.pro_tipo, p.pro_impid, p.pro_nostock
        FROM app_productos p 
        LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        JOIN app_productos_codbarra pc ON pc.pc_proid = p.pro_id
        WHERE pro_sevende = 1 AND pro_bloqueado = 0 AND pc_codigo = '$barcode' AND (p.pro_nostock = 0 OR p.pro_nostock = 1) AND ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen
        OR (p.pro_nostock = 1 AND ps.ps_cantidad IS NULL AND ps.ps_almid IS NULL AND pc_codigo = '$barcode')")->row();
    }

    public function buscarProductoBarcodeVentasCaja(int $id_almacen, string $barcode)
    {
        return $this->consultar("SELECT p.pro_id, p.pro_codigo, p.pro_impid,p.pro_descripcion, p.pro_costo, p.pro_precio, p.pro_tipo, p.pro_impid, p.pro_nostock
        FROM app_productos p 
        LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        JOIN app_productos_codbarra pc ON pc.pc_proid = p.pro_id
        WHERE pro_sevende = 1 AND pro_costo > 0 AND pro_precio > 0 AND pro_bloqueado = 0 AND pc_codigo = '$barcode' 
        AND (p.pro_nostock = 0 OR p.pro_nostock = 1) AND ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen
        OR (pro_costo > 0 AND pro_precio > 0 AND p.pro_nostock = 1 AND ps.ps_cantidad IS NULL AND ps.ps_almid IS NULL AND pc_codigo = '$barcode')")->row();
    }

    public function buscarProductosVentasCaja(int $id_almacen, string $buscar)
    {
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {
            $sqlproducto .= " (ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen AND pro_sevende = 1 AND pro_costo > 0 AND pro_precio > 0 AND pro_bloqueado = 0) AND (p.pro_nostock = 0 OR p.pro_nostock = 1) 
                AND (";

            foreach ($palabras as $i => $pal) {
                if ($i == 0) {
                    $sqlproducto .= "(LOWER(p.pro_nombrecorto) LIKE '%" . $pal . "%' OR LOWER(p.pro_codigo) LIKE '%" . $pal . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $pal . "%')";
                } else {
                    $sqlproducto .= " AND (LOWER(p.pro_nombrecorto) LIKE '%" . $pal . "%' OR LOWER(p.pro_codigo) LIKE '%" . $pal . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $pal . "%')";
                }
            }

            $sqlproducto .= ")";
        } else {
            $sqlproducto .= " (ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen AND p.pro_sevende = 1 AND p.pro_costo > 0 AND p.pro_precio > 0 AND p.pro_bloqueado = 0) AND (p.pro_nostock = 0 OR p.pro_nostock = 1) 
                AND (LOWER(p.pro_nombrecorto) LIKE '%" . $buscar . "%' OR LOWER(p.pro_codigo) LIKE '%" . $buscar . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $buscar . "%')";
        }

        $sql = "SELECT DISTINCT(pro_id), p.*, pimg.pi_imagen,imp.*,fa.*  
            FROM app_productos p
            LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
            LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
            LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
            LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
            WHERE $sqlproducto GROUP BY p.pro_id";

        return $this->consultar("$sql")->all();
    }

    public function todosProductos(int $id_almacen)
    {
        return $this->consultar("SELECT pro_id, pro_codigo, fa_nombre, pro_impid,pro_descripcion, pro_precio, ps.ps_cantidad, pimg.pi_imagen 
    FROM app_productos p 
    LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid 
    LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id 
    LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
    WHERE ps.ps_almid = $id_almacen
    GROUP BY pro_id LIMIT 50")->all();
    }

    public function todosProductosPtv(int $id_almacen)
    {
        return $this->consultar("SELECT pro_id, pro_codigo, fa_nombre, pro_impid,pro_descripcion, pro_precio, ps.ps_cantidad, pimg.pi_imagen, imp.*
        FROM app_productos p
        LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
        LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
         LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE pro_tipo = 3  OR
        pro_sevende = 1 AND pro_costo > 0 AND pro_precio > 0 AND pro_bloqueado = 0 AND (p.pro_nostock = 0 OR p.pro_nostock = 1) AND ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen
        OR (pro_costo > 0 AND pro_precio > 0 AND p.pro_nostock = 1 AND ps.ps_cantidad IS NULL AND ps.ps_almid IS NULL)
        GROUP BY p.pro_id LIMIT 50")->all();
    }

    public function buscarCategoria(int $id_almacen, string $buscar)
    {
        $buscar = strtolower($buscar);
        return $this->consultar("SELECT *
        FROM app_productos p
        LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
        LEFT JOIN app_productos_categorias cp ON cp.pc_proid = p.pro_id
        LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid
        WHERE pro_tipo = 3 OR pro_sevende = 1 AND pro_costo > 0 AND pro_precio > 0 AND pro_bloqueado = 0 AND cp.pc_catid =$buscar AND (p.pro_nostock = 0 OR p.pro_nostock = 1) AND ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen
        OR (pro_costo > 0 AND pro_precio > 0 AND p.pro_nostock = 1 AND ps.ps_cantidad IS NULL AND ps.ps_almid IS NULL)
        GROUP BY p.pro_id
        LIMIT 50")->all();
    }

    public function obtenerTodasCategorias()
    {
        return $this->consultar("SELECT *
        FROM app_categorias 
        WHERE cat_eliminado=0")->all();
    }

    public function buscarLineasNEV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal)
    {

        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {
            if ($filtro == 1) {

                $sqlproducto .= " ne.ne_surcid=$sucursal  AND ne.ne_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(ne.ne_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(ne.ne_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 2) {
                $sqlproducto .= " ne.ne_surcid=$sucursal  AND ne.ne_estatus=1 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(ne.ne_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(ne.ne_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 3) {
                $sqlproducto .= " ne.ne_surcid=$sucursal  AND ne.ne_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(andea.neart_procodigo) LIKE '%$pal%' OR LOWER(andea.neart_propnombre) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(andea.neart_procodigo) LIKE '%$pal%' OR LOWER(andea.neart_propnombre) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 4) {
                $sqlproducto .= " ne.ne_surcid=$sucursal AND ne.ne_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 5) {
                $sqlproducto .= " ne.ne_surcid=$sucursal AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(ne.ne_observaciones) LIKE '%$pal%') ";
                    } else {
                        $sqlproducto .= " AND (LOWER(ne.ne_observaciones) LIKE '%$pal%') ";
                    }
                }
            }
        } else {
            if ($filtro == 1) {
                $sqlproducto .= " ne.ne_surcid=$sucursal  AND ne.ne_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(ne.ne_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 2) {
                $sqlproducto .= " ne.ne_surcid=$sucursal  AND ne.ne_estatus=1 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(ne.ne_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 3) {
                $sqlproducto .= " ne.ne_surcid=$sucursal  AND ne.ne_estatus=2 AND (LOWER(andea.neart_procodigo) LIKE '%$buscar%' OR LOWER(andea.neart_propnombre) LIKE '%$buscar%')";
            } elseif ($filtro == 4) {
                $sqlproducto .= " ne.ne_surcid=$sucursal AND ne.ne_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')";
            } elseif ($filtro == 5) {
                $sqlproducto .= " ne.ne_surcid=$sucursal AND (LOWER(ne.ne_observaciones) LIKE '%$buscar%')";
            }
        }

        $sql = "SELECT ne.ne_divid, ne.ne_id, ne.ne_correlativo, ne.ne_estatus,c.cli_dni, c.cli_razon_social, andea.neart_proid, andea.neart_procantidad, andea.neart_procodigo, andea.neart_propnombre, andea.neart_prototal, DATE_FORMAT(ne.ne_fecha, '%d/%m/%Y')  as fecha
        FROM app_notas_de_entrega_articulos andea
        JOIN app_notas_de_entrega ne ON ne.ne_id = andea.neart_neid 
        JOIN app_clientes c ON c.cli_id = ne.ne_cliid 
        WHERE $sqlproducto AND ne.ne_id NOT IN (SELECT ard.rd_facid_procedencia FROM app_ruta_documento ard WHERE rd_docid_procedencia=1 AND rd_docid_conversion =2)  
        GROUP BY ne.ne_fecha";

        return $this->consultar("$sql")->all();
    }

    public function buscarLineasFACV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal)
    {
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {
            if ($filtro == 1) {
                $sqlproducto .= " fm.fm_surcid=$sucursal  AND fm.fm_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(fm.fm_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(fm.fm_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 2) {
                $sqlproducto .= " fm.fm_surcid=$sucursal  AND fm.fm_estatus=1 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(fm.fm_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(fm.fm_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 3) {
                $sqlproducto .= " fm.fm_surcid=$sucursal  AND fm.fm_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(fa.fa_procodigo) LIKE  '%$pal%' OR LOWER(fa.fa_propnombre) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(fa.fa_procodigo) LIKE  '%$pal%' OR LOWER(fa.fa_propnombre) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 4) {
                $sqlproducto .= " fm.fm_surcid=$sucursal AND fm.fm_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 5) {
                $sqlproducto .= " fm.fm_surcid=$sucursal AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(fm.fm_observaciones) LIKE '%$pal%') ";
                    } else {
                        $sqlproducto .= " AND (LOWER(fm.fm_observaciones) LIKE '%$pal%') ";
                    }
                }
            }
        } else {
            if ($filtro == 1) {
                $sqlproducto .= " fm.fm_surcid=$sucursal  AND fm.fm_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(fm.fm_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 2) {
                $sqlproducto .= " fm.fm_surcid=$sucursal  AND fm.fm_estatus=1 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(fm.fm_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 3) {
                $sqlproducto .= " fm.fm_surcid=$sucursal  AND fm.fm_estatus=2 AND (LOWER(fa.fa_procodigo) LIKE  '%$buscar%' OR LOWER(fa.fa_propnombre) LIKE '%$buscar%')";
            } elseif ($filtro == 4) {
                $sqlproducto .= " fm.fm_surcid=$sucursal AND fm.fm_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')";
            } elseif ($filtro == 5) {
                $sqlproducto .= " fm.fm_surcid=$sucursal AND (LOWER(fm.fm_observaciones) LIKE '%$buscar%')";
            }
        }

        $sql = "SELECT fm.fm_divid, fm.fm_id, fm.fm_correlativo,fm.fm_estatus, c.cli_dni,c.cli_razon_social, fa.fa_proid, fa.fa_procantidad, fa.fa_procodigo, fa.fa_propnombre, fa.fa_prototal, DATE_FORMAT(fm.fm_fecha, '%d/%m/%Y')  as fecha
        FROM app_factura_master fm
        JOIN app_factura_articulos fa ON fm.fm_id = fa.fa_fmid
        JOIN app_clientes c ON c.cli_id = fm.fm_cliid 
        WHERE $sqlproducto GROUP BY fm.fm_fecha";

        return $this->consultar("$sql")->all();
    }

    public function buscarLineasPEDV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal)
    {
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {
            if ($filtro == 1) {
                $sqlproducto .= " pe.pe_surcid=$sucursal  AND pe.pe_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pe_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pe_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 2) {
                $sqlproducto .= " pe.pe_surcid=$sucursal  AND pe.pe_estatus=1 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pe_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pe_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 3) {
                $sqlproducto .= " pe.pe_surcid=$sucursal  AND pe.pe_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(pa.peart_procodigo) LIKE '%$pal%' OR LOWER(pa.peart_propnombre) LIKE '%$pal%' OR LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(pa.peart_procodigo) LIKE  '%$pal%' OR LOWER(pa.peart_propnombre) LIKE '%$pal%' OR LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 4) {
                $sqlproducto .= " pe.pe_surcid=$sucursal AND pe.pe_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 5) {
                $sqlproducto .= " pe.pe_surcid=$sucursal AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(pe.pe_observaciones) LIKE '%$pal%') ";
                    } else {
                        $sqlproducto .= " AND (LOWER(pe.pe_observaciones) LIKE '%$pal%') ";
                    }
                }
            }
        } else {
            if ($filtro == 1) {
                $sqlproducto .= " pe.pe_surcid=$sucursal  AND pe.pe_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(pe.pe_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 2) {
                $sqlproducto .= " pe.pe_surcid=$sucursal  AND pe.pe_estatus=1 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(pe.pe_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 3) {
                $sqlproducto .= " pe.pe_surcid=$sucursal  AND pe.pe_estatus=2 AND (LOWER(pa.peart_procodigo) LIKE  '%$buscar%' OR LOWER(pa.peart_propnombre) LIKE '%$buscar%' OR LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')";
            } elseif ($filtro == 4) {
                $sqlproducto .= " pe.pe_surcid=$sucursal AND pe.pe_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')";
            } elseif ($filtro == 5) {
                $sqlproducto .= " pe.pe_surcid=$sucursal AND (LOWER(pe.pe_observaciones) LIKE '%$buscar%')";
            }
        }

        $sql = "SELECT pe.pe_divid, pe.pe_id, pe.pe_correlativo,pe.pe_estatus,c.cli_dni, c.cli_razon_social, pa.peart_proid, pa.peart_procantidad, pa.peart_procodigo, pa.peart_propnombre, pa.peart_prototal, DATE_FORMAT(pe.pe_fecha, '%d/%m/%Y')  as fecha
        FROM app_pedidos pe
        JOIN app_pedidos_articulos pa ON pe.pe_id = pa.peart_peid
        JOIN app_clientes c ON c.cli_id = pe.pe_cliid 
        WHERE $sqlproducto GROUP BY pe.pe_fecha";

        return $this->consultar("$sql")->all();
    }

    public function buscarLineasPRESV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal)
    {
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {
            if ($filtro == 1) {
                $sqlproducto .= " pe.pre_surcid=$sucursal  AND pe.pre_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pre_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pre_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 2) {
                $sqlproducto .= " pe.pre_surcid=$sucursal  AND pe.pre_estatus=1 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pre_correlativo) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%' OR LOWER(pe.pre_correlativo) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 3) {
                $sqlproducto .= " pe.pre_surcid=$sucursal  AND pe.pre_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(pa.preart_procodigo) LIKE  '%$pal%' OR LOWER(pa.preart_propnombre) LIKE '%$pal%' OR LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(pa.preart_procodigo) LIKE  '%$pal%' OR LOWER(pa.preart_propnombre) LIKE '%$pal%' OR LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 4) {
                $sqlproducto .= " pe.pre_surcid=$sucursal AND pe.pre_estatus=2 AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    } else {
                        $sqlproducto .= " AND (LOWER(c.cli_dni) LIKE '%$pal%' OR LOWER(c.cli_razon_social) LIKE '%$pal%')";
                    }
                }
            } elseif ($filtro == 5) {
                $sqlproducto .= " pe.pre_surcid=$sucursal AND";

                foreach ($palabras as $i => $pal) {
                    if ($i == 0) {
                        $sqlproducto .= " (LOWER(pe.pre_observaciones) LIKE '%$pal%') ";
                    } else {
                        $sqlproducto .= " AND (LOWER(pe.pre_observaciones) LIKE '%$pal%') ";
                    }
                }
            }
        } else {
            if ($filtro == 1) {
                $sqlproducto .= " pe.pre_surcid=$sucursal  AND pe.pre_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(pe.pre_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 2) {
                $sqlproducto .= " pe.pre_surcid=$sucursal  AND pe.pre_estatus=1 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%' OR LOWER(pe.pre_correlativo) LIKE '%$buscar%')";
            } elseif ($filtro == 3) {
                $sqlproducto .= " pe.pre_surcid=$sucursal  AND pe.pre_estatus=2 AND (LOWER(pa.preart_procodigo) LIKE  '%$buscar%' OR LOWER(pa.preart_propnombre) LIKE '%$buscar%' OR LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')";
            } elseif ($filtro == 4) {
                $sqlproducto .= " pe.pre_surcid=$sucursal AND pe.pre_estatus=2 AND (LOWER(c.cli_dni) LIKE '%$buscar%' OR LOWER(c.cli_razon_social) LIKE '%$buscar%')";
            } elseif ($filtro == 5) {
                $sqlproducto .= " pe.pre_surcid=$sucursal AND (LOWER(pe.pre_observaciones) LIKE '%$buscar%')";
            }
        }

        $sql = "SELECT pe.pre_divid, pe.pre_id, pe.pre_correlativo,pe.pre_estatus,c.cli_dni, c.cli_razon_social, pa.preart_proid, pa.preart_procantidad, pa.preart_procodigo, pa.preart_propnombre, pa.preart_prototal, DATE_FORMAT(pe.pre_fecha, '%d-%m-%Y')  as fecha
        FROM app_presupuesto pe
        JOIN app_presupuesto_articulos pa ON pe.pre_id = pa.preart_preid
        JOIN app_clientes c ON c.cli_id = pe.pre_cliid 
        WHERE $sqlproducto GROUP BY pe.pre_fecha";

        return $this->consultar("$sql")->all();
    }

    public function obtenerBalanceComprarDolares($doc, $tipo)
    {
        return $this->consultar("SELECT * 
            FROM app_movimientos m
            LEFT JOIN app_empleados e ON e.emp_id = m.fab_empid
            LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = m.fab_cmpid 
            LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid 
            LEFT JOIN app_bancos b ON b.ban_id = bc.bc_banid 
            LEFT JOIN app_sucursales s ON s.su_id=m.fab_sucursal 
            LEFT JOIN app_categorias_ingreso_egreso cie ON cie.cie_id = m.fab_categoria 
            LEFT JOIN app_divisas d ON d.div_id = m.fab_divisa  
            WHERE m.fab_categoria = 10 AND m.fab_idgenerico=$doc AND m.fab_doc=$tipo")->all();
    }

    public function buscarProductos(int $id_almacen, string $buscar)
    {
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {

            $sqlproducto .= "(
                (p.pro_tipo = 3) OR(
                    ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen  
                ) OR(
                    (
                        p.pro_sevende = 1 AND p.pro_bloqueado = 0 AND(
                            p.pro_nostock = 0 OR p.pro_nostock = 1
                        ) AND ps.ps_cantidad > 0
                    ) AND ps.ps_almid = $id_almacen  
                ) OR(
                    p.pro_nostock = 1 AND ps.ps_cantidad IS NULL AND ps.ps_almid IS NULL
                )
            ) AND (";

            foreach ($palabras as $i => $pal) {

                if ($i == 0) {
                    $sqlproducto .= "(LOWER(p.pro_nombrecorto) LIKE '%" . $pal . "%' OR LOWER(p.pro_codigo) LIKE '%" . $pal . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $pal . "%')";
                } else {
                    $sqlproducto .= " OR (LOWER(p.pro_nombrecorto) LIKE '%" . $pal . "%' OR LOWER(p.pro_codigo) LIKE '%" . $pal . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $pal . "%')";
                }
            }
            $sqlproducto .= ")";
        } else {
            $sqlproducto .= "(
                (p.pro_tipo = 3) OR(
                    ps.ps_cantidad > 0 AND ps.ps_almid = $id_almacen  
                ) OR(
                    (
                        p.pro_sevende = 1 AND p.pro_bloqueado = 0 AND(
                            p.pro_nostock = 0 OR p.pro_nostock = 1
                        ) AND ps.ps_cantidad > 0
                    ) AND ps.ps_almid = $id_almacen  
                ) OR(
                    p.pro_nostock = 1 AND ps.ps_cantidad IS NULL AND ps.ps_almid IS NULL
                )
            ) AND (LOWER(p.pro_nombrecorto) LIKE '%" . $buscar . "%' OR LOWER(p.pro_codigo) LIKE '%" . $buscar . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $buscar . "%')";
        }

        $sql = "SELECT DISTINCT(pro_id), p.*, pimg.pi_imagen,imp.*,fa.*,ps.*  
      FROM app_productos p
      LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
      LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
      LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
      LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
      WHERE $sqlproducto GROUP BY p.pro_id";

        return $this->consultar("$sql")->all();
    }

    public function buscarProductosSinStock(string $buscar)
    {
        $sqlproducto = '';
        $palabras = explode(' ', $buscar);

        if (count($palabras) > 1) {
            $sqlproducto .= " (p.pro_tipo = 3) OR ((pro_sevende = 1 AND pro_bloqueado = 0) AND (";

            foreach ($palabras as $i => $pal) {
                if ($i == 0) {
                    $sqlproducto .= "(LOWER(p.pro_nombrecorto) LIKE '%" . $pal . "%' OR LOWER(p.pro_codigo) LIKE '%" . $pal . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $pal . "%')";
                } else {
                    $sqlproducto .= " OR (LOWER(p.pro_nombrecorto) LIKE '%" . $pal . "%' OR LOWER(p.pro_codigo) LIKE '%" . $pal . "%' OR LOWER(p.pro_descripcion) LIKE '%" . $pal . "%')";
                }
            }

            $sqlproducto .= "))";
        } else {
            $sqlproducto .= "(p.pro_tipo = 3) OR ((pro_sevende = 1 AND pro_bloqueado = 0) AND (LOWER(pro_nombrecorto) LIKE '%" . $buscar . "%' OR LOWER(pro_codigo) LIKE '%" . $buscar . "%' OR LOWER(pro_descripcion) LIKE '%" . $buscar . "%'))";
        }

        $sql = "SELECT DISTINCT(p.pro_id), p.*, pimg.pi_imagen,imp.*,fa.*,ps.*   
        FROM app_productos p
        LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
        LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
        LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE $sqlproducto GROUP BY p.pro_id";

        return $this->consultar("$sql")->all();
    }

    public function buscarProductosCompras(string $buscar)
    {
        // $buscar = strtolower($buscar);
        $sqlproducto = '';

        $palabras = explode(' ', $buscar);
        if (count($palabras) > 1) {
            $sqlproducto .= " (pro_secompra = 1 AND pro_tipo != 3 AND pro_bloqueado = 0) AND ( ";

            foreach ($palabras as $i => $pal) {
                if ($i == 0) {
                    $sqlproducto .= " (LOWER(p.pro_codigo) LIKE '%$pal%' OR LOWER(p.pro_descripcion) LIKE '%$pal%')";
                } else {
                    $sqlproducto .= " AND (LOWER(pro_codigo) LIKE '%$pal%' OR LOWER(pro_descripcion) LIKE '%$pal%')";
                }
            }

            $sqlproducto .= " )";
        } else {
            $sqlproducto .= " (LOWER(pro_codigo) LIKE '%$buscar%' OR LOWER(pro_descripcion) LIKE '%$buscar%')";
        }

        $sql = "SELECT DISTINCT(pro_id), p.*, pimg.*,fa.*,ps.*   
        FROM app_productos p
        LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
        LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
        LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid 
        WHERE $sqlproducto GROUP BY p.pro_id";

        return $this->consultar("$sql")->all();
    }

    public function obtenerProveedor(int $id_proveedor)
    {
        return $this->consultar("SELECT * FROM app_proveedores 
        JOIN app_tipo_documentos ON prov_tipoidfiscal = tipodoc_id
        LEFT JOIN app_paises ON pa_id = prov_paisid 
        WHERE prov_id=$id_proveedor")->row();
    }

    public function obtenerCliente(int $id_cliente)
    {
        return $this->consultar("SELECT *
        FROM app_clientes c
        JOIN app_tipo_documentos ON cli_tipodocid = tipodoc_id
        LEFT JOIN app_paises ON pa_id = cli_paisid 
        LEFT JOIN app_clientes_grupos gr ON gr.grup_id = c.cli_grupid
        WHERE c.cli_id=$id_cliente")->row();
    }

    public function obtenerEmpleados()
    {
        return $this->consultar("SELECT * 
        FROM app_empleados p
        JOIN app_permissions_actions pc ON p.emp_id = pc.emp_id
        WHERE p.emp_estatus = 1 AND action_id = 'auth_descuento'")->all();
    }

    public function obtenerAgenteDelCliente(int $id_cliente)
    {
        return $this->consultar("SELECT empagent_empid agente, empagent_captado captado
        FROM app_empleados_agentes
        WHERE empagent_clientid=$id_cliente")->row();
    }

    public function obtenerComisiones(int $id_agente)
    {
        return $this->consultar("SELECT *
        FROM app_empleados_agentes_tipo_comision c
        WHERE empagentipo_agente=$id_agente")->all();
    }

    public function obtenerProductoNeCompra(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT cmpnart_proid pro_id, cmpnart_almid alm_id, cmpnart_agregar_inventario agregado 
        FROM app_compras_notas_articulos 
        WHERE cmpnart_cmpnid=$id_factura AND cmpnart_proid=$id_producto")->row();
    }

    public function obtenerProductoFacCompra(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT cmpart_proid pro_id, cmpart_almid alm_id, cmpart_agregar_inventario agregado 
        FROM app_compras_articulos 
        WHERE cmpart_cmpid=$id_factura AND cmpart_proid=$id_producto")->row();
    }
    
     public function obtenerProductoPeCompra(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT cmppeart_proid pro_id, cmppeart_almid alm_id, cmppeart_proid proid 
        FROM app_cmppedidos_articulos   
        WHERE cmppeart_peid=$id_factura AND cmppeart_proid=$id_producto")->row();
    }

    public function obtenerProductoNe(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT neart_proid pro_id, neart_almid alm_id, neart_descontar_inventario descontado 
        FROM app_notas_de_entrega_articulos 
        WHERE neart_neid=$id_factura AND neart_proid=$id_producto")->row();
    }

    public function obtenerProductoOr(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT nart_proid pro_id, nart_almid alm_id, nart_descontar_inventario descontado 
        FROM app_orden_de_entrega_articulos 
        WHERE nart_nid=$id_factura AND nart_proid=$id_producto")->row();
    }

    public function obtenerProductoFac(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT fa_proid pro_id, fa_almid alm_id, fa_descontar_inventario descontado 
        FROM app_factura_articulos 
        WHERE fa_fmid=$id_factura AND fa_proid=$id_producto")->row();
    }

    public function obtenerProductoPe(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT peart_proid pro_id, peart_almid alm_id, peart_descontar_inventario descontado 
        FROM app_pedidos_articulos 
        WHERE peart_peid=$id_factura AND peart_proid=$id_producto")->row();
    }

    public function obtenerProductoPre(int $id_factura, int $id_producto)
    {
        return $this->consultar("SELECT preart_proid pro_id, preart_almid alm_id, preart_descontar_inventario descontado 
        FROM app_presupuesto_articulos 
        WHERE preart_preid=$id_factura AND preart_proid=$id_producto")->row();
    }

    public function eliminarProductoNeCompra(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_compras_notas_articulos WHERE cmpnart_cmpnid=$id_factura AND cmpnart_proid=$id_producto")->run();
        $this->consultar("UPDATE app_compras_notas SET cmpn_articulos_total = cmpn_articulos_total - 1 WHERE cmpn_id=$id_factura")->run();
    }

    public function eliminarProductoFacCompra(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_compras_articulos WHERE cmpart_cmpid=$id_factura AND cmpart_proid=$id_producto")->run();
        $this->consultar("UPDATE app_compras SET cmp_articulos_total = cmp_articulos_total - 1 WHERE cmp_id=$id_factura")->run();
    }
    
    public function eliminarProductoPeCompra(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_cmppedidos_articulos WHERE cmppeart_peid=$id_factura AND cmppeart_proid=$id_producto")->run();
       /// $this->consultar("UPDATE app_cmppedidos SET cmppe_articulos_total = cmppe_articulos_total - 1 WHERE cmppe_id=$id_factura ")->run();
    }

    public function eliminarProductoNe(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_notas_de_entrega_articulos WHERE neart_neid=$id_factura AND neart_proid=$id_producto")->run();
        $this->consultar("UPDATE app_notas_de_entrega SET ne_articulos_total = ne_articulos_total - 1 WHERE ne_id=$id_factura")->run();
    }

    public function eliminarProductoOr(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_orden_de_entrega_articulos WHERE nart_nid=$id_factura AND nart_proid=$id_producto")->run();
        $this->consultar("UPDATE app_orden_de_entrega SET n_articulos_total = n_articulos_total -1 WHERE n_id=$id_factura")->run();
    }

    public function eliminarServicioDePlanilla(int $id_factura, int $id_producto)
    {
        $planilla = $this->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_nid = $id_factura")->row();

        if ($planilla) {

            $data_servicio = $this->consultar("SELECT preserv_id, preserv_estatus
            FROM app_preorden_master m
            JOIN app_preorden_master_servicios ms ON ms.preserv_preid = m.pre_id
            JOIN app_planillas_servicios s ON ms.preserv_servid = s.serv_id
            WHERE pre_id = {$planilla['po_preid']} AND serv_proid = $id_producto")->row();

            if ($data_servicio['preserv_estatus'] == 0) {
                $this->consultar("DELETE FROM app_preorden_master_servicios WHERE preserv_id = {$data_servicio['preserv_id']}")->run();
            } elseif ($data_servicio['preserv_estatus'] == 1) {
                $this->consultar("UPDATE app_preorden_master_servicios SET preserv_estatus = 2 WHERE preserv_id = {$data_servicio['preserv_id']}")->run();
            }
        }
    }

    public function actualizarCantidadServicioDePlanilla(int $id_factura, int $id_producto, int $cantidad)
    {
        $planilla = $this->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_nid = $id_factura")->row();

        if ($planilla) {

            $data_servicio = $this->consultar("SELECT preserv_id
            FROM app_preorden_master m
            JOIN app_preorden_master_servicios ms ON ms.preserv_preid = m.pre_id
            JOIN app_planillas_servicios s ON ms.preserv_servid = s.serv_id
            WHERE pre_id = {$planilla['po_preid']} AND serv_proid = $id_producto")->row();

            $this->consultar("UPDATE app_preorden_master_servicios SET preserv_cantidad = $cantidad WHERE preserv_id = {$data_servicio['preserv_id']}")->run();
        }
    }

    public function eliminarProductoFac(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_factura_articulos WHERE fa_fmid=$id_factura AND fa_proid=$id_producto")->run();
        $this->consultar("UPDATE app_factura_master SET fm_articulos_total = fm_articulos_total - $cantidad WHERE fm_id=$id_factura ")->run();
    }

    public function eliminarProductoPe(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_pedidos_articulos WHERE peart_peid=$id_factura AND peart_proid=$id_producto")->run();
        $this->consultar("UPDATE app_pedidos SET pe_articulos_total = pe_articulos_total - $cantidad WHERE pe_id=$id_factura ")->run();
    }

    public function eliminarProductoPre(int $id_factura, int $id_producto, int $cantidad)
    {
        $this->consultar("DELETE FROM app_presupuesto_articulos WHERE preart_preid=$id_factura AND preart_proid=$id_producto")->run();
        $this->consultar("UPDATE app_presupuesto SET pre_articulos_total = pre_articulos_total - $cantidad WHERE pre_id=$id_factura ")->run();
    }

    public function restablecerStock(int $id_producto, string $id_alamcen, float $cantidad)
    {
        return $this->consultar("UPDATE app_productos_stocks SET ps_cantidad = ps_cantidad + $cantidad WHERE ps_proid=$id_producto AND ps_almid=$id_alamcen")->run();
    }

    public function obtenerAlmacen(int $id_almacen)
    {
        return $this->consultar("SELECT * FROM app_almacenes WHERE alm_id = $id_almacen")->row();
    }

    public function chuequearStock(int $id_producto, int $id_almacen)
    {
        return $this->consultar("SELECT * FROM app_productos_stocks WHERE ps_proid = $id_producto AND ps_almid = $id_almacen")->row();
    }

    public function obtenerCorrelativoNe(int $id_factura)
    {
        return $this->consultar("SELECT ne_correlativo correlativo FROM app_notas_de_entrega WHERE ne_id = $id_factura")->row();
    }

    public function obtenerCorrelativoFac(int $id_factura)
    {
        return $this->consultar("SELECT fm_correlativo correlativo FROM app_factura_master WHERE fm_id = $id_factura")->row();
    }

    public function obtenerCorrelativoOrden(int $id_factura)
    {
        return $this->consultar("SELECT n_correlativo correlativo FROM app_orden_de_entrega WHERE n_id = $id_factura")->row();
    }

    public function obtenerFacCompra(int $id_factura)
    {
        return $this->consultar("SELECT cmp_id id, cmp_almid id_almacen, cmp_subtotal subtotal, cmp_descuento descuento, cmp_neto neto, cmp_iva iva,
        cmp_total total, cmp_articulos_total art_total, cmp_empresaid empresa, cmp_empleadoid id_empleado, 
        cmp_divid id_divisa, cmp_serid id_serie, cmp_serie serie, DATE_FORMAT(cmp_fecha, '%d-%m-%Y %H:%i:%s') fecha, cmp_correlativo correlativo, 
        cmp_cliid id_cliente, cmp_estatus estatus, cmp_observaciones observaciones
        FROM app_compras
        WHERE cmp_id = $id_factura")->row();
    }

    public function obtenerFacArticulosCompra(int $id_factura)
    {
        return $this->consultar("SELECT cmpart_proid id_producto, cmpart_procodigo codigo, cmpart_prototal total, cmpart_idiva id_iva, cmpart_procantidad cantidad,
        cmpart_propnombre nombre, cmpart_proprecio precio, cmpart_proiva iva, cmpart_ivatotal iva_total, cmpart_prodescuento descuento, cmpart_proneto neto, cmpart_almid alm_id
        FROM app_compras_articulos
        WHERE cmpart_cmpid = $id_factura")->all();
    }

    public function obtenerNeCompra(int $id_factura)
    {
        return $this->consultar("SELECT cmpn_id id, cmpn_almid id_almacen, cmpn_subtotal subtotal, cmpn_descuento descuento, cmpn_neto neto, cmpn_iva iva,
        cmpn_total total, cmpn_articulos_total art_total, cmpn_empresaid empresa, cmpn_empleadoid id_empleado, 
        cmpn_divid id_divisa, cmpn_serid id_serie, cmpn_serie serie, DATE_FORMAT(cmpn_fecha, '%d-%m-%Y %H:%i:%s') fecha, cmpn_correlativo correlativo, 
        cmpn_cliid id_cliente, cmpn_estatus estatus, cmpn_observaciones observaciones
        FROM app_compras_notas
        WHERE cmpn_id = $id_factura")->row();
    }

    public function obtenerNeArticulosCompra(int $id_factura)
    {
        return $this->consultar("SELECT cmpnart_proid id_producto, cmpnart_procodigo codigo, cmpnart_prototal total, cmpnart_idiva id_iva, cmpnart_procantidad cantidad,
        cmpnart_propnombre nombre, cmpnart_proprecio precio, cmpnart_proiva iva, cmpnart_ivatotal iva_total, cmpnart_prodescuento descuento, cmpnart_proneto neto, cmpnart_almid alm_id
        FROM app_compras_notas_articulos
        WHERE cmpnart_cmpnid = $id_factura")->all();
    }

    public function obtenerPeCompra(int $id_factura)
    {
        return $this->consultar("SELECT cmppe_id id, cmppe_almid id_almacen, cmppe_subtotal subtotal, cmppe_descuento descuento, cmppe_neto neto, cmppe_iva iva,
        cmppe_total total, cmppe_articulos_total art_total, cmppe_empresaid empresa, cmppe_empleadoid id_empleado, 
        cmppe_divid id_divisa, cmppe_serid id_serie, cmppe_serie serie, DATE_FORMAT(cmppe_fecha, '%d-%m-%Y %H:%i:%s') fecha, cmppe_correlativo correlativo, 
        cmppe_cliid id_cliente, cmppe_estatus estatus, cmppe_observaciones observaciones
        FROM app_cmppedidos
        WHERE cmppe_id = $id_factura")->row();
    }

    public function obtenerPeArticulosCompra(int $id_factura)
    {
        return $this->consultar("SELECT cmppeart_proid id_producto, cmppeart_procodigo codigo, cmppeart_prototal total, cmppeart_idiva id_iva, cmppeart_procantidad cantidad,
        cmppeart_propnombre nombre, cmppeart_proprecio precio, cmppeart_proiva iva, cmppeart_ivatotal iva_total, cmppeart_prodescuento descuento, cmppeart_proneto neto, cmppeart_almid alm_id
        FROM app_cmppedidos_articulos 
        WHERE cmppeart_peid = $id_factura")->all();
    }

    public function abonosFacCompra(int $id_factura)
    {
        return $this->consultar("SELECT *, DATE_FORMAT(fab_fecha, '%d-%m-%Y') as fecha 
        FROM app_movimientos fa
        JOIN app_compras cmp ON cmp.cmp_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 8 ORDER BY fab_fecha DESC")->all();
    }

    public function abonosNeCompra(int $id_factura)
    {
        return $this->consultar("SELECT *, DATE_FORMAT(fab_fecha, '%d-%m-%Y') as fecha 
        FROM app_movimientos fa
        JOIN app_compras_notas cmp ON cmp.cmpn_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 9 ORDER BY fab_fecha DESC")->all();
    }

    public function obtenerNe(int $id_factura)
    {
        return $this->consultar("SELECT ne_id id, ne_almid id_almacen, ne_subtotal subtotal, ne_descuento descuento, ne_neto neto, ne_iva iva,
        ne_total total, ne_articulos_total art_total, ne_empresaid empresa, ne_empleadoid id_empleado, 
        ne_divid id_divisa, ne_serid id_serie, ne_serie serie, DATE_FORMAT(ne_fecha, '%d-%m-%Y %H:%i:%s') fecha, ne_correlativo correlativo, 
        ne_cliid id_cliente, ne_estatus estatus, ne_observaciones observaciones, ne_empagente id_agente, ne_surcid sucursal
        FROM app_notas_de_entrega
        WHERE ne_id = $id_factura")->row();
    }

    public function obtenerFac(int $id_factura)
    {
        return $this->consultar("SELECT fm_id id, fm_almid id_almacen, fm_subtotal subtotal, fm_descuento descuento, fm_neto neto, fm_iva iva,
        fm_total total, fm_articulos_total art_total, fm_empresaid empresa, fm_empleadoid id_empleado, 
        fm_divid id_divisa, fm_serid id_serie, fm_serie serie, DATE_FORMAT(fm_fecha, '%d-%m-%Y %H:%i:%s') fecha, fm_correlativo correlativo, 
        fm_cliid id_cliente, fm_estatus estatus, fm_observaciones observaciones, fm_empagente id_agente, fm_impreso impreso, fm_surcid sucursal
        FROM app_factura_master
        WHERE fm_id = $id_factura")->row();
    }

    public function obtenerPre(int $id_factura)
    {
        return $this->consultar("SELECT pre_id id, pre_almid id_almacen, pre_subtotal subtotal, pre_descuento descuento, pre_neto neto, pre_iva iva,
        pre_total total, pre_articulos_total art_total, pre_empresaid empresa, pre_empleadoid id_empleado, 
        pre_divid id_divisa, pre_serid id_serie, pre_serie serie, DATE_FORMAT(pre_fecha, '%d-%m-%Y %H:%i:%s') fecha, pre_correlativo correlativo, 
        pre_cliid id_cliente, pre_estatus estatus, pre_observaciones observaciones, pre_empagente id_agente, pre_surcid sucursal
        FROM app_presupuesto
        WHERE pre_id = $id_factura")->row();
    }

    public function obtenerPe(int $id_factura)
    {
        return $this->consultar("SELECT pe_id id, pe_almid id_almacen, pe_subtotal subtotal, pe_descuento descuento, pe_neto neto, pe_iva iva,
        pe_total total, pe_articulos_total art_total, pe_empresaid empresa, pe_empleadoid id_empleado, 
        pe_divid id_divisa, pe_serid id_serie, pe_serie serie, DATE_FORMAT(pe_fecha, '%d-%m-%Y %H:%i:%s') fecha, pe_correlativo correlativo, 
        pe_cliid id_cliente, pe_estatus estatus, pe_observaciones observaciones, pe_empagente id_agente, pe_surcid sucursal
        FROM app_pedidos
        WHERE pe_id = $id_factura")->row();
    }

    public function obtenerOrdenE(int $id_factura)
    {
        return $this->consultar("SELECT n_id id, n_almid id_almacen, n_subtotal subtotal, n_descuento descuento, n_neto neto, n_iva iva,
        n_total total, n_articulos_total art_total, n_empresaid empresa, n_empleadoid id_empleado, 
        n_divid id_divisa, n_serid id_serie, n_serie serie, DATE_FORMAT(n_fecha, '%d-%m-%Y %H:%i:%s') fecha, n_correlativo correlativo, 
        n_cliid id_cliente, n_estatus estatus, n_observaciones observaciones, n_empagente id_agente, n_surcid sucursal
        FROM app_orden_de_entrega
        WHERE n_id = $id_factura")->row();
    }

    public function obtenerPrOrden(int $id_factura)
    {
        return $this->consultar("SELECT * FROM app_planilla_orden_de_entrega po 
        LEFT JOIN app_preorden_master p ON po.po_preid = p.pre_id 
        LEFT JOIN app_motores m ON m.mot_id=p.pre_motid 
        LEFT JOIN app_marcas mc ON mc.m_id = m.mot_marca 
        WHERE po_nid = $id_factura")->row();
    }

    public function obtenerFacArticulos(int $id_factura)
    {
        return $this->consultar("SELECT fa_id id,fa_proid id_producto, fa_procodigo codigo, fa_prototal total, fa_idiva id_iva, fa_procantidad cantidad,
        fa_propnombre nombre, fa_procosto costo, fa_costo_servicio costo_servicio, fa_proprecio precio, fa_proiva iva, fa_ivatotal iva_total, fa_prodescuento descuento, fa_proneto neto, fa_almid alm_id,fa_licencia_serial seriall,fa_licencia_fecha_expiracion ser_fecha,fa_licencia_comentario comentario, fa_tarifa tarifa 
        FROM app_factura_articulos
        WHERE fa_fmid = $id_factura")->all();
    }

    public function obtenerNeArticulos(int $id_factura)
    {
        return $this->consultar("SELECT neart_id id,neart_proid id_producto, neart_procodigo codigo, neart_prototal total, neart_idiva id_iva, neart_procantidad cantidad,
        neart_propnombre nombre, neart_procosto costo, neart_costo_servicio costo_servicio, neart_proprecio precio, neart_proiva iva, neart_ivatotal iva_total, neart_prodescuento descuento, neart_proneto neto, neart_almid alm_id,neart_licencia_serial seriall,neart_licencia_fecha_expiracion ser_fecha,neart_licencia_comentario comentario,neart_tarifa tarifa, imp_valor imp
        FROM app_notas_de_entrega_articulos ne 
        LEFT JOIN app_productos p ON p.pro_id=ne.neart_proid 
        LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE ne.neart_neid = $id_factura")->all();
    }

    public function obtenerOrdenArticulos(int $id_factura)
    {
        return $this->consultar("SELECT nart_proid id_producto, nart_procodigo codigo, nart_prototal total, nart_idiva id_iva, nart_procantidad cantidad,
        nart_propnombre nombre, nart_procosto costo, nart_costo_servicio costo_servicio, nart_proprecio precio, nart_proiva iva, nart_ivatotal iva_total, nart_prodescuento descuento, nart_proneto neto, nart_almid alm_id,imp_valor imp 
        FROM app_orden_de_entrega_articulos pre 
        LEFT JOIN app_productos p ON p.pro_id=pre.nart_proid 
        LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE pre.nart_nid = $id_factura")->all();
    }

    public function obtenerPeArticulos(int $id_factura)
    {
        return $this->consultar("SELECT peart_proid id_producto, peart_procodigo codigo, peart_prototal total, peart_idiva id_iva, peart_procantidad cantidad,
        peart_propnombre nombre, peart_procosto costo, peart_costo_servicio costo_servicio, peart_proprecio precio, peart_proiva iva, peart_ivatotal iva_total, peart_prodescuento descuento, peart_proneto neto, peart_almid alm_id,imp_valor imp 
        FROM app_pedidos_articulos pe 
        LEFT JOIN app_productos p ON p.pro_id=pe.peart_proid 
        LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE pe.peart_peid = $id_factura")->all();
    }

    public function obtenerPreArticulos(int $id_factura)
    {
        return $this->consultar("SELECT preart_proid id_producto, preart_procodigo codigo, preart_prototal total, preart_idiva id_iva, preart_procantidad cantidad,
        preart_propnombre nombre, preart_procosto costo, preart_costo_servicio costo_servicio, preart_proprecio precio, preart_proiva iva, preart_ivatotal iva_total, preart_prodescuento descuento, preart_proneto neto, preart_almid alm_id,imp_valor imp 
        FROM app_presupuesto_articulos pre 
        LEFT JOIN app_productos p ON p.pro_id=pre.preart_proid 
        LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE pre.preart_preid = $id_factura")->all();
    }

    public function obtenerCajero(int $id_cajero)
    {
        return $this->consultar("SELECT einfo_nombres, einfo_apellidos
        FROM app_empleados_info
        WHERE einfo_id = $id_cajero")->row();
    }

    public function impresora(int $id_impresora)
    {
        return $this->consultar("SELECT imp_tipo,imp_codigo, CONCAT(imp_ip, ':', imp_puerto) ip_puerto,imp_limite,imp_redondear, imp_usd,imp_descripcion_final      
        FROM app_impresoras WHERE imp_id = $id_impresora")->row();
    }

    public function abonosNe(int $id_factura)
    {
        return $this->consultar("SELECT *, DATE_FORMAT(fab_fecha, '%d-%m-%Y') as fecha 
        FROM app_movimientos fa
        JOIN app_notas_de_entrega fm ON fm.ne_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 1  AND fa.fab_categoria=1 ORDER BY fab_fecha DESC")->all();
    }

    public function abonosFac(int $id_factura)
    {
        return $this->consultar("SELECT *, DATE_FORMAT(fab_fecha, '%d/%m/%Y') as fecha 
        FROM app_movimientos fa
        JOIN app_factura_master fm ON fm.fm_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 2 AND fa.fab_categoria=1 ORDER BY fab_fecha DESC")->all();
    }

    public function abonosOrden(int $id_factura)
    {
        return $this->consultar("SELECT *, DATE_FORMAT(fab_fecha, '%d-%m-%Y') as fecha 
        FROM app_movimientos fa
        JOIN app_orden_de_entrega fm ON fm.n_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 12  AND fa.fab_categoria=1 ORDER BY fab_fecha DESC")->all();
    }

    public function abonosPositvos(int $id_factura)
    {
        return $this->consultar("SELECT *
        FROM app_movimientos fa
        JOIN app_factura_master fm ON fm.fm_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 2 AND fab_retiro = 0  AND fa.fab_categoria=1 ORDER BY fab_fecha DESC")->all();
    }

    public function abonosPositvosDocumento(int $id_factura, $id_documento)
    {
        return $this->consultar("SELECT *
        FROM app_movimientos fa
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = $id_documento AND fab_retiro = 0  AND fa.fab_categoria=1 ORDER BY fab_fecha DESC")->all();
    }

    public function obtenerAbono(int $id_factura, int $id_documento, int $id_movimiento)
    {
        return $this->consultar("SELECT fab_id, fab_divisa, fab_monto, fab_factor, fab_divid_conversion, fab_conversion, fab_retiro, mp_nombre, fab_fecha
        FROM app_movimientos fa
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fa.fab_id = $id_movimiento AND fab_idgenerico=$id_factura AND fa.fab_doc = $id_documento AND fab_retiro = 0  AND fab_categoria=1 ORDER BY fab_fecha DESC")->row();
    }

    public function obtenerAbonoDevol(int $id_factura, int $id_documento, int $id_movimiento)
    {
        return $this->consultar("SELECT fab_id, fab_divisa, fab_monto, fab_factor, fab_divid_conversion, fab_conversion, fab_retiro, mp_nombre, fab_fecha
        FROM app_movimientos fa
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fa.fab_id = $id_movimiento AND fab_idgenerico=$id_factura AND fa.fab_doc = $id_documento AND fab_categoria=1 ORDER BY fab_fecha DESC")->row();
    }

    public function totalPagos(int $id_factura, int $documento, int $categoria)
    {
        return $this->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico=$id_factura AND fab_doc = $documento AND fab_categoria=$categoria")->row();
    }

    public function actualizarCorrelativo(int $id_serie, $id_documento)
    {
        return $this->consultar("UPDATE app_correlativos SET cor_correlativo = cor_correlativo + 1 WHERE cor_serid = $id_serie AND cor_docid=$id_documento")->run();
    }

    public function obtenerDocumento(int $id)
    {
        return $this->consultar("SELECT * FROM app_documentos WHERE doc_id=$id")->row();
    }

    public function descontardeStock(int $id_producto, int $id_alamcen, float $cantidad)
    {
        return $this->consultar("UPDATE app_productos_stocks SET ps_cantidad = ps_cantidad - $cantidad WHERE ps_proid=$id_producto AND ps_almid=$id_alamcen")->run();
    }

    public function rutaDocumento(int $id_factura, int $id_doc_conversion)
    {
        return $this->consultar("SELECT rd_facid_procedencia, rd_docid_procedencia, d.doc_prefijo, emp.emp_username, rd.rd_observacion, DATE_FORMAT(rd.rd_fecha, '%d-%m-%Y') as fecha
        FROM app_ruta_documento rd 
        JOIN app_documentos d ON d.doc_id = rd.rd_docid_procedencia
        JOIN app_empleados emp ON emp.emp_id = rd.rd_empleadoid
        WHERE rd.rd_facid_conversion = $id_factura AND rd_docid_conversion = $id_doc_conversion")->row();
    }

    public function obtenerComisionesAgente(int $id_empleado)
    {
        return $this->consultar("SELECT * 
        FROM app_empleados_agentes_tipo_comision ec 
        JOIN app_comision c ON ec.empagentipo_comid = c.com_id 
        WHERE ec.empagentipo_agente=$id_empleado")->all();
    }

    public function obtenerEmpleadosComisionesFijasPorDocumento(int $id_documento)
    {
        return $this->consultar("SELECT empagentipo_comid, empagentipo_agente, empagentipo_porcentaje, empagentipo_estatus, com_tipo, com_porcentaje,com_formula, com_estatus
        FROM app_empleados_comision_doc cd
        JOIN app_empleados_agentes_tipo_comision ec ON ec.empagentipo_id = cd.ecd_empagentipoid
        JOIN app_comision c ON ec.empagentipo_comid = c.com_id 
        WHERE ecd_docid = $id_documento AND ecd_fijo = 1")->all();
    }

    public function obtenerCreditos(int $id_factura, int $id_documento)
    {
        return $this->consultar("SELECT * FROM app_nota_de_credito WHERE cre_facid = $id_factura AND cre_docid = $id_documento")->all();
    }

    public function obtenerCredito(int $id_credito)
    {
        return $this->consultar("SELECT nc.cre_id, nc.cre_correlativo, nc.cre_docid, nc.cre_modulo, nc.cre_monto, nc.cre_fecha, nc.cre_descripcion, c.cli_id, c.cli_dni, c.cli_razon_social,
        cli_direccion, cli_telefono, einfo_nombres, einfo_apellidos
        FROM app_nota_de_credito nc
        JOIN app_clientes c ON c.cli_id = nc.cre_cliid 
        JOIN app_empleados e ON e.emp_id = nc.cre_empleado
        JOIN app_empleados_info i ON i.einfo_id = e.emp_edatosid
        WHERE cre_id = $id_credito")->row();
    }

    public function totalDocumentosPendientes(int $id_cliente): int
    {
        $total_a = $this->consultar("SELECT count(ne_id) total FROM app_notas_de_entrega ne WHERE ne_estatus = 0 OR ne_estatus = 2 AND ne_cliid = $id_cliente")->row();
        $total_b = $this->consultar("SELECT count(fm_id) total FROM app_factura_master WHERE fm_estatus = 0 OR fm_estatus = 2 AND fm_cliid = $id_cliente")->row();
        $total_c = $this->consultar("SELECT count(n_id) total FROM app_orden_de_entrega WHERE n_estatus = 0 OR n_estatus = 2 AND n_cliid = $id_cliente")->row();
        return $total_a['total'] + $total_b['total'] + $total_c['total'];
    }

    // CUENTAS PENDIENTES POR PAGAR POR CLIENTE

    public function obtenerFacturasPendientesClient(int $id)
    {
        return $this->consultar("SELECT c.cli_id, c.cli_dni, c.cli_razon_social, fm.fm_id, fm.fm_correlativo, fm.fm_total, DATE_FORMAT(fm.fm_fecha, '%d/%m/%Y') as fecha, fm.fm_estatus, d.div_id, d.div_nombre, d.div_locale, div_simbolo, s.ser_codigo
        FROM app_factura_master fm 
        JOIN app_series s ON s.ser_id = fm.fm_serid
        JOIN app_divisas d ON d.div_id = fm.fm_divid
        JOIN app_clientes c ON c.cli_id = fm.fm_cliid
        WHERE fm_estatus = 0 OR fm_estatus = 2 AND c.cli_id=$id")->all();
    }

    public function obtenerNotasdeentregaPendienteClient(int $id)
    {
        return $this->consultar("SELECT c.cli_id, c.cli_dni, c.cli_razon_social, ne.ne_id, ne.ne_correlativo, ne.ne_total, DATE_FORMAT(ne.ne_fecha, '%d/%m/%Y') as fecha, ne.ne_estatus, d.div_id, d.div_nombre, d.div_locale, div_simbolo, s.ser_codigo
        FROM app_notas_de_entrega ne 
        JOIN app_series s ON s.ser_id = ne.ne_serid
        JOIN app_divisas d ON d.div_id = ne.ne_divid
        JOIN app_clientes c ON c.cli_id = ne.ne_cliid
        WHERE (ne_estatus = 0 OR ne_estatus = 2) AND ne.ne_id not in (SELECT ard.rd_facid_procedencia FROM app_ruta_documento ard WHERE rd_docid_procedencia=1 AND rd_docid_conversion =2) AND c.cli_id=$id")->all();
    }

    public function obtenerOrdendeentregaPendienteClient(int $id)
    {
        return $this->consultar("SELECT c.cli_id, c.cli_dni, c.cli_razon_social, n.n_id, n.n_correlativo, n.n_total, DATE_FORMAT(n.n_fecha, '%d/%m/%Y') as fecha, n.n_estatus, d.div_id, d.div_nombre, d.div_locale, div_simbolo, s.ser_codigo
        FROM app_orden_de_entrega n
        JOIN app_series s ON s.ser_id = n.n_serid
        JOIN app_divisas d ON d.div_id = n.n_divid
        JOIN app_clientes c ON c.cli_id = n.n_cliid
        WHERE (n_estatus = 0 OR n_estatus = 2) AND n.n_id not in (SELECT ard.rd_facid_procedencia FROM app_ruta_documento ard WHERE rd_docid_procedencia=12 AND rd_docid_conversion =2) AND c.cli_id=$id")->all();
    }

    public function obtenerAcumuladofno(int $id_factura, int $documento)
    {
        return $this->consultar("SELECT SUM(fab_conversion) as total FROM app_movimientos WHERE fab_idgenerico=$id_factura AND fab_doc=$documento AND fab_categoria=1")->row();
    }

    public function obtenerAgentesFijo(int $id_documento)
    {
        return $this->consultar("SELECT ecd_docid, com_tipo, com_estatus,com_formula, empagentipo_agente, empagentipo_comid, empagentipo_porcentaje, com_porcentaje
            FROM app_empleados_comision_doc doc
            JOIN app_empleados_agentes_tipo_comision ac ON doc.ecd_empagentipoid = empagentipo_id
            JOIN app_comision c ON c.com_id = ac.empagentipo_comid
            WHERE ecd_docid = $id_documento AND empagentipo_estatus = 1 AND ecd_fijo= 1")->all();
    }

    public function obtenerAgenteComision(int $id_documento, int $id_tipodocumento, int $id_agente, $id_comision)
    {
        return $this->consultar("SELECT comagentefn_id FROM app_comisiones_agente_fn
            WHERE comagentefn_fnempagente=$id_agente AND comagentefn_com=$id_comision AND comagentefn_fnid=$id_documento AND comagentefn_fntipo=$id_tipodocumento AND comagentefn_planilla IS NULL")->row();
    }

    public function obtenerComisionesPendientes(int $id_factura, int $id_documento)
    {
        return $this->consultar("SELECT comagentefn_id, comagentefn_divid, com_tipo,com_formula, comagentefn_porcentaje, comagentefn_fnempagente 
        FROM app_comisiones_agente_fn fn
        JOIN app_comision c ON fn.comagentefn_com=c.com_id 
        WHERE comagentefn_fnid = $id_factura AND comagentefn_fntipo = $id_documento AND fn.comagentefn_estatus = 0 AND comagentefn_planilla IS NULL")->all();
    }

    public function obtenerComisionesPendientesCom(int $comision, int $id_factura, int $id_documento)
    {
        return $this->consultar("SELECT comagentefn_id, comagentefn_divid, com_tipo,com_formula, comagentefn_porcentaje, comagentefn_fnempagente 
        FROM app_comisiones_agente_fn fn
        JOIN app_comision c ON fn.comagentefn_com=c.com_id 
        WHERE comagentefn_fnid = $id_factura AND comagentefn_fntipo = $id_documento AND fn.comagentefn_estatus = 0 AND comagentefn_com=$comision AND comagentefn_planilla IS NULL")->all();
    }

    public function obtenerComisionesPendientesPlanilla(int $id_factura, int $id_documento, int $id_planilla)
    {
        return $this->consultar("SELECT comagentefn_planilla_servid,comagentefn_id, comagentefn_divid, com_tipo,com_formula, comagentefn_porcentaje, comagentefn_fnempagente
            FROM app_comisiones_agente_fn fn
            JOIN app_comision c ON fn.comagentefn_com=c.com_id
            WHERE comagentefn_fnid = $id_factura AND comagentefn_fntipo = $id_documento AND fn.comagentefn_estatus = 0 AND comagentefn_planilla = $id_planilla")->all();
    }

    public function obtenerPlanilla(int $id_factura)
    {
        return $this->consultar("SELECT * FROM app_planilla_orden_de_entrega WHERE po_nid = $id_factura")->row();
    }
}
