<?php

namespace App\Modelos;

use Core\Database;

class BitacoraStock extends Database
{
    protected $table = 'app_bitacora_stock_producto';
    protected $id    = 'bsp_id';

    public function obtenerBitacoraStockProducto(int $pro_id)
    {
        return $this->consultar("SELECT DATE_FORMAT(b.bsp_fecha, '%d/%m/%Y %h:%i %p') as fecha,DATE_FORMAT(b.bsp_fecha, '%d/%m/%Y') as fechan, bsp_almacen almacen, b.bsp_modulo modulo, bsp_empleado empleado, bsp_habia habia, bsp_sube sube, bsp_baja baja, bsp_total total, bsp_facid factura, bsp_docid documento
        FROM app_bitacora_stock_producto b 
        JOIN app_productos p ON b.bsp_proid = p.pro_id            
        WHERE bsp_proid = $pro_id  
        ORDER BY bsp_fecha DESC")->all();
    }

    public function obtenerNe($correlativo,$almacen,$proid)
    {
        return $this->consultar("SELECT ne.ne_id as id  FROM app_notas_de_entrega_articulos art 
        LEFT JOIN app_notas_de_entrega ne ON ne.ne_id=art.neart_neid
        LEFT JOIN app_almacenes alm ON alm.alm_id=ne.ne_almid 
        WHERE ne.ne_correlativo = $correlativo AND alm.alm_nombre='$almacen' AND art.neart_proid=$proid ")->row();
    }

    public function obtenerFa($correlativo,$almacen,$proid)
    {
        return $this->consultar("SELECT fm.fm_id as id  FROM app_factura_articulos art
         LEFT JOIN app_factura_master fm ON fm.fm_id=art.fa_fmid 
         LEFT JOIN app_almacenes alm ON alm.alm_id=fm.fm_almid 
        WHERE fm.fm_correlativo = $correlativo AND alm.alm_nombre='$almacen' AND art.fa_proid=$proid")->row();
    }

    public function obtenerOrden($correlativo,$almacen,$proid)
    {
        return $this->consultar("SELECT n.n_id id FROM app_orden_de_entrega_articulo art 
        LEFT JOIN app_orden_de_entrega n ON n.n_id=art.nart_nid 
        WHERE n.n_correlativo = $correlativo AND alm.alm_nombre='$almacen' AND art.nart_proid=$proid")->row();
    }

    public function obtenerCmpNota($correlativo)
    {
        return $this->consultar("SELECT cmpn_id id, cmpn_correlativo correlativo FROM app_compras_notas WHERE cmpn_id =$correlativo")->row();
    }

    public function obtenerCmpFac($correlativo)
    {
        return $this->consultar("SELECT cmp_id id, cmp_correlativo correlativo  FROM app_compras WHERE cmp_id =$correlativo")->row();
    }
}
